---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-trace-next-server

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/trace-next-server.js` L1-147
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L36

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MAX_COMPRESSED_SIZE = 250,000 | E-01 L11 | ○ |
| C-02 | MAX_UNCOMPRESSED_SIZE = 2,500,000 | E-01 L12 | ○ |
| C-03 | os.tmpdir()に一時ディレクトリ作成 | E-01 L20-23 | ○ |
| C-04 | testディレクトリ、ドットファイル、node_modulesを除外してコピー | E-01 L27-37 | ○ |
| C-05 | linkPackagesでパッケージリンク | E-01 L43-46 | ○ |
| C-06 | YARN_CACHE_FOLDERを一時ディレクトリ内に設定 | E-01 L65-67 | ○ |
| C-07 | nodeFileTraceでnext-server.jsをトレース | E-01 L78-91 | ○ |
| C-08 | トレース除外パターン（pages、image-optimizer等） | E-01 L82-90 | ○ |
| C-09 | gzipSizeで圧縮サイズ計算 | E-01 L105 | ○ |
| C-10 | トレース結果をnext-server.js.nft.jsonに書き込み | E-01 L119-128 | ○ |
| C-11 | 一時ディレクトリをクリーンアップ | E-01 L129-130 | ○ |
| C-12 | サイズ超過時にエラーをスロー | E-01 L134-141 | ○ |
| C-13 | console.time/timeEndでトレース時間計測 | E-01 L75-76, L132 | ○ |
| C-14 | numberFiles、totalGzipSize、totalUncompressedSizeを表示 | E-01 L113-117 | ○ |
| C-15 | yarn installで依存関係インストール | E-01 L61-68 | ○ |
| C-16 | package.jsonにnextのtarballパスを設定 | E-01 L48-59 | ○ |
| C-17 | NFTファイルのversion: 1 | E-01 L126 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ソースコードから全主張の根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] linkPackages関数の動作を確認（next-stats-actionのユーティリティ）
- [ ] サイズ上限値が最新の要件と一致しているか確認
