---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-benchmark-next-dev-boot

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/benchmark-next-dev-boot.js` L1-245
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L37

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト5イテレーション | E-01 L30 | ○ |
| C-02 | デフォルトテストディレクトリが/private/tmp/next-boot-test | E-01 L31 | ○ |
| C-03 | Turbopackがデフォルト | E-01 L34 | ○ |
| C-04 | pkill -f "next dev"で既存プロセス終了 | E-01 L63 | ○ |
| C-05 | .nextディレクトリの削除 | E-01 L72-74 | ○ |
| C-06 | "Ready in Xms"パターンの検出 | E-01 L90 | ○ |
| C-07 | 60秒タイムアウト | E-01 L111-117 | ○ |
| C-08 | SIGTERM/SIGKILLでプロセス終了 | E-01 L95, L114 | ○ |
| C-09 | FORCE_COLOR=0環境変数 | E-01 L82 | ○ |
| C-10 | 報告時間と実時間の両方を測定 | E-01 L93-94 | ○ |
| C-11 | 統計計算（avg, min, max, median） | E-01 L152-159 | ○ |
| C-12 | 500ms待機時間 | E-01 L131 | ○ |
| C-13 | --compareでバンドル版/非バンドル版比較 | E-01 L213-237 | ○ |
| C-14 | setBundledでソース書き換え | E-01 L180-207 | ○ |
| C-15 | taskr cliで再ビルド | E-01 L205 | ○ |
| C-16 | 全イテレーション失敗時に"No successful runs" | E-01 L147-149 | ○ |
| C-17 | テストディレクトリ不在時にプロジェクト作成手順を表示 | E-01 L49-57 | ○ |
| C-18 | 比較時にバンドル版に復元 | E-01 L222 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ソースコードから全主張の根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで検証済み
- 1: 中リスク - --compareオプションがnext-dev.tsソースを書き換えるため、実行中の中断に注意

## 6) レビュアーチェックリスト（最小）
- [ ] --compareオプション使用後にソースが正しく復元されることを確認
- [ ] pkillの影響範囲（他のnext devプロセスへの影響）を認識
