---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-devlow-bench

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/devlow-bench.mjs` L1-619
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L38

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @vercel/devlow-benchフレームワーク使用 | E-01 L4-8 | ○ |
| C-02 | "Ready in"と"Local: URL"パターン検出 | E-01 L11-12 | ○ |
| C-03 | GITHUB_SHA/GITHUB_REF_NAMEまたはgitから取得 | E-01 L14-28 | ○ |
| C-04 | 3つのベンチマークシナリオ定義 | E-01 L547-580 | ○ |
| C-05 | heavy-npm-depsプロジェクト使用 | E-01 L537-545, L554 | ○ |
| C-06 | .next削除にretry関数使用 | E-01 L57-59, L582-596 | ○ |
| C-07 | PORT=0でランダムポート | E-01 L52, L265-268 | ○ |
| C-08 | __NEXT_TEST_MODE=1でHMRイベント検出 | E-01 L46, L262 | ○ |
| C-09 | OTEL_SDK_DISABLED=trueでOTel無効化 | E-01 L257 | ○ |
| C-10 | HMRテスト最大10回 | E-01 L355 | ○ |
| C-11 | 最初3回がウォームアップ(hmr/warmup) | E-01 L363-366 | ○ |
| C-12 | tsx:div挿入 | E-01 L431-433 | ○ |
| C-13 | css:プロパティ追加 | E-01 L434-436 | ○ |
| C-14 | mdx:テキスト追加 | E-01 L437-439 | ○ |
| C-15 | HMR 60秒タイムアウト | E-01 L392-396 | ○ |
| C-16 | ステータスコード(0:成功、1:リロード、2:タイムアウト、3:クリーンアップ失敗) | E-01 L374-396 | ○ |
| C-17 | Webpackキャッシュ書き込み5秒待機 | E-01 L476-477 | ○ |
| C-18 | キャッシュパス：.next/dev/cache/webpack/client-development | E-01 L479-484 | ○ |
| C-19 | finally句でクリーンアップ逆順実行 | E-01 L214, L530-533 | ○ |
| C-20 | ページ状態検証（404チェック、エラーチェック） | E-01 L124-148, L303-327 | ○ |
| C-21 | Git SHA/ブランチをpropsに付与 | E-01 L598-618 | ○ |
| C-22 | homepageのHMR対象ファイルがcomponents/lodash.js | E-01 L541-543 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ソースコードから全主張の根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] bench/heavy-npm-depsプロジェクトの存在とpnpmスクリプト定義を確認
- [ ] @vercel/devlow-benchフレームワークのバージョン互換性を確認
