---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-pr-status

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/pr-status.js` L1-1108
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L39

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 出力先がscripts/pr-status/ | E-01 L5 | ○ |
| C-02 | maxBufferが50MB | E-01 L14 | ○ |
| C-03 | PR番号引数またはgh pr viewで自動検出 | E-01 L90-117 | ○ |
| C-04 | "build-and-test"ワークフローのみ対象 | E-01 L122 | ○ |
| C-05 | 最大10件のワークフロー実行を取得 | E-01 L121 | ○ |
| C-06 | 進行中時は全ジョブ取得 | E-01 L886-893 | ○ |
| C-07 | 完了時は失敗ジョブのみ取得 | E-01 L895-908 | ○ |
| C-08 | ジョブをfailed/inProgress/queued/succeeded/cancelled/skippedに分類 | E-01 L204-213 | ○ |
| C-09 | テスト結果JSONを--test output start/end--で抽出 | E-01 L293-309 | ○ |
| C-10 | テストケースグループを##[group]パターンで抽出 | E-01 L311-338 | ○ |
| C-11 | 同一テストパスのリトライを統合 | E-01 L323-328 | ○ |
| C-12 | タイムスタンプの除去 | E-01 L76-79 | ○ |
| C-13 | ボットフィルタリング（-bot, [bot]） | E-01 L81-84 | ○ |
| C-14 | PRレビューでボットを除外 | E-01 L234 | ○ |
| C-15 | GraphQL APIでレビュースレッド取得 | E-01 L241-275 | ○ |
| C-16 | diff hunk付きスレッド | E-01 L258, L823 | ○ |
| C-17 | 出力ディレクトリ削除・再作成 | E-01 L851-852 | ○ |
| C-18 | ファイル名サニタイズ100文字制限 | E-01 L64 | ○ |
| C-19 | ログ取得失敗時"Logs not available" | E-01 L225 | ○ |
| C-20 | API失敗時に空配列返却 | E-01 L236, L274, L285 | ○ |
| C-21 | ワークフロー実行なし時にexit(0) | E-01 L866-868 | ○ |
| C-22 | ジョブログのセクション分割 | E-01 L340-405 | ○ |
| C-23 | index.mdにCI進捗（完了/総数）を表示 | E-01 L453-474 | ○ |
| C-24 | main()のcatchでexit(1) | E-01 L1104-1107 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ソースコードから全主張の根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] gh CLIの認証設定が正しいことを確認
- [ ] GraphQL APIクエリの権限要件を確認
