---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：39-next-typegen

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **writeRouteTypesManifestの出力形式**：型ファイルの具体的な内容は関連モジュール未確認
  2. **routes.d.tsとnext-env.d.tsの関係**：エントリファイルの参照構造

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/cli/next-typegen.ts` L1-206
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L40
- E-03: `packages/next/src/build/entries`（import参照）
- E-04: `packages/next/src/server/lib/router-utils/route-types-utils`（import参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getProjectDirでディレクトリ取得 | E-01 L46 | ○ |
| C-02 | existsSyncでディレクトリ存在確認 | E-01 L49-51 | ○ |
| C-03 | PHASE_PRODUCTION_BUILDで設定読み込み | E-01 L53 | ○ |
| C-04 | installBindingsでSWCバインディングインストール | E-01 L54 | ○ |
| C-05 | findPagesDirでpagesDir/appDir検出 | E-01 L56 | ○ |
| C-06 | strictRouteTypesオプション | E-01 L58 | ○ |
| C-07 | verifyTypeScriptSetupで設定検証 | E-01 L60-72 | ○ |
| C-08 | route-types.d.tsの出力パス | E-01 L78 | ○ |
| C-09 | validator.tsの出力パス | E-01 L79 | ○ |
| C-10 | mkdir(recursive: true)でディレクトリ作成 | E-01 L80 | ○ |
| C-11 | collectPagesFilesでPages Routerファイル収集 | E-01 L117 | ○ |
| C-12 | collectAppFilesでApp Routerファイル収集 | E-01 L130-133 | ○ |
| C-13 | extractSlotsFromAppRoutes + extractSlotsFromDefaultFiles | E-01 L140-141 | ○ |
| C-14 | combineSlots関数でスロット統合 | E-01 L144 | ○ |
| C-15 | createRouteTypesManifestでマニフェスト作成 | E-01 L159-170 | ○ |
| C-16 | redirectsとrewritesをマニフェストに含む | E-01 L167-168 | ○ |
| C-17 | writeCacheLifeTypesでcache-life.d.ts生成 | E-01 L186 | ○ |
| C-18 | writeRouteTypesEntryFileでroutes.d.ts生成 | E-01 L190-200 | ○ |
| C-19 | next-env.d.tsからの一貫したimportパスを提供 | **根拠なし** | △ |
| C-20 | 処理時間が数秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- `packages/next/src/server/lib/router-utils/route-types-utils`モジュールの実装が未確認のため、型ファイルの具体的な出力内容が検証できない
  - 候補：`packages/next/src/server/lib/router-utils/route-types-utils.ts`
- next-env.d.tsからroutes.d.tsへの参照関係は推測に基づく
  - 候補：`packages/next/`内のnext-env.d.ts生成ロジック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CLIエントリポイントの処理フローはソースコードから正確に抽出
- 1: 中リスク - 型ファイルの具体的な内容は関連モジュールの実装に依存

## 6) レビュアーチェックリスト（最小）
- [ ] route-types-utilsモジュールの実装を確認し、型ファイルの出力内容を検証
- [ ] cache-life-type-utilsモジュールの動作を確認
- [ ] distDirとdistDirRootの違いが正しく反映されているか確認
