---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：4-pack-next バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **ビルド時間の見積もり**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/pack-next.ts` - バッチエントリポイント
- E-02: `package.json` (ルート) - scripts.pack-next 定義
- E-03: `scripts/build-native.ts` - ネイティブビルド処理（内部呼出し）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | yargsによるCLIオプション定義 | E-01 (L27-70) | ○ |
| C-02 | --js-buildオプション（デフォルトtrue） | E-01 (L31-35) | ○ |
| C-03 | --projectオプション | E-01 (L37-39) | ○ |
| C-04 | --tarオプション | E-01 (L40-42) | ○ |
| C-05 | --compressオプション（none/strip/objcopy-zlib/objcopy-zstd） | E-01 (L44-57) | ○ |
| C-06 | --compress は --tar 必須のバリデーション | E-01 (L58-63) | ○ |
| C-07 | Linux環境でのstripデフォルト | E-01 (L65-69) | ○ |
| C-08 | tarballs/ ディレクトリへの出力 | E-01 (L17-24) | ○ |
| C-09 | 5つのパッケージをtar化 | E-01 (L99-109) | ○ |
| C-10 | next-swcの圧縮処理（strip/objcopy） | E-01 (L206-238) | ○ |
| C-11 | macOSでの--no-mac-metadataオプション | E-01 (L183) | ○ |
| C-12 | patchPackageJsonによる外部プロジェクトパッチ | E-01 (L114-122) | ○ |
| C-13 | buildNative()の内部呼び出し | E-01 (L93), E-03 | ○ |
| C-14 | npm pack/pnpm packではなくtarコマンドを使用 | E-01 (L167-194) | ○ |
| C-15 | ビルド時間の見積もり | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ビルド時間はネイティブビルドを含むため変動が大きく、ソースコードから定量的根拠を得られない
  - 候補：CI/CDの実行ログ / ローカル実行結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CLIオプションとパッケージング処理はソースコードから直接確認
- 0: 低リスク - 圧縮処理の分岐はswitch文で明確に定義
- 1: 中リスク - pack-utilモジュールの内部実装は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] tarball出力先パスが最新であるか確認
- [ ] 圧縮オプションの動作がLinux/macOS両環境で正しいか確認
- [ ] patchPackageJsonの動作仕様を確認
