---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：40-next-upgrade

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **@next/codemodの具体的なアップグレード処理内容**：外部パッケージのため詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/cli/next-upgrade.ts` L1-42
- E-02: `packages/next/src/lib/helpers/get-npx-command.ts` L1-17
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L41
- E-04: `packages/next/src/lib/get-project-dir.ts`（import参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getProjectDirでディレクトリ解決 | E-01 L14 | ○ |
| C-02 | getNpxCommandでパッケージマネージャー検出 | E-01 L15-16 | ○ |
| C-03 | @next/codemod@canaryを常に使用 | E-01 L21 | ○ |
| C-04 | upgradeコマンドを引数に渡す | E-01 L22 | ○ |
| C-05 | options.revisionを引数に含む | E-01 L23 | ○ |
| C-06 | --verboseオプションの転送 | E-01 L25-27 | ○ |
| C-07 | spawnで子プロセス起動 | E-01 L29-35 | ○ |
| C-08 | stdio: 'inherit'で入出力直接接続 | E-01 L33 | ○ |
| C-09 | process.exitCode = code ?? 0で終了コード伝搬 | E-01 L38-40 | ○ |
| C-10 | pnpm → "pnpm --silent dlx" | E-02 L8 | ○ |
| C-11 | yarn (dlx対応) → "yarn --quiet dlx" | E-02 L11 | ○ |
| C-12 | npm → "npx --yes" | E-02 L6 | ○ |
| C-13 | yarn dlx対応確認で`yarn dlx --help`実行 | E-02 L10 | ○ |
| C-14 | NextUpgradeOptionsにrevisionとverbose | E-01 L5-8 | ○ |
| C-15 | @next/codemodの具体的なコード変換内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- @next/codemodパッケージは外部パッケージであり、具体的なコードモッドの内容やアップグレードロジックは本リポジトリ内で確認できない
  - 候補：`@next/codemod`パッケージのソースコード / npmレジストリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ランチャー部分のコードはシンプルで正確に記述
- 1: 中リスク - 実際のアップグレード処理は外部パッケージに委譲されているため、影響範囲の詳細が不明

## 6) レビュアーチェックリスト（最小）
- [ ] @next/codemod@canaryの具体的な動作を確認（外部パッケージ）
- [ ] getPkgManager関数でのパッケージマネージャー検出ロジックを確認
- [ ] revisionパラメータの有効な値の範囲を確認
