---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：42-clean.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **パッケージ数約20**：正確なパッケージ数は未確認
  2. **目標処理時間1分以内**：具体的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `package.json` scripts.clean定義
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cleanバッチはモノレポ全体のクリーンアップを実行する | E-01, E-02 | ○ |
| C-02 | lerna clean -yで全パッケージのnode_modulesを削除する | E-01 | ○ |
| C-03 | lerna run cleanで各パッケージのcleanスクリプトを実行する | E-01 | ○ |
| C-04 | lerna exec で全パッケージのdistディレクトリを削除する | E-01 | ○ |
| C-05 | scripts/rm.mjsスクリプトでdist削除を行う | E-01 | ○ |
| C-06 | pnpm cleanで実行される | E-01 | ○ |
| C-07 | 3つのコマンドが&&で連結して順次実行される | E-01 | ○ |
| C-08 | クリーンアップ後はpnpm installとpnpm buildが必要 | E-02 | ○ |
| C-09 | -yフラグで確認なしで削除される | E-01 | ○ |
| C-10 | lernaがインストールされていることが前提 | E-01 | ○ |
| C-11 | モノレポ内の全パッケージは約20パッケージ | **根拠なし** | △ |
| C-12 | 目標処理時間は1分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- モノレポ内のパッケージ正確数はlerna.jsonまたはpnpm-workspace.yamlの確認が必要
  - 候補：lerna.json / pnpm-workspace.yaml / packagesディレクトリ一覧
- 処理時間は実測データがない
  - 候補：CI実行ログ / ローカル実行計測

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本バッチはシンプルなファイル削除操作であり、実装が明確

## 6) レビュアーチェックリスト（最小）
- [ ] モノレポ内のパッケージ数が正確か確認
- [ ] 目標処理時間の妥当性を確認
- [ ] rm.mjsスクリプトの実装を確認し、dist以外のディレクトリに影響がないか検証
