---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：43-postinstall.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間30秒以内**：ネットワーク状況に依存するため根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `package.json` scripts.postinstall定義
- E-02: `scripts/git-configure.mjs`（Git設定スクリプト）
- E-03: `scripts/install-native.mjs`（ネイティブバイナリインストールスクリプト）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | postinstallはpnpm install後に自動実行される | E-01 | ○ |
| C-02 | git-configure.mjsとinstall-native.mjsを順次実行する | E-01 | ○ |
| C-03 | git config index.skipHash falseを設定する | E-02 L5 | ○ |
| C-04 | errors.jsonマージドライバーをインストールする | E-02 L16-19 | ○ |
| C-05 | git-configure.mjsはreject: falseでエラーを無視する | E-02 L7, L18 | ○ |
| C-06 | NEXT_SKIP_NATIVE_POSTINSTALL環境変数でスキップ可能 | E-03 L7-12 | ○ |
| C-07 | packages/next/package.jsonからバージョンを取得する | E-03 L17-19 | ○ |
| C-08 | 既存SWCバージョンが一致する場合はスキップする | E-03 L24-40 | ○ |
| C-09 | 一時ディレクトリを/tmp/next-swc-{timestamp}に作成する | E-03 L43 | ○ |
| C-10 | 8プラットフォーム分のoptionalDependenciesを定義する | E-03 L48-57 | ○ |
| C-11 | pnpm addでSWCバイナリをインストールする | E-03 L63-67 | ○ |
| C-12 | インストール後にnode_modules/@next/にコピーする | E-03 L73-84 | ○ |
| C-13 | 一時ディレクトリは処理完了後に削除される | E-03 L85 | ○ |
| C-14 | SWCインストール失敗時はエラーをcatchしてログ出力する | E-03 L87-90 | ○ |
| C-15 | NEXT_TEST_PREFER_OFFLINEで--prefer-offlineオプション追加可能 | E-03 L14, L64-66 | ○ |
| C-16 | 目標処理時間は30秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 処理時間はネットワーク環境やキャッシュ状態に大きく依存するため、固定的な目標値の根拠がない
  - 候補：CI実行ログ / ローカル環境での実測データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 両スクリプトともエラー時にグレースフルに処理を継続する設計

## 6) レビュアーチェックリスト（最小）
- [ ] 目標処理時間の妥当性を確認
- [ ] SWCバイナリのWasmフォールバック動作について追加記載が必要か検討
