---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-check-is-release.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/check-is-release.js`（リリース判定スクリプト）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コミットメッセージからリリースバージョンを検出する | E-01 L3-23 | ○ |
| C-02 | process.argv[2]からコミットIDを取得する | E-01 L4 | ○ |
| C-03 | git log -n 1 --pretty='format:%B'でコミットメッセージを取得する | E-01 L8-9 | ○ |
| C-04 | コミットメッセージをスペースで分割し最後の要素をバージョン候補とする | E-01 L14 | ○ |
| C-05 | 正規表現/^v\d{1,}\.\d{1,}\.\d{1,}(-\w{1,}\.\d{1,})?$/でマッチングする | E-01 L15 | ○ |
| C-06 | マッチ時はバージョン文字列を出力しexit(0)で終了する | E-01 L17-19 | ○ |
| C-07 | 不一致時は"not publish commit"を出力しexit(1)で終了する | E-01 L21-23 | ○ |
| C-08 | コミットID省略時は最新コミット（HEAD）が対象となる | E-01 L4, L9 | ○ |
| C-09 | デバッグ情報としてcommitId, commitMsg, versionStringを出力する | E-01 L22 | ○ |
| C-10 | publish-releaseから呼び出されるユーティリティスクリプトである | E-02 | ○ |
| C-11 | canaryプレリリースバージョン形式に対応する | E-01 L15 | ○ |
| C-12 | execSyncでgit logを同期実行する | E-01 L1, L8-12 | ○ |
| C-13 | 読み取り専用の処理でファイルシステムへの変更は行わない | E-01 L1-26 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本バッチは読み取り専用の判定処理であり、副作用なし

## 6) レビュアーチェックリスト（最小）
- [ ] 正規表現パターンが全てのリリースバージョン形式をカバーしているか確認
- [ ] コミットメッセージ形式の変更がこの判定ロジックに影響しないか確認
