---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：45-get-changed-tests.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間10秒以内**：具体的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/get-changed-tests.mjs`（変更テスト検出スクリプト）
- E-02: `scripts/git-info.mjs`（Git情報取得モジュール）
- E-03: `scripts/test-new-tests.mjs`（呼び出し元スクリプト）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | origin/canaryとの差分から変更テストを検出する | E-01 L25-26, E-02 L72-77 | ○ |
| C-02 | canaryブランチの場合はスキップし空配列を返す | E-01 L18-21 | ○ |
| C-03 | GitHub Actions pull_requestイベントではHEAD~1を使用 | E-02 L48-59 | ○ |
| C-04 | それ以外の環境ではorigin/canaryに対してdiffを取得 | E-02 L62-77 | ○ |
| C-05 | origin/canaryを--depth=20で浅いfetchする | E-02 L63 | ○ |
| C-06 | テストパターンはtest/**/*.test.(js|ts|tsx) | E-01 L57 | ○ |
| C-07 | ファイル存在チェックを行う | E-01 L52-55 | ○ |
| C-08 | test/e2e/はdevTests, prodTests, deployTests全てに追加 | E-01 L58-61 | ○ |
| C-09 | test/integration/はdevTests, prodTestsに追加 | E-01 L62-64 | ○ |
| C-10 | test/prod*はprodTestsのみに追加 | E-01 L65-66 | ○ |
| C-11 | test/development*はdevTestsのみに追加 | E-01 L67-68 | ○ |
| C-12 | パスのスラッシュを正規化する | E-01 L51 | ○ |
| C-13 | git diffエラー時は空文字列を返す | E-01 L28-31 | ○ |
| C-14 | 検出テストをJSON形式でコンソール出力する | E-01 L73-84 | ○ |
| C-15 | test-new-testsから呼び出されるモジュールである | E-03 L4 | ○ |
| C-16 | GITHUB_EVENT_PATHからPR情報を読み込む | E-02 L14-20 | ○ |
| C-17 | commitShaを戻り値に含む | E-01 L86 | ○ |
| C-18 | 目標処理時間は10秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 処理時間はGitリポジトリのサイズやネットワーク速度に依存するため固定値の根拠がない
  - 候補：CI実行ログ / パフォーマンス計測データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本バッチは読み取り専用の分析処理でありリスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] 目標処理時間の妥当性を確認
- [ ] テストファイルのモード分類ルールが最新のテストディレクトリ構造と整合しているか確認
