---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：46-pull-turbo-cache.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間60秒以内**：ネットワーク速度に依存するため根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/pull-turbo-cache.js`（キャッシュプルスクリプト）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Turboリモートキャッシュからネイティブビルドキャッシュを取得する | E-01 L49-68, E-02 | ○ |
| C-02 | process.argvの最後の引数からtargetを取得する | E-01 L7 | ○ |
| C-03 | pnpm dlx turbo@{version}でTurborepoを使用する | E-01 L10 | ○ |
| C-04 | TURBO_VERSION環境変数でバージョン制御可能、デフォルトはlatest | E-01 L10 | ○ |
| C-05 | --dry=jsonでキャッシュ状態をドライラン確認する | E-01 L15 | ○ |
| C-06 | JSON結果をパースしてタスクを検索する | E-01 L40-42 | ○ |
| C-07 | commandが<NONEXISTENT>のタスクはスキップ対象 | E-01 L42 | ○ |
| C-08 | task.cache.localまたはtask.cache.remoteでキャッシュ可否を判定 | E-01 L50 | ○ |
| C-09 | キャッシュ利用可能時はturbo runで実際にキャッシュをプルする | E-01 L52-68 | ○ |
| C-10 | キャッシュなしの場合は警告を出力して継続 | E-01 L69-71 | ○ |
| C-11 | タスク未検出時は警告を出力して返す | E-01 L44-47 | ○ |
| C-12 | 非ゼロ終了コードやシグナルでPromiseをrejectする | E-01 L30-33, L60-63 | ○ |
| C-13 | stderrは親プロセスにパイプされる | E-01 L21-23 | ○ |
| C-14 | キャッシュ利用可能時にtaskId, hash, cache情報をログ出力する | E-01 L51 | ○ |
| C-15 | 目標処理時間は60秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 処理時間はネットワーク速度やキャッシュサイズに依存するため固定値の根拠がない
  - 候補：CI実行ログ / パフォーマンス計測データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - キャッシュ取得はオプティミスティックな処理であり、失敗してもフルビルドで対応可能

## 6) レビュアーチェックリスト（最小）
- [ ] 目標処理時間の妥当性を確認
- [ ] Turboリモートキャッシュの設定（認証トークン等）がCI環境で正しく設定されているか確認
