---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：47-deploy-docs.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **メモリ使用量上限4GB**：ビルドプロセスのメモリ消費に関する明確な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/deploy-docs.sh`（ドキュメントデプロイスクリプト）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Next.jsドキュメントサイトをVercelにデプロイする | E-01 L44-46, E-02 | ○ |
| C-02 | VERCEL_API_TOKEN未設定時はスキップしてexit 0 | E-01 L10-13 | ○ |
| C-03 | DEPLOY_ENVIRONMENTがproductionの場合は--prodフラグを設定 | E-01 L5-8 | ○ |
| C-04 | DEPLOY_ENVIRONMENTのデフォルトはpreview | E-01 L6 | ○ |
| C-05 | corepack@0.31をインストールする | E-01 L23 | ○ |
| C-06 | corepackが既にインストールされている場合はスキップ | E-01 L21-24 | ○ |
| C-07 | NEXT_SKIP_NATIVE_POSTINSTALL=1を設定する | E-01 L29 | ○ |
| C-08 | PLAYWRIGHT_SKIP_BROWSER_DOWNLOAD=1を設定する | E-01 L30 | ○ |
| C-09 | vercel@latestをグローバルインストールする | E-01 L33 | ○ |
| C-10 | プロジェクト名はnext-docs、スコープはvercel | E-01 L16, L36 | ○ |
| C-11 | vercel pullで環境変数を取得する | E-01 L39 | ○ |
| C-12 | vercel buildでローカルビルドを実行する | E-01 L42 | ○ |
| C-13 | --prebuilt --archive=tgzでデプロイする | E-01 L45 | ○ |
| C-14 | set -euo pipefailで厳格なエラーハンドリングを適用 | E-01 L2 | ○ |
| C-15 | ログ出力は標準エラー出力に送り、URLのみ標準出力に出力 | E-01 L18, L46 | ○ |
| C-16 | CWDは"."（カレントディレクトリ） | E-01 L15 | ○ |
| C-17 | メモリ使用量上限は4GB以下 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ビルドプロセスのメモリ消費量は環境やドキュメント量に依存するため固定値の根拠がない
  - 候補：CI実行ログのメモリ使用量 / Vercel buildのリソース制限

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - プロダクションデプロイの場合、公開ドキュメントに即座に反映されるため慎重な確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] メモリ使用量上限の妥当性を確認
- [ ] プロダクションデプロイ時の承認フローが適切に設定されているか確認
- [ ] VERCEL_API_TOKENの権限範囲が適切か確認
