---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：48-deploy-examples.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間5分以内**：具体的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/deploy-examples.sh`（サンプルデプロイスクリプト）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Next.jsサンプルアプリケーションをVercelにデプロイする | E-01, E-02 | ○ |
| C-02 | 現在はワークアラウンドとしてexamples/image-componentが固定 | E-01 L4-6 | ○ |
| C-03 | DEPLOY_ENVIRONMENT=productionの場合は--prodフラグを設定 | E-01 L8-11 | ○ |
| C-04 | VERCEL_API_TOKEN未設定時はスキップしてexit 0 | E-01 L13-16 | ○ |
| C-05 | ディレクトリパスのスラッシュをハイフンに変換してプロジェクト名を生成 | E-01 L19 | ○ |
| C-06 | プロジェクト名にnextjs-プレフィックスを付与 | E-01 L20 | ○ |
| C-07 | vercel linkでプロジェクトをリンクする | E-01 L22 | ○ |
| C-08 | vercel deployでデプロイを実行する | E-01 L23 | ○ |
| C-09 | Vercelスコープはvercel | E-01 L22 | ○ |
| C-10 | forループで複数のexampleをデプロイする | E-01 L18-24 | ○ |
| C-11 | set -euo pipefailで厳格なエラーハンドリング | E-01 L2 | ○ |
| C-12 | scripts/run-for-change.mjsでの変更検出にバグがある（TODO） | E-01 L4-5 | ○ |
| C-13 | デプロイ開始時にログメッセージを出力する | E-01 L21 | ○ |
| C-14 | 目標処理時間は5分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 処理時間はデプロイするexampleの数やビルド時間に依存するため固定値の根拠がない
  - 候補：CI実行ログ / パフォーマンス計測データ

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 変更example検出ロジックにバグがありワークアラウンドが適用されている

## 6) レビュアーチェックリスト（最小）
- [ ] 目標処理時間の妥当性を確認
- [ ] 変更example検出ロジック（scripts/run-for-change.mjs）のバグ修正状況を確認
- [ ] ワークアラウンドの解除時期を検討
