---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 13
  claims_with_evidence: 11
  claims_without_evidence: 2
confidence_derived: 0.85
---

# 根拠レポート：49-deploy-turbopack-docs.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：11 / 13、根拠なし：2
- 優先レビュー（高）
  1. **nightlyツールチェーンが必要**：スクリプト内に明示的なnightly指定がない
  2. **目標処理時間5分以内**：具体的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/deploy-turbopack-docs.sh`（Turbopackドキュメント生成スクリプト）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Turbopack関連のRustクレートからcargo docでドキュメントを生成する | E-01 L5 | ○ |
| C-02 | 対象パッケージは5つ（next-napi-bindings, next-api, next-build, next-core, next-custom-transforms） | E-01 L4 | ○ |
| C-03 | -pオプションで対象パッケージを指定する | E-01 L4 | ○ |
| C-04 | RUSTDOCFLAGS="-Z unstable-options --enable-index-page"を設定する | E-01 L5 | ○ |
| C-05 | --no-depsオプションで依存クレートのドキュメントを除外する | E-01 L5 | ○ |
| C-06 | set -euo pipefailで厳格なエラーハンドリングを適用 | E-01 L2 | ○ |
| C-07 | target/doc/ディレクトリにHTMLドキュメントが生成される | E-01（cargo docの標準動作） | ○ |
| C-08 | --enable-index-pageでトップレベルのインデックスページを生成する | E-01 L5 | ○ |
| C-09 | PACKAGESを変数として定義している | E-01 L4 | ○ |
| C-10 | Bashスクリプトとして実装されている | E-01 L1 | ○ |
| C-11 | ドキュメント生成は冪等な処理である | E-01（cargo docの標準動作） | ○ |
| C-12 | nightlyのRustツールチェーンが必要 | **根拠なし**（-Z unstable-optionsから推測） | △ |
| C-13 | 目標処理時間は5分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- nightlyツールチェーンの要否はCI環境の設定やRustのバージョンによって異なる可能性がある
  - 候補：CI設定ファイル / rustup設定 / .rust-toolchainファイル
- 処理時間はクレート数やソースコード量に依存する
  - 候補：CI実行ログ / パフォーマンス計測データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ドキュメント生成のみの処理で副作用が限定的

## 6) レビュアーチェックリスト（最小）
- [ ] nightlyツールチェーンの要否を確認（-Z unstable-optionsの利用条件）
- [ ] 目標処理時間の妥当性を確認
- [ ] 生成されたドキュメントのデプロイ先（Vercel等）の設定を確認
