---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：5-start-release バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **canaryリリース頻度の記述**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/start-release.js` - バッチエントリポイント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | release-typeはstable/canary/rc/betaの4種類 | E-01 (L16-26) | ○ |
| C-02 | semver-typeはpatch/minor/majorの3種類 | E-01 (L6, L27-34) | ○ |
| C-03 | RELEASE_BOT_GITHUB_TOKEN必須 | E-01 (L36-41) | ○ |
| C-04 | configstoreにトークン設定 | E-01 (L43-50) | ○ |
| C-05 | GitリモートURLをnextjs-botで設定 | E-01 (L52-55) | ○ |
| C-06 | Gitユーザー名: nextjs-bot | E-01 (L56-58) | ○ |
| C-07 | Gitメール: it+nextjs-bot@vercel.com | E-01 (L59-63) | ○ |
| C-08 | canary: preleaseType選択ロジック | E-01 (L66-71) | ○ |
| C-09 | lerna version --preid canary --force-publish -y | E-01 (L75) | ○ |
| C-10 | rc: --preid rc | E-01 (L77) | ○ |
| C-11 | beta: --preid beta | E-01 (L79) | ○ |
| C-12 | stable: lerna version semverType --force-publish -y | E-01 (L80) | ○ |
| C-13 | 完了メッセージ出力 | E-01 (L90) | ○ |
| C-14 | canaryリリースがほぼ日次 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- canaryリリースの頻度はソースコードからは判定できない。実際のリリース履歴から推定した記述である。
  - 候補：GitHub Releases履歴 / npm publishログ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - リリースタイプの分岐処理はソースコードから直接確認
- 0: 低リスク - Git設定とlernaコマンドはソースコードと一致
- 1: 中リスク - configstoreの依存解決（resolveFrom）が正しく動作するか

## 6) レビュアーチェックリスト（最小）
- [ ] release-type/semver-typeのバリデーションが正しいか確認
- [ ] lernaバージョンコマンドのオプションが正しいか確認
- [ ] configstoreのトークン設定が最新のreleaseパッケージと互換性があるか確認
