---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：50-inject-deploy-url.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間30秒以内**：具体的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/inject-deploy-url.js`（デプロイURL注入スクリプト）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tarballを展開しデプロイURLを注入する | E-01 L7-69, E-02 | ○ |
| C-02 | public/ディレクトリからSWCでないtarballを検出する | E-01 L8-9 | ○ |
| C-03 | tarballをカレントディレクトリに移動する（fs.rename） | E-01 L11-13 | ○ |
| C-04 | tar -xfで展開する | E-01 L16-29 | ○ |
| C-05 | package/package.jsonを読み込む | E-01 L31-34 | ○ |
| C-06 | optionalDependenciesのDEPLOY_URLをVERCEL_URLに置換する | E-01 L37-42 | ○ |
| C-07 | process.env.VERCEL_URLを置換値として使用する | E-01 L40 | ○ |
| C-08 | 更新されたpackage.jsonを書き込む | E-01 L44-47 | ○ |
| C-09 | 元のtarballをfs.unlinkで削除する | E-01 L49 | ○ |
| C-10 | tar -czfで再パッケージングする | E-01 L51-64 | ○ |
| C-11 | tarballをpublic/ディレクトリに戻す（fs.rename） | E-01 L66-69 | ○ |
| C-12 | main関数全体がcatchでラップされexit(1)で終了する | E-01 L72-75 | ○ |
| C-13 | spawnによる子プロセスでtar実行（shell: true） | E-01 L17-19, L52 | ○ |
| C-14 | 非ゼロ終了コードでPromiseをrejectする | E-01 L23-25, L57-59 | ○ |
| C-15 | JSON.stringify(parsedPackageJson, null, 2)でフォーマット出力する | E-01 L46 | ○ |
| C-16 | 目標処理時間は30秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 処理時間はtarballのサイズに依存するため固定値の根拠がない
  - 候補：CI実行ログ / tarballサイズの実測値

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - tarball操作の途中で失敗した場合、tarballが不完全な状態になる可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] 目標処理時間の妥当性を確認
- [ ] VERCEL_URL環境変数が未設定の場合の動作を確認
- [ ] tarball操作中の中間状態で失敗した場合のリカバリ方法を検討
