---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：6-publish-release バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **パッケージ数の見積もり**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/publish-release.js` - バッチエントリポイント
- E-02: `scripts/check-is-release.js` - リリースバージョン検出（参照のみ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | check-is-release.jsでタグからバージョン検出 | E-01 (L19-21) | ○ |
| C-02 | canary/rc/beta/stableの判定 | E-01 (L24-28) | ○ |
| C-03 | distタグの決定ロジック | E-01 (L39-45) | ○ |
| C-04 | backport検出（semver.lt比較） | E-01 (L48-65) | ○ |
| C-05 | NPM_TOKEN必須 | E-01 (L74-77) | ○ |
| C-06 | Sema(2)による並列数制御 | E-01 (L81) | ○ |
| C-07 | npm publish --access public --ignore-scripts --tag | E-01 (L87-97) | ○ |
| C-08 | リトライ最大3回 | E-01 (L118) | ○ |
| C-09 | リトライ間隔15秒 | E-01 (L125) | ○ |
| C-10 | already publishedエラーの無視 | E-01 (L111-116) | ○ |
| C-11 | privateパッケージのスキップ | E-01 (L211-213) | ○ |
| C-12 | Promise.allSettledによる並列実行 | E-01 (L202) | ○ |
| C-13 | 一部失敗時のexit(1) | E-01 (L219-221) | ○ |
| C-14 | GitHub Release draft解除（canary時） | E-01 (L133-200) | ○ |
| C-15 | Release検索のリトライ（最大6回、10秒間隔） | E-01 (L155-175) | ○ |
| C-16 | PATCH APIでdraft:falseに更新 | E-01 (L182-189) | ○ |
| C-17 | パッケージ数が約10-15 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パッケージ数はpackagesディレクトリの実際の内容に依存する
  - 候補：`ls packages/` の実行結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - publish処理のフローはソースコードから完全に追跡可能
- 0: 低リスク - リトライ・エラー処理のロジックは明確
- 0: 低リスク - GitHub API呼び出しのエンドポイントとヘッダーは明確

## 6) レビュアーチェックリスト（最小）
- [ ] distタグの分岐ロジックが正しいか確認
- [ ] backport検出のsemver比較が意図通りか確認
- [ ] GitHub Release APIのエンドポイントとヘッダーが最新か確認
- [ ] already publishedエラーの判定文字列が最新か確認
