---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：7-publish-native バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **対象プラットフォーム数の見積もり**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/publish-native.js` - バッチエントリポイント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @next/swc/package.jsonからバージョン取得 | E-01 (L14) | ○ |
| C-02 | crates/next-napi-bindings/npm/からプラットフォーム一覧取得 | E-01 (L17-19) | ○ |
| C-03 | Sema(2)による並列数制御 | E-01 (L12) | ○ |
| C-04 | バイナリファイルのコピー処理 | E-01 (L29-31) | ○ |
| C-05 | package.jsonのバージョン更新 | E-01 (L33-42) | ○ |
| C-06 | npm publish --access public | E-01 (L43-52) | ○ |
| C-07 | canaryバージョン時の--tag canary | E-01 (L50) | ○ |
| C-08 | already publishedエラーの無視 | E-01 (L64-70) | ○ |
| C-09 | WASMパッケージ名: @next/swc-wasm-web/nodejs | E-01 (L89) | ○ |
| C-10 | WASMパッケージのrepository情報追加 | E-01 (L91-95) | ○ |
| C-11 | next/package.jsonのoptionalDependencies更新 | E-01 (L132-143) | ○ |
| C-12 | 個別プラットフォームの失敗が他をブロックしない | E-01 (L61-73) | ○ |
| C-13 | crates/wasmディレクトリからWASMビルド読み込み | E-01 (L81-82) | ○ |
| C-14 | 対象プラットフォーム数が約10 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- プラットフォーム数はcrates/next-napi-bindings/npm/の実際のサブディレクトリ数に依存する
  - 候補：`ls crates/next-napi-bindings/npm/` の実行結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ネイティブバイナリのコピー・バージョン更新はソースコードから直接確認
- 0: 低リスク - WASMパッケージの処理もソースコードと一致
- 1: 中リスク - optionalDependencies更新の影響範囲（nextパッケージのpublish時の動作）

## 6) レビュアーチェックリスト（最小）
- [ ] バイナリファイル名パターン（next-swc.{platform}.node）が正しいか確認
- [ ] WASMパッケージのrepository URLが正しいか確認
- [ ] optionalDependencies更新がnextパッケージのインストール動作に影響しないか確認
