---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：8-create-release-branch バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **GitHub Environments APIの権限要件**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/create-release-branch.js` - バッチエントリポイント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | --branch-name引数必須 | E-01 (L8, L11-13) | ○ |
| C-02 | --tag-nameが"v"で始まること | E-01 (L9, L15-17) | ○ |
| C-03 | RELEASE_BOT_GITHUB_TOKEN必須 | E-01 (L19-24) | ○ |
| C-04 | GitリモートURLをnextjs-botで設定 | E-01 (L26-29) | ○ |
| C-05 | git checkout -b でブランチ作成 | E-01 (L38-41) | ○ |
| C-06 | git fetch origin tagName --tags | E-01 (L42-45) | ○ |
| C-07 | git reset --hard tagName | E-01 (L46-49) | ○ |
| C-08 | lerna.json のallowBranchにブランチ追加 | E-01 (L50-56) | ○ |
| C-09 | build_and_deploy.yml のブランチ参照置換 | E-01 (L58-69) | ○ |
| C-10 | build_and_test.yml のブランチ参照置換 | E-01 (L71-88) | ○ |
| C-11 | test-new-tests の if: false 化 | E-01 (L83-87) | ○ |
| C-12 | git add . && commit && push | E-01 (L91-102) | ○ |
| C-13 | 5秒待機後にGitHub Environments更新 | E-01 (L104-105) | ○ |
| C-14 | release-stable環境のデプロイメントブランチポリシー更新 | E-01 (L107-118) | ○ |
| C-15 | API失敗時のエラーハンドリング | E-01 (L120-126) | ○ |
| C-16 | GitHub Environments APIの権限要件の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GitHub Environments APIの必要権限（PAT scope）はソースコードには明記されていない
  - 候補：GitHub API公式ドキュメント / リポジトリ設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Git操作のフローはソースコードから完全に追跡可能
- 0: 低リスク - ワークフロー設定の置換パターンは正規表現で明確
- 1: 中リスク - GitHub Environments APIの動作はGitHub側の仕様変更の影響を受ける可能性

## 6) レビュアーチェックリスト（最小）
- [ ] ワークフローファイルのパスが最新であるか確認
- [ ] test-new-testsの無効化パターンが最新のワークフローと一致するか確認
- [ ] GitHub Environments APIエンドポイントが最新であるか確認
- [ ] 5秒待機が十分であるか確認（GitHub側の反映時間）
