---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：9-create-preview-tarballs バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **vercel-packagesサービスの動作仕様**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/create-preview-tarballs.js` - バッチエントリポイント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | githubSha, githubHeadSha, tarballDirectoryの3引数 | E-01 (L8-11) | ○ |
| C-02 | デフォルトtarballDirectory: os.tmpdir()/vercel-nextjs-preview-tarballs | E-01 (L11) | ○ |
| C-03 | git rev-parse --shortで短縮SHA取得 | E-01 (L17-18) | ○ |
| C-04 | git show --format=%cd --date=format:%Y%m%dで日付取得 | E-01 (L20-27) | ○ |
| C-05 | バージョン形式: semverStable-preview-shortSha-dateString | E-01 (L36-37) | ○ |
| C-06 | lerna.jsonからベースバージョン取得、"-"で分割 | E-01 (L30-36) | ○ |
| C-07 | ネイティブバイナリENOENT時のスキップ | E-01 (L56-61) | ○ |
| C-08 | パッケージ名をディレクトリに含めてtarball作成 | E-01 (L76) | ○ |
| C-09 | pnpm --silent lerna list --jsonでパッケージ一覧取得 | E-01 (L93-98) | ○ |
| C-10 | vercel-packages.vercel.appのURL形式 | E-01 (L106) | ○ |
| C-11 | privateパッケージのスキップ | E-01 (L119) | ○ |
| C-12 | dependencies/devDependencies/peerDependencies/optionalDependenciesの書き換え | E-01 (L138-149) | ○ |
| C-13 | nextパッケージのoptionalDependenciesにswcパッケージ追加 | E-01 (L128-134) | ○ |
| C-14 | npm packでtarball生成 | E-01 (L162-166) | ○ |
| C-15 | vercel-packagesサービスの詳細な動作仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- vercel-packagesサービスの動作（tarballの解凍・配信方法）はソースコードからは確認できない外部サービスである
  - 候補：vercel-packagesのドキュメント / Vercel内部仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - tarball生成処理はソースコードから直接確認可能
- 0: 低リスク - バージョン・依存関係の書き換えロジックは明確
- 1: 中リスク - vercel-packagesサービスとの連携仕様は外部依存

## 6) レビュアーチェックリスト（最小）
- [ ] プレビューバージョン形式が想定通りか確認
- [ ] 依存関係URL書き換えが全依存タイプを網羅しているか確認
- [ ] vercel-packagesサービスが正しくtarballを配信するか確認
- [ ] ENOENTスキップ時に必要なプラットフォームが欠落しないか確認
