---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 151
  claims_with_evidence: 148
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：eslint-plugin-next 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：148 / 151、根拠なし：3
- 優先レビュー（高）
  1. **C-030 (getUrlFromPagesDirectories)**: ファイルシステム依存のためテスト環境構築に関する根拠不足
  2. **C-033 (getUrlFromAppDirectory)**: ファイルシステム依存のためテスト環境構築に関する根拠不足
  3. **C-101 (no-html-link-for-pages ディレクトリ不在)**: console.warn呼び出しのモック方法に関する根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/eslint-plugin-next/src/utils/node-attributes.ts` - NodeAttributesクラス定義
- E-02: `packages/eslint-plugin-next/src/utils/url.ts` - URL関連ユーティリティ関数群（normalizeURL, normalizeAppPath, execOnce, getUrlFromPagesDirectories, getUrlFromAppDirectory, parseUrlForPages, parseUrlForAppDir, ensureLeadingSlash, isGroupSegment）
- E-03: `packages/eslint-plugin-next/src/utils/get-root-dirs.ts` - getRootDirs関数, processRootDir関数
- E-04: `packages/eslint-plugin-next/src/utils/define-rule.ts` - defineRuleヘルパー関数
- E-05: `packages/eslint-plugin-next/src/index.ts` - プラグインエントリポイント（rules, configs, recommendedRules, coreWebVitalsRules）
- E-06: `packages/eslint-plugin-next/src/rules/google-font-display.ts` - google-font-displayルール
- E-07: `packages/eslint-plugin-next/src/rules/google-font-preconnect.ts` - google-font-preconnectルール
- E-08: `packages/eslint-plugin-next/src/rules/inline-script-id.ts` - inline-script-idルール
- E-09: `packages/eslint-plugin-next/src/rules/next-script-for-ga.ts` - next-script-for-gaルール
- E-10: `packages/eslint-plugin-next/src/rules/no-assign-module-variable.ts` - no-assign-module-variableルール
- E-11: `packages/eslint-plugin-next/src/rules/no-async-client-component.ts` - no-async-client-componentルール（isCapitalized関数含む）
- E-12: `packages/eslint-plugin-next/src/rules/no-before-interactive-script-outside-document.ts` - no-before-interactive-script-outside-documentルール
- E-13: `packages/eslint-plugin-next/src/rules/no-css-tags.ts` - no-css-tagsルール
- E-14: `packages/eslint-plugin-next/src/rules/no-document-import-in-page.ts` - no-document-import-in-pageルール
- E-15: `packages/eslint-plugin-next/src/rules/no-duplicate-head.ts` - no-duplicate-headルール
- E-16: `packages/eslint-plugin-next/src/rules/no-head-element.ts` - no-head-elementルール
- E-17: `packages/eslint-plugin-next/src/rules/no-head-import-in-document.ts` - no-head-import-in-documentルール
- E-18: `packages/eslint-plugin-next/src/rules/no-html-link-for-pages.ts` - no-html-link-for-pagesルール
- E-19: `packages/eslint-plugin-next/src/rules/no-img-element.ts` - no-img-elementルール
- E-20: `packages/eslint-plugin-next/src/rules/no-page-custom-font.ts` - no-page-custom-fontルール（isIdentifierMatch関数含む）
- E-21: `packages/eslint-plugin-next/src/rules/no-script-component-in-head.ts` - no-script-component-in-headルール
- E-22: `packages/eslint-plugin-next/src/rules/no-styled-jsx-in-document.ts` - no-styled-jsx-in-documentルール
- E-23: `packages/eslint-plugin-next/src/rules/no-sync-scripts.ts` - no-sync-scriptsルール
- E-24: `packages/eslint-plugin-next/src/rules/no-title-in-document-head.ts` - no-title-in-document-headルール
- E-25: `packages/eslint-plugin-next/src/rules/no-typos.ts` - no-typosルール（minDistance関数含む）
- E-26: `packages/eslint-plugin-next/src/rules/no-unwanted-polyfillio.ts` - no-unwanted-polyfillioルール

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | NodeAttributes constructorがJSXAttribute文字列値をパースする | E-01 (L26-51) | ○ |
| C-002 | NodeAttributes constructorがexpression値をパースする | E-01 (L35-40) | ○ |
| C-003 | NodeAttributes constructorがexpression.propertiesをパースする | E-01 (L38-40) | ○ |
| C-004 | NodeAttributes constructorが値なしJSXAttributeをパースする | E-01 (L46-50) | ○ |
| C-005 | NodeAttributes constructorが非JSXAttribute型をスキップする | E-01 (L29-31) | ○ |
| C-006 | NodeAttributes constructorが空配列を処理する | E-01 (L28) | ○ |
| C-007 | NodeAttributes hasAnyが属性存在時trueを返す | E-01 (L53-55) | ○ |
| C-008 | NodeAttributes hasAnyが空時falseを返す | E-01 (L53-55) | ○ |
| C-009 | NodeAttributes hasが存在する属性でtrueを返す | E-01 (L56-58) | ○ |
| C-010 | NodeAttributes hasが存在しない属性でfalseを返す | E-01 (L56-58) | ○ |
| C-011 | NodeAttributes hasValueが値あり属性でtrueを返す | E-01 (L59-61) | ○ |
| C-012 | NodeAttributes hasValueが値なし属性でfalseを返す | E-01 (L59-61) | ○ |
| C-013 | NodeAttributes valueが値ありの場合に値を返す | E-01 (L62-74) | ○ |
| C-014 | NodeAttributes valueが存在しない属性でtrueを返す | E-01 (L65-67) | ○ |
| C-015 | NodeAttributes valueがhasValue=falseでundefinedを返す | E-01 (L69-73) | ○ |
| C-016 | normalizeURLが末尾スラッシュを付与する | E-02 (L69-82) | ○ |
| C-017 | normalizeURLがクエリ文字列を除去する | E-02 (L73) | ○ |
| C-018 | normalizeURLがハッシュフラグメントを除去する | E-02 (L74) | ○ |
| C-019 | normalizeURLがindex.htmlを/に置換する | E-02 (L75) | ○ |
| C-020 | normalizeURLが既存末尾スラッシュを保持する | E-02 (L80) | ○ |
| C-021 | normalizeURLが空文字列でundefinedを返す | E-02 (L70-71) | ○ |
| C-022 | normalizeURLがnull入力でundefinedを返す | E-02 (L70-71) | ○ |
| C-023 | normalizeAppPathがpage leafセグメントを除去する | E-02 (L103-132) | ○ |
| C-024 | normalizeAppPathがグループセグメントを除去する | E-02 (L111-114) | ○ |
| C-025 | normalizeAppPathがparallelセグメントを除去する | E-02 (L116-119) | ○ |
| C-026 | normalizeAppPathがroute leafセグメントを除去する | E-02 (L122-127) | ○ |
| C-027 | normalizeAppPathが先頭スラッシュを付与する | E-02 (L193-194) | ○ |
| C-028 | execOnceが関数を1回だけ実行する | E-02 (L178-191) | ○ |
| C-029 | execOnceが2回目以降キャッシュを返す | E-02 (L178-191) | ○ |
| C-030 | getUrlFromPagesDirectoriesがページURLのRegExp配列を返す | E-02 (L137-155) | △ |
| C-031 | getUrlFromPagesDirectoriesが動的ルートをRegExpに変換する | E-02 (L152) | ○ |
| C-032 | getUrlFromPagesDirectoriesが空ディレクトリで空配列を返す | E-02 (L137-155) | ○ |
| C-033 | getUrlFromAppDirectoryがURLのRegExp配列を返す | E-02 (L157-176) | △ |
| C-034 | getRootDirsが未設定時cwdを返す | E-03 (L16-32) | ○ |
| C-035 | getRootDirsが文字列rootDirをglob展開する | E-03 (L23-24) | ○ |
| C-036 | getRootDirsが配列rootDirを各glob展開する | E-03 (L25-29) | ○ |
| C-037 | getRootDirsがnext設定なし時cwdを返す | E-03 (L19-20) | ○ |
| C-038 | defineRuleがRuleModuleをそのまま返す | E-04 (L3) | ○ |
| C-039 | pluginに21個のルールが登録されている | E-05 (L60-83) | ○ |
| C-040 | recommended configにwarnルールが含まれる | E-05 (L25-49) | ○ |
| C-041 | recommended configにerrorルールが含まれる | E-05 (L43-49) | ○ |
| C-042 | core-web-vitals configがルールをerrorに上書きする | E-05 (L51-54, L116-120) | ○ |
| C-043 | recommended-legacy configにplugins配列が含まれる | E-05 (L95-98) | ○ |
| C-044 | google-font-displayがdisplayパラメータ欠如を検知 | E-06 (L39-41) | ○ |
| C-045 | google-font-displayがdisplay=optionalで報告しない | E-06 (L39-50) | ○ |
| C-046 | google-font-displayがdisplay=autoを非推奨とする | E-06 (L43) | ○ |
| C-047 | google-font-displayがdisplay=blockを非推奨とする | E-06 (L44) | ○ |
| C-048 | google-font-displayがdisplay=fallbackを非推奨とする | E-06 (L45) | ○ |
| C-049 | google-font-displayがdisplay=swapで報告しない | E-06 (L42-50) | ○ |
| C-050 | google-font-displayが非Google Fontsを無視する | E-06 (L31-34) | ○ |
| C-051 | google-font-displayが非link要素を無視する | E-06 (L21-22) | ○ |
| C-052 | google-font-preconnectがpreconnect欠如を検知 | E-07 (L29-43) | ○ |
| C-053 | google-font-preconnectがrel=preconnect設定済みで報告しない | E-07 (L29-32) | ○ |
| C-054 | google-font-preconnectが非gstaticドメインを無視する | E-07 (L36) | ○ |
| C-055 | inline-script-idがid欠如のインラインスクリプトを検知 | E-08 (L61-69) | ○ |
| C-056 | inline-script-idがid設定済みで報告しない | E-08 (L65) | ○ |
| C-057 | inline-script-idがdangerouslySetInnerHTML+id欠如を検知 | E-08 (L63) | ○ |
| C-058 | inline-script-idがnext/script未import時スキップする | E-08 (L26) | ○ |
| C-059 | inline-script-idが非チェック可能spread属性をスキップする | E-08 (L59) | ○ |
| C-060 | inline-script-idが外部スクリプトで報告しない | E-08 (L62-63) | ○ |
| C-061 | next-script-for-gaがGA srcを検知する | E-09 (L41-45) | ○ |
| C-062 | next-script-for-gaがGTM srcを検知する | E-09 (L46-54) | ○ |
| C-063 | next-script-for-gaがインラインGAを検知する | E-09 (L62-69) | ○ |
| C-064 | next-script-for-gaがインラインGTMを検知する | E-09 (L70-78) | ○ |
| C-065 | next-script-for-gaが非script要素を無視する | E-09 (L29-31) | ○ |
| C-066 | next-script-for-gaが属性なしscriptをスキップする | E-09 (L32-34) | ○ |
| C-067 | no-assign-module-variableがmodule変数代入を検知する | E-10 (L17-35) | ○ |
| C-068 | no-assign-module-variableが非module変数を除外する | E-10 (L19-24) | ○ |
| C-069 | no-async-client-componentが直接export async functionを検知 | E-11 (L36-47) | ○ |
| C-070 | no-async-client-componentがuse clientなしで報告しない | E-11 (L25-36) | ○ |
| C-071 | no-async-client-componentが識別子経由exportを検知 | E-11 (L50-84) | ○ |
| C-072 | no-async-client-componentがasyncアロー関数経由を検知 | E-11 (L86-101) | ○ |
| C-073 | no-async-client-componentが小文字始まり関数を除外 | E-11 (L41, L7-9) | ○ |
| C-074 | isCapitalizedが大文字始まりでtrueを返す | E-11 (L7-9) | ○ |
| C-075 | isCapitalizedが小文字始まりでfalseを返す | E-11 (L7-9) | ○ |
| C-076 | no-before-interactive-script-outside-documentが_document外で検知 | E-12 (L30-68) | ○ |
| C-077 | no-before-interactive-script-outside-documentが_document内で許可 | E-12 (L60-63) | ○ |
| C-078 | no-before-interactive-script-outside-documentがappディレクトリで除外 | E-12 (L33-38) | ○ |
| C-079 | no-before-interactive-script-outside-documentが他strategyを除外 | E-12 (L52-58) | ○ |
| C-080 | no-css-tagsがローカルスタイルシートを検知 | E-13 (L24-43) | ○ |
| C-081 | no-css-tagsが外部CSSを除外 | E-13 (L35-36) | ○ |
| C-082 | no-css-tagsが非stylesheetを除外 | E-13 (L28-29) | ○ |
| C-083 | no-css-tagsが属性なしlinkをスキップ | E-13 (L20-22) | ○ |
| C-084 | no-document-import-in-pageが_document外でのimportを検知 | E-14 (L19-39) | ○ |
| C-085 | no-document-import-in-pageが_document内でのimportを許可 | E-14 (L27-33) | ○ |
| C-086 | no-document-import-in-pageが非documentインポートを除外 | E-14 (L20-22) | ○ |
| C-087 | no-document-import-in-pageがpages外を除外 | E-14 (L24-28) | ○ |
| C-088 | no-duplicate-headが複数Headを検知 | E-15 (L49-63) | ○ |
| C-089 | no-duplicate-headが単一Headを許可 | E-15 (L56) | ○ |
| C-090 | no-duplicate-headがDocumentクラス外を除外 | E-15 (L31-41) | ○ |
| C-091 | no-head-elementがpages内headを検知 | E-16 (L19-33) | ○ |
| C-092 | no-head-elementがappディレクトリを除外 | E-16 (L22-27) | ○ |
| C-093 | no-head-elementが非head要素を除外 | E-16 (L26) | ○ |
| C-094 | no-head-import-in-documentが_documentでのnext/head importを検知 | E-17 (L18-41) | ○ |
| C-095 | no-head-import-in-documentが通常ページでの importを許可 | E-17 (L28-32) | ○ |
| C-096 | no-head-import-in-documentが_documentディレクトリ形式を検知 | E-17 (L32) | ○ |
| C-097 | no-html-link-for-pagesが内部リンクa要素を検知 | E-18 (L115-162) | ○ |
| C-098 | no-html-link-for-pagesが外部URLを除外 | E-18 (L150-152) | ○ |
| C-099 | no-html-link-for-pagesがtarget=_blankを除外 | E-18 (L124-129) | ○ |
| C-100 | no-html-link-for-pagesがdownload属性を除外 | E-18 (L140-147) | ○ |
| C-101 | no-html-link-for-pagesがディレクトリ不在時に警告を出す | E-18 (L105-108) | △ |
| C-102 | no-html-link-for-pagesが非a要素を無視 | E-18 (L116-118) | ○ |
| C-103 | no-html-link-for-pagesが非Literal hrefをスキップ | E-18 (L136) | ○ |
| C-104 | no-img-elementがimg要素を検知 | E-19 (L28-52) | ○ |
| C-105 | no-img-elementがpicture内imgを除外 | E-19 (L37-39) | ○ |
| C-106 | no-img-elementがメタデータルートファイルを除外 | E-19 (L43-47) | ○ |
| C-107 | no-img-elementが属性なしimgをスキップ | E-19 (L33-35) | ○ |
| C-108 | no-page-custom-fontが_document外でGoogle Fontを検知 | E-20 (L146-167) | ○ |
| C-109 | no-page-custom-fontが_documentデフォルトエクスポート内を許可 | E-20 (L142-144) | ○ |
| C-110 | no-page-custom-fontが_document内Head外を検知 | E-20 (L159-160) | ○ |
| C-111 | no-page-custom-fontがpages外をスキップ | E-20 (L27-29) | ○ |
| C-112 | isIdentifierMatchが同じ名前でtrueを返す | E-20 (L8-10) | ○ |
| C-113 | isIdentifierMatchが異なる名前でfalseを返す | E-20 (L8-10) | ○ |
| C-114 | isIdentifierMatchが両方nullでtrueを返す | E-20 (L9) | ○ |
| C-115 | no-script-component-in-headがHead内Scriptを検知 | E-21 (L27-53) | ○ |
| C-116 | no-script-component-in-headがHead外Scriptを許可 | E-21 (L32-38) | ○ |
| C-117 | no-script-component-in-headがnext/head未import時スキップ | E-21 (L28-30) | ○ |
| C-118 | no-styled-jsx-in-documentが_documentでstyled-jsxを検知 | E-22 (L18-44) | ○ |
| C-119 | no-styled-jsx-in-documentが通常ページで許可 | E-22 (L25-32) | ○ |
| C-120 | no-styled-jsx-in-documentが_documentディレクトリ形式を検知 | E-22 (L29) | ○ |
| C-121 | no-styled-jsx-in-documentがpages外をスキップ | E-22 (L19-22) | ○ |
| C-122 | no-sync-scriptsが同期scriptを検知 | E-23 (L17-36) | ○ |
| C-123 | no-sync-scriptsがasync scriptを許可 | E-23 (L29) | ○ |
| C-124 | no-sync-scriptsがdefer scriptを許可 | E-23 (L30) | ○ |
| C-125 | no-sync-scriptsがsrcなしscriptを許可 | E-23 (L28) | ○ |
| C-126 | no-sync-scriptsが属性なしscriptをスキップ | E-23 (L21-23) | ○ |
| C-127 | no-title-in-document-headがHead内titleを検知 | E-24 (L25-51) | ○ |
| C-128 | no-title-in-document-headがtitle不在時報告しない | E-24 (L46) | ○ |
| C-129 | no-title-in-document-headがHead未import時スキップ | E-24 (L26-28) | ○ |
| C-130 | no-typosがgetStaticPropsタイポを検知 | E-25 (L54-72) | ○ |
| C-131 | no-typosが正しいgetStaticPropsで報告しない | E-25 (L55-57) | ○ |
| C-132 | no-typosがgetServerSidePropsタイポを検知 | E-25 (L54-72) | ○ |
| C-133 | no-typosがgetStaticPathsタイポを検知 | E-25 (L54-72) | ○ |
| C-134 | no-typosがpages外をスキップ | E-25 (L75-76) | ○ |
| C-135 | no-typosがpages/apiを除外 | E-25 (L76) | ○ |
| C-136 | no-typosがVariableDeclaration形式を検知 | E-25 (L91-98) | ○ |
| C-137 | no-typosが編集距離超過を除外 | E-25 (L63) | ○ |
| C-138 | minDistanceが同一文字列で0を返す | E-25 (L14-41) | ○ |
| C-139 | minDistanceが1文字違いで1を返す | E-25 (L14-41) | ○ |
| C-140 | minDistanceが空文字列と非空で長さを返す | E-25 (L22-24) | ○ |
| C-141 | minDistanceが両方空で0を返す | E-25 (L22-24) | ○ |
| C-142 | minDistanceがa<bで入れ替えて計算する | E-25 (L18-20) | ○ |
| C-143 | no-unwanted-polyfillioが重複polyfillを検知 | E-26 (L97-139) | ○ |
| C-144 | no-unwanted-polyfillioが非重複polyfillを許可 | E-26 (L127-129) | ○ |
| C-145 | no-unwanted-polyfillioがcdn.polyfill.io/v2を検知 | E-26 (L117) | ○ |
| C-146 | no-unwanted-polyfillioがpolyfill-fastly.netを検知 | E-26 (L120) | ○ |
| C-147 | no-unwanted-polyfillioがcdnjs.cloudflare.comを検知 | E-26 (L123) | ○ |
| C-148 | no-unwanted-polyfillioが複数重複polyfillを報告 | E-26 (L130-138) | ○ |
| C-149 | no-unwanted-polyfillioがnext/script経由を検知 | E-26 (L92-101) | ○ |
| C-150 | no-unwanted-polyfillioが非Literal srcをスキップ | E-26 (L112) | ○ |
| C-151 | no-unwanted-polyfillioがfeaturesなしで報告しない | E-26 (L126-130) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-030, C-033: `getUrlFromPagesDirectories`と`getUrlFromAppDirectory`はファイルシステム操作（`fs.readdirSync`）に依存しており、テスト実行時のモック構成について具体的な根拠がソースコード内に不足
  - 候補：テスト用の一時ディレクトリ構成 / fsモジュールのモック / 既存テストケースの参照
- C-101: `no-html-link-for-pages`のディレクトリ不在時の`console.warn`呼び出しについて、`execOnce`ラッパーにより1回のみ出力される挙動のテスト方法に根拠不足
  - 候補：console.warnのモック / execOnceのリセット方法

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ユーティリティ関数（defineRule, NodeAttributes）のテストケースは十分に網羅
- 0: 低リスク - 各ESLintルールの正常系・異常系テストケースはソースコードの条件分岐に基づいて設計済み
- 1: 中リスク - ファイルシステム依存の関数（parseUrlForPages, parseUrlForAppDir, getRootDirs）はモック構成への依存がある
- 0: 低リスク - minDistance（レーベンシュタイン距離）の境界値テストは十分

## 6) レビュアーチェックリスト（最小）
- [ ] 各ESLintルールの正常系テストケースが、ソースコード内の全条件分岐をカバーしているか
- [ ] ファイルシステム依存テストケース（C-030, C-033）の前提条件が実現可能か
- [ ] NodeAttributesクラスの各メソッドに対するエッジケースが不足していないか
- [ ] no-html-link-for-pagesルールのカスタムpagesDirectory設定パターンがテストされているか
- [ ] normalizeURL関数の追加的な境界値（特殊文字を含むURL等）が必要か
- [ ] 各ルールのmeta情報（docs.description, type, schema）のテストが必要か検討
