---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 115
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：font モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：115 / 120、根拠なし：5
- 優先レビュー（高）
  1. **UT-FNT-049（fetchCSSFromGoogleFonts通常フェッチ）**：実際のネットワーク動作はモック依存のため根拠不足
  2. **UT-FNT-052（fetchFontFile通常フェッチ）**：実際のネットワーク動作はモック依存のため根拠不足
  3. **UT-FNT-053/054/057（fetchResource）**：低レベルHTTP動作の詳細な検証にはモック環境が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/font/src/next-font-error.ts` - nextFontError関数の実装
- E-02: `packages/font/src/format-available-values.ts` - formatAvailableValues関数の実装
- E-03: `packages/font/src/constants.ts` - allowedDisplayValues定数
- E-04: `packages/font/src/types.ts` - 型定義
- E-05: `packages/font/src/google/validate-google-font-function-call.ts` - Googleフォントバリデーション実装
- E-06: `packages/font/src/google/get-font-axes.ts` - getFontAxes関数の実装
- E-07: `packages/font/src/google/get-google-fonts-url.ts` - getGoogleFontsUrl関数の実装
- E-08: `packages/font/src/google/sort-fonts-variant-values.ts` - sortFontsVariantValues関数の実装
- E-09: `packages/font/src/google/find-font-files-in-css.ts` - findFontFilesInCss関数の実装
- E-10: `packages/font/src/google/fetch-css-from-google-fonts.ts` - fetchCSSFromGoogleFonts関数の実装
- E-11: `packages/font/src/google/fetch-font-file.ts` - fetchFontFile関数の実装
- E-12: `packages/font/src/google/fetch-resource.ts` - fetchResource関数の実装
- E-13: `packages/font/src/google/get-proxy-agent.ts` - getProxyAgent関数の実装
- E-14: `packages/font/src/google/get-fallback-font-override-metrics.ts` - getFallbackFontOverrideMetrics関数の実装
- E-15: `packages/font/src/google/retry.ts` - retry関数の実装
- E-16: `packages/font/src/google/loader.ts` - nextFontGoogleFontLoader関数の実装
- E-17: `packages/font/src/google/google-fonts-metadata.ts` - メタデータ定義
- E-18: `packages/font/src/local/validate-local-font-function-call.ts` - ローカルフォントバリデーション実装
- E-19: `packages/font/src/local/pick-font-file-for-fallback-generation.ts` - pickFontFileForFallbackGeneration関数の実装
- E-20: `packages/font/src/local/get-fallback-metrics-from-font-file.ts` - getFallbackMetricsFromFontFile関数の実装
- E-21: `packages/font/src/local/loader.ts` - nextFontLocalFontLoader関数の実装
- E-22: `packages/font/src/google/find-font-files-in-css.test.ts` - 既存テスト（参考）
- E-23: `packages/font/src/google/get-font-axes.test.ts` - 既存テスト（参考）
- E-24: `packages/font/src/google/loader.test.ts` - 既存テスト（参考）
- E-25: `packages/font/src/google/sort-fonts-variant-values.test.ts` - 既存テスト（参考）
- E-26: `packages/font/src/google/validate-google-font-function-call.test.ts` - 既存テスト（参考）
- E-27: `packages/font/src/local/loader.test.ts` - 既存テスト（参考）
- E-28: `packages/font/src/local/pick-font-file-for-fallback-generation.test.ts` - 既存テスト（参考）
- E-29: `packages/font/src/local/validate-local-font-function-call.test.ts` - 既存テスト（参考）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | nextFontErrorがNextFontError名のエラーをスローする | E-01 | ○ |
| C-02 | nextFontErrorのメッセージが正しく設定される | E-01 | ○ |
| C-03 | nextFontErrorに空文字列を渡してもスローされる | E-01 | ○ |
| C-04 | formatAvailableValuesが値をバッククォートで囲みカンマ区切りにする | E-02 | ○ |
| C-05 | formatAvailableValuesが空配列で空文字列を返す | E-02 | ○ |
| C-06 | formatAvailableValuesが単一要素で正しく動作する | E-02 | ○ |
| C-07 | validateGoogleFontFunctionCallが有効な入力を検証する | E-05, E-17 | ○ |
| C-08 | アンダースコアがスペースに変換される | E-05 (L40) | ○ |
| C-09 | 空functionNameでエラーがスローされる | E-05 (L36-38) | ○ |
| C-10 | 未知フォントでエラーがスローされる | E-05 (L43-45) | ○ |
| C-11 | weight未指定でvariable非対応時エラー | E-05 (L81-91) | ○ |
| C-12 | weight未指定でvariable対応時にvariableがデフォルト | E-05 (L83-84) | ○ |
| C-13 | variable混在時エラー | E-05 (L94-98) | ○ |
| C-14 | 不正weightでエラー | E-05 (L100-108) | ○ |
| C-15 | 不正styleでエラー | E-05 (L120-128) | ○ |
| C-16 | 不正displayでエラー | E-05 (L130-136), E-03 | ○ |
| C-17 | preload時subsets必須 | E-05 (L52-57) | ○ |
| C-18 | 不正subsetでエラー | E-05 (L59-67) | ○ |
| C-19 | デフォルトスタイルnormal | E-05 (L110-118) | ○ |
| C-20 | italicのみフォントのデフォルト | E-05 (L111-113) | ○ |
| C-21 | 非variableでaxes指定エラー | E-05 (L138-148) | ○ |
| C-22 | weight重複除去 | E-05 (L74-76) | ○ |
| C-23 | variableフォントの重み範囲返却 | E-06 (L59-77) | ○ |
| C-24 | 非variableフォントのweightsそのまま返却 | E-06 (L78-83) | ○ |
| C-25 | italic時のital軸生成 | E-06 (L18-22) | ○ |
| C-26 | normal+italic時のital軸 | E-06 (L18-22) | ○ |
| C-27 | normalのみ時ital未定義 | E-06 (L22) | ○ |
| C-28 | selectedVariableAxesの処理 | E-06 (L32-71) | ○ |
| C-29 | 定義不可能軸指定エラー | E-06 (L38-40) | ○ |
| C-30 | 存在しない軸名エラー | E-06 (L48-56) | ○ |
| C-31 | 基本URL生成 | E-07 | ○ |
| C-32 | スペースの+変換 | E-07 (L50-53) | ○ |
| C-33 | ital軸付きURL | E-07 (L17-29) | ○ |
| C-34 | variableAxes付きURL | E-07 (L30-48) | ○ |
| C-35 | variableAxesのソート | E-07 (L37-48) | ○ |
| C-36 | 軸なしURL | E-07 (L50-63) | ○ |
| C-37 | 単純数値ソート | E-08 (L23-24) | ○ |
| C-38 | ital,wght形式ソート | E-08 (L8-21) | ○ |
| C-39 | 同prefix時suffixソート | E-08 (L14-16) | ○ |
| C-40 | 同一値比較 | E-08 | ○ |
| C-41 | CSSからURL抽出 | E-09 | ○ |
| C-42 | preload対象subsetマーク | E-09 (L31) | ○ |
| C-43 | preload対象外false | E-09 (L31) | ○ |
| C-44 | 重複URL除外 | E-09 (L24-26) | ○ |
| C-45 | 空CSS処理 | E-09 | ○ |
| C-46 | subsetsToPreload未指定時 | E-09 (L31) | ○ |
| C-47 | モックレスポンス返却 | E-10 (L17-24) | ○ |
| C-48 | モック未定義URLエラー | E-10 (L20-22) | ○ |
| C-49 | fetchCSSFromGoogleFonts通常フェッチ | E-10 (L26-35) | △ |
| C-50 | モックローカルファイル読込 | E-11 (L11-13) | ○ |
| C-51 | モックURL変換 | E-11 (L14) | ○ |
| C-52 | fetchFontFile通常フェッチ | E-11 (L17-23) | △ |
| C-53 | fetchResource HTTPS基本動作 | E-12 | △ |
| C-54 | devモードタイムアウト | E-12 (L18, L49-52) | ○ |
| C-55 | 非200ステータスエラー | E-12 (L33-40) | ○ |
| C-56 | カスタムエラーメッセージ | E-12 (L36-37) | ○ |
| C-57 | HTTPプロトコル選択 | E-12 (L16-17) | △ |
| C-58 | https_proxyでHttpsProxyAgent | E-13 (L11-14) | ○ |
| C-59 | HTTPS_PROXYでHttpsProxyAgent | E-13 (L11) | ○ |
| C-60 | http_proxyでHttpProxyAgent | E-13 (L16-19) | ○ |
| C-61 | プロキシ未設定でundefined | E-13 | ○ |
| C-62 | フォールバックメトリクス形式 | E-14 (L15-23) | ○ |
| C-63 | メトリクス取得失敗時undefined | E-14 (L24-26) | ○ |
| C-64 | retry成功時結果返却 | E-15 | ○ |
| C-65 | retry全失敗時エラー | E-15 | ○ |
| C-66 | retry途中成功 | E-15 | ○ |
| C-67 | 正規表現エスケープ | E-16 (L20-26) | ○ |
| C-68 | エスケープ不要時そのまま返却 | E-16 (L22-25) | ○ |
| C-69 | 空文字列処理 | E-16 (L22) | ○ |
| C-70 | GoogleFontLoader基本機能 | E-16 (L28-194) | ○ |
| C-71 | body CSS除去 | E-16 (L98) | ○ |
| C-72 | URL置換 | E-16 (L151-157) | ○ |
| C-73 | CSSキャッシュ動作 | E-16 (L80-92) | ○ |
| C-74 | CSS取得失敗（本番）エラー | E-16 (L93-95, L190-192) | ○ |
| C-75 | 開発モードフォールバック | E-16 (L164-189) | ○ |
| C-76 | 単一weight時result | E-16 (L65-68) | ○ |
| C-77 | 複数weight時result | E-16 (L65-68) | ○ |
| C-78 | ローカルフォントバリデーション基本 | E-18 | ○ |
| C-79 | 名前付きエクスポートエラー | E-18 (L38-39) | ○ |
| C-80 | src未指定エラー | E-18 (L61-63) | ○ |
| C-81 | 文字列src配列変換 | E-18 (L65-66) | ○ |
| C-82 | 配列src処理 | E-18 (L73-84) | ○ |
| C-83 | 空配列srcエラー | E-18 (L68-70) | ○ |
| C-84 | 不正拡張子エラー | E-18 (L74-77) | ○ |
| C-85 | ttf format変換 | E-18 (L5-11) | ○ |
| C-86 | woff2 format変換 | E-18 (L5-11) | ○ |
| C-87 | otf format変換 | E-18 (L5-11) | ○ |
| C-88 | eot format変換 | E-18 (L5-11) | ○ |
| C-89 | 不正displayエラー | E-18 (L53-59), E-03 | ○ |
| C-90 | 禁止prop検出（src） | E-18 (L86-95) | ○ |
| C-91 | 禁止prop検出（font-display） | E-18 (L89) | ○ |
| C-92 | 禁止prop検出（font-weight） | E-18 (L89) | ○ |
| C-93 | デフォルト値適用 | E-18 (L43, L47) | ○ |
| C-94 | weight400最接近選択 | E-19 (L68-103) | ○ |
| C-95 | normalスタイル優先 | E-19 (L80-86) | ○ |
| C-96 | 軽量フォント優先 | E-19 (L95-100) | ○ |
| C-97 | variable weight範囲処理 | E-19 (L23-57) | ○ |
| C-98 | 単一ファイル処理 | E-19 (L71) | ○ |
| C-99 | weight未指定時距離0 | E-19 (L24) | ○ |
| C-100 | normal weight=400解釈 | E-19 (L10-16) | ○ |
| C-101 | bold weight=700解釈 | E-19 (L10-16) | ○ |
| C-102 | 不正weight値エラー | E-19 (L32-36) | ○ |
| C-103 | sans-serifフォールバック | E-20 (L6-10, L77-78) | ○ |
| C-104 | serifフォールバック | E-20 (L11-15, L77-78) | ○ |
| C-105 | オーバーライド値%形式 | E-20 (L54-56, L88-93) | ○ |
| C-106 | デフォルトカテゴリserif | E-20 (L76) | ○ |
| C-107 | 平均幅計算 | E-20 (L21-52) | ○ |
| C-108 | グリフ不足時undefined | E-20 (L41) | ○ |
| C-109 | formatOverrideValue正常 | E-20 (L54-56) | ○ |
| C-110 | formatOverrideValue負値 | E-20 (L54-56) | ○ |
| C-111 | formatOverrideValueゼロ | E-20 (L54-56) | ○ |
| C-112 | ローカルローダー基本機能 | E-21 | ○ |
| C-113 | 単一src時weight/style返却 | E-21 (L107-108) | ○ |
| C-114 | 複数src時weight/style undefined | E-21 (L107-108) | ○ |
| C-115 | フォールバック無効時 | E-21 (L94) | ○ |
| C-116 | カスタムfont-family | E-21 (L58-67) | ○ |
| C-117 | デフォルトfont-family | E-21 (L67) | ○ |
| C-118 | serifフォールバック指定 | E-21 (L99) | ○ |
| C-119 | allowedDisplayValues定数検証 | E-03 | ○ |
| C-120 | googleFontsMetadata構造検証 | E-17 | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-FNT-049/052/053/057（ネットワーク関連テスト）**: 実際のHTTPリクエストの動作検証にはネットワークモック（nock, msw等）が必要。ソースコード上のロジックは確認できるが、実際のネットワーク挙動の完全な検証は外部依存。
  - 候補：nock / msw / jest.mock('http') / jest.mock('https')
- **UT-FNT-120（googleFontsMetadata構造）**: font-data.jsonの全体構造は非常に大きく（826KB超）、全エントリの網羅的な検証は困難。代表的なフォントでのスポットチェックが現実的。
  - 候補：代表フォント（Roboto, Open Sans等）でのスポットチェック

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - nextFontError, formatAvailableValues, constants: 単純な関数で根拠が明確
- **0: 低リスク** - sortFontsVariantValues: 既存テスト（E-25）も存在し、ロジックが明確
- **1: 中リスク** - validateGoogleFontFunctionCall: 複雑な条件分岐が多く、テストケースの網羅性に注意が必要
- **1: 中リスク** - getFontAxes: variableフォントの軸処理が複雑で、googleFontsMetadataへの依存あり
- **1: 中リスク** - pickFontFileForFallbackGeneration: weightの距離計算ロジックが複雑
- **2: 高リスク** - fetchResource/fetchCSSFromGoogleFonts/fetchFontFile: ネットワーク依存の処理で、テスト環境でのモック設定が必須

## 6) レビュアーチェックリスト（最小）
- [ ] validateGoogleFontFunctionCallの全条件分岐がテストケースでカバーされているか
- [ ] validateLocalFontFunctionCallの全拡張子マッピングが検証されているか
- [ ] pickFontFileForFallbackGenerationのweight距離計算ロジックが正しくテストされているか
- [ ] getFontAxesのvariableフォント軸処理が網羅的にテストされているか
- [ ] ネットワーク関連テスト（fetchResource等）のモック戦略が妥当か
- [ ] getGoogleFontsUrlのURL生成で、特殊文字やスペースを含むフォント名が正しく処理されるか
- [ ] nextFontGoogleFontLoaderの開発モードフォールバック動作が十分にテストされているか
- [ ] getFallbackMetricsFromFontFileのメトリクス計算精度が許容範囲内か
