---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 112
  claims_with_evidence: 108
  claims_without_evidence: 4
confidence_derived: 0.96
---

# 根拠レポート：next-routing 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：108 / 112、根拠なし：4
- 優先レビュー（高）
  1. **C-105 (i18nドメインリダイレクト)**: resolveRoutes内のi18nドメインリダイレクトのフロー全体が複雑であり、条件分岐の網羅が不十分な可能性
  2. **C-106 (i18n内部ロケール付与)**: 内部的なロケール付与の副作用について、テストケースの前提条件が曖昧
  3. **C-081 (重複ヘッダー処理)**: Response APIの重複ヘッダー挙動はブラウザ実装依存であり、テスト環境によって結果が異なる可能性
  4. **C-047 (不正なq値の処理)**: parseFloatの挙動に依存しており、NaNの場合のフィルタリングの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next-routing/src/destination.ts` - replaceDestination, isExternalDestination, applyDestination, isRedirectStatus, hasRedirectHeaders関数の実装
- E-02: `packages/next-routing/src/i18n.ts` - detectDomainLocale, normalizeLocalePath, getAcceptLanguageLocale, getCookieLocale, detectLocale関数の実装
- E-03: `packages/next-routing/src/matchers.ts` - matchesCondition, getConditionValue, normalizeCaptureKey, checkHasConditions, checkMissingConditions関数の実装
- E-04: `packages/next-routing/src/middleware.ts` - responseToMiddlewareResult, getRelativeURL関数の実装, allowedStatusCodesの定義
- E-05: `packages/next-routing/src/next-data.ts` - normalizeNextDataUrl, denormalizeNextDataUrl関数の実装
- E-06: `packages/next-routing/src/resolve-routes.ts` - resolveRoutes, matchRoute, processRoutes, matchesPathname, matchDynamicRoute, applyOnMatchHeaders, checkDynamicRoutes関数の実装
- E-07: `packages/next-routing/src/types.ts` - RouteHas, Route, MiddlewareContext, MiddlewareResult, ResolveRoutesParams, ResolveRoutesResult型定義
- E-08: `packages/next-routing/src/index.ts` - モジュールのエクスポート定義

## 3) Claims と根拠の対応（レビューの主戦場）

### destination.ts関連 (C-001 ~ C-026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | replaceDestination: 番号付きキャプチャ($1,$2)の置換 | E-01 (L12-19) | ○ |
| C-002 | replaceDestination: 名前付きキャプチャ($name)の置換 | E-01 (L22-29) | ○ |
| C-003 | replaceDestination: hasキャプチャの置換 | E-01 (L32-35) | ○ |
| C-004 | replaceDestination: 両方のキャプチャの同時置換 | E-01 (L12-35) | ○ |
| C-005 | replaceDestination: regexMatches=nullでhasキャプチャのみ適用 | E-01 (L13, L32-35) | ○ |
| C-006 | replaceDestination: プレースホルダなしの場合にそのまま返却 | E-01 (L10, L37) | ○ |
| C-007 | replaceDestination: undefined値のスキップ | E-01 (L17) | ○ |
| C-008 | isExternalDestination: http://判定 | E-01 (L44) | ○ |
| C-009 | isExternalDestination: https://判定 | E-01 (L44) | ○ |
| C-010 | isExternalDestination: 相対パスの判定 | E-01 (L44) | ○ |
| C-011 | isExternalDestination: 空文字列の判定 | E-01 (L44) | ○ |
| C-012 | applyDestination: 外部URLの場合 | E-01 (L52-54) | ○ |
| C-013 | applyDestination: 相対パスの更新 | E-01 (L57-71) | ○ |
| C-014 | applyDestination: クエリ文字列マージ | E-01 (L63-69) | ○ |
| C-015 | applyDestination: クエリなしで既存パラメータ保持 | E-01 (L57-60) | ○ |
| C-016 | isRedirectStatus: 300がtrue | E-01 (L78-79) | ○ |
| C-017 | isRedirectStatus: 399がtrue | E-01 (L79) | ○ |
| C-018 | isRedirectStatus: 200がfalse | E-01 (L79) | ○ |
| C-019 | isRedirectStatus: undefinedがfalse | E-01 (L78) | ○ |
| C-020 | isRedirectStatus: 299がfalse | E-01 (L79) | ○ |
| C-021 | isRedirectStatus: 400がfalse | E-01 (L79) | ○ |
| C-022 | hasRedirectHeaders: Location検出 | E-01 (L86-87) | ○ |
| C-023 | hasRedirectHeaders: Refresh検出 | E-01 (L87) | ○ |
| C-024 | hasRedirectHeaders: 大小文字不問 | E-01 (L86) | ○ |
| C-025 | hasRedirectHeaders: リダイレクトヘッダーなし | E-01 (L86-87) | ○ |
| C-026 | hasRedirectHeaders: 空オブジェクト | E-01 (L86-87) | ○ |

### i18n.ts関連 (C-027 ~ C-058)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-027 | detectDomainLocale: ホスト名マッチ | E-02 (L36-37) | ○ |
| C-028 | detectDomainLocale: ロケールマッチ | E-02 (L38) | ○ |
| C-029 | detectDomainLocale: locales配列マッチ | E-02 (L39-41) | ○ |
| C-030 | detectDomainLocale: ポート番号除去 | E-02 (L34) | ○ |
| C-031 | detectDomainLocale: undefined domains | E-02 (L27) | ○ |
| C-032 | detectDomainLocale: undefined hostname | E-02 (L29-30) | ○ |
| C-033 | detectDomainLocale: 大小文字不問 | E-02 (L29-30, L34) | ○ |
| C-034 | normalizeLocalePath: ロケール除去 | E-02 (L65-89) | ○ |
| C-035 | normalizeLocalePath: ロケールなし | E-02 (L79-81) | ○ |
| C-036 | normalizeLocalePath: 大小文字不問 | E-02 (L73, L76-77) | ○ |
| C-037 | normalizeLocalePath: 空locales | E-02 (L60-62) | ○ |
| C-038 | normalizeLocalePath: ルートパス | E-02 (L68-69) | ○ |
| C-039 | normalizeLocalePath: ロケールのみパス | E-02 (L87) | ○ |
| C-040 | getAcceptLanguageLocale: 最優先ロケール | E-02 (L105-136) | ○ |
| C-041 | getAcceptLanguageLocale: 品質値優先 | E-02 (L122) | ○ |
| C-042 | getAcceptLanguageLocale: プレフィックスマッチ | E-02 (L139-144) | ○ |
| C-043 | getAcceptLanguageLocale: 逆プレフィックスマッチ | E-02 (L146-149) | ○ |
| C-044 | getAcceptLanguageLocale: 空ヘッダー | E-02 (L99-101) | ○ |
| C-045 | getAcceptLanguageLocale: マッチなし | E-02 (L153) | ○ |
| C-046 | getAcceptLanguageLocale: 空locales | E-02 (L99) | ○ |
| C-047 | getAcceptLanguageLocale: 不正q値 | E-02 (L113-116, L154-156) | △ |
| C-048 | getCookieLocale: クッキーロケール検出 | E-02 (L170-188) | ○ |
| C-049 | getCookieLocale: 複数クッキー | E-02 (L171-179) | ○ |
| C-050 | getCookieLocale: 大小文字不問 | E-02 (L182, L187) | ○ |
| C-051 | getCookieLocale: undefined入力 | E-02 (L166-168) | ○ |
| C-052 | getCookieLocale: クッキーなし | E-02 (L183-185) | ○ |
| C-053 | getCookieLocale: 未設定ロケール | E-02 (L187) | ○ |
| C-054 | detectLocale: パスロケール優先 | E-02 (L211-218) | ○ |
| C-055 | detectLocale: クッキー>Accept-Language | E-02 (L231-238, L241-251) | ○ |
| C-056 | detectLocale: localeDetection=false | E-02 (L221-228) | ○ |
| C-057 | detectLocale: ドメインフォールバック | E-02 (L254-261) | ○ |
| C-058 | detectLocale: デフォルトフォールバック | E-02 (L264-268) | ○ |

### matchers.ts関連 (C-059 ~ C-073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-059 | checkHasConditions: undefined条件 | E-03 (L93-95) | ○ |
| C-060 | checkHasConditions: 空配列 | E-03 (L93-95) | ○ |
| C-061 | checkHasConditions: ヘッダーマッチ | E-03 (L48-50, L99-114) | ○ |
| C-062 | checkHasConditions: クッキーマッチ | E-03 (L51-67) | ○ |
| C-063 | checkHasConditions: クエリマッチ | E-03 (L69-70) | ○ |
| C-064 | checkHasConditions: ホストマッチ | E-03 (L71-72) | ○ |
| C-065 | checkHasConditions: 正規表現マッチ | E-03 (L22-28) | ○ |
| C-066 | checkHasConditions: マッチ失敗 | E-03 (L103-105) | ○ |
| C-067 | checkHasConditions: 複数条件全マッチ | E-03 (L99-114) | ○ |
| C-068 | checkHasConditions: 部分マッチ失敗 | E-03 (L103-105) | ○ |
| C-069 | checkHasConditions: host条件キャプチャ除外 | E-03 (L108) | ○ |
| C-070 | checkMissingConditions: undefined条件 | E-03 (L125-127) | ○ |
| C-071 | checkMissingConditions: 不在確認成功 | E-03 (L129-138) | ○ |
| C-072 | checkMissingConditions: 不在条件違反 | E-03 (L134-135) | ○ |
| C-073 | checkMissingConditions: 複数条件一部マッチ | E-03 (L129-138) | ○ |

### middleware.ts関連 (C-074 ~ C-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-074 | responseToMiddlewareResult: rewrite処理 | E-04 (L142-161) | ○ |
| C-075 | responseToMiddlewareResult: redirect処理 | E-04 (L164-194) | ○ |
| C-076 | responseToMiddlewareResult: ヘッダーオーバーライド | E-04 (L38-82) | ○ |
| C-077 | responseToMiddlewareResult: bodySent=true | E-04 (L85-91, L198-201) | ○ |
| C-078 | responseToMiddlewareResult: set-cookie処理 | E-04 (L111-122) | ○ |
| C-079 | responseToMiddlewareResult: 外部rewrite | E-04 (L150-154) | ○ |
| C-080 | responseToMiddlewareResult: 非リダイレクトlocation | E-04 (L168, L190-193) | ○ |
| C-081 | responseToMiddlewareResult: 重複ヘッダー | E-04 (L22-34) | △ |
| C-082 | responseToMiddlewareResult: 内部ヘッダーフィルタ | E-04 (L98-108) | ○ |

### next-data.ts関連 (C-083 ~ C-090)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-083 | normalizeNextDataUrl: プレフィックス除去 | E-05 (L14-27) | ○ |
| C-084 | normalizeNextDataUrl: .json除去 | E-05 (L21-23) | ○ |
| C-085 | normalizeNextDataUrl: basePath処理 | E-05 (L14, L25) | ○ |
| C-086 | normalizeNextDataUrl: 非データURL | E-05 (L16) | ○ |
| C-087 | normalizeNextDataUrl: ネストパス | E-05 (L18-25) | ○ |
| C-088 | denormalizeNextDataUrl: プレフィックス付与 | E-05 (L45-56) | ○ |
| C-089 | denormalizeNextDataUrl: basePath処理 | E-05 (L48-51, L54) | ○ |
| C-090 | denormalizeNextDataUrl: 二重変換防止 | E-05 (L46) | ○ |

### resolve-routes.ts関連 (C-091 ~ C-112)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-091 | resolveRoutes: 静的パスマッチ | E-06 (L523-564) | ○ |
| C-092 | resolveRoutes: 動的ルートマッチ | E-06 (L163-202, L676-711) | ○ |
| C-093 | resolveRoutes: beforeMiddleware処理順序 | E-06 (L407-435) | ○ |
| C-094 | resolveRoutes: beforeMiddlewareリダイレクト停止 | E-06 (L419-425) | ○ |
| C-095 | resolveRoutes: middleware bodySent | E-06 (L450-452) | ○ |
| C-096 | resolveRoutes: ミドルウェアリダイレクト | E-06 (L460-466) | ○ |
| C-097 | resolveRoutes: ミドルウェアrewrite | E-06 (L469-480) | ○ |
| C-098 | resolveRoutes: 外部リライト検出 | E-06 (L472-479) | ○ |
| C-099 | resolveRoutes: beforeFiles処理 | E-06 (L487-515) | ○ |
| C-100 | resolveRoutes: afterFilesリダイレクト | E-06 (L571-605) | ○ |
| C-101 | resolveRoutes: afterFiles外部リライト | E-06 (L607-614) | ○ |
| C-102 | resolveRoutes: fallback処理 | E-06 (L713-815) | ○ |
| C-103 | resolveRoutes: データURL正規化 | E-06 (L304-312) | ○ |
| C-104 | resolveRoutes: i18nルーティング | E-06 (L314-405) | ○ |
| C-105 | resolveRoutes: i18nドメインリダイレクト | E-06 (L351-395) | △ |
| C-106 | resolveRoutes: i18n内部ロケール付与 | E-06 (L399-403) | △ |
| C-107 | resolveRoutes: i18n除外パス | E-06 (L321) | ○ |
| C-108 | resolveRoutes: onMatchヘッダー適用 | E-06 (L207-219) | ○ |
| C-109 | resolveRoutes: マッチなし結果 | E-06 (L818-821) | ○ |
| C-110 | resolveRoutes: ミドルウェアヘッダー伝播 | E-06 (L455-457) | ○ |
| C-111 | resolveRoutes: ミドルウェア前の逆正規化 | E-06 (L437-440) | ○ |
| C-112 | resolveRoutes: 静的+動的マッチ | E-06 (L524-555) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-047 (不正なq値の処理)**: parseFloat('invalid')の結果はNaN。NaN > 0はfalseとなるためfilterで除外されるが、この挙動はJavaScript仕様に依存しており、テストケースの期待結果をより具体的に記述すべき
  - 候補：JavaScript仕様書 / parseFloat MDN / RFC 7231
- **C-081 (重複ヘッダー処理)**: Response APIのheaders.forEach()での重複ヘッダー列挙挙動はFetch API仕様に依存。テスト環境(Node.js版)での実際の挙動確認が必要
  - 候補：Fetch API仕様 / Node.js実装ドキュメント
- **C-105 (i18nドメインリダイレクト)**: ドメインリダイレクトのフロー内には複数の条件分岐があり、テストケースが全分岐を網羅しているか確認が必要
  - 候補：既存テスト `__tests__/i18n-resolve-routes.test.ts` を参照
- **C-106 (i18n内部ロケール付与)**: ロケール付与後のURL形式の詳細仕様(basePath + locale + pathnameの組み合わせ)について要確認
  - 候補：既存テスト `__tests__/i18n-resolve-routes.test.ts` を参照

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - destination.ts, next-data.tsの関数群は純粋関数であり、テストケースのカバレッジは十分
- 0: 低リスク - matchers.tsのcheckHasConditions/checkMissingConditionsは入出力が明確
- 1: 中リスク - middleware.tsのresponseToMiddlewareResultは内部状態変更（requestHeadersのミューテーション）があり、副作用のテストが重要
- 1: 中リスク - resolve-routes.tsのresolveRoutesは多数の条件分岐を持ち、統合的なシナリオテストの網羅性確認が必要
- 1: 中リスク - i18nのドメインリダイレクトフローは複雑な条件分岐があり、テストケースの充実が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] destination.tsの各関数について正常系・異常系・境界値が網羅されているか
- [ ] i18n.tsのロケール検出優先順位（パス > クッキー > Accept-Language > ドメイン > デフォルト）がテストケースに反映されているか
- [ ] matchers.tsの各条件タイプ（header, cookie, query, host）のテストケースが揃っているか
- [ ] middleware.tsのresponseToMiddlewareResultの副作用（requestHeadersの変更）が適切にテストされているか
- [ ] resolve-routes.tsのルート処理順序（beforeMiddleware -> middleware -> beforeFiles -> static -> afterFiles -> dynamic -> fallback）がテストされているか
- [ ] next-data.tsのnormalize/denormalizeの対称性が確認されているか
- [ ] i18nドメインリダイレクトの条件分岐が十分にカバーされているか（C-105参照）
- [ ] 重複ヘッダー処理のテスト環境依存性を確認したか（C-081参照）
