---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 70
  claims_with_evidence: 67
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：next-src-api 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：67 / 70、根拠なし：3
- 優先レビュー（高）
  1. **UT-API-055**：不正なインポート時の挙動はTypeScriptコンパイラとランタイムで異なる可能性
  2. **UT-API-056**：cookies/headers/draftModeの戻り値型検証はランタイム環境依存
  3. **UT-API-069/070**：entry-constantsファイルの内容を直接確認していない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/api/app-dynamic.ts` - app-dynamic再エクスポートファイル
- E-02: `packages/next/src/api/app.tsx` - app再エクスポートファイル
- E-03: `packages/next/src/api/constants.ts` - constants再エクスポートファイル
- E-04: `packages/next/src/api/document.tsx` - document再エクスポートファイル
- E-05: `packages/next/src/api/dynamic.ts` - dynamic再エクスポートファイル
- E-06: `packages/next/src/api/form.ts` - form再エクスポートファイル
- E-07: `packages/next/src/api/head.ts` - head再エクスポートファイル
- E-08: `packages/next/src/api/headers.ts` - headers再エクスポートファイル
- E-09: `packages/next/src/api/image.ts` - image再エクスポートファイル
- E-10: `packages/next/src/api/link.ts` - link再エクスポートファイル
- E-11: `packages/next/src/api/navigation.react-server.ts` - navigation(react-server)再エクスポートファイル
- E-12: `packages/next/src/api/navigation.ts` - navigation再エクスポートファイル
- E-13: `packages/next/src/api/og.ts` - og再エクスポートファイル
- E-14: `packages/next/src/api/router.ts` - router再エクスポートファイル
- E-15: `packages/next/src/api/script.ts` - script再エクスポートファイル
- E-16: `packages/next/src/api/server.ts` - server再エクスポートファイル
- E-17: `packages/next/src/shared/lib/app-dynamic.tsx` - app-dynamic実装ファイル
- E-18: `packages/next/src/shared/lib/dynamic.tsx` - dynamic実装ファイル
- E-19: `packages/next/src/shared/lib/head.tsx` - head実装ファイル
- E-20: `packages/next/src/shared/lib/constants.ts` - constants実装ファイル
- E-21: `packages/next/src/shared/lib/image-external.tsx` - image-external実装ファイル
- E-22: `packages/next/src/server/request/cookies.ts` - cookies実装ファイル
- E-23: `packages/next/src/server/request/headers.ts` - headers実装ファイル
- E-24: `packages/next/src/server/request/draft-mode.ts` - draft-mode実装ファイル
- E-25: `packages/next/src/server/web/exports/index.ts` - server web exports実装ファイル
- E-26: `packages/next/src/server/og/image-response.ts` - image-response実装ファイル
- E-27: `packages/next/src/client/components/navigation.react-server.ts` - navigation.react-server実装ファイル
- E-28: `packages/next/src/client/components/navigation.ts` - navigation実装ファイル
- E-29: `packages/next/src/pages/_app.tsx` - App実装ファイル
- E-30: `packages/next/src/pages/_document.tsx` - Document実装ファイル
- E-31: `packages/next/src/client/form.tsx` - Form実装ファイル
- E-32: `packages/next/src/client/router.ts` - router実装ファイル
- E-33: `packages/next/src/client/script.tsx` - Script実装ファイル
- E-34: `packages/next/src/client/link.tsx` - Link実装ファイル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | app-dynamic.tsはshared/lib/app-dynamicからdefaultとnamed exportsを再エクスポートする | E-01, E-17 | ○ |
| C-02 | app.tsxはpages/_appからAppクラスと関連型を再エクスポートする | E-02, E-29 | ○ |
| C-03 | constants.tsはshared/lib/constantsから全定数を再エクスポートする | E-03, E-20 | ○ |
| C-04 | COMPILER_NAMESがclient/server/edgeServerの3値を持つ | E-20 | ○ |
| C-05 | PHASE定数群が正しい文字列値を持つ | E-20 | ○ |
| C-06 | CONFIG_FILESにnext.config.js/mjs/tsが含まれる | E-20 | ○ |
| C-07 | BLOCKED_PAGESに/_document/_app/_errorが含まれる | E-20 | ○ |
| C-08 | document.tsxはpages/_documentからDocument/Head/Html/Main/NextScriptを再エクスポートする | E-04, E-30 | ○ |
| C-09 | dynamic.tsはshared/lib/dynamicからdynamic関数とnoSSRを再エクスポートする | E-05, E-18 | ○ |
| C-10 | form.tsはclient/formからFormコンポーネントを再エクスポートする | E-06, E-31 | ○ |
| C-11 | head.tsはshared/lib/headからHeadコンポーネントとdefaultHead関数を再エクスポートする | E-07, E-19 | ○ |
| C-12 | headers.tsはserver/request/cookies, headers, draft-modeから関数を再エクスポートする | E-08, E-22, E-23, E-24 | ○ |
| C-13 | cookies関数がPromise<ReadonlyRequestCookies>を返す | E-22 | ○ |
| C-14 | headers関数がPromise<ReadonlyHeaders>を返す | E-23 | ○ |
| C-15 | draftMode関数がPromise<DraftMode>を返す | E-24 | ○ |
| C-16 | image.tsはshared/lib/image-externalからImageとgetImagePropsを再エクスポートする | E-09, E-21 | ○ |
| C-17 | link.tsはclient/linkからLinkコンポーネントを再エクスポートする | E-10, E-34 | ○ |
| C-18 | navigation.react-server.tsはclient/components/navigation.react-serverから再エクスポートする | E-11, E-27 | ○ |
| C-19 | redirect/permanentRedirect/notFound/forbidden/unauthorizedがエクスポートされる | E-27 | ○ |
| C-20 | unstable_isUnrecognizedActionErrorがサーバー側でエラーをスローする | E-27 | ○ |
| C-21 | RedirectTypeがpushとreplaceの2値を持つ | E-27 | ○ |
| C-22 | navigation.tsはclient/components/navigationから全フックを再エクスポートする | E-12, E-28 | ○ |
| C-23 | useSearchParams/usePathname/useRouter/useParamsフックが含まれる | E-28 | ○ |
| C-24 | useSelectedLayoutSegment/useSelectedLayoutSegmentsフックが含まれる | E-28 | ○ |
| C-25 | og.tsはserver/og/image-responseからImageResponseを再エクスポートする | E-13, E-26 | ○ |
| C-26 | router.tsはclient/routerからsingletonRouter/useRouter/withRouter等を再エクスポートする | E-14, E-32 | ○ |
| C-27 | createRouter/makePublicRouterInstanceが再エクスポートされる | E-32 | ○ |
| C-28 | script.tsはclient/scriptからScriptコンポーネントを再エクスポートする | E-15, E-33 | ○ |
| C-29 | server.tsはserver/web/exports/indexからNextRequest/NextResponse等を再エクスポートする | E-16, E-25 | ○ |
| C-30 | after/connectionがserver.tsから再エクスポートされる | E-25 | ○ |
| C-31 | AdapterOutputTypeが7つのenum値を持つ | E-20 | ○ |
| C-32 | マニフェスト定数群が正しいファイル名文字列である | E-20 | ○ |
| C-33 | SYSTEM_ENTRYPOINTSがmain/react-refresh/main-appを含むSet | E-20 | ○ |
| C-34 | COMPILER_INDEXESがclient:0, server:1, edge-server:2 | E-20 | ○ |
| C-35 | EDGE_UNSUPPORTED_NODE_APISが空でない配列 | E-20 | ○ |
| C-36 | DEFAULT_SERIF_FONT/DEFAULT_SANS_SERIF_FONTが4プロパティを持つ | E-20 | ○ |
| C-37 | RSC_MODULE_TYPESがclientとserverの2値を持つ | E-20 | ○ |
| C-38 | UNDERSCORE_NOT_FOUND_ROUTEが再エクスポートされる | E-20 | △ |
| C-39 | UNDERSCORE_GLOBAL_ERROR_ROUTEが再エクスポートされる | E-20 | △ |
| C-40 | 不正なインポート時の挙動がundefinedとなる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- entry-constantsファイル（`packages/next/src/shared/lib/entry-constants.ts`）の内容を直接確認していないため、UNDERSCORE_NOT_FOUND_ROUTE/UNDERSCORE_GLOBAL_ERROR_ROUTEの具体的な値は未検証
  - 候補：`shared/lib/entry-constants.ts`を確認
- 不正インポート時のランタイム挙動はTypeScriptの型チェックとJavaScriptランタイムで異なる可能性がある
  - 候補：実際のランタイムテストで検証

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全16ファイルが再エクスポート（バレルファイル）であり、ロジックを含まないため、テストケースは主にエクスポートの正確性を検証するもの
- 0: 低リスク - 再エクスポート先の実装の詳細テストは各実装モジュール（next-src-shared-lib, next-src-server-request等）の担当範囲
- 1: 中リスク - headers.tsが再エクスポートする cookies/headers/draftMode は非同期API（Promise返却）であり、呼び出しコンテキスト（workStore/workUnitStore）に依存するため、単体テストでのモック設計が重要

## 6) レビュアーチェックリスト（最小）
- [ ] 全16ファイルに対するエクスポート検証テストケースが含まれているか
- [ ] constants.tsの主要定数（PHASE定数、COMPILER_NAMES、CONFIG_FILES等）のテストケースが十分か
- [ ] headers.tsが再エクスポートするcookies/headers/draftModeのテストケースが含まれているか
- [ ] navigation.react-server.tsの各ナビゲーション関数（redirect, notFound, forbidden, unauthorized等）のテストケースが含まれているか
- [ ] navigation.tsの各フック（useSearchParams, usePathname, useRouter, useParams等）のテストケースが含まれているか
- [ ] server.tsの各サーバーAPI（NextRequest, NextResponse, after, connection等）のテストケースが含まれているか
- [ ] テストケースの優先度が適切に設定されているか（認証・認可・データ整合性関連が高優先度）
