---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 141
  claims_with_evidence: 137
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：next-src-build-babel 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：137 / 141、根拠なし：4
- 優先レビュー（高）
  1. **C-027 (UT-BAB-027)**: 正常変換の具体的な入出力は実行環境依存のため根拠が限定的
  2. **C-079 (UT-BAB-079)**: transform全体フローの具体的な変換結果は実行環境依存
  3. **C-090 (UT-BAB-090)**: 既存requireバインディング検出パスの網羅テストは動作確認が必要
  4. **C-122 (UT-BAB-122)**: sweep処理による未使用import削除の全体フローは統合テストに近い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/next/src/build/babel/preset.ts` - Babelプリセット定義（styledJsxOptions, supportsStaticESM, presetTypescriptSyntaxOnly, default export）
- E-02: `packages/next/src/build/babel/loader/index.ts` - webpack loader エントリポイント（nextBabelLoader, nextBabelLoaderOuter）
- E-03: `packages/next/src/build/babel/loader/get-config.ts` - Babel設定生成・キャッシュ（shouldSkipBabel, getCacheCharacteristics, getPlugins, getCustomBabelConfig, checkCustomBabelConfigDeprecation, getCacheKey, updateBabelConfigWithFileDetails, getConfig）
- E-04: `packages/next/src/build/babel/loader/transform.ts` - AST変換処理（getTraversalParams, invokePluginPre, invokePluginPost, transformAstPass, transform）
- E-05: `packages/next/src/build/babel/loader/util.ts` - ユーティリティ関数（consumeIterator, SourceMap型, BabelLoaderTransformOptions型）
- E-06: `packages/next/src/build/babel/loader/types.d.ts` - 型定義（NextJsLoaderContext, NextBabelLoaderOptions等）
- E-07: `packages/next/src/build/babel/plugins/commonjs.ts` - CommonJSモジュールプラグイン
- E-08: `packages/next/src/build/babel/plugins/jsx-pragma.ts` - JSXプラグマ注入プラグイン
- E-09: `packages/next/src/build/babel/plugins/next-font-unsupported.ts` - next/font禁止プラグイン
- E-10: `packages/next/src/build/babel/plugins/next-page-config.ts` - ページ設定バリデーションプラグイン
- E-11: `packages/next/src/build/babel/plugins/next-page-disallow-re-export-all-exports.ts` - export * 禁止プラグイン
- E-12: `packages/next/src/build/babel/plugins/next-ssg-transform.ts` - SSG/SSR変換プラグイン（isDataIdentifier, decorateSsgExport, getIdentifier, isIdentifierReferenced, markFunction, markImport, sweep処理）
- E-13: `packages/next/src/build/babel/plugins/optimize-hook-destructuring.ts` - フック分割代入最適化プラグイン
- E-14: `packages/next/src/build/babel/plugins/react-loadable-plugin.ts` - React Loadable (next/dynamic) プラグイン

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | styledJsxOptionsがundefinedの場合にデフォルト値を返す | E-01 (L17-37) | ○ |
| C-002 | pluginsが配列の場合にrequire.resolveされる | E-01 (L25-34) | ○ |
| C-003 | pluginsが未定義の場合にそのまま返却 | E-01 (L21-23) | ○ |
| C-004 | supportsStaticESMがcaller.supportsStaticESMを返す | E-01 (L74-76) | ○ |
| C-005 | callerがnullの場合にfalse | E-01 (L75: オプショナルチェイニング) | ○ |
| C-006 | callerがundefinedの場合にfalse | E-01 (L75: オプショナルチェイニング) | ○ |
| C-007 | allExtensionsで拡張子検出無効化 | E-01 (L89-90, L107-115) | ○ |
| C-008 | ignoreExtensionsで拡張子検出無効化 | E-01 (L89-90) | ○ |
| C-009 | 拡張子ベースのoverrides生成 | E-01 (L118-138) | ○ |
| C-010 | mtsのsourceType=module | E-01 (L124-126) | ○ |
| C-011 | ctsのsourceType=unambiguous | E-01 (L128-131) | ○ |
| C-012 | standaloneモードでsyntaxのみ | E-01 (L165-181) | ○ |
| C-013 | standaloneでsyntax-typescriptオプション優先 | E-01 (L172-174) | ○ |
| C-014 | standaloneでpreset-typescriptフォールバック | E-01 (L173: ?? 演算子) | ○ |
| C-015 | サーバー向けtargets.node設定 | E-01 (L219-233) | ○ |
| C-016 | テスト環境targets.node設定 | E-01 (L187-195, L220) | ○ |
| C-017 | 既存targets.nodeの保持 | E-01 (L221-226) | ○ |
| C-018 | jsxRuntime=automaticの設定 | E-01 (L204-207, L251) | ○ |
| C-019 | jsxRuntime=classicでpragma設定 | E-01 (L251, L265-276) | ○ |
| C-020 | クライアント向けtransform-runtime有効化 | E-01 (L298-314) | ○ |
| C-021 | サーバー向けtransform-runtime無効化 | E-01 (L298) | ○ |
| C-022 | productionでremove-prop-types有効 | E-01 (L195, L321-326) | ○ |
| C-023 | developmentでremove-prop-types無効 | E-01 (L321) | ○ |
| C-024 | class-propertiesオプション指定時の有効化 | E-01 (L288-291) | ○ |
| C-025 | babel-loader時のruntimeModuleName設定 | E-01 (L235-237) | ○ |
| C-026 | サーバー時のbigintプラグイン有効化 | E-01 (L161-163) | ○ |
| C-027 | 通常ソースコードの変換 | E-02 (L7-46) | △ |
| C-028 | .d.tsファイルのスキップ | E-02 (L16-18) | ○ |
| C-029 | excludeオプションによるスキップ | E-02 (L26-28) | ○ |
| C-030 | webpack loaderとしてのcallback正常呼び出し | E-02 (L48-72) | ○ |
| C-031 | 変換エラー時のcallbackエラー | E-02 (L68-70) | ○ |
| C-032 | shouldSkipBabelのstandalone/noConfig/noCompiler判定 | E-03 (L68-78) | ○ |
| C-033 | shouldSkipBabelのconfigFileあり判定 | E-03 (L68-78) | ○ |
| C-034 | shouldSkipBabelのreactCompilerあり判定 | E-03 (L68-78) | ○ |
| C-035 | shouldSkipBabelのdefaultモード判定 | E-03 (L68-78) | ○ |
| C-036 | getCacheCharacteristicsのdefaultモード | E-03 (L81-151) | ○ |
| C-037 | getCacheCharacteristicsのstandaloneモード | E-03 (L93-95) | ○ |
| C-038 | getCacheCharacteristicsの不正transformMode | E-03 (L96-100) | ○ |
| C-039 | module.exports検出 | E-03 (L104) | ○ |
| C-040 | module.exports非検出 | E-03 (L104) | ○ |
| C-041 | nextDistパス検出 | E-03 (L35-36, L103) | ○ |
| C-042 | node_modules除外によるhasReactCompiler=false | E-03 (L123) | ○ |
| C-043 | ファイル拡張子抽出 | E-03 (L80, L105) | ○ |
| C-044 | 拡張子なしファイルでunknown | E-03 (L105) | ○ |
| C-045 | hasModuleExportsでcommonJsプラグイン | E-03 (L166-171) | ○ |
| C-046 | hasReactRefreshでreactRefreshプラグイン | E-03 (L172-180) | ○ |
| C-047 | クライアントページファイルでpageConfigプラグイン | E-03 (L181-191) | ○ |
| C-048 | サーバー向けプラグイン除外 | E-03 (L182, L192, L213) | ○ |
| C-049 | isNextDistでcommonJsモジュール変換 | E-03 (L219-224) | ○ |
| C-050 | JSON設定ファイル読み込み | E-03 (L253-256) | ○ |
| C-051 | JS設定ファイル読み込み | E-03 (L257-259) | ○ |
| C-052 | .mjsファイルエラー | E-03 (L260-262) | ○ |
| C-053 | 空設定での警告なし | E-03 (L274-277) | ○ |
| C-054 | undefinedでの警告なし | E-03 (L275) | ○ |
| C-055 | styled-components警告 | E-03 (L304-309) | ○ |
| C-056 | emotion警告 | E-03 (L310-314) | ○ |
| C-057 | 未サポートプラグインで警告なし | E-03 (L330-331, L337) | ○ |
| C-058 | 重複警告防止 | E-03 (L284-286) | ○ |
| C-059 | 追加オプションでのスキップ | E-03 (L279-281) | ○ |
| C-060 | 同一特性で同一キー | E-03 (L501-525) | ○ |
| C-061 | 異なるisServerで異なるキー | E-03 (L513-520) | ○ |
| C-062 | 全フラグtrueのビットフラグ | E-03 (L513-520) | ○ |
| C-063 | 全フラグfalseでflags=0 | E-03 (L513-520) | ○ |
| C-064 | 空configFilePath | E-03 (L524) | ○ |
| C-065 | ファイル固有情報の適用 | E-03 (L533-556) | ○ |
| C-066 | cachedConfig=nullでnull返却 | E-03 (L539-541) | ○ |
| C-067 | cachedConfig=undefinedでnull返却 | E-03 (L539) | ○ |
| C-068 | cwdとroot設定 | E-03 (L546-547) | ○ |
| C-069 | キャッシュミス時の設定生成 | E-03 (L558-622) | ○ |
| C-070 | キャッシュヒット時の設定取得 | E-03 (L590-598) | ○ |
| C-071 | addDependency呼び出し | E-03 (L584-587) | ○ |
| C-072 | getTraversalParamsの正常動作 | E-04 (L20-33) | ○ |
| C-073 | 空pluginPairsでblockHoistのみ | E-04 (L25) | ○ |
| C-074 | invokePluginPreのpre呼び出し | E-04 (L35-41) | ○ |
| C-075 | pre未定義のスキップ | E-04 (L37-39) | ○ |
| C-076 | invokePluginPostのpost呼び出し | E-04 (L43-49) | ○ |
| C-077 | post未定義のスキップ | E-04 (L45-47) | ○ |
| C-078 | babelConfig=null時のソース返却 | E-04 (L93-94) | ○ |
| C-079 | 正常変換フローのcode/map返却 | E-04 (L75-113) | △ |
| C-080 | undefinedソースマップのnull変換 | E-04 (L94) | ○ |
| C-081 | consumeIteratorの最終値返却 | E-05 (L3-9) | ○ |
| C-082 | マルチステップイテレータ消費 | E-05 (L3-9) | ○ |
| C-083 | 即時完了イテレータ | E-05 (L3-9) | ○ |
| C-084 | module.exportsでcommonjs変換適用 | E-07 (L6-30) | ○ |
| C-085 | module.exportsなしで変換スキップ | E-07 (L21-23) | ○ |
| C-086 | module.hot等の類似パターン非検出 | E-07 (L15-16) | ○ |
| C-087 | JSX要素でimport/pragma挿入 | E-08 (L16-17, L27-101) | ○ |
| C-088 | JSXフラグメントでpragma挿入 | E-08 (L22-24) | ○ |
| C-089 | JSXなしでスキップ | E-08 (L28) | ○ |
| C-090 | 既存requireバインディング後の挿入 | E-08 (L60-69) | △ |
| C-091 | namespace import生成 | E-08 (L86) | ○ |
| C-092 | next/font/localのSyntaxError | E-09 (L8-14) | ○ |
| C-093 | next/font/googleのSyntaxError | E-09 (L8-14) | ○ |
| C-094 | @next/font/localのSyntaxError | E-09 (L8-14) | ○ |
| C-095 | @next/font/googleのSyntaxError | E-09 (L8-14) | ○ |
| C-096 | 非対象インポートのスキップ | E-09 (L8-14) | ○ |
| C-097 | 正常なconfig export処理 | E-10 (L22-158) | ○ |
| C-098 | re-exportのエラー | E-10 (L33-54) | ○ |
| C-099 | インポート値exportのエラー | E-10 (L93-111) | ○ |
| C-100 | 不正型configのエラー | E-10 (L130-137) | ○ |
| C-101 | スプレッド禁止エラー | E-10 (L141-148) | ○ |
| C-102 | TSAsExpression処理 | E-10 (L126-128) | ○ |
| C-103 | errorMessageのフォーマット | E-10 (L11-14) | ○ |
| C-104 | export * のSyntaxError | E-11 (L7-18) | ○ |
| C-105 | 名前付きre-exportの許容 | E-11 (L7: ExportAllDeclarationのみ対象) | ○ |
| C-106 | getStaticPropsの検出 | E-12 (L79-95) | ○ |
| C-107 | getServerSidePropsの検出 | E-12 (L81-85) | ○ |
| C-108 | SSG/SSR競合エラー（SSG先） | E-12 (L82-84) | ○ |
| C-109 | SSR/SSG競合エラー（SSR先） | E-12 (L87-89) | ○ |
| C-110 | 非SSG関数のfalse返却 | E-12 (L80, L94) | ○ |
| C-111 | レガシーSSG関数サポート | E-12 (L20-23) | ○ |
| C-112 | SSG変換全体フロー | E-12 (L97-454) | ○ |
| C-113 | SSR変換全体フロー | E-12 (L97-454) | ○ |
| C-114 | 非SSGページの無変更 | E-12 (L310-312) | ○ |
| C-115 | VariableDeclaratorのID取得 | E-12 (L109-115) | ○ |
| C-116 | AssignmentExpressionのID取得 | E-12 (L117-123) | ○ |
| C-117 | ArrowFunctionExpressionでnull | E-12 (L125-127) | ○ |
| C-118 | FunctionDeclarationのID取得 | E-12 (L129-131) | ○ |
| C-119 | 参照識別子の検出 | E-12 (L134-151) | ○ |
| C-120 | 未参照識別子の検出 | E-12 (L134-151) | ○ |
| C-121 | 自己参照FunctionDeclarationの処理 | E-12 (L141-146) | ○ |
| C-122 | sweep処理による未使用import削除 | E-12 (L342-361, L363-448) | △ |
| C-123 | isPrerender時のSTATIC_PROPS_ID装飾 | E-12 (L33-77) | ○ |
| C-124 | isServerProps時のSERVER_PROPS_ID装飾 | E-12 (L38) | ○ |
| C-125 | done=trueでの重複装飾防止 | E-12 (L46-48) | ○ |
| C-126 | フック配列分割代入のオブジェクト変換 | E-13 (L52-72) | ○ |
| C-127 | 戻り値非分割代入のスキップ | E-13 (L33) | ○ |
| C-128 | 非フック関数のスキップ | E-13 (L50) | ○ |
| C-129 | onlyBuiltInsモードのフィルタ | E-13 (L50) | ○ |
| C-130 | libオプションによるフィルタ | E-13 (L23-47) | ○ |
| C-131 | null要素のスキップ | E-13 (L55-56) | ○ |
| C-132 | next/dynamicのloadableGenerated追加 | E-14 (L45-206) | ○ |
| C-133 | import()のアロー関数ラップ | E-14 (L211-213) | ○ |
| C-134 | 非next/dynamicのスキップ | E-14 (L49-50) | ○ |
| C-135 | 引数3つ以上のエラー | E-14 (L70-73) | ○ |
| C-136 | ssr:false+サーバーでloader置換 | E-14 (L131-144) | ○ |
| C-137 | ssr:false+クライアントでloader維持 | E-14 (L140) | ○ |
| C-138 | loadableGenerated既存時のスキップ | E-14 (L113-115) | ○ |
| C-139 | dev/serverモードのmodulesプロパティ | E-14 (L177-184) | ○ |
| C-140 | productionクライアントのwebpackプロパティ | E-14 (L185-203) | ○ |
| C-141 | default specifierなしのスキップ | E-14 (L52-56) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-027, C-079: transform関数の統合テストに相当するケースであり、具体的な変換結果はBabel内部の動作とプラグイン構成に依存する。実際のコード変換結果の検証にはBabelのランタイムが必要。
  - 候補：Babelのテストユーティリティを使った統合テスト / スナップショットテスト
- C-090: jsx-pragmaプラグインのrequireバインディング検出パスは、特定のAST構造（VariableDeclarator + CallExpression(require)）に依存しており、テスト時にBabel ASTの構築が必要。
  - 候補：babel-plugin-tester等のプラグインテストフレームワーク
- C-122: sweep処理は複数回のトラバーサルを行う複雑な処理であり、単体テストよりも統合テストとして検証する方が適切な可能性がある。
  - 候補：完全なBabelトランスフォーム結果を使ったアサーション

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - preset.tsのstyledJsxOptions, supportsStaticESM等の純粋関数は根拠が明確
- 0: 低リスク - get-config.tsのshouldSkipBabel, getCacheKey等のロジック関数は条件分岐が明確
- 0: 低リスク - plugins/next-font-unsupported.ts, next-page-disallow-re-export-all-exports.tsは単純なバリデーション
- 1: 中リスク - plugins/next-ssg-transform.tsのsweep処理は複雑なAST操作を含み、テストケースが全パスをカバーしているか確認が必要
- 1: 中リスク - plugins/react-loadable-plugin.tsのSSR/クライアント分岐はcaller状態に依存するため、モック設定の正確性が重要
- 1: 中リスク - get-config.tsのgetFreshConfig関数は外部依存（Babel API、ファイルシステム）が多く、モックの整合性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] preset.tsのstandalone/defaultモード分岐テストケース（C-012〜C-026）が全条件パスを網羅しているか確認
- [ ] get-config.tsのキャッシュ関連テスト（C-060〜C-071）がキャッシュの一貫性とファイル固有情報の分離を正しく検証しているか確認
- [ ] next-ssg-transform.tsのSSG/SSR競合検出テスト（C-108, C-109）が双方向の競合を検証しているか確認
- [ ] react-loadable-plugin.tsのSSR無効化テスト（C-136, C-137）がサーバー/クライアント両方のケースを検証しているか確認
- [ ] optimize-hook-destructuring.tsのlibフィルタリングテスト（C-130）がreact/preact以外のライブラリを正しく除外するか確認
- [ ] 全テストケースの優先度が、金額計算・認証・セキュリティ関連を「高」とする基準に沿っているか確認
- [ ] 境界値テスト（C-044, C-063, C-073, C-083, C-086, C-131）が適切なエッジケースをカバーしているか確認
