---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 116
  claims_with_evidence: 108
  claims_without_evidence: 8
confidence_derived: 0.93
---

# 根拠レポート：next-src-build-misc 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：108 / 116、根拠なし：8
- 優先レビュー（高）
  1. **C-053〜C-059 (formatRevalidate/formatExpire)**: 関数の具体的な戻り値パターンはformat.tsの実装詳細に依存しており、ファイル全体を精査した上での確認が必要
  2. **C-101〜C-102 (transpileConfig)**: トランスパイル処理はSWCバインディングへの依存があり、実行環境によって結果が異なる可能性がある
  3. **C-115〜C-116 (parseModule)**: parseModuleのキャッシュ動作とエラー時のnull返却は実装詳細であり、バージョンにより異なる可能性がある

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/build/analysis/extract-const-value.ts` - extractExportedConstValue関数、UnsupportedValueError/NoSuchDeclarationErrorクラスの実装
- E-02: `packages/next/src/build/analysis/get-page-static-info.ts` - getRSCModuleInformation、getMiddlewareMatchers、getPageStaticInfo関数の実装
- E-03: `packages/next/src/build/analysis/parse-module.ts` - parseModule関数の実装
- E-04: `packages/next/src/build/static-paths/utils.ts` - encodeParam、normalizePathname、extractPathnameRouteParamSegmentsFromSegments関数の実装
- E-05: `packages/next/src/build/static-paths/app.ts` - filterUniqueParams、generateAllParamCombinations、calculateFallbackMode、assignErrorIfEmpty、generateRouteStaticParams関数の実装
- E-06: `packages/next/src/build/static-paths/app/extract-pathname-route-param-segments-from-loader-tree.ts` - extractPathnameRouteParamSegmentsFromLoaderTree、validatePrefixMatch関数の実装
- E-07: `packages/next/src/build/output/format.ts` - humanReadableTimeRounded、formatRevalidate、formatExpire関数の実装
- E-08: `packages/next/src/build/output/log.ts` - prefixedLog、warnOnce、errorOnce関数の実装
- E-09: `packages/next/src/build/output/store.ts` - formatTrigger関数の実装
- E-10: `packages/next/src/build/segment-config/app/app-segment-config.ts` - parseAppSegmentConfig関数、AppSegmentConfigSchemaの定義
- E-11: `packages/next/src/build/segment-config/pages/pages-segment-config.ts` - parsePagesSegmentConfig関数、PagesSegmentConfigSchemaの定義
- E-12: `packages/next/src/build/segment-config/app/app-segments.ts` - collectSegments関数の実装
- E-13: `packages/next/src/build/segment-config/app/collect-root-param-keys.ts` - collectRootParamKeys関数の実装
- E-14: `packages/next/src/build/turborepo-access-trace/result.ts` - TurborepoAccessTraceResultクラスの実装
- E-15: `packages/next/src/build/turborepo-access-trace/env.ts` - envProxy関数の実装
- E-16: `packages/next/src/build/turborepo-access-trace/tcp.ts` - tcpProxy関数の実装
- E-17: `packages/next/src/build/turborepo-access-trace/helpers.ts` - turborepoTraceAccess、writeTurborepoAccessTraceResult関数の実装
- E-18: `packages/next/src/build/manifests/formatter/format-manifest.ts` - formatManifest関数の実装
- E-19: `packages/next/src/build/webpack-config-rules/resolve.ts` - getMainField関数、mainFieldsPerCompilerオブジェクトの実装
- E-20: `packages/next/src/build/next-config-ts/require-hook.ts` - registerHook、deregisterHook、requireFromString関数の実装
- E-21: `packages/next/src/build/next-config-ts/transpile-config.ts` - transpileConfig、resolveSWCOptions、loadTsConfig関数の実装
- E-22: `packages/next/src/build/jest/jest.ts` - nextJest関数の実装
- E-23: `packages/next/src/build/jest/object-proxy.ts` - オブジェクトプロキシの実装
- E-24: `packages/next/src/build/webpack-build/index.ts` - deepMerge関数の実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | extractExportedConstValueで文字列値を抽出できる | E-01 | ○ |
| C-002 | extractExportedConstValueで数値を抽出できる | E-01 | ○ |
| C-003 | extractExportedConstValueでブール値を抽出できる | E-01 | ○ |
| C-004 | extractExportedConstValueで配列を抽出できる | E-01 | ○ |
| C-005 | extractExportedConstValueでオブジェクトを抽出できる | E-01 | ○ |
| C-006 | extractExportedConstValueでnullを抽出できる | E-01 | ○ |
| C-007 | extractExportedConstValueでテンプレートリテラルを抽出できる | E-01 | ○ |
| C-008 | extractExportedConstValueで正規表現を抽出できる | E-01 | ○ |
| C-009 | extractExportedConstValueでTsSatisfiesExpressionを処理できる | E-01 | ○ |
| C-010 | 存在しないエクスポート名でNoSuchDeclarationErrorがスローされる | E-01 | ○ |
| C-011 | サポートされていないノード型でUnsupportedValueErrorがスローされる | E-01 | ○ |
| C-012 | スプレッド演算子を含む配列でUnsupportedValueErrorがスローされる | E-01 | ○ |
| C-013 | スプレッド演算子を含むオブジェクトでUnsupportedValueErrorがスローされる | E-01 | ○ |
| C-014 | 式を含むテンプレートリテラルでUnsupportedValueErrorがスローされる | E-01 | ○ |
| C-015 | UnsupportedValueErrorでパス情報が生成される | E-01 | ○ |
| C-016 | UnsupportedValueErrorでパスなしの場合undefined | E-01 | ○ |
| C-017 | constでないexportは無視される | E-01 | ○ |
| C-018 | 疎な配列のundefined要素が処理される | E-01 | ○ |
| C-019 | サーバーコンポーネントが正しく識別される | E-02 | ○ |
| C-020 | クライアントコンポーネントが正しく識別される | E-02 | ○ |
| C-021 | 非サーバーレイヤーではclientタイプが返される | E-02 | ○ |
| C-022 | アクションメタデータが正しくパースされる | E-02 | ○ |
| C-023 | 文字列matcherが正しくパースされる | E-02 | ○ |
| C-024 | 配列matcherが正しくパースされる | E-02 | ○ |
| C-025 | basePathが正しく付加される | E-02 | ○ |
| C-026 | i18n設定でlocaleパターンが付加される | E-02 | ○ |
| C-027 | APP typeでgetAppPageStaticInfoが呼ばれる | E-02 | ○ |
| C-028 | PAGES typeでgetPagesPageStaticInfoが呼ばれる | E-02 | ○ |
| C-029 | 文字列パラメータがエンコードされる | E-04 | ○ |
| C-030 | 配列パラメータがスラッシュ区切りでエンコードされる | E-04 | ○ |
| C-031 | 空配列が空文字列を返す | E-04 | ○ |
| C-032 | バックスラッシュがスラッシュに変換される | E-04 | ○ |
| C-033 | 末尾スラッシュが削除される | E-04 | ○ |
| C-034 | ルートパスの末尾スラッシュが保持される | E-04 | ○ |
| C-035 | 動的セグメントが正しく抽出される | E-04 | ○ |
| C-036 | パラメータなしのセグメントがスキップされる | E-04 | ○ |
| C-037 | ローダーツリーからルートパラメータが解決される | E-04 | ○ |
| C-038 | 重複パラメータが除去される | E-05 | ○ |
| C-039 | 配列値を持つパラメータが正しく比較される | E-05 | ○ |
| C-040 | 空のrouteParamsで空配列が返される | E-05 | ○ |
| C-041 | 全てのパラメータ組み合わせが生成される | E-05 | ○ |
| C-042 | rootParamKeysがある場合に不完全な組み合わせがスキップされる | E-05 | ○ |
| C-043 | 空のrouteParamsで空配列が返される（generateAllParamCombinations） | E-05 | ○ |
| C-044 | dynamicParams=trueでfallbackRootParamsがある場合のフォールバック | E-05 | ○ |
| C-045 | dynamicParams=trueでfallbackRootParamsが空の場合のフォールバック | E-05 | ○ |
| C-046 | dynamicParams=falseでNOT_FOUNDが返される | E-05 | ○ |
| C-047 | 子ルートがある場合にthrowOnEmptyStaticShellがfalse | E-05 | ○ |
| C-048 | 子ルートがない場合にthrowOnEmptyStaticShellがtrue | E-05 | ○ |
| C-049 | 空のprerenderedRoutesで早期リターン | E-05 | ○ |
| C-050 | generateStaticParamsが呼び出されパラメータが収集される | E-05 | ○ |
| C-051 | 親パラメータと子パラメータがマージされる | E-05 | ○ |
| C-052 | 空のsegmentsで空配列が返される | E-05 | ○ |
| C-053 | 秒単位の時間が正しくフォーマットされる | E-07 | △ |
| C-054 | 分単位の時間が正しくフォーマットされる | E-07 | △ |
| C-055 | 時間単位のフォーマットが正しい | E-07 | △ |
| C-056 | 近似値が正しく表示される | E-07 | △ |
| C-057 | revalidateが0の場合の戻り値 | E-07 | △ |
| C-058 | expire値が正しくフォーマットされる | E-07 | △ |
| C-059 | expireがundefinedの場合の戻り値 | E-07 | △ |
| C-060 | waitログがプレフィックス付きで出力される | E-08 | ○ |
| C-061 | errorログがconsole.errorで出力される | E-08 | ○ |
| C-062 | warnOnceで同一メッセージが一度だけ出力される | E-08 | ○ |
| C-063 | errorOnceで同一エラーメッセージが一度だけ出力される | E-08 | ○ |
| C-064 | 空メッセージの場合の処理 | E-08 | ○ |
| C-065 | メタデータIDパターンが簡略化される | E-09 | ○ |
| C-066 | formatTriggerで末尾スラッシュが削除される | E-09 | ○ |
| C-067 | formatTriggerでルートパスが保持される | E-09 | ○ |
| C-068 | parseAppSegmentConfigで有効な設定がパースされる | E-10 | ○ |
| C-069 | parseAppSegmentConfigで空オブジェクトがパースされる | E-10 | ○ |
| C-070 | 不正なruntime値でエラーがスローされる（App） | E-10 | ○ |
| C-071 | 不正なrevalidate値でエラーがスローされる | E-10 | ○ |
| C-072 | 全てのdynamic値が受け入れられる | E-10 | ○ |
| C-073 | parsePagesSegmentConfigで有効な設定がパースされる | E-11 | ○ |
| C-074 | 不正なruntime値でエラーがスローされる（Pages） | E-11 | ○ |
| C-075 | collectSegmentsでAppRouteモジュールのセグメントが収集される | E-12 | ○ |
| C-076 | collectSegmentsでAppPageモジュールのセグメントが収集される | E-12 | ○ |
| C-077 | collectSegmentsで不正なモジュール型でエラー | E-12 | ○ |
| C-078 | collectRootParamKeysでAppPageモジュールのキーが収集される | E-13 | ○ |
| C-079 | collectRootParamKeysでAppRouteモジュールで空配列 | E-13 | ○ |
| C-080 | collectRootParamKeysで不正なモジュール型でエラー | E-13 | ○ |
| C-081 | TurborepoAccessTraceResult mergeでトレース結果がマージされる | E-14 | ○ |
| C-082 | TurborepoAccessTraceResult serializeでシリアライズされる | E-14 | ○ |
| C-083 | TurborepoAccessTraceResult toPublicTraceでネットワークアクセスあり | E-14 | ○ |
| C-084 | TurborepoAccessTraceResult toPublicTraceでネットワークアクセスなし | E-14 | ○ |
| C-085 | TurborepoAccessTraceResult fromSerializedでインスタンスが復元される | E-14 | ○ |
| C-086 | envProxyで環境変数アクセスが追跡される | E-15 | ○ |
| C-087 | envProxyの復元関数がprocess.envを元に戻す | E-15 | ○ |
| C-088 | tcpProxyでTCP接続が記録される | E-16 | ○ |
| C-089 | tcpProxyの復元関数がconnectを元に戻す | E-16 | ○ |
| C-090 | turborepoTraceAccessでTRACE_FILE未設定時に直接実行 | E-17 | ○ |
| C-091 | turborepoTraceAccessでTRACE_FILE設定時にトレース実行 | E-17 | ○ |
| C-092 | formatManifestでJSONに整形される | E-18 | ○ |
| C-093 | formatManifestで空オブジェクトがフォーマットされる | E-18 | ○ |
| C-094 | getMainFieldでedge-lightフィールドが返される | E-19 | ○ |
| C-095 | getMainFieldでbrowserフィールドが返される | E-19 | ○ |
| C-096 | getMainFieldでpreferEsm=trueでmoduleが先 | E-19 | ○ |
| C-097 | getMainFieldでpreferEsm=falseでmainが先 | E-19 | ○ |
| C-098 | registerHookでTypeScriptファイルのrequire拡張が登録される | E-20 | ○ |
| C-099 | deregisterHookで登録された拡張が削除される | E-20 | ○ |
| C-100 | requireFromStringで文字列コードからモジュールが読み込まれる | E-20 | ○ |
| C-101 | transpileConfigでTS設定ファイルがトランスパイルされる | E-21 | ○ |
| C-102 | transpileConfig失敗時にエラーがスローされる | E-21 | ○ |
| C-103 | nextJestでカスタム設定がマージされる | E-22 | ○ |
| C-104 | nextJestでCSS/画像モックが設定される | E-22 | ○ |
| C-105 | nextJestでdirなしデフォルト設定が返される | E-22 | ○ |
| C-106 | objectProxyでプロパティ名がそのまま返される | E-23 | ○ |
| C-107 | objectProxyで__esModuleがfalse | E-23 | ○ |
| C-108 | deepMergeで配列を含むオブジェクトがマージされる | E-24 | ○ |
| C-109 | deepMergeでネストされたオブジェクトが再帰的にマージされる | E-24 | ○ |
| C-110 | deepMergeで空オブジェクト同士のマージ | E-24 | ○ |
| C-111 | extractPathnameRouteParamSegmentsFromLoaderTreeで動的セグメント抽出 | E-06 | ○ |
| C-112 | パラレルルートの動的セグメントも抽出される | E-06 | ○ |
| C-113 | プレフィックスマッチで静的セグメントが一致する場合 | E-06 | ○ |
| C-114 | プレフィックスマッチで静的セグメントが一致しない場合 | E-06 | ○ |
| C-115 | parseModuleでパース結果がキャッシュされる | E-03 | △ |
| C-116 | parseModule失敗時にnullが返される | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- **format.tsの詳細実装**: humanReadableTimeRounded/formatRevalidate/formatExpireの具体的な戻り値パターン（近似値表示の閾値等）はformat.tsの完全な実装を精査する必要がある。特に近似値の表記ルール（「≈」の使用基準）は確認が必要。
  - 候補：format.tsの完全な実装確認 / 既存テストケースの参照 / ドキュメントの参照
- **parseModuleのキャッシュ動作**: キャッシュの有無は実装バージョンにより変わる可能性がある。LRU-Cacheの利用有無やキャッシュキーの生成方法を確認する必要がある。
  - 候補：parse-module.tsの完全な実装確認 / LRUキャッシュの利用確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - extractExportedConstValue関連（C-001〜C-018）: ソースコードから直接確認可能
- **0: 低リスク** - TurborepoAccessTraceResult関連（C-081〜C-091）: 小さなクラスでメソッドが明確
- **0: 低リスク** - getMainField関連（C-094〜C-097）: 単純な条件分岐のみ
- **0: 低リスク** - formatManifest関連（C-092〜C-093）: JSON.stringifyのラッパー
- **1: 中リスク** - format.ts関連（C-053〜C-059）: 具体的な出力フォーマットの確認が必要
- **1: 中リスク** - transpileConfig関連（C-101〜C-102）: SWC依存の処理
- **1: 中リスク** - parseModule関連（C-115〜C-116）: キャッシュ動作の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] format.ts（C-053〜C-059）の具体的なフォーマットパターンがソースコードの実装と一致しているか確認
- [ ] parseModule（C-115）のキャッシュ動作が現在の実装バージョンで正しいか確認
- [ ] segment-config関連のZodスキーマ（C-068〜C-074）のバリデーションルールが最新のスキーマ定義と一致しているか確認
- [ ] transpileConfig（C-101〜C-102）のSWCバインディング依存部分が実行環境で適切にテスト可能か確認
- [ ] テストケースのカバレッジが対象モジュール内の全publicメソッド/関数を網羅しているか確認
