---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 168
  claims_with_evidence: 162
  claims_without_evidence: 6
confidence_derived: 0.96
---

# 根拠レポート：next-src-build-swc 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：162 / 168、根拠なし：6
- 優先レビュー（高）
  1. **subscribe関数のバッファリング動作（C-144, C-145）**：内部クロージャのため直接テストが困難。実際の動作はネイティブバインディングの挙動に依存
  2. **loadWasm内removeUndefinedの再帰処理（C-101〜C-105）**：内部クロージャ関数であり、loadWasmからしかアクセスできない
  3. **serializeNextConfig/serializeRuleCondition（C-119〜C-133）**：bindingToApi内部のスコープにある関数で、直接テスト不可能な場合がある
  4. **loadNativeのバインディング検索ロジック（C-110, C-113）**：require呼び出しに依存するためモック化が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/build/swc/options.ts` - SWCオプション生成ロジック（550行）
- E-02: `packages/next/src/build/swc/index.ts` - メインバインディングロード・API（1704行）
- E-03: `packages/next/src/build/swc/helpers.ts` - ヘルパー関数（3行）
- E-04: `packages/next/src/build/swc/jest-transformer.ts` - Jestトランスフォーマー（109行）
- E-05: `packages/next/src/build/swc/types.ts` - 型定義（453行）
- E-06: `packages/next/src/build/swc/install-bindings.ts` - バインディングインストール（23行）
- E-07: `packages/next/src/build/swc/generated-native.d.ts` - ネイティブ型宣言（545行）
- E-08: `packages/next/src/build/swc/generated-wasm.d.ts` - wasm型宣言（22行）

## 3) Claims と根拠の対応（レビューの主戦場）

### options.ts - getParserOptions
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | TSファイルでsyntax='typescript', tsx=false | E-01 (L25-53) | ○ |
| C-002 | TSXファイルでsyntax='typescript', tsx=true | E-01 (L25-53) | ○ |
| C-003 | JSファイルでsyntax='ecmascript', jsx=true | E-01 (L25-53) | ○ |
| C-004 | JSXファイルでsyntax='ecmascript', jsx=true | E-01 (L25-53) | ○ |
| C-005 | experimentalDecoratorsでdecorators=true | E-01 (L42-44) | ○ |
| C-006 | dynamicImport常にtrue | E-01 (L48) | ○ |
| C-007 | jsConfig未指定時のデフォルト | E-01 (L42-44) | ○ |
| C-008 | restパラメータの透過 | E-01 (L39,46) | ○ |

### options.ts - getBaseSWCOptions
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-009 | jest=trueでsourceMaps='inline' | E-01 (L178) | ○ |
| C-010 | jest=falseでsourceMaps=undefined | E-01 (L178) | ○ |
| C-011 | development=trueでNODE_ENV='development' | E-01 (L168) | ○ |
| C-012 | development=falseでNODE_ENV='production' | E-01 (L168) | ○ |
| C-013 | globalWindow=trueでwindow typeof='object' | E-01 (L165) | ○ |
| C-014 | globalWindow=falseでwindow typeof='undefined' | E-01 (L165) | ○ |
| C-015 | hasReactRefresh=trueでreact.refresh=true | E-01 (L157) | ○ |
| C-016 | resolvedBaseUrlとpathsの設定 | E-01 (L120-125) | ○ |
| C-017 | modularizeImportsの変換 | E-01 (L186-202) | ○ |
| C-018 | swcPluginsのフィルタリング・変換 | E-01 (L114-116) | ○ |
| C-019 | serverComponents設定 | E-01 (L216-224) | ○ |
| C-020 | jest=trueでserverComponents=undefined | E-01 (L217) | ○ |
| C-021 | supportedBrowsersのcssEnv設定 | E-01 (L244-250) | ○ |
| C-022 | 空supportedBrowsersでcssEnv非設定 | E-01 (L244) | ○ |
| C-023 | emotion有効時のオプション | E-01 (L210) | ○ |
| C-024 | ReactServerLayerでCSS-in-JS無効 | E-01 (L209) | ○ |

### options.ts - getStyledComponentsOptions / getEmotionOptions
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-025 | styled-components true時のデフォルト | E-01 (L254-270) | ○ |
| C-026 | styled-componentsオブジェクト設定 | E-01 (L260-264) | ○ |
| C-027 | styled-components falsy時null | E-01 (L258) | ○ |
| C-028 | emotion true時のデフォルト | E-01 (L272-304) | ○ |
| C-029 | emotion autoLabel='never' | E-01 (L283) | ○ |
| C-030 | emotion autoLabel='always' | E-01 (L285) | ○ |
| C-031 | emotion autoLabel='dev-only' | E-01 (L287-288) | ○ |
| C-032 | emotion falsy時null | E-01 (L276-278) | ○ |

### options.ts - getJestSWCOptions / getLoaderSWCOptions
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-033 | Jest用サーバーオプション | E-01 (L306-365) | ○ |
| C-034 | Jest用クライアントオプション | E-01 (L335) | ○ |
| C-035 | ESM有効時module.type='es6' | E-01 (L360) | ○ |
| C-036 | .cjsのCommonJS出力 | E-01 (L29-37, L350) | ○ |
| C-037 | disableNextSsg=true | E-01 (L362) | ○ |
| C-038 | ローダーのサーバーオプション | E-01 (L488-506) | ○ |
| C-039 | クライアントページでSSG有効 | E-01 (L511) | ○ |
| C-040 | 非ページでSSG無効 | E-01 (L511) | ○ |
| C-041 | デフォルトES5ターゲット | E-01 (L525-528) | ○ |
| C-042 | optimizeServerReact設定 | E-01 (L464-468) | ○ |
| C-043 | optimizePackageImports設定 | E-01 (L471-475) | ○ |
| C-044 | appPagesBrowserレイヤーnode_modules | E-01 (L533-545) | ○ |
| C-045 | fontLoaders設定 | E-01 (L446-449) | ○ |
| C-046 | cjsRequireOptimizer設定 | E-01 (L450-462) | ○ |

### options.ts - 内部関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-047 | isTypeScriptFile: .ts判定 | E-01 (L25-27) | ○ |
| C-048 | isTypeScriptFile: .tsx判定 | E-01 (L25-27) | ○ |
| C-049 | isTypeScriptFile: .js非判定 | E-01 (L25-27) | ○ |
| C-050 | isCommonJSFile: .cjs判定 | E-01 (L29-31) | ○ |
| C-051 | isCommonJSFile: .js非判定 | E-01 (L29-31) | ○ |
| C-052 | shouldOutputCommonJs: .cjs | E-01 (L35-37) | ○ |
| C-053 | shouldOutputCommonJs: Next.js内部 | E-01 (L35-37, L15-17) | ○ |
| C-054 | shouldOutputCommonJs: 通常ファイル | E-01 (L35-37) | ○ |

### index.ts - エクスポート関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-055 | getSupportedArchTriples: 全プラットフォーム | E-02 (L68-94) | ○ |
| C-056 | win32のmsvcフィルタ | E-02 (L75-76) | ○ |
| C-057 | linuxのgnux32フィルタ | E-02 (L80) | ○ |
| C-058 | getBindingsSync: 正常取得 | E-02 (L175-187) | ○ |
| C-059 | getBindingsSync: pending中エラー | E-02 (L177-180) | ○ |
| C-060 | getBindingsSync: 未ロードエラー | E-02 (L181-184) | ○ |
| C-061 | loadBindings: キャッシュ | E-02 (L200-202) | ○ |
| C-062 | loadBindings: pending再利用 | E-02 (L203-205) | ○ |
| C-063 | loadBindings: RUST_MIN_STACK | E-02 (L208-210) | ○ |
| C-064 | loadBindings: NEXT_TEST_WASM | E-02 (L212-214) | ○ |
| C-065 | loadBindings: 完全失敗エラー | E-02 (L298-304) | ○ |
| C-066 | createDefineEnv: 3バリアント | E-02 (L429-471) | ○ |
| C-067 | createDefineEnv: client | E-02 (L461) | ○ |
| C-068 | createDefineEnv: edge | E-02 (L462) | ○ |

### index.ts - 内部関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-069 | rustifyEnv変換 | E-02 (L473-480) | ○ |
| C-070 | rustifyEnv nullフィルタ | E-02 (L475) | ○ |
| C-071 | rustifyEnv空オブジェクト | E-02 (L473-480) | ○ |
| C-072 | rustifyOptionEnv変換 | E-02 (L482-489) | ○ |
| C-073 | normalizePathOnWindows(Windows) | E-02 (L491-492) | ○ |
| C-074 | normalizePathOnWindows(Unix) | E-02 (L491-492) | ○ |
| C-075 | checkVersionMismatch一致 | E-02 (L131-139) | ○ |
| C-076 | checkVersionMismatch不一致 | E-02 (L134-138) | ○ |
| C-077 | checkVersionMismatch未定義 | E-02 (L133) | ○ |
| C-078 | getMdxOptionsデフォルト | E-02 (L1599-1606) | ○ |
| C-079 | getMdxOptionsカスタム | E-02 (L1599-1606) | ○ |
| C-080 | getMdxOptions引数省略 | E-02 (L1599) | ○ |
| C-081 | toBuffer変換 | E-02 (L1608-1610) | ○ |
| C-082 | toBuffer空オブジェクト | E-02 (L1608-1610) | ○ |

### index.ts - 公開API
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-083 | transform呼び出し | E-02 (L1612-1615) | ○ |
| C-084 | transform未ロードエラー | E-02 (L1613, L175-186) | ○ |
| C-085 | transformSync呼び出し | E-02 (L1618-1621) | ○ |
| C-086 | minify呼び出し | E-02 (L1623-1629) | ○ |
| C-087 | parse呼び出し | E-02 (L1636-1641) | ○ |
| C-088 | parseのパーサーオプション | E-02 (L1638) | ○ |
| C-089 | isReactCompilerRequired | E-02 (L1631-1634) | ○ |
| C-090 | getBinaryMetadata | E-02 (L1643-1647) | ○ |
| C-091 | getBinaryMetadata未ロード | E-02 (L1645) | ○ |
| C-092 | initCustomTraceSubscriber初期化 | E-02 (L1653-1658) | ○ |
| C-093 | initCustomTraceSubscriber重複防止 | E-02 (L1654) | ○ |
| C-094 | teardownTraceSubscriber実行 | E-02 (L1682-1690) | ○ |
| C-095 | teardownTraceSubscriber once | E-02 (L1661-1671) | ○ |
| C-096 | teardownTraceSubscriberエラー抑制 | E-02 (L1687-1689) | ○ |
| C-097 | once: 1回実行 | E-02 (L1661-1671) | ○ |
| C-098 | once: 重複防止 | E-02 (L1661-1671) | ○ |
| C-099 | getModuleNamedExports | E-02 (L1692-1696) | ○ |
| C-100 | warnForEdgeRuntime | E-02 (L1698-1703) | ○ |

### index.ts - loadWasm内部
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | removeUndefined: プロパティ除去 | E-02 (L1233-1251) | ○ |
| C-102 | removeUndefined: ネスト処理 | E-02 (L1233-1251) | ○ |
| C-103 | removeUndefined: 配列処理 | E-02 (L1241) | ○ |
| C-104 | removeUndefined: null | E-02 (L1238) | ○ |
| C-105 | removeUndefined: プリミティブ | E-02 (L1238) | ○ |
| C-106 | wasmBindings isWam=true | E-02 (L1270) | ○ |
| C-107 | wasm turbo.createProjectエラー | E-02 (L1290-1296) | ○ |
| C-108 | wasm css lightningエラー | E-02 (L1258-1262) | ○ |
| C-109 | wasm getTargetTriple undefined | E-02 (L1286-1288) | ○ |

### index.ts - loadNative
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | ネイティブバインディングロード | E-02 (L1384-1595) | ○ |
| C-111 | loadNativeキャッシュ | E-02 (L1385-1387) | ○ |
| C-112 | NEXT_TEST_WASMでエラー | E-02 (L1389-1391) | ○ |
| C-113 | 全トリプル失敗 | E-02 (L1594) | ○ |
| C-114 | モジュールオブジェクトのJSON.stringify | E-02 (L1455-1469) | ○ |
| C-115 | 文字列srcの透過 | E-02 (L1455-1469) | ○ |
| C-116 | transformSync undefined入力エラー | E-02 (L1473-1475) | ○ |
| C-117 | transformSync Buffer入力エラー | E-02 (L1477-1479) | ○ |
| C-118 | パーサーsyntaxデフォルト | E-02 (L1461-1462) | ○ |

### index.ts - bindingToApi内部関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | serializeNextConfig: exportPathMap | E-02 (L859) | ○ |
| C-120 | serializeNextConfig: distDir正規化 | E-02 (L882-887) | ○ |
| C-121 | serializeNextConfig: loaderFile | E-02 (L890-899) | ○ |
| C-122 | serializeNextConfig: cacheHandler絶対パス | E-02 (L901-909) | ○ |
| C-123 | serializeNextConfig: cacheHandler相対パス | E-02 (L901-909) | ○ |
| C-124 | serializeNextConfig: modularizeImports | E-02 (L864-879) | ○ |
| C-125 | serializeNextConfig: turbopackルール | E-02 (L929-938) | ○ |
| C-126 | serializeRuleCondition: 文字列 | E-02 (L973) | ○ |
| C-127 | serializeRuleCondition: all | E-02 (L975-976) | ○ |
| C-128 | serializeRuleCondition: any | E-02 (L977-978) | ○ |
| C-129 | serializeRuleCondition: not | E-02 (L979-980) | ○ |
| C-130 | serializeRuleCondition: path RegExp | E-02 (L984-992) | ○ |
| C-131 | serializeRuleCondition: path glob | E-02 (L992) | ○ |
| C-132 | serializeRuleCondition: query RegExp | E-02 (L996-1001) | ○ |
| C-133 | serializeRuleCondition: query string | E-02 (L1002) | ○ |
| C-134 | serializeTurbopackRules: 配列 | E-02 (L1022-1033) | ○ |
| C-135 | serializeTurbopackRules: 単一 | E-02 (L1034-1036) | ○ |
| C-136 | checkLoaderItem: 非直列化エラー | E-02 (L1061-1071) | ○ |
| C-137 | napiEntrypoints: page | E-02 (L1082-1088) | ○ |
| C-138 | napiEntrypoints: page-api | E-02 (L1089-1093) | ○ |
| C-139 | napiEntrypoints: app-page | E-02 (L1095-1103) | ○ |
| C-140 | napiEntrypoints: app-route | E-02 (L1105-1111) | ○ |
| C-141 | napiEntrypoints: conflict | E-02 (L1112-1116) | ○ |
| C-142 | napiEntrypoints: middleware | E-02 (L1127-1133) | ○ |
| C-143 | napiEntrypoints: middleware未設定 | E-02 (L1131-1133) | ○ |

### index.ts - subscribe / loadBindingsSync / logLoadFailure
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-144 | subscribe: バッファモード | E-02 (L572-642) | △ |
| C-145 | subscribe: 最新値モード | E-02 (L572-642) | △ |
| C-146 | subscribe: エラー伝播 | E-02 (L616-617) | ○ |
| C-147 | subscribe: キャンセル | E-02 (L636-639) | ○ |
| C-148 | loadBindingsSync: 正常 | E-02 (L382-395) | ○ |
| C-149 | loadBindingsSync: 失敗 | E-02 (L394) | ○ |
| C-150 | logLoadFailure: テレメトリ出力 | E-02 (L405-424) | ○ |
| C-151 | logLoadFailure: 重複防止 | E-02 (L407) | ○ |
| C-152 | infoLog: DEBUG時出力 | E-02 (L56-63) | ○ |
| C-153 | infoLog: ビルドワーカー抑制 | E-02 (L57-59) | ○ |

### jest-transformer.ts
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-154 | createTransformer: 基本変換 | E-04 (L83-106) | ○ |
| C-155 | process: testEnvironment='node'でisServer=true | E-04 (L88-90) | ○ |
| C-156 | process: jest-environment-node含むでisServer=true | E-04 (L90) | ○ |
| C-157 | process: jsdom環境でisServer=false | E-04 (L88-90) | ○ |
| C-158 | getJestConfig: jest27形式 | E-04 (L59-65) | ○ |
| C-159 | isEsm: ESMプロジェクトのjsファイル | E-04 (L67-78) | ○ |
| C-160 | isEsm: extensionsToTreatAsEsm | E-04 (L74-76) | ○ |
| C-161 | isEsm: 非ESM | E-04 (L67-78) | ○ |

### helpers.ts
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-162 | __nextjs_pure: 数値 | E-03 (L1-3) | ○ |
| C-163 | __nextjs_pure: オブジェクト | E-03 (L1-3) | ○ |
| C-164 | __nextjs_pure: null | E-03 (L1-3) | ○ |
| C-165 | __nextjs_pure: undefined | E-03 (L1-3) | ○ |

### install-bindings.ts
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-166 | installBindings: ネイティブ | E-06 (L16-23) | ○ |
| C-167 | installBindings: wasm | E-06 (L16-23) | ○ |
| C-168 | installBindings: デフォルト引数 | E-06 (L17) | ○ |

## 4) 不足情報（Unknown / Missing）
- **subscribe関数のバッファリング挙動詳細（C-144, C-145）**：subscribe関数はbindingToApi内部のクロージャであり、直接的な単体テストが困難。バッファモードと最新値モードの切り替えロジック自体はコードから読み取れるが、実際のネイティブ関数との統合動作は不明。
  - 候補：統合テスト / E2Eテスト / モックによる検証
- **loadWasmRawBindingsのパッケージ解決（未カバー）**：`@next/swc-wasm-nodejs`と`@next/swc-wasm-web`の動的importの挙動は環境依存のため、単体テストでの完全な検証が困難。
  - 候補：モック化 / テスト環境でのwasm配置
- **serializeNextConfigのcacheHandlers（C-122〜C-123）**：`cacheHandlers`（複数形）のnullフィルタリングロジックはコードで確認できるが、実行時のnextConfigの構造に依存。
  - 候補：実際のnext.config.jsの検証
- **bindingToApi内部のinvariant関数（未カバー）**：exhaustive checkのためのneverケースであり、通常到達しない。テスト時にモックルートタイプを渡す必要がある。
  - 候補：TypeScriptの型安全性に依存 / 意図的な不正値テスト

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**：subscribe関数のバッファリング動作テスト（C-144, C-145）は、ネイティブバインディングのモック化が必要で、テスト実装が複雑になる可能性がある
- **リスク0（低）**：helpers.tsの`__nextjs_pure`はidentity関数であり、テストケースは網羅的だが実用上のリスクは極めて低い
- **リスク1（中）**：loadNative/loadWasmの各種環境変数（NEXT_TEST_WASM, NEXT_TEST_NATIVE_DIR, __INTERNAL_CUSTOM_TURBOPACK_BINDINGS）に依存するテストケースは、CI環境での再現性に注意が必要
- **リスク1（中）**：serializeNextConfigやserializeRuleConditionはbindingToApi関数内のスコープに定義されており、直接テストするにはリファクタリングまたは統合テストでの検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] getParserOptions: .ts/.tsx/.js/.jsx/.cjs全拡張子のパーサー設定が正しいか
- [ ] getBaseSWCOptions: jest/development/serverComponents等のフラグ組み合わせが網羅されているか
- [ ] getLoaderSWCOptions: isServer=true/false, isPageFile=true/false, bundleLayerの組み合わせが十分か
- [ ] getEmotionOptions: autoLabelの3パターン（never/always/dev-only）がカバーされているか
- [ ] loadBindings/loadNative: エラーケース（全バインディング失敗）が十分にテストされているか
- [ ] serializeNextConfig: Windowsパス正規化、相対パス変換が漏れなく検証されているか
- [ ] subscribe: バッファモードと最新値モードの動作が統合テストで補完されるべきか確認
- [ ] Jestトランスフォーマー: testEnvironment判定ロジックが全パターンカバーされているか
