---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：next-src-build-templates 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **C-094 (maybeJSONParse空文字列)**: 空文字列はfalsyであるためundefined返却だが、実行時の挙動の厳密検証が必要
  2. **C-006 (hoist空文字キー)**: 空文字列キーのin演算子の挙動は言語仕様依存であり実機検証推奨
  3. **C-099 (PPRデバッグモード)**: デバッグモードの条件分岐が複雑で、複数の環境変数の組み合わせに依存
  4. **C-028 (revalidate値バリデーション)**: revalidate < 1 のチェックはコード上で確認できるが、0.5等の小数値テストは実機確認推奨
  5. **C-089 (レガシーAPI)**: unstable_ プレフィクスのAPIは実際のuserlandでの存在が不確実

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/build/templates/helpers.ts` (hoist関数の定義、28行)
- E-02: `packages/next/src/build/templates/edge-wrapper.js` (Proxyベースの非同期モジュールラッパー、23行)
- E-03: `packages/next/src/build/templates/app-page.ts` (App Pageテンプレートハンドラ、1582行)
- E-04: `packages/next/src/build/templates/app-route.ts` (App Routeテンプレートハンドラ、546行)
- E-05: `packages/next/src/build/templates/edge-app-route.ts` (Edge App Routeテンプレート、80行)
- E-06: `packages/next/src/build/templates/edge-ssr-app.ts` (Edge SSR Appテンプレート、424行)
- E-07: `packages/next/src/build/templates/edge-ssr.ts` (Edge SSR Pagesテンプレート、418行)
- E-08: `packages/next/src/build/templates/middleware.ts` (ミドルウェアテンプレート、128行)
- E-09: `packages/next/src/build/templates/pages-api.ts` (Pages APIテンプレート、187行)
- E-10: `packages/next/src/build/templates/pages-edge-api.ts` (Pages Edge APIテンプレート、77行)
- E-11: `packages/next/src/build/templates/pages.ts` (Pagesテンプレート、75行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | hoist: nameプロパティ存在時にその値を返す | E-01 (L10-12) | ○ |
| C-002 | hoist: Promiseライクモジュールのthen解決 | E-01 (L16-18) | ○ |
| C-003 | hoist: 関数モジュール+default時にモジュール自身を返す | E-01 (L22-24) | ○ |
| C-004 | hoist: プロパティ不在時にundefinedを返す | E-01 (L27) | ○ |
| C-005 | hoist: 空オブジェクトでundefinedを返す | E-01 (L10-12, L27) | ○ |
| C-006 | hoist: 空文字キーの挙動 | E-01 (L10) | △ |
| C-007 | hoist: Promise解決後にnameがない場合 | E-01 (L16-18) | ○ |
| C-008 | hoist: 関数モジュール+非defaultキー | E-01 (L22-27) | ○ |
| C-009 | Proxy: thenプロパティでPromise thenを返す | E-02 (L14-15) | ○ |
| C-010 | Proxy: then以外でcallable関数を返す | E-02 (L17-18) | ○ |
| C-011 | Proxy: 返却関数がthenable | E-02 (L19-20) | ○ |
| C-012 | Proxy: モジュールPromise reject時のエラー伝播 | E-02 (L17-18) | ○ |
| C-013 | self._ENTRIESの初期化 | E-02 (L9) | ○ |
| C-014 | self._ENTRIESの既存保護 | E-02 (L9, `||=` 演算子) | ○ |
| C-015 | app-page handler: requestMeta設定 | E-03 (L127-129) | ○ |
| C-016 | app-page handler: prepare null時に400 | E-03 (L155-160) | ○ |
| C-017 | app-page handler: Turbopack /index正規化 | E-03 (L141-142) | ○ |
| C-018 | app-page handler: 非Turbopack /index正規化 | E-03 (L143-146) | ○ |
| C-019 | app-page handler: PPR resumeデータ設定 | E-03 (L317-334) | ○ |
| C-020 | app-page handler: 413サイズ超過 | E-03 (L250-261) | ○ |
| C-021 | app-page handler: postponed受信バイト不足エラー | E-03 (L309-313) | ○ |
| C-022 | app-page handler: draftMode Cache-Control | E-03 (L1111-1116) | ○ |
| C-023 | app-page handler: dev Cache-Control no-cache | E-03 (L1119-1126) | ○ |
| C-024 | app-page handler: エラー時onRequestError | E-03 (L1541-1558) | ○ |
| C-025 | app-page handler: NoFallbackError特別処理 | E-03 (L1542) | ○ |
| C-026 | app-page handler: x-nextjs-cacheヘッダー | E-03 (L1156-1169) | ○ |
| C-027 | app-page handler: cacheEntry null invariantエラー | E-03 (L1129-1136) | ○ |
| C-028 | app-page handler: revalidate値バリデーション | E-03 (L1206-1209) | △ |
| C-029 | createPPRBoundarySentinel | E-03 (L1572-1581) | ○ |
| C-030 | app-route handler: requestMeta設定 | E-04 (L93-95) | ○ |
| C-031 | app-route handler: prepare null時に400 | E-04 (L118-123) | ○ |
| C-032 | app-route handler: ISR cacheKey設定 | E-04 (L171-177) | ○ |
| C-033 | app-route handler: /index cacheKey正規化 | E-04 (L176) | ○ |
| C-034 | app-route handler: 非ISR sendResponse | E-04 (L379-388) | ○ |
| C-035 | app-route handler: ISR draftMode Cache-Control | E-04 (L454-459) | ○ |
| C-036 | app-route handler: ISRエラー再スロー | E-04 (L535) | ○ |
| C-037 | app-route handler: 非ISR 500レスポンス | E-04 (L538-543) | ○ |
| C-038 | app-route handler: エラー時onRequestError | E-04 (L513-529) | ○ |
| C-039 | app-route handler: NoFallbackError | E-04 (L161-167) | ○ |
| C-040 | patchFetch呼び出し | E-04 (L70-75) | ○ |
| C-041 | edge-app-route handler: GET body undefined | E-05 (L63-66) | ○ |
| C-042 | edge-app-route handler: POST body | E-05 (L63-66) | ○ |
| C-043 | edge-app-route handler: waitUntil | E-05 (L73) | ○ |
| C-044 | maybeJSONParse: 正常JSON | E-05 (L12) | ○ |
| C-045 | maybeJSONParse: undefined | E-05 (L12) | ○ |
| C-046 | maybeJSONParse: 不正JSON | E-05 (L12) | ○ |
| C-047 | edge-app-route: マニフェスト設定 | E-05 (L17-23) | ○ |
| C-048 | edge-app-route: マニフェスト不在スキップ | E-05 (L17) | ○ |
| C-049 | edge-ssr-app: prepare null時400 | E-06 (L68-72) | ○ |
| C-050 | edge-ssr-app: 静的レスポンスContent-Length | E-06 (L253-264) | ○ |
| C-051 | edge-ssr-app: 動的ReadableStream | E-06 (L268-283) | ○ |
| C-052 | edge-ssr-app: null結果500 | E-06 (L213-217) | ○ |
| C-053 | edge-ssr-app: Varyヘッダー | E-06 (L208-233) | ○ |
| C-054 | edge-ssr-app handler: HEAD body undefined | E-06 (L407-410) | ○ |
| C-055 | edge-ssr: prepare null時400 | E-07 (L103-107) | ○ |
| C-056 | edge-ssr: 静的Content-Length | E-07 (L211-221) | ○ |
| C-057 | edge-ssr: null結果500 | E-07 (L180-183) | ○ |
| C-058 | edge-ssr: 500エラーページフォールバック | E-07 (L301-338) | ○ |
| C-059 | edge-ssr: errorModフォールバック | E-07 (L301, L327) | ○ |
| C-060 | edge-ssr: 開発モードエラー再スロー | E-07 (L304-306) | ○ |
| C-061 | edge-ssr: pageMod初期化 | E-07 (L42-54) | ○ |
| C-062 | edge-ssr: error500Mod null条件 | E-07 (L71-85) | ○ |
| C-063 | middleware: 非関数エクスポートエラー | E-08 (L30-34) | ○ |
| C-064 | middleware: mod.middleware選択 | E-08 (L18) | ○ |
| C-065 | middleware: mod.defaultフォールバック | E-08 (L18) | ○ |
| C-066 | middleware: proxy判定 /proxy | E-08 (L17-18) | ○ |
| C-067 | middleware: proxy判定 /src/proxy | E-08 (L17) | ○ |
| C-068 | errorHandledHandler: 正常実行 | E-08 (L38-41) | ○ |
| C-069 | errorHandledHandler: NextRouterError | E-08 (L45-49) | ○ |
| C-070 | errorHandledHandler: エッジインストゥルメンテーション | E-08 (L54-67) | ○ |
| C-071 | middleware handler: POST body | E-08 (L111-114) | ○ |
| C-072 | ProxyMissingExportError: stack空文字 | E-08 (L23) | ○ |
| C-073 | pages-api handler: requestMeta設定 | E-09 (L51-53) | ○ |
| C-074 | pages-api handler: prepare null時400 | E-09 (L68-73) | ○ |
| C-075 | pages-api handler: Turbopackパス正規化 | E-09 (L62-64) | ○ |
| C-076 | pages-api handler: 開発モードエラー再スロー | E-09 (L174-176) | ○ |
| C-077 | pages-api handler: 本番sendError 500 | E-09 (L179) | ○ |
| C-078 | pages-api handler: waitUntil Promise.resolve | E-09 (L184) | ○ |
| C-079 | pages-api: defaultエクスポート | E-09 (L23) | ○ |
| C-080 | pages-api: configエクスポート | E-09 (L26) | ○ |
| C-081 | pages-edge-api: 非関数エクスポートエラー | E-10 (L16-20) | ○ |
| C-082 | pages-edge-api handler: GET body undefined | E-10 (L60-63) | ○ |
| C-083 | pages-edge-api handler: POST body | E-10 (L60-63) | ○ |
| C-084 | pages: getStaticPropsエクスポート | E-11 (L18) | ○ |
| C-085 | pages: getStaticPathsエクスポート | E-11 (L19) | ○ |
| C-086 | pages: getServerSidePropsエクスポート | E-11 (L20) | ○ |
| C-087 | pages: routeModule初期化 | E-11 (L47-64) | ○ |
| C-088 | pages: getHandler呼び出し | E-11 (L66-74) | ○ |
| C-089 | pages: レガシーAPIエクスポート | E-11 (L25-44) | △ |
| C-090 | pages: reportWebVitalsエクスポート | E-11 (L22) | ○ |
| C-091 | app-page: セグメントプリフェッチ対応 | E-03 (L1228-1265) | ○ |
| C-092 | app-page: セグメントキャッシュミス204 | E-03 (L1273-1281) | ○ |
| C-093 | app-page: cacheComponents有効時RSC 404 | E-03 (L1361-1371) | ○ |
| C-094 | edge-ssr-app: maybeJSONParse空文字列 | E-06 (L36) | △ |
| C-095 | app-page: flightヘッダーストリップ | E-03 (L485-493) | ○ |
| C-096 | app-page: マニフェストシングルトン設定 | E-03 (L506-512) | ○ |
| C-097 | app-route: マニフェストシングルトン設定 | E-04 (L195-201) | ○ |
| C-098 | app-page: Varyヘッダー設定 | E-03 (L529-533) | ○ |
| C-099 | app-page: PPRデバッグモード空レスポンス | E-03 (L1054-1068) | △ |
| C-100 | app-route: on-demand revalidateスキップ | E-04 (L311-322) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-006**: 空文字列キーのin演算子の挙動はJavaScript仕様上は正常動作するが、実際のuserlandモジュールでこのケースが発生するかは不明
  - 候補：JavaScriptエンジンの仕様確認 / 実機テスト
- **C-028**: revalidate < 1 の条件チェックでは、0と負数は別の経路で処理される可能性があるため、閾値テストの正確性は実機確認が必要
  - 候補：app-page.tsの実行時テスト / ISR revalidation統合テスト
- **C-089**: unstable_ プレフィクス付きのレガシーAPIが実際のNext.jsアプリケーションで利用されているかの確認が必要
  - 候補：Next.js公式ドキュメント / 廃止情報の確認
- **C-094**: 空文字列は JavaScript の falsy 値であるため `str ? JSON.parse(str) : undefined` で undefined を返すが、テンプレート内で空文字列が渡されるシナリオの実在性は未確認
  - 候補：Edge Runtime環境でのself.__RSC_SERVER_MANIFESTの実際の値
- **C-099**: PPRデバッグモードは複数の環境変数とクエリパラメータの組み合わせに依存しており、全パターンの網羅は困難
  - 候補：PPR開発ドキュメント / Next.jsの実験的機能テスト

## 5) リスクフラグ（レビュー観点）
- **リスク1 (中)**: テンプレートファイルはビルド時にローダーによって変数が注入されるため、単体テストの実行にはモック環境の構築が必要。テストケースの「入力値」は実際のテスト実装時にモック設計を要する。
- **リスク0 (低)**: helpers.ts の hoist 関数は純粋関数であり、単体テストが最も容易。他のテンプレートファイルは外部依存が多い。
- **リスク1 (中)**: edge-wrapper.js はES Module形式でProxyを使用しており、テスト環境でのESMサポートが必要。
- **リスク1 (中)**: app-page.ts のhandler関数は1500行超の大規模関数であり、テストケースで全ての条件分岐を網羅することは困難。主要なパスに絞ったテストケースを選定している。
- **リスク0 (低)**: pages.ts はhoist関数への委譲が中心であり、hoist関数自体のテストで大部分がカバーされる。

## 6) レビュアーチェックリスト（最小）
- [ ] helpers.ts の hoist 関数テストケース（C-001～C-008）が全ての条件分岐をカバーしているか
- [ ] edge-wrapper.js の Proxy テストケース（C-009～C-014）が非同期モジュールのローディングパターンを適切にカバーしているか
- [ ] app-page.ts handler の PPR 関連テストケース（C-019～C-021, C-091～C-093, C-099）がPPRの主要フローをカバーしているか
- [ ] 各テンプレートの handler 関数のエラーハンドリングテストケースが適切か（C-024～C-025, C-036～C-039, C-058～C-060, C-069～C-070, C-076～C-077）
- [ ] Edge Runtime テンプレート（edge-app-route, edge-ssr-app, edge-ssr, middleware, pages-edge-api）のbody渡しロジックが一貫しているか
- [ ] テストケースの優先度が適切に設定されているか（セキュリティ関連・データ整合性：高、データ変換：中、表示用処理：低）
