---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 131
  claims_with_evidence: 126
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：next-src-build-top 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：126 / 131、根拠なし：5
- 優先レビュー（高）
  1. **UT-BLD-118（divideSegments内部関数テスト）**：内部関数のためexport未確認、間接テスト方法に依存
  2. **UT-BLD-121（loadEntrypoint正常系）**：SWCバインディングの挙動に依存し、テスト環境構築が必要
  3. **UT-BLD-097（Lockfile.unlockSync）**：ネイティブバインディングのモック方法に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/build/generate-build-id.ts` - generateBuildId関数の実装
- E-02: `packages/next/src/build/is-writeable.ts` - isWriteable関数の実装
- E-03: `packages/next/src/build/write-build-id.ts` - writeBuildId関数の実装
- E-04: `packages/next/src/build/duration-to-string.ts` - durationToString, hrtimeToSeconds, hrtimeBigIntDurationToString, hrtimeDurationToString関数の実装
- E-05: `packages/next/src/build/utils.ts` - unique, difference, isMiddlewareFilename, isInstrumentationHookFilename, isReservedPage, isCustomErrorPage, isMiddlewareFile, isProxyFile, isInstrumentationHookFile, getPossibleInstrumentationHookFilenames, getPossibleMiddlewareFilenames, collectRoutesUsingEdgeRuntime, collectMeta, reduceAppConfig, NestedMiddlewareError, pageToRoute, isWebpackDefaultLayer, isWebpackClientOnlyLayer, isWebpackBundledLayer, shouldUseReactServerCondition, isWebpackAppPagesLayer, isAppBuiltinPage関数の実装
- E-06: `packages/next/src/build/normalize-catchall-routes.ts` - normalizeCatchAllRoutes関数と内部関数の実装
- E-07: `packages/next/src/build/validate-app-paths.ts` - validateAppPaths, validateAppRoute, validateSegmentParam, normalizeSegments関数の実装
- E-08: `packages/next/src/build/sort-by-page-exts.ts` - sortByPageExts関数の実装
- E-09: `packages/next/src/build/load-jsconfig.ts` - parseJsonFile, loadJsConfig関数の実装
- E-10: `packages/next/src/build/get-babel-config-file.ts` - getBabelConfigFile関数とBABEL_CONFIG_FILES定数の実装
- E-11: `packages/next/src/build/build-context.ts` - resumePluginState, getProxiedPluginState, getPluginState関数の実装
- E-12: `packages/next/src/build/lockfile.ts` - readLockfileContent, parseDevServerInfo, Lockfileクラスの実装
- E-13: `packages/next/src/build/preview-key-utils.ts` - generatePreviewKeys関数の実装
- E-14: `packages/next/src/build/entries.ts` - getPageFromPath, createRelativeFilePath, processPageRoutes, extractSlotsFromAppRoutes, combineSlots, processLayoutRoutes, extractSlotsFromDefaultFiles関数の実装
- E-15: `packages/next/src/build/handle-externals.ts` - isResourceInPackages関数の実装
- E-16: `packages/next/src/build/progress.ts` - createProgress, divideSegments関数の実装
- E-17: `packages/next/src/build/load-entrypoint.ts` - loadEntrypoint関数の実装
- E-18: `packages/next/src/build/normalize-catchall-routes.test.ts` - 既存テストファイル（参考）
- E-19: `packages/next/src/build/validate-app-paths.test.ts` - 既存テストファイル（参考）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-BLD-001: generateBuildIdがgenerate関数の返り値をビルドIDとして使用する | E-01（L1-5: buildId = await generate()） | ○ |
| C-02 | UT-BLD-002: generate関数がnullの場合にfallbackが使用される | E-01（L7-12: if buildId === null → fallback()） | ○ |
| C-03 | UT-BLD-003: ビルドIDがトリムされる | E-01（L21: return buildId.trim()） | ○ |
| C-04 | UT-BLD-004: 文字列以外でエラーがスローされる | E-01（L15-19: typeof buildId !== 'string' → throw） | ○ |
| C-05 | UT-BLD-005: fallback値に'ad'が含まれる場合に再生成される | E-01（L10: /ad/i.test(buildId)） | ○ |
| C-06 | UT-BLD-006: Promiseを返すgenerate関数が対応される | E-01（L1: async関数, L5: await generate()） | ○ |
| C-07 | UT-BLD-007: 書き込み可能ディレクトリでtrue | E-02（L3-6: fs.promises.access → return true） | ○ |
| C-08 | UT-BLD-008: 書き込み不可ディレクトリでfalse | E-02（L7-8: catch → return false） | ○ |
| C-09 | UT-BLD-009: 存在しないパスでfalse | E-02（L7-8: catch → return false） | ○ |
| C-10 | UT-BLD-010: writeBuildIdがファイルに書き込む | E-03（L9-10: fs.writeFile） | ○ |
| C-11 | UT-BLD-011: 存在しないdistDirでエラー | E-03（L10: promises.writeFile → fs error） | ○ |
| C-12 | UT-BLD-012-017: durationToStringの各閾値判定 | E-04（L30-39: 条件分岐コード） | ○ |
| C-13 | UT-BLD-018-019: hrtimeToSecondsの変換 | E-04（L75-77: hrtime[0] + hrtime[1] / NANOSECONDS_PER_SECOND） | ○ |
| C-14 | UT-BLD-020-021: hrtimeBigIntDurationToStringの変換 | E-04（L54-67: durationToStringWithNanoseconds関数） | ○ |
| C-15 | UT-BLD-022: hrtimeDurationToStringの変換 | E-04（L98-99: durationToString(hrtimeToSeconds(hrtime))） | ○ |
| C-16 | UT-BLD-023-025: unique関数の動作 | E-05（L140-142: [...new Set([...main, ...sub])]） | ○ |
| C-17 | UT-BLD-026-028: difference関数の動作 | E-05（L144-151: Set差分ロジック） | ○ |
| C-18 | UT-BLD-029-032: isMiddlewareFilenameの判定 | E-05（L153-160: 文字列比較ロジック） | ○ |
| C-19 | UT-BLD-033-035: isInstrumentationHookFilenameの判定 | E-05（L162-167: 文字列比較ロジック） | ○ |
| C-20 | UT-BLD-036-040: isReservedPageの判定 | E-05（L138: RESERVED_PAGE正規表現, L1496-1497） | ○ |
| C-21 | UT-BLD-041-043: isCustomErrorPageの判定 | E-05（L1506-1508: page === '/404' || page === '/500'） | ○ |
| C-22 | UT-BLD-044-048: isMiddlewareFile, isProxyFile, isInstrumentationHookFileの判定 | E-05（L1510-1528） | ○ |
| C-23 | UT-BLD-049-051: getPossibleInstrumentationHookFilenames/getPossibleMiddlewareFilenamesの生成 | E-05（L1530-1553） | ○ |
| C-24 | UT-BLD-052-053: collectRoutesUsingEdgeRuntimeの収集 | E-05（L223-234） | ○ |
| C-25 | UT-BLD-054-059: collectMetaの動作 | E-05（L1639-1685） | ○ |
| C-26 | UT-BLD-060-063: reduceAppConfigの動作 | E-05（L1049-1102） | ○ |
| C-27 | UT-BLD-064: NestedMiddlewareErrorのメッセージ | E-05（L1555-1572） | ○ |
| C-28 | UT-BLD-065-066: pageToRouteの変換 | E-05（L1697-1725） | ○ |
| C-29 | UT-BLD-067-069: normalizeCatchAllRoutesの動作 | E-06（L11-62） | ○ |
| C-30 | UT-BLD-070-077: validateAppPathsの各バリデーション | E-07（L16-281） | ○ |
| C-31 | UT-BLD-078-080: sortByPageExtsの動作 | E-08（L4-24） | ○ |
| C-32 | UT-BLD-081-083: parseJsonFileの動作 | E-09（L12-40） | ○ |
| C-33 | UT-BLD-084-086: getBabelConfigFileの動作 | E-10（L4-25） | ○ |
| C-34 | UT-BLD-087-091: build-contextの関数群 | E-11（L15-41） | ○ |
| C-35 | UT-BLD-092-097: lockfile関連の動作 | E-12（L31-261） | ○ |
| C-36 | UT-BLD-098-101: generatePreviewKeysの動作 | E-13（L46-100） | ○ |
| C-37 | UT-BLD-102-113: entries.ts関数群の動作 | E-14（L90-414） | ○ |
| C-38 | UT-BLD-114-117: isResourceInPackagesの動作 | E-15（L28-43） | ○ |
| C-39 | UT-BLD-118: divideSegments内部関数のテスト | **根拠不足** | △ |
| C-40 | UT-BLD-119-120: createProgressの動作 | E-16（L18-25） | ○ |
| C-41 | UT-BLD-121-122: loadEntrypointの動作 | E-17（L28-56） | △ |
| C-42 | UT-BLD-123-129: webpack層判定関数群の動作 | E-05（L1599-1637） | ○ |
| C-43 | UT-BLD-130-131: processLayoutRoutesの動作 | E-14（L373-396） | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-BLD-118（divideSegments）**: `divideSegments`はモジュール内部関数（非export）のため、直接テスト不可。`createProgress`を通じた間接テストのみ可能。具体的な分割結果の期待値はコード内部の実装詳細に依存する。
  - 候補：createProgressの統合テストで間接的にカバー / 内部関数をexportして直接テスト / divideSegmentsの結果確認手段を追加
- **UT-BLD-121-122（loadEntrypoint）**: SWCネイティブバインディング（`getBindingsSync().expandNextJsTemplate`）への依存があり、テスト環境でのバインディング可用性が不明。テンプレートファイルの実在も前提条件。
  - 候補：SWCバインディングのモック / ビルド後のテンプレートファイル確認 / 統合テストでの確認
- **UT-BLD-097（Lockfile.unlockSync）**: ネイティブバインディングのモック方法が必要。WASM環境では`nativeLockfile`が`undefined`になる挙動の確認方法。
  - 候補：バインディングモックを使用したユニットテスト / WASM環境での統合テスト
- **WEBPACK_LAYERS定数の具体値**: UT-BLD-123-129で使用するWEBPACK_LAYERSの各グループメンバーの具体値は`../lib/constants`に定義されており、テスト記述時に参照が必要。
  - 候補：constants.tsの具体値を確認してテスト入力値を決定
- **getSupportedBrowsers**: この関数は外部ライブラリ`browserslist`に依存しており、テストケースとして含めていない。統合テストレベルでのカバーが推奨される。
  - 候補：browserslistのモック / `.browserslistrc`ファイルを用意したテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケース（126/131）はソースコードから直接根拠を確認済み
- 1: 中リスク - loadEntrypoint関連テスト（UT-BLD-121-122）はSWCバインディング依存
- 1: 中リスク - Lockfileテスト（UT-BLD-097）はネイティブバインディングモック依存
- 0: 低リスク - divideSegments（UT-BLD-118）は間接テストで代替可能

## 6) レビュアーチェックリスト（最小）
- [ ] 全テストケースのテストIDが一意であること（UT-BLD-001〜UT-BLD-131）
- [ ] 各テストケースの期待結果がソースコードの実装と一致していること
- [ ] WEBPACK_LAYERS定数の具体値を確認し、レイヤー判定テスト（UT-BLD-123-129）の入力値を具体化すること
- [ ] loadEntrypointテストのSWCバインディング可用性を確認すること
- [ ] generatePreviewKeysテストのファイルシステムモック方法を確認すること
- [ ] 既存テストファイル（normalize-catchall-routes.test.ts, validate-app-paths.test.ts）との重複・整合性を確認すること
- [ ] getSupportedBrowsers, printTreeView, printCustomRoutes, detectConflictingPaths, copyTracedFiles等の大規模関数が統合テストとしてカバーされるか検討すること
