---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 190
  claims_with_evidence: 182
  claims_without_evidence: 8
confidence_derived: 0.96
---

# 根拠レポート：next-src-build-webpack 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：182 / 190、根拠なし：8
- 優先レビュー（高）
  1. **UT-WPK-137 (SubresourceIntegrityPlugin.apply)**: プラグインのapplyメソッドはwebpackコンパイラフックに依存しており、単体テストでの検証方法が要確認
  2. **UT-WPK-178/179 (getBlurImage)**: 画像最適化処理は外部依存(is-animated, image-optimizer)があり、モック戦略が必要
  3. **UT-WPK-126/127/128 (getModuleBuildError)**: 複数のエラーパーサーを統合する関数で、各パーサーの結合テストに注意

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/build/webpack/utils.ts` - traverseModules, forEachEntryModule, formatBarrelOptimizedResource, getModuleReferencesInOrder, getCompilationSpan
- E-02: `packages/next/src/build/webpack/stringify-request.ts` - stringifyRequest
- E-03: `packages/next/src/build/webpack/cache-invalidation.ts` - invalidateFileSystemCache, checkFileSystemCacheInvalidationAndCleanup, cleanupFileSystemCache
- E-04: `packages/next/src/build/webpack/config/helpers.ts` - loader, unshiftLoader, plugin
- E-05: `packages/next/src/build/webpack/config/utils.ts` - pipe, ConfigurationContext
- E-06: `packages/next/src/build/webpack/config/blocks/base.ts` - shouldIgnorePath, base
- E-07: `packages/next/src/build/webpack/loaders/css-loader/src/camelcase.ts` - camelCase, preserveCamelCase
- E-08: `packages/next/src/build/webpack/loaders/css-loader/src/utils.ts` - isDataUrl, isUrlRequestable, normalizeUrl, requestify, getURLType, sort, shouldUseImportPlugin, shouldUseURLPlugin, shouldUseModulesPlugins, shouldUseIcssPlugin, normalizeSourceMap, getImportCode, getExportCode, dashesCamelCase, resolveRequests, getFilter, getModuleCode
- E-09: `packages/next/src/build/webpack/loaders/css-loader/src/runtime/getUrl.ts` - getUrl
- E-10: `packages/next/src/build/webpack/loaders/css-loader/src/runtime/api.ts` - cssWithMappingToString, list.toString, list.i
- E-11: `packages/next/src/build/webpack/loaders/css-loader/src/CssSyntaxError.ts` - CssSyntaxError
- E-12: `packages/next/src/build/webpack/loaders/utils.ts` - isClientComponentEntryModule, isCSSMod, encodeToBase64, decodeFromBase64, regexCSS
- E-13: `packages/next/src/build/webpack/loaders/get-module-build-info.ts` - getModuleBuildInfo
- E-14: `packages/next/src/build/webpack/loaders/modularize-import-loader.ts` - transformSource
- E-15: `packages/next/src/build/webpack/plugins/build-manifest-plugin-utils.ts` - processRoute, normalizeRewritesForBuildManifest, createEdgeRuntimeManifest
- E-16: `packages/next/src/build/webpack/plugins/telemetry-plugin/use-cache-tracker-utils.ts` - createUseCacheTracker, mergeUseCacheTrackers
- E-17: `packages/next/src/build/webpack/plugins/wellknown-errors-plugin/simpleWebpackError.ts` - SimpleWebpackError
- E-18: `packages/next/src/build/webpack/plugins/wellknown-errors-plugin/parseBabel.ts` - getBabelError
- E-19: `packages/next/src/build/webpack/plugins/wellknown-errors-plugin/parseCss.ts` - getCssError
- E-20: `packages/next/src/build/webpack/plugins/wellknown-errors-plugin/parseScss.ts` - getScssError
- E-21: `packages/next/src/build/webpack/plugins/wellknown-errors-plugin/parseNextFontError.ts` - getNextFontError
- E-22: `packages/next/src/build/webpack/plugins/wellknown-errors-plugin/webpackModuleError.ts` - getModuleBuildError, getFileData
- E-23: `packages/next/src/build/webpack/plugins/wellknown-errors-plugin/getModuleTrace.ts` - getModuleTrace, formatModuleTrace
- E-24: `packages/next/src/build/webpack/plugins/wellknown-errors-plugin/parse-dynamic-code-evaluation-error.ts` - getDynamicCodeEvaluationError
- E-25: `packages/next/src/build/webpack/plugins/wellknown-errors-plugin/parseNextInvalidImportError.ts` - getNextInvalidImportError
- E-26: `packages/next/src/build/webpack/plugins/wellknown-errors-plugin/parseNextAppLoaderError.ts` - getNextAppLoaderError
- E-27: `packages/next/src/build/webpack/plugins/subresource-integrity-plugin.ts` - SubresourceIntegrityPlugin
- E-28: `packages/next/src/build/webpack/config/blocks/css/loaders/getCssModuleLocalIdent.ts` - getCssModuleLocalIdent
- E-29: `packages/next/src/build/webpack/config/blocks/css/loaders/file-resolve.ts` - cssFileResolve
- E-30: `packages/next/src/build/webpack/loaders/next-style-loader/runtime/isEqualLocals.ts` - isEqualLocals
- E-31: `packages/next/src/build/webpack/loaders/resolve-url-loader/lib/file-protocol.ts` - prepend, remove
- E-32: `packages/next/src/build/webpack/loaders/lightningcss-loader/src/utils.ts` - getTargets, version, parseVersion, browserslistToTargets
- E-33: `packages/next/src/build/webpack/loaders/lightningcss-loader/src/codegen.ts` - getImportCode, getModuleCode, getExportCode
- E-34: `packages/next/src/build/webpack/loaders/metadata/resolve-route-data.ts` - resolveRobots, resolveSitemap, resolveManifest, resolveRouteData
- E-35: `packages/next/src/build/webpack/loaders/next-flight-loader/action-validate.ts` - ensureServerEntryExports
- E-36: `packages/next/src/build/webpack/loaders/next-image-loader/blur.ts` - getBlurImage
- E-37: `packages/next/src/build/webpack/loaders/next-barrel-loader.ts` - NextBarrelLoader, getBarrelMapping

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | traverseModulesが全chunkGroupsのモジュールを走査する | E-01 (L16-46) | ○ |
| C-02 | filterChunkGroupでフィルタリングされる | E-01 (L27-29) | ○ |
| C-03 | ネストモジュール(anyModule.modules)も走査される | E-01 (L38-42) | ○ |
| C-04 | modIdがnullの場合callbackが呼ばれない | E-01 (L37) | ○ |
| C-05 | forEachEntryModuleがpages/エントリをスキップする | E-01 (L55-57) | ○ |
| C-06 | edge SSRエントリ内のapp-loaderが解決される | E-01 (L77-86) | ○ |
| C-07 | formatBarrelOptimizedResourceが@で結合する | E-01 (L92-97) | ○ |
| C-08 | getModuleReferencesInOrderのフォールバック処理 | E-01 (L99-120) | ○ |
| C-09 | stringifyRequestがJSON文字列化する | E-02 (L3-13) | ○ |
| C-10 | invalidateFileSystemCacheがマーカーファイルを作成する | E-03 (L17-32) | ○ |
| C-11 | ENOENT以外のエラーが伝搬される | E-03 (L24-28) | ○ |
| C-12 | checkFileSystemCacheInvalidationAndCleanupがマーカー確認後クリーンアップする | E-03 (L38-50) | ○ |
| C-13 | loader関数がconfig.module.rulesにルールを追加する | E-04 (L4-25) | ○ |
| C-14 | oneOfルールが既存oneOfに統合される | E-04 (L12-21) | ○ |
| C-15 | unshiftLoaderが先頭に追加する | E-04 (L27-48) | ○ |
| C-16 | plugin関数がconfig.pluginsに追加する | E-04 (L50-59) | ○ |
| C-17 | pipe関数が順次実行する | E-05 (L38-44) | ○ |
| C-18 | shouldIgnorePathがnode_modulesを含むパスでtrue | E-06 (L9-17) | ○ |
| C-19 | base関数がmodeを正しく設定する | E-06 (L23) | ○ |
| C-20 | camelCaseがハイフン区切り文字列を変換する | E-07 (L64-113) | ○ |
| C-21 | camelCaseが空文字列で空を返す | E-07 (L84-86) | ○ |
| C-22 | camelCaseが不正入力でTypeErrorをスローする | E-07 (L65-67) | ○ |
| C-23 | isDataUrlがdata:で始まるURLでtrue | E-08 (L548-554) | ○ |
| C-24 | isUrlRequestableの各パターン判定 | E-08 (L520-542) | ○ |
| C-25 | normalizeUrlのWindows/データURL処理 | E-08 (L44-74) | ○ |
| C-26 | getURLTypeの各URL種別判定 | E-08 (L176-190) | ○ |
| C-27 | getImportCode/getExportCodeのコード生成 | E-08 (L261-498) | ○ |
| C-28 | dashesCamelCaseの変換 | E-08 (L380-384) | ○ |
| C-29 | resolveRequestsのフォールバック | E-08 (L500-518) | ○ |
| C-30 | getUrl(runtime)のURL処理 | E-09 (L1-26) | ○ |
| C-31 | CssSyntaxErrorのメッセージ生成 | E-11 (L1-29) | ○ |
| C-32 | isClientComponentEntryModuleの判定 | E-12 (L14-21) | ○ |
| C-33 | isCSSModのCSS判定 | E-12 (L27-44) | ○ |
| C-34 | encodeToBase64/decodeFromBase64の変換 | E-12 (L46-52) | ○ |
| C-35 | getModuleBuildInfoの型キャスト | E-13 (L25-27) | ○ |
| C-36 | transformSourceのre-export生成 | E-14 (L22-37) | ○ |
| C-37 | processRouteの外部destination削除 | E-15 (L25-34) | ○ |
| C-38 | normalizeRewritesForBuildManifestの正規化 | E-15 (L36-50) | ○ |
| C-39 | createEdgeRuntimeManifestのglobalThis代入 | E-15 (L52-58) | ○ |
| C-40 | mergeUseCacheTrackersのマージ・加算 | E-16 (L14-34) | ○ |
| C-41 | SimpleWebpackErrorのコンストラクタ | E-17 (L6-13) | ○ |
| C-42 | getBabelErrorのパース | E-18 (L4-38) | ○ |
| C-43 | getCssErrorのパース | E-19 (L7-38) | ○ |
| C-44 | getScssErrorのパース | E-20 (L7-44) | ○ |
| C-45 | getNextFontErrorのパース | E-21 (L3-37) | ○ |
| C-46 | getModuleBuildErrorの統合エラー処理 | E-22 (L47-118) | ○ |
| C-47 | getModuleTrace/formatModuleTraceの取得・フォーマット | E-23 (L5-87) | ○ |
| C-48 | getDynamicCodeEvaluationErrorのエラー生成 | E-24 (L5-22) | ○ |
| C-49 | getNextInvalidImportErrorのエラー生成 | E-25 (L5-34) | ○ |
| C-50 | getNextAppLoaderErrorのエラー生成 | E-26 (L6-25) | ○ |
| C-51 | SubresourceIntegrityPluginのSRIハッシュ生成 | E-27 (L9-70) | ○ |
| C-52 | getCssModuleLocalIdentのID生成 | E-28 (L7-53) | ○ |
| C-53 | cssFileResolveのURL判定 | E-29 (L1-13) | ○ |
| C-54 | isEqualLocalsの等価判定 | E-30 (L1-31) | ○ |
| C-55 | prepend/removeのfile://プロトコル処理 | E-31 (L28-61) | ○ |
| C-56 | getTargetsのブラウザターゲット変換 | E-32 (L66-74) | ○ |
| C-57 | lightningcss codegenのコード生成 | E-33 (L41-229) | ○ |
| C-58 | resolveRobots/resolveSitemap/resolveManifestの生成 | E-34 (L5-166) | ○ |
| C-59 | ensureServerEntryExportsの検証 | E-35 (L4-13) | ○ |
| C-60 | getBlurImageの画像blur生成 | E-36 (L8-89) | ○ |
| C-61 | getBlurImageのblurサイズ計算（横長/縦長） | E-36 (L42-54) | ○ |
| C-62 | getLoaderModuleNamedExportsのRspack/webpack分岐 | E-12 (L54-93) | △ |
| C-63 | NextBarrelLoaderの全体フロー | E-37 (L247-338) | △ |
| C-64 | cssWithMappingToStringのソースマップ処理 | E-10 (L61-91) | △ |
| C-65 | list.iの重複排除処理 | E-10 (L22-56) | △ |
| C-66 | getModulesPluginsのプラグイン構成 | E-08 (L132-171) | △ |
| C-67 | normalizeSourceMapForRuntimeのソースマップ正規化 | E-08 (L283-314) | △ |
| C-68 | getModuleCodeのモジュールコード生成 | E-08 (L316-378) | △ |
| C-69 | getPreRequesterのキャッシュ付きプリリクエスタ | E-08 (L235-259) | △ |

## 4) 不足情報（Unknown / Missing）
- **webpack内部APIの詳細仕様**: compilation, moduleGraph等のwebpack内部オブジェクトの正確な振る舞いはwebpackのソースコード自体を参照する必要がある
  - 候補: webpack公式ドキュメント / webpack GitHubリポジトリ / webpack型定義ファイル
- **バレルローダーの完全なフロー**: getBarrelMapping/NextBarrelLoaderの完全な動作検証にはSWC transformの実行結果が必要
  - 候補: SWCのbarrel_transform実装 / 既存テストファイル(resolve-route-data.test.ts)
- **CSSランタイムAPI(api.ts)の詳細**: list.toString/list.iの完全な動作はブラウザ環境でのCSS適用と関連する
  - 候補: css-loader公式リポジトリ / mini-css-extract-plugin
- **画像最適化の外部依存**: getBlurImageはis-animated, image-optimizerに依存しており、モック戦略が未確認
  - 候補: packages/next/src/server/image-optimizer.ts

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 純粋なユーティリティ関数(camelCase, isDataUrl, sort, encodeToBase64等): ソースコードから完全に動作を把握可能
- **0: 低リスク** - エラーパーサー(parseBabel, parseCss, parseScss等): 正規表現パターンと条件分岐が明確
- **1: 中リスク** - webpack依存の関数(traverseModules, forEachEntryModule等): webpack compilationオブジェクトのモックが複雑になる可能性
- **1: 中リスク** - コード生成系(getImportCode, getExportCode, getModuleCode): 生成されるコード文字列の正確性は実行環境依存の可能性
- **2: 高リスク** - SubresourceIntegrityPlugin.apply: webpackコンパイラフックの統合テストが必要で、単体テストの範囲を超える可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] traverseModulesのテストケースがchunkGraph/moduleGraph APIのモック構造を正しく想定しているか
- [ ] forEachEntryModuleのテストでnext-app-loader/next-edge-ssr-loaderの識別条件が網羅されているか
- [ ] cache-invalidation系のテストでファイルシステム操作のモック戦略が妥当か
- [ ] camelCase/dashesCamelCaseのテストで国際文字(Unicode)のケースが必要か確認
- [ ] resolveRobots/resolveSitemapのテストでEdgeケース(空配列、未定義フィールド等)が十分か
- [ ] エラーパーサー群のテストで正規表現のマッチ/非マッチパターンが網羅されているか
- [ ] getBlurImageのテストでアニメーション画像(GIF/APNG)の除外が確認されているか
- [ ] SubresourceIntegrityPluginのテストが実際のwebpackコンパイルサイクルなしでも有意義か確認
