---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 101
  claims_with_evidence: 97
  claims_without_evidence: 4
confidence_derived: 0.96
---

# 根拠レポート：next-src-cli 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：97 / 101、根拠なし：4
- 優先レビュー（高）
  1. **C-019 (UT-CLI-019)**: メモリ50%設定の正確な計算ロジックの検証が必要
  2. **C-052 (UT-CLI-052)**: テストランナー優先順位の網羅的検証が必要（next.config未設定時のデフォルト挙動）
  3. **C-089 (UT-CLI-089)**: staleness判定の具体的な条件はparseVersionInfoの実装に依存
  4. **C-026 (UT-CLI-026)**: macOS固有のWATCHPACK_WATCHER_LIMIT設定は実行環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/next/src/cli/next-dev.ts` - devサーバー起動CLIコマンド実装
- E-02: `packages/next/src/cli/next-start.ts` - productionサーバー起動CLIコマンド実装
- E-03: `packages/next/src/cli/next-build.ts` - ビルドCLIコマンド実装
- E-04: `packages/next/src/cli/next-export.ts` - エクスポートCLIコマンド実装（非推奨）
- E-05: `packages/next/src/cli/next-test.ts` - テストCLIコマンド実装
- E-06: `packages/next/src/cli/next-telemetry.ts` - テレメトリCLIコマンド実装
- E-07: `packages/next/src/cli/next-analyze.ts` - 解析CLIコマンド実装
- E-08: `packages/next/src/cli/next-typegen.ts` - 型生成CLIコマンド実装
- E-09: `packages/next/src/cli/next-upgrade.ts` - アップグレードCLIコマンド実装
- E-10: `packages/next/src/cli/next-info.ts` - 情報表示CLIコマンド実装
- E-11: `packages/next/src/cli/internal/turbo-trace-server.ts` - Turbopackトレースサーバー起動

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | nextDevが有効なオプションでdevサーバーを起動する | E-01 (L170-419) | ○ |
| C-002 | Turbopackフラグが正しく処理される | E-01 (L177) | ○ |
| C-003 | NEXT_PRIVATE_DEV_DIR環境変数でディレクトリ指定可能 | E-01 (L179) | ○ |
| C-004 | 存在しないディレクトリでエラー終了する | E-01 (L182-184) | ○ |
| C-005 | 予約済みポートでエラー終了する | E-01 (L232-234) | ○ |
| C-006 | portSource='default'でallowRetry=true | E-01 (L237) | ○ |
| C-007 | portSource='cli'でallowRetry=false | E-01 (L237) | ○ |
| C-008 | experimentalHttpsで証明書自動生成 | E-01 (L382-406) | ○ |
| C-009 | カスタムHTTPS証明書指定 | E-01 (L389-398) | ○ |
| C-010 | experimentalUploadTraceでURL設定 | E-01 (L244-248) | ○ |
| C-011 | NEXT_TRACE_UPLOAD_DISABLEDでトレース無効化 | E-01 (L244-248) | ○ |
| C-012 | セッション停止時テレメトリ送信 | E-01 (L104-138) | ○ |
| C-013 | セッション停止時カーソル再表示 | E-01 (L158-159) | ○ |
| C-014 | sessionStopHandledで二重停止防止 | E-01 (L81) | ○ |
| C-015 | traceUploadUrlとdistDir設定時にトレースアップロード | E-01 (L144-152) | ○ |
| C-016 | sassとnode-sass重複検出 | E-01 (L197-207) | ○ |
| C-017 | @next/font非推奨検出 | E-01 (L214-227) | ○ |
| C-018 | skipOnRebootで@next/fontチェックスキップ | E-01 (L209) | ○ |
| C-019 | maxOldSpaceSizeがシステムメモリ50%に自動設定 | E-01 (L268-277) | △ |
| C-020 | NEXT_DISABLE_MEM_OVERRIDEでメモリオーバーライド無効化 | E-01 (L268) | ○ |
| C-021 | disableSourceMapsでenable-source-maps削除 | E-01 (L279-283) | ○ |
| C-022 | nextServerReadyメッセージでresolve | E-01 (L335-348) | ○ |
| C-023 | RESTART_EXIT_CODEで再起動 | E-01 (L356-371) | ○ |
| C-024 | nextWorkerReadyメッセージでオプション送信 | E-01 (L333-334) | ○ |
| C-025 | inspectオプションでデバッグアドレス設定 | E-01 (L295-301) | ○ |
| C-026 | macOSでWATCHPACK_WATCHER_LIMIT=20 | E-01 (L319) | △ |
| C-027 | nextStartが有効オプションでサーバー起動 | E-02 (L42-91) | ○ |
| C-028 | nextStartで予約済みポートエラー | E-02 (L49-51) | ○ |
| C-029 | inspectオプションでデバッガー起動 | E-02 (L53-75) | ○ |
| C-030 | インスペクター重複起動の警告 | E-02 (L56-59) | ○ |
| C-031 | inspector.open失敗時のエラー処理 | E-02 (L65-73) | ○ |
| C-032 | keepAliveTimeoutがstartServerに渡される | E-02 (L84-90) | ○ |
| C-033 | experimentalCpuProfでCPUプロファイリング有効化 | E-02 (L77-82) | ○ |
| C-034 | nextBuildが有効オプションでビルド実行 | E-03 (L38-164) | ○ |
| C-035 | nextBuildで存在しないディレクトリエラー | E-03 (L101-103) | ○ |
| C-036 | experimentalAnalyzeのTurbopack互換性チェック | E-03 (L68-72) | ○ |
| C-037 | mangling=falseで警告出力 | E-03 (L74-78) | ○ |
| C-038 | profile=trueで警告出力 | E-03 (L80-84) | ○ |
| C-039 | experimentalDebugMemoryUsageでメモリデバッグ有効化 | E-03 (L94-97) | ○ |
| C-040 | experimentalUploadTraceでURL設定 | E-03 (L61-64) | ○ |
| C-041 | WEBPACK_ERRORSビルドエラー処理 | E-03 (L139-157) | ○ |
| C-042 | 未知ビルドエラー処理 | E-03 (L154-157) | ○ |
| C-043 | debugBuildPathsの解決 | E-03 (L108-124) | ○ |
| C-044 | debugBuildPaths解決失敗時のエラー | E-03 (L119-123) | ○ |
| C-045 | debugPrerender警告出力 | E-03 (L86-92) | ○ |
| C-046 | nextExportが非推奨メッセージ表示して終了 | E-04 (L4-12) | ○ |
| C-047 | nextTestが有効プロジェクトでテストランナー実行 | E-05 (L33-90) | ○ |
| C-048 | testProxy無効時のエラー終了 | E-05 (L75-79) | ○ |
| C-049 | 未サポートテストランナーのエラー | E-05 (L85-88) | ○ |
| C-050 | 無効パスのフォールバック処理 | E-05 (L48-53) | ○ |
| C-051 | 非Next.jsディレクトリのフォールバック | E-05 (L56-67) | ○ |
| C-052 | テストランナー優先順位 | E-05 (L70-73) | △ |
| C-053 | 依存関係自動インストール | E-05 (L92-121) | ○ |
| C-054 | 既存依存関係のスキップ | E-05 (L100) | ○ |
| C-055 | Playwright設定ファイル自動生成 | E-05 (L137-168) | ○ |
| C-056 | Playwright実行 | E-05 (L170-186) | ○ |
| C-057 | TS設定テンプレート | E-05 (L189-198) | ○ |
| C-058 | JS設定テンプレート | E-05 (L189-198) | ○ |
| C-059 | enableオプションでテレメトリ有効化 | E-06 (L15-18) | ○ |
| C-060 | disableオプションでテレメトリ無効化 | E-06 (L20-29) | ○ |
| C-061 | 引数'enable'でテレメトリ有効化 | E-06 (L15) | ○ |
| C-062 | 引数'disable'でテレメトリ無効化 | E-06 (L20) | ○ |
| C-063 | ステータス表示 | E-06 (L32-33) | ○ |
| C-064 | 重複無効化メッセージ | E-06 (L23-28) | ○ |
| C-065 | nextAnalyzeが有効オプションで解析実行 | E-07 (L21-59) | ○ |
| C-066 | nextAnalyzeで存在しないディレクトリエラー | E-07 (L47-49) | ○ |
| C-067 | nextAnalyze mangling無効警告 | E-07 (L33-37) | ○ |
| C-068 | nextAnalyze profiling有効警告 | E-07 (L39-43) | ○ |
| C-069 | nextTypegenが型生成 | E-08 (L42-203) | ○ |
| C-070 | nextTypegenで存在しないディレクトリエラー | E-08 (L49-51) | ○ |
| C-071 | pagesDirが存在する場合のルート処理 | E-08 (L116-125) | ○ |
| C-072 | appDirが存在する場合のルート処理 | E-08 (L128-157) | ○ |
| C-073 | strictRouteTypes有効時のバリデータ生成 | E-08 (L178-183) | ○ |
| C-074 | cacheLife型生成 | E-08 (L185-186) | ○ |
| C-075 | srcディレクトリ検出 | E-08 (L111-113) | ○ |
| C-076 | spawnNextUpgradeが正しいコマンドで起動 | E-09 (L10-41) | ○ |
| C-077 | verboseフラグ追加 | E-09 (L25-27) | ○ |
| C-078 | リビジョン指定 | E-09 (L23) | ○ |
| C-079 | 終了コード伝搬 | E-09 (L38-40) | ○ |
| C-080 | nullコードのデフォルト値 | E-09 (L39) | ○ |
| C-081 | パッケージバージョン取得 | E-10 (L55-61) | ○ |
| C-082 | 未インストールパッケージのフォールバック | E-10 (L58-59) | ○ |
| C-083 | バイナリバージョン取得 | E-10 (L78-91) | ○ |
| C-084 | 存在しないバイナリのフォールバック | E-10 (L84-90) | ○ |
| C-085 | Next.js設定読み込み | E-10 (L63-72) | ○ |
| C-086 | デフォルトoutput値 | E-10 (L67) | ○ |
| C-087 | 基本情報の出力 | E-10 (L96-169) | ○ |
| C-088 | Rspackバージョン表示 | E-10 (L142-145) | ○ |
| C-089 | 古いバージョンの警告 | E-10 (L164-168) | △ |
| C-090 | レジストリ接続失敗 | E-10 (L120-133) | ○ |
| C-091 | infoコマンド基本実行 | E-10 (L600-606) | ○ |
| C-092 | verbose情報出力 | E-10 (L601-605) | ○ |
| C-093 | 共有依存チェック | E-10 (L177-249) | ○ |
| C-094 | ツール未インストール時のスキップ | E-10 (L200-205) | ○ |
| C-095 | SWCパッケージ不在時のスキップ | E-10 (L214-222) | ○ |
| C-096 | 診断レポート生成 | E-10 (L254-593) | ○ |
| C-097 | 非対応プラットフォーム | E-10 (L258-267) | ○ |
| C-098 | タスク実行時の例外処理 | E-10 (L557-566) | ○ |
| C-099 | Turbopackトレースサーバー起動 | E-11 (L3-9) | ○ |
| C-100 | ポート未指定時の動作 | E-11 (L5-8) | ○ |
| C-101 | loadBindings失敗時のエラー | E-11 (L7) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-019**: メモリ計算ロジック（totalMem * 0.5）は確認できるが、os.totalmem()のモック時の正確な期待値はテスト実行環境に依存する
  - 候補：os.totalmem()の具体的な返却値に基づく計算結果の検証
- **C-026**: macOSのWATCHPACK_WATCHER_LIMIT設定はos.platform()の返却値に依存し、テスト環境でのモックが必要
  - 候補：os.platform()のモック実装
- **C-052**: テストランナー優先順位において、CLIオプション/next.config/デフォルトの全パターン網羅は確認できるが、defaultTestRunnerが未定義かつtestRunnerも未指定の場合のデフォルト値'playwright'の根拠はコード上明確
  - 候補：next.config.jsのexperimental.defaultTestRunnerの型定義確認
- **C-089**: versionInfo.stalenessの判定条件はparseVersionInfo関数の実装に依存し、CLIモジュール外のコードである
  - 候補：parseVersionInfo / getStalenessの実装確認

## 5) リスクフラグ（レビュー観点）
- 0: nextExport（C-046）は単純な非推奨メッセージ表示のみ -- 低リスク
- 1: nextDev handleSessionStop（C-012〜C-015）はプロセス終了時のテレメトリ・トレース処理 -- 中リスク（非同期処理の競合の可能性）
- 1: nextTest directoryフォールバック（C-050, C-051）は複数のtry-catchによる複雑なフォールバック処理 -- 中リスク
- 0: nextTelemetry（C-059〜C-064）は単純な状態切り替え -- 低リスク
- 1: nextBuildエラーハンドリング（C-041, C-042）は特定のエラーコードに基づく分岐処理 -- 中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] next-dev.tsのhandleSessionStopにおける非同期処理の順序が正しくテストケースに反映されているか確認
- [ ] next-build.tsのエラーコード（INVALID_RESOLVE_ALIAS, WEBPACK_ERRORS等）の網羅性を確認
- [ ] next-test.tsのdirectory/testRunnerArgs引数の複雑なフォールバックロジックがテストケースでカバーされているか確認
- [ ] next-info.tsのプラットフォーム固有処理（linux/darwin/win32）がテストケースに反映されているか確認
- [ ] 各コマンドのSIGINT/SIGTERMハンドラーの動作が正しく記載されているか確認
