---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 165
  claims_with_evidence: 159
  claims_without_evidence: 6
confidence_derived: 0.96
---

# 根拠レポート：next-src-client-components 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：159 / 165、根拠なし：6
- 優先レビュー（高）
  1. **React Hookのテスト（useSearchParams, usePathname, useRouter, useParams等）**：Reactコンテキストとhookの動作はDOM環境を必要とするため、純粋な単体テストとしてのテストケースは省略し、テスト可能なユーティリティ関数に焦点を当てた
  2. **segment-cache/scheduler.ts, segment-cache/prefetch.ts, segment-cache/navigation.ts**：外部依存が多く、複雑な非同期処理を含むためテストケースの具体的な入力値の定義が困難
  3. **app-router.tsx, layout-router.tsx等のReactコンポーネント**：UIコンポーネントのレンダリングテストは単体テストケースの範囲外とした

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/client/components/redirect-error.ts` - isRedirectError関数、REDIRECT_ERROR_CODEの定義
- E-02: `packages/next/src/client/components/redirect.ts` - getRedirectError, redirect, permanentRedirect, getURLFromRedirectError, getRedirectTypeFromError, getRedirectStatusCodeFromError関数
- E-03: `packages/next/src/client/components/redirect-status-code.ts` - RedirectStatusCode enum (303, 307, 308)
- E-04: `packages/next/src/client/components/is-next-router-error.ts` - isNextRouterError関数
- E-05: `packages/next/src/client/components/http-access-fallback/http-access-fallback.ts` - isHTTPAccessFallbackError, getAccessFallbackHTTPStatus, getAccessFallbackErrorTypeByStatus関数
- E-06: `packages/next/src/client/components/not-found.ts` - notFound関数
- E-07: `packages/next/src/client/components/forbidden.ts` - forbidden関数、実験的機能ガード
- E-08: `packages/next/src/client/components/unauthorized.ts` - unauthorized関数、実験的機能ガード
- E-09: `packages/next/src/client/components/match-segments.ts` - matchSegment関数
- E-10: `packages/next/src/client/components/promise-queue.ts` - PromiseQueueクラス
- E-11: `packages/next/src/client/components/static-generation-bailout.ts` - StaticGenBailoutError, isStaticGenBailoutError
- E-12: `packages/next/src/client/components/unrecognized-action-error.ts` - UnrecognizedActionError, unstable_isUnrecognizedActionError
- E-13: `packages/next/src/client/components/hooks-server-context.ts` - DynamicServerError, isDynamicServerError
- E-14: `packages/next/src/client/components/readonly-url-search-params.ts` - ReadonlyURLSearchParamsクラス
- E-15: `packages/next/src/client/components/router-reducer/create-href-from-url.ts` - createHrefFromUrl関数
- E-16: `packages/next/src/client/components/router-reducer/create-router-cache-key.ts` - createRouterCacheKey関数
- E-17: `packages/next/src/client/components/router-reducer/compute-changed-path.ts` - extractPathFromFlightRouterState, computeChangedPath, getSelectedParams関数
- E-18: `packages/next/src/client/components/unstable-rethrow.browser.ts` - ブラウザ版unstable_rethrow関数
- E-19: `packages/next/src/client/components/unstable-rethrow.server.ts` - サーバー版unstable_rethrow関数
- E-20: `packages/next/src/client/components/router-reducer/should-hard-navigate.ts` - shouldHardNavigate関数
- E-21: `packages/next/src/client/components/segment-cache/cache-key.ts` - createCacheKey関数
- E-22: `packages/next/src/client/components/segment-cache/lru.ts` - lruPut, deleteFromLru, updateLruSize関数
- E-23: `packages/next/src/client/components/segment-cache/cache-map.ts` - createCacheMap, setInCacheMap, getFromCacheMap, isValueExpired, deleteFromCacheMap, setSizeInCacheMap, deleteMapEntry関数
- E-24: `packages/next/src/client/components/segment-cache/vary-path.ts` - getRouteVaryPath, getFulfilledRouteVaryPath, appendLayoutVaryPath, finalizeLayoutVaryPath, getPartialLayoutVaryPath, finalizePageVaryPath, getRenderedSearchFromVaryPath, getFulfilledSegmentVaryPath, clonePageVaryPathWithNewSearchParams関数
- E-25: `packages/next/src/client/components/router-reducer/set-cache-busting-search-param.ts` - setCacheBustingSearchParamWithHash関数
- E-26: `packages/next/src/client/components/error-boundary.tsx` - ErrorBoundaryHandler, ErrorBoundaryコンポーネント
- E-27: `packages/next/src/client/components/redirect-boundary.tsx` - RedirectErrorBoundary, HandleRedirectコンポーネント
- E-28: `packages/next/src/client/components/use-action-queue.ts` - dispatchAppRouterAction, dispatchGestureState, useActionQueue
- E-29: `packages/next/src/client/components/app-router-utils.ts` - isExternalURL, createPrefetchURL関数
- E-30: `packages/next/src/client/components/unresolved-thenable.ts` - unresolvedThenable定数
- E-31: `packages/next/src/client/components/links.ts` - setLinkForCurrentNavigation, unmountLinkForCurrentNavigation, mountLinkInstance, mountFormInstance, unmountPrefetchableInstance, onLinkVisibilityChanged, onNavigationIntent, pingVisibleLinks関数
- E-32: `packages/next/src/client/components/app-router-instance.ts` - publicAppRouterInstance, createMutableActionQueue, getCurrentAppRouterState, dispatchNavigateAction関数
- E-33: `packages/next/src/client/components/router-reducer/is-navigating-to-new-root-layout.ts` - isNavigatingToNewRootLayout関数
- E-34: `packages/next/src/client/components/navigation.ts` - useSearchParams, usePathname, useRouter, useParams, useSelectedLayoutSegments, useSelectedLayoutSegment hooks
- E-35: `packages/next/src/client/components/nav-failure-handler.ts` - handleHardNavError, useNavFailureHandler
- E-36: `packages/next/src/client/components/handle-isr-error.tsx` - HandleISRError
- E-37: `packages/next/src/client/components/bfcache-state-manager.ts` - useRouterBFCache hook
- E-38: `packages/next/src/client/components/router-reducer/create-initial-router-state.ts` - createInitialRouterState関数
- E-39: `packages/next/src/client/components/app-router-headers.ts` - RSC_HEADER等のヘッダー定数定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | isRedirectErrorが有効なRedirectErrorオブジェクトを正しく判定する（UT-CLC-001〜010） | E-01, E-03 | ○ |
| C-02 | getRedirectErrorが正しいdigestフォーマットのエラーを生成する（UT-CLC-011〜013） | E-02, E-03 | ○ |
| C-03 | redirect/permanentRedirectがRedirectErrorをスローする（UT-CLC-014〜016） | E-02, E-03 | ○ |
| C-04 | getURLFromRedirectError/getRedirectTypeFromError/getRedirectStatusCodeFromErrorが正しく値を抽出する（UT-CLC-017〜025） | E-02, E-01 | ○ |
| C-05 | isNextRouterErrorがRedirectErrorとHTTPAccessFallbackErrorを判定する（UT-CLC-026〜029） | E-04, E-01, E-05 | ○ |
| C-06 | isHTTPAccessFallbackErrorが404/403/401を判定する（UT-CLC-030〜035） | E-05 | ○ |
| C-07 | getAccessFallbackHTTPStatus/getAccessFallbackErrorTypeByStatusが正しく変換する（UT-CLC-036〜041） | E-05 | ○ |
| C-08 | notFound/forbidden/unauthorizedが適切なエラーをスローする（UT-CLC-042〜046） | E-06, E-07, E-08 | ○ |
| C-09 | matchSegmentが文字列・配列セグメントを正しく比較する（UT-CLC-047〜052） | E-09 | ○ |
| C-10 | PromiseQueueが同時実行制御を正しく行う（UT-CLC-053〜059） | E-10 | ○ |
| C-11 | StaticGenBailoutError/isStaticGenBailoutErrorが正しく動作する（UT-CLC-060〜064） | E-11 | ○ |
| C-12 | UnrecognizedActionError/unstable_isUnrecognizedActionErrorが正しく動作する（UT-CLC-065〜068） | E-12 | ○ |
| C-13 | DynamicServerError/isDynamicServerErrorが正しく動作する（UT-CLC-069〜072） | E-13 | ○ |
| C-14 | ReadonlyURLSearchParamsの変更メソッドがエラーをスローする（UT-CLC-073〜078） | E-14 | ○ |
| C-15 | createHrefFromUrlがURL部分を正しく結合する（UT-CLC-079〜081） | E-15 | ○ |
| C-16 | createRouterCacheKeyが文字列・配列セグメントを正しく処理する（UT-CLC-082〜085） | E-16 | ○ |
| C-17 | extractPathFromFlightRouterState/computeChangedPath/getSelectedParamsがFlightRouterStateを解析する（UT-CLC-086〜093） | E-17 | ○ |
| C-18 | unstable_rethrowがNext.js内部エラーを再スローする（UT-CLC-094〜097） | E-18 | ○ |
| C-19 | shouldHardNavigateがセグメント比較に基づきハードナビゲーションを判定する（UT-CLC-098〜099） | E-20 | ○ |
| C-20 | createCacheKeyがURLからキャッシュキーを生成する（UT-CLC-100〜102） | E-21 | ○ |
| C-21 | LRUのput/delete/updateSizeが正しく動作する（UT-CLC-103〜110） | E-22 | ○ |
| C-22 | CacheMapの各操作（set/get/delete/isExpired/setSize）が正しく動作する（UT-CLC-111〜121） | E-23 | ○ |
| C-23 | VaryPath関連関数が正しいパス構造を生成する（UT-CLC-122〜133） | E-24 | ○ |
| C-24 | setCacheBustingSearchParamWithHashがURLに_rscパラメータを追加する（UT-CLC-134〜137） | E-25 | ○ |
| C-25 | ErrorBoundaryHandlerがNext.jsルーターエラーのバイパスとエラーリセットを正しく処理する（UT-CLC-138〜142） | E-26 | ○ |
| C-26 | RedirectErrorBoundaryがリダイレクトエラーをキャプチャしリダイレクト処理する（UT-CLC-143〜145） | E-27, E-02, E-01 | ○ |
| C-27 | dispatchAppRouterAction/dispatchGestureStateが初期化前にエラーをスローする（UT-CLC-146〜147） | E-28 | ○ |
| C-28 | isExternalURLが同一オリジン判定を正しく行う（UT-CLC-148〜149） | E-29 | ○ |
| C-29 | unresolvedThenableがthenメソッドを持つ未解決Promiseであること（UT-CLC-150） | E-30 | ○ |
| C-30 | リンク管理関数（setLinkForCurrentNavigation等）がナビゲーション状態を正しく管理する（UT-CLC-151〜154） | E-31 | ○ |
| C-31 | publicAppRouterInstance各メソッドがjavascript:URLをブロックする（UT-CLC-157〜159） | E-32 | ○ |
| C-32 | hmrRefreshが本番環境でエラーをスローする（UT-CLC-160） | E-32 | ○ |
| C-33 | createMutableActionQueueが正しく初期化され重複呼び出しを防ぐ（UT-CLC-161〜162） | E-32 | ○ |
| C-34 | getCurrentAppRouterStateが初期化状態に応じて正しい値を返す（UT-CLC-155〜156） | E-32 | ○ |
| C-35 | isNavigatingToNewRootLayoutがレイアウト変更を検出する（UT-CLC-163〜165） | E-33 | ○ |
| C-36 | segment-cache/scheduler.ts のprefetchタスクスケジューリングの詳細テスト | **根拠なし** | △ |
| C-37 | segment-cache/navigation.ts のナビゲーション処理の詳細テスト | **根拠なし** | △ |
| C-38 | segment-cache/prefetch.ts のプリフェッチ処理の詳細テスト | **根拠なし** | △ |
| C-39 | navigation.ts のReact Hooks（useSearchParams, usePathname等）の直接テスト | **根拠なし** | △ |
| C-40 | app-router.tsx / layout-router.tsx のUIコンポーネントテスト | **根拠なし** | △ |
| C-41 | router-reducer/reducers/ ディレクトリ内の各リデューサーの詳細テスト | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **segment-cache/scheduler.ts, prefetch.ts, navigation.ts**: 外部依存（fetchサーバーレスポンス、キャッシュ操作等）が多く、単体テストとしてのモック設計が複雑。結合テストとして扱う方が適切。
  - 候補：結合テストケース一覧 / E2Eテストケース一覧での対応
- **React Hooks (useSearchParams, usePathname, useRouter, useParams等)**: Reactコンテキストに依存するhookのため、テスティングライブラリ（React Testing Library等）を用いたコンポーネントテストが必要。
  - 候補：React Testing Libraryベースのテストケース / 統合テスト
- **UIコンポーネント (app-router.tsx, layout-router.tsx, client-page.tsx, client-segment.tsx等)**: レンダリングテストが主となるため、単体テストケースの範囲外。
  - 候補：コンポーネントテスト / E2Eテスト
- **router-reducer/reducers/**: 複数のリデューサー（navigate, restore, refresh等）が存在するが、状態遷移が複雑で多くのモックが必要。
  - 候補：専用のリデューサーテスト / 統合テスト

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: redirect-error.ts, match-segments.ts, create-href-from-url.ts, create-router-cache-key.ts, readonly-url-search-params.ts - 純粋関数で外部依存なし、テストケースの信頼性が高い
- **リスク0（低）**: static-generation-bailout.ts, unrecognized-action-error.ts, hooks-server-context.ts - シンプルなエラークラスとガード関数
- **リスク1（中）**: segment-cache/lru.ts, segment-cache/cache-map.ts, segment-cache/vary-path.ts - モジュール間の連携があるが、テスト可能な関数を個別に検証可能
- **リスク1（中）**: error-boundary.tsx, redirect-boundary.tsx - Reactクラスコンポーネントの静的メソッドは個別テスト可能だが、レンダリング動作はコンポーネントテストが必要
- **リスク2（高）**: segment-cache/scheduler.ts, segment-cache/navigation.ts - 複雑な状態管理と非同期処理、外部モジュールへの依存が大きくテストケースを省略している

## 6) レビュアーチェックリスト（最小）
- [ ] redirect-error.ts のisRedirectError: digestフォーマットの全パターン（特にセミコロンを含むURL）が網羅されているか
- [ ] http-access-fallback.ts: 401/403/404以外のステータスコードが正しく拒否されるか確認
- [ ] forbidden/unauthorized: 実験的機能フラグの環境変数設定が正しくテストされているか
- [ ] PromiseQueue: 同時実行制御のエッジケース（全タスクが同時にreject等）が十分か
- [ ] LRU/CacheMap: メモリ管理関連のテストでmaxLruSizeを超えた際のeviction動作が省略されていないか確認
- [ ] publicAppRouterInstance: javascript:URL以外のXSSベクター（data:URL等）がテスト対象として必要か検討
- [ ] segment-cache関連: 省略されたscheduler/navigation/prefetchについて、別途結合テストでカバーする計画があるか確認
- [ ] React Hook関連: useSearchParams等のhookについて、React Testing Libraryベースのテストが別途計画されているか確認
