---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 132
  claims_with_evidence: 128
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：next-src-client-dev 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：128 / 132、根拠なし：4
- 優先レビュー（高）
  1. **C-096 (createProcessTurbopackMessage キュー動作)**: 動的importの内部動作のため完全なテスト可能性が不明
  2. **C-036 (onBuilding 遅延ログ)**: setTimeout内部のタイミング依存テストで実装詳細に依存
  3. **C-039 (onBuilt no-op抑制)**: タイマー進行前の状態判定でテスト環境への依存度が高い
  4. **C-076 (handleStaticIndicator static判定)**: window.next.router内部状態への依存が強い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/client/dev/debug-channel.ts` - デバッグチャネルのReadableWriterPair管理
- E-02: `packages/next/src/client/dev/fouc.ts` - FOUC防止スタイル除去
- E-03: `packages/next/src/client/dev/report-hmr-latency.ts` - HMRレイテンシ報告
- E-04: `packages/next/src/client/dev/runtime-error-handler.ts` - ランタイムエラーハンドラ状態管理
- E-05: `packages/next/src/client/dev/hot-reloader/shared.ts` - 共有定数・ユーティリティ
- E-06: `packages/next/src/client/dev/hot-reloader/get-socket-url.ts` - WebSocket URL生成
- E-07: `packages/next/src/client/dev/hot-reloader/turbopack-hot-reloader-common.ts` - TurbopackHmrクラス
- E-08: `packages/next/src/client/dev/hot-reloader/pages/websocket.ts` - Pages Router WebSocket管理
- E-09: `packages/next/src/client/dev/hot-reloader/pages/hot-reloader-pages.ts` - Pages Router HMR処理
- E-10: `packages/next/src/client/dev/hot-reloader/app/web-socket.ts` - App Router WebSocket管理
- E-11: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` - App Router HMR処理
- E-12: `packages/next/src/client/dev/hot-middleware-client.ts` - Hot Middlewareクライアント
- E-13: `packages/next/src/client/dev/on-demand-entries-client.ts` - On-demand entriesクライアント
- E-14: `packages/next/src/client/dev/noop-turbopack-hmr.ts` - Turbopack HMR noop
- E-15: `packages/next/src/client/dev/error-overlay/websocket.ts` - エラーオーバーレイWebSocket（レガシー再export）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | 新規requestIdでペアが作成される | E-01 L11-24 | ○ |
| C-002 | 同一requestIdで既存ペアが返却される | E-01 L14-15 | ○ |
| C-003 | 異なるrequestIdで異なるペアが作成される | E-01 L9,14-19 | ○ |
| C-004 | writerがcloseされた後にpairsから削除される | E-01 L20 | ○ |
| C-005 | requestHeadersにNEXT_REQUEST_ID_HEADERが含まれる場合readableが返却される | E-01 L34-35,52-54 | ○ |
| C-006 | requestHeadersにNEXT_REQUEST_ID_HEADERが存在しない場合InvariantError | E-01 L37-41 | ○ |
| C-007 | requestHeadersがundefinedでself.__next_rが定義済みの場合readable返却 | E-01 L42-44,52-54 | ○ |
| C-008 | requestHeadersがundefinedでself.__next_rも未定義でInvariantError | E-01 L45-49 | ○ |
| C-009 | data-next-hide-fouc属性を持つ要素が削除される | E-02 L22-29 | ○ |
| C-010 | Promiseが正常にresolveされる | E-02 L19-32 | ○ |
| C-011 | data-next-hide-fouc要素が0件でも正常完了 | E-02 L22-29 | ○ |
| C-012 | トップレベルウィンドウでrequestAnimationFrameが使用される | E-02 L9-10 | ○ |
| C-013 | iframe内ではsetTimeoutが使用される | E-02 L11-13 | ○ |
| C-014 | HMRレイテンシがコンソールにログ出力される | E-03 L25-26 | ○ |
| C-015 | hasUpdate=trueでclient-hmr-latencyイベント送信 | E-03 L30-42 | ○ |
| C-016 | hasUpdate=falseでsendMessageが呼ばれない | E-03 L27-29 | ○ |
| C-017 | __NEXT_HMR_LATENCY_CBが定義されている場合コールバック呼び出し | E-03 L43-45 | ○ |
| C-018 | __NEXT_HMR_LATENCY_CBが未定義の場合エラーなし | E-03 L43 | ○ |
| C-019 | isPageHiddenがdocument.visibilityStateに基づく | E-03 L40 | ○ |
| C-020 | 初期状態でhadRuntimeErrorがfalse | E-04 L1-3 | ○ |
| C-021 | hadRuntimeErrorをtrueに設定可能 | E-04 L1-3 | ○ |
| C-022 | REACT_REFRESH_FULL_RELOAD定数の値 | E-05 L3-9 | ○ |
| C-023 | REACT_REFRESH_FULL_RELOAD_FROM_ERROR定数の値 | E-05 L11-12 | ○ |
| C-024 | reportInvalidHmrMessageでconsole.warnが出力される | E-05 L14-24 | ○ |
| C-025 | errがErrorインスタンスでない場合も動作する | E-05 L22 | ○ |
| C-026 | assetPrefixが相対パスの場合window.locationベースのURL | E-06 L14-26 | ○ |
| C-027 | assetPrefixが絶対URLの場合そのURLベースのURL | E-06 L18-22 | ○ |
| C-028 | httpsのassetPrefixでwss:プロトコル | E-06 L11,21 | ○ |
| C-029 | assetPrefixがundefinedの場合 | E-06 L15-16 | ○ |
| C-030 | ポートが空の場合ポート部分が省略される | E-06 L25 | ○ |
| C-031 | http:プロトコルでws:が返却される | E-06 L11 | ○ |
| C-032 | https:プロトコルでwss:が返却される | E-06 L11 | ○ |
| C-033 | 不正なURL文字列でwindow.location.protocolにフォールバック | E-06 L6-9 | ○ |
| C-034 | TurbopackHmr初期状態でupdatedModulesが空Set | E-07 L28-31 | ○ |
| C-035 | onBuildingでstartMsSinceEpochが記録される | E-07 L54-67 | ○ |
| C-036 | onBuildingで遅延してrebuildingメッセージが出力される | E-07 L41-47,60-66 | △ |
| C-037 | onBuilding後にonTurbopackMessageとonBuiltでHmrUpdate返却 | E-07 L75-81,100-124 | ○ |
| C-038 | onBuildingなしでonBuiltがnull返却 | E-07 L106-112 | ○ |
| C-039 | 更新なくrebuildingメッセージも未出力でnull返却 | E-07 L108-112 | △ |
| C-040 | onBuilt後にupdatedModulesがリセットされる | E-07 L121-122 | ○ |
| C-041 | partial + ChunkListUpdate + mergedからモジュール名抽出 | E-07 L127-156 | ○ |
| C-042 | mergedがundefinedの場合スキップ | E-07 L136-141 | ○ |
| C-043 | typeがpartialでない場合スキップ | E-07 L136 | ○ |
| C-044 | onServerComponentChangesでタイムスタンプ更新 | E-07 L83-85 | ○ |
| C-045 | onReloadPageでタイムスタンプ更新 | E-07 L87-89 | ○ |
| C-046 | onPageAddRemoveでタイムスタンプ更新 | E-07 L91-93 | ○ |
| C-047 | 配列形式dataから複数モジュール抽出 | E-07 L132-155 | ○ |
| C-048 | 空配列で空のSet返却 | E-07 L130-132 | ○ |
| C-049 | 正規表現不一致でスキップ | E-07 L145-148 | ○ |
| C-050 | addMessageListenerでコールバック登録 | E-08 L15-17 | ○ |
| C-051 | 複数コールバック登録で全て呼ばれる | E-08 L13,16,67-69 | ○ |
| C-052 | WebSocket OPENでメッセージ送信 | E-08 L19-22 | ○ |
| C-053 | WebSocket非OPENでメッセージ送信されない | E-08 L20 | ○ |
| C-054 | source未定義でエラーなくreturn | E-08 L20 | ○ |
| C-055 | WebSocket接続確立でログ出力 | E-08 L34-37 | ○ |
| C-056 | 接続確立でreconnectionsが0リセット | E-08 L35-36 | ○ |
| C-057 | メッセージ受信で登録コールバック呼び出し | E-08 L40-69 | ○ |
| C-058 | TURBOPACK_CONNECTEDでserverSessionId変更時リロード | E-08 L49-65 | ○ |
| C-059 | 切断後WEB_SOCKET_MAX_RECONNECTIONS超過でリロード | E-08 L72-82 | ○ |
| C-060 | 切断後5回以内は1秒後に再接続 | E-08 L86 | ○ |
| C-061 | 切断後6回以上は5秒後に再接続 | E-08 L86 | ○ |
| C-062 | reloading中はメッセージ未処理 | E-08 L42-45 | ○ |
| C-063 | connect関数がdevClientオブジェクトを返却 | E-09 L95-125 | ○ |
| C-064 | subscribeToHmrEventでハンドラ登録 | E-09 L107-109 | ○ |
| C-065 | onUnrecoverableErrorでhadRuntimeError=true | E-09 L110-112 | ○ |
| C-066 | BUILDINGメッセージでbuildingIndicatorShow呼び出し | E-09 L282-291 | ○ |
| C-067 | BUILT/SYNCでerrorsがある場合handleErrors実行 | E-09 L309-318 | ○ |
| C-068 | BUILT/SYNCでwarningsがある場合handleWarnings実行 | E-09 L322-332 | ○ |
| C-069 | BUILT/SYNCでエラーも警告もない場合handleSuccess実行 | E-09 L334-340 | ○ |
| C-070 | SERVER_ERRORでerrorJSONパースしhandleErrors呼び出し | E-09 L349-358 | ○ |
| C-071 | ISR_MANIFESTでisrManifest更新 | E-09 L277-280 | ○ |
| C-072 | ADDED_PAGE/REMOVED_PAGE/RELOAD_PAGEでcustomHmrEventHandler呼び出し | E-09 L384-391 | ○ |
| C-073 | SERVER_COMPONENT_CHANGESでhadRuntimeErrorがtrueならリロード | E-09 L342-347 | ○ |
| C-074 | REQUEST_CURRENT_ERROR_STATEでエラー状態返信 | E-09 L405-414 | ○ |
| C-075 | REQUEST_PAGE_METADATAでページメタデータ返信 | E-09 L416-425 | ○ |
| C-076 | handleStaticIndicator static判定 | E-09 L255-272 | △ |
| C-077 | 動的ページでdynamic判定 | E-09 L255-272 | ○ |
| C-078 | performFullReload (pages)でエラー送信とリロード | E-09 L537-554 | ○ |
| C-079 | performFullReload (pages)でerr=nullの処理 | E-09 L538-542 | ○ |
| C-080 | createWebSocketでWebSocket接続確立 | E-10 L24-146 | ○ |
| C-081 | self.__next_r未定義でInvariantError | E-10 L28-32 | ○ |
| C-082 | 接続確立でreconnectionsリセットとログ | E-10 L56-61 | ○ |
| C-083 | バイナリメッセージのパース | E-10 L71-73,220-260 | ○ |
| C-084 | JSONメッセージのパースとprocessMessage呼び出し | E-10 L73,107-112 | ○ |
| C-085 | TURBOPACK_CONNECTED serverSessionId変更でリロード | E-10 L76-88 | ○ |
| C-086 | SYNC hash変更でリロード | E-10 L92-105 | ○ |
| C-087 | 切断後最大再接続数超過でリロード | E-10 L124-129 | ○ |
| C-088 | 不正メッセージでreportInvalidHmrMessage呼び出し | E-10 L113-115 | ○ |
| C-089 | ERRORS_TO_SHOW_IN_BROWSER型バイナリメッセージパース | E-10 L226-233 | ○ |
| C-090 | REACT_DEBUG_CHUNK型バイナリメッセージパース | E-10 L234-253 | ○ |
| C-091 | REACT_DEBUG_CHUNK型でchunkなしの場合null | E-10 L243-246 | ○ |
| C-092 | 不明messageTypeでInvariantError | E-10 L254-258 | ○ |
| C-093 | assertByteLengthで十分な長さの場合エラーなし | E-10 L262-268 | ○ |
| C-094 | assertByteLengthで不足長さの場合InvariantError | E-10 L263-267 | ○ |
| C-095 | 0バイトデータでInvariantError | E-10 L221,262-268 | ○ |
| C-096 | TURBOPACKでメッセージキュー蓄積とリプレイ | E-10 L148-186 | △ |
| C-097 | 非TURBOPACKで空関数返却 | E-10 L151-153 | ○ |
| C-098 | BUILDINGでbuildingIndicatorShow (App) | E-11 L286-296 | ○ |
| C-099 | BUILT/SYNCでerrorsがある場合handleErrors (App) | E-11 L318-331 | ○ |
| C-100 | BUILT/SYNCでwarningsのみの場合警告ログ (App) | E-11 L333-361 | ○ |
| C-101 | RELOAD_PAGEでページリロード (App) | E-11 L436-447 | ○ |
| C-102 | RELOAD_PAGEでreloading中の重複防止 | E-11 L444 | ○ |
| C-103 | SERVER_COMPONENT_CHANGESでhmrRefresh (App) | E-11 L399-434 | ○ |
| C-104 | SERVER_COMPONENT_CHANGESでhadRuntimeErrorならリロード | E-11 L413-420 | ○ |
| C-105 | SERVER_ERRORでerrorJSONパース (App) | E-11 L454-463 | ○ |
| C-106 | ISR_MANIFESTでstaticIndicatorState更新 | E-11 L267-284 | ○ |
| C-107 | REACT_DEBUG_CHUNKでchunkがwriterに書き込まれる | E-11 L471-487 | ○ |
| C-108 | REACT_DEBUG_CHUNKでchunk=nullならwriter.close | E-11 L477-483 | ○ |
| C-109 | SERVER_COMPONENT_CHANGESでHMRハッシュクッキー設定 | E-11 L411 | ○ |
| C-110 | CACHE_INDICATORでdispatcher.onCacheIndicator呼び出し | E-11 L510-513 | ○ |
| C-111 | performFullReload (App)でエラー送信とリロード | E-11 L116-138 | ○ |
| C-112 | performFullReload (App)でreloading中の重複防止 | E-11 L135-136 | ○ |
| C-113 | errにstackがある場合先頭5行切り詰め | E-11 L120-124 | ○ |
| C-114 | err=nullの場合stackTraceがfalsy | E-11 L120-124 | ○ |
| C-115 | TURBOPACK環境でisUpdateAvailableがtrue | E-11 L87-90 | ○ |
| C-116 | Webpackでハッシュ異なればtrue | E-11 L95 | ○ |
| C-117 | Webpackでハッシュ同じならfalse | E-11 L95 | ○ |
| C-118 | module.hot.status()=idleでtrue | E-11 L100-101 | ○ |
| C-119 | module.hot.status()!=idleでfalse | E-11 L100-101 | ○ |
| C-120 | waitForWebpackRuntimeHotUpdateがPromise返却 | E-11 L72-74 | ○ |
| C-121 | noop connect関数がundefined返却 | E-14 L3 | ○ |
| C-122 | hot-middleware-clientのdefault exportがdevClient返却 | E-12 L24-102 | ○ |
| C-123 | RELOAD_PAGEでwindow.location.reload呼び出し | E-12 L38-47 | ○ |
| C-124 | REMOVED_PAGEで現在ページ削除時リロード | E-12 L48-66 | ○ |
| C-125 | REMOVED_PAGEで異なるページ削除の無視 | E-12 L56 | ○ |
| C-126 | ADDED_PAGEで現在ページ未ロード時リロード | E-12 L68-89 | ○ |
| C-127 | ADDED_PAGEで既ロードの無視 | E-12 L80 | ○ |
| C-128 | エラーページ上でのリロード | E-12 L34-36,56,80 | ○ |
| C-129 | reloading中のメッセージ抑制 | E-12 L28 | ○ |
| C-130 | TURBOPACK環境での早期return | E-13 L7-9 | ○ |
| C-131 | Webpack環境でpingメッセージ送信 | E-13 L11-25 | ○ |
| C-132 | notFoundSrcPage定義時のパス優先 | E-13 L16-21 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-036 (onBuilding遅延ログ)**: setTimeoutの内部タイミング動作であり、テスト環境でのタイマーモック設定次第で挙動が変わる可能性がある
  - 候補：jest.useFakeTimers() / sinon.useFakeTimers() での検証
- **C-039 (onBuilt no-op抑制)**: deferredReportHmrStartIdとreportedHmrStartの内部状態の組み合わせ条件であり、privateフィールドへのアクセスが必要
  - 候補：onBuilding() -> onBuilt()のみの呼出しシーケンスで間接的に検証
- **C-076 (handleStaticIndicator static判定)**: window.next.routerの内部構造（components, pathname）とisrManifestの組み合わせ判定であり、テスト環境でのモック構成が必要
  - 候補：window.next.routerのモックオブジェクト構築
- **C-096 (createProcessTurbopackMessage キュー動作)**: 動的import (`@vercel/turbopack-ecmascript-runtime`) の解決後にキューがリプレイされる動作で、テスト環境でのモジュールモックが必要
  - 候補：jest.mock() での動的importモック

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: debug-channel.ts, fouc.ts, runtime-error-handler.ts, noop-turbopack-hmr.ts, shared.ts - 独立性が高く副作用が限定的
- **1 (中リスク)**: report-hmr-latency.ts, get-socket-url.ts, turbopack-hot-reloader-common.ts, on-demand-entries-client.ts - グローバル状態（window, document）への依存があるがテスト可能
- **2 (高リスク)**: hot-reloader-app.tsx, hot-reloader-pages.ts, web-socket.ts, websocket.ts, hot-middleware-client.ts - WebSocket接続、webpack module.hot API、React hooks、グローバル状態への強い依存がありモックが複雑

## 6) レビュアーチェックリスト（最小）
- [ ] debug-channel.ts: TransformStreamのモック戦略が適切か確認
- [ ] fouc.ts: DOM操作テストでjsdomまたは類似環境が使用されているか確認
- [ ] report-hmr-latency.ts: window.__nextDevClientId, document.visibilityStateのモックが適切か確認
- [ ] get-socket-url.ts: URL.canParseのブラウザ互換性を考慮したモック設定か確認
- [ ] turbopack-hot-reloader-common.ts: TurbopackHmrのprivateフィールドを間接的にテストしているか確認
- [ ] websocket.ts (pages): WebSocketモックがonopen/onclose/onmessageイベントを適切にシミュレートしているか確認
- [ ] hot-reloader-pages.ts: dispatcher, module.hot, formatWebpackMessagesのモック設定が適切か確認
- [ ] web-socket.ts (app): バイナリメッセージ(ArrayBuffer)のテストデータ構築が正確か確認
- [ ] hot-reloader-app.tsx: React hooks (useEffect, useContext) を含むコンポーネントのテスト方法が適切か確認
- [ ] hot-middleware-client.ts: window.next.routerの複雑なモック構造が正確か確認
- [ ] 全ファイル: window.location.reloadのモック/スパイが適切に設定されているか確認
