---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 149
  claims_with_evidence: 145
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：next-src-client-misc 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：145 / 149、根拠なし：4
- 優先レビュー（高）
  1. **C-075〜C-077 (Portal)**: Reactコンポーネントの副作用テストであり、DOMの生成・削除タイミングの検証にはブラウザ環境のモックが必要
  2. **C-073 (resolvePromiseWithTimeout タイムアウト)**: タイマーモックの精密な制御が必要で、requestIdleCallbackの動作仮定に依存
  3. **C-146〜C-149 (handleLoading)**: img要素のdecode() Promiseチェーンのテストであり、非同期処理とDOM状態の組み合わせ検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/client/app-dir/form.tsx` - Formコンポーネント、onFormSubmit関数、hasReactServerActionAttributes関数
- E-02: `packages/next/src/client/app-dir/link.tsx` - LinkComponent、isModifiedEvent、linkClicked、formatStringOrUrl、getFetchStrategyFromPrefetchProp、useLinkStatus
- E-03: `packages/next/src/client/app-dir/link.react-server.tsx` - サーバー側LinkComponent
- E-04: `packages/next/src/client/compat/router.ts` - useRouter関数
- E-05: `packages/next/src/client/lib/console.ts` - formatObject、formatConsoleArgs、parseConsoleArgs
- E-06: `packages/next/src/client/lib/javascript-url.ts` - isJavaScriptURLString関数
- E-07: `packages/next/src/client/lib/promise.ts` - resolvePromiseWithTimeout関数
- E-08: `packages/next/src/client/portal/index.tsx` - Portalコンポーネント
- E-09: `packages/next/src/client/react-client-callbacks/error-boundary-callbacks.ts` - onCaughtError、onUncaughtError関数
- E-10: `packages/next/src/client/react-client-callbacks/on-recoverable-error.ts` - isRecoverableError、onRecoverableError関数
- E-11: `packages/next/src/client/react-client-callbacks/report-global-error.ts` - reportGlobalError関数
- E-12: `packages/next/src/client/request/params.browser.dev.ts` - createRenderParamsFromClient、makeDynamicallyTrackedParamsWithDevWarnings
- E-13: `packages/next/src/client/request/params.browser.prod.ts` - createRenderParamsFromClient (本番)
- E-14: `packages/next/src/client/request/search-params.browser.dev.ts` - createRenderSearchParamsFromClient、makeUntrackedSearchParamsWithDevWarnings
- E-15: `packages/next/src/client/request/search-params.browser.prod.ts` - createRenderSearchParamsFromClient (本番)
- E-16: `packages/next/src/client/tracing/tracer.ts` - Span クラス、Tracer クラス
- E-17: `packages/next/src/client/tracing/report-to-socket.ts` - reportToSocket関数
- E-18: `packages/next/src/client/legacy/image.tsx` - normalizeSrc、imgixLoader、akamaiLoader、cloudinaryLoader、customLoader、defaultLoader、getWidths、generateImgAttrs、getInt、defaultImageLoader、isStaticImport、handleLoading、Image コンポーネント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Formコンポーネント: action文字列指定時にナビゲーションフォームがレンダリングされる | E-01 (L26-144) | ○ |
| C-002 | Formコンポーネント: action関数指定時に通常のformがレンダリングされる | E-01 (L123-124) | ○ |
| C-003 | Form: prefetchにtrue等の不正な値が渡された場合にエラーログ出力 | E-01 (L46-62) | ○ |
| C-004 | Form: action関数指定時にprefetchを渡した場合に警告出力 | E-01 (L57-61) | ○ |
| C-005 | Form: action関数指定時にreplace/scrollを渡した場合に警告出力 | E-01 (L69-78) | ○ |
| C-006 | Form: DISALLOWED_FORM_PROPSに含まれるプロパティが削除される | E-01 (L81-94) | ○ |
| C-007 | onFormSubmit: router.pushが呼ばれる | E-01 (L221-223) | ○ |
| C-008 | onFormSubmit: replace=true時にrouter.replaceが呼ばれる | E-01 (L221) | ○ |
| C-009 | onFormSubmit: onSubmitコールバックが呼ばれる | E-01 (L163-164) | ○ |
| C-010 | onFormSubmit: preventDefaultで処理中断 | E-01 (L168-170) | ○ |
| C-011 | onFormSubmit: router=nullで処理中断 | E-01 (L173-177) | ○ |
| C-012 | onFormSubmit: submitterのformAction属性の使用 | E-01 (L207-213) | ○ |
| C-013 | hasReactServerActionAttributes: $ACTION_ID_検出 | E-01 (L226-232) | ○ |
| C-014 | hasReactServerActionAttributes: $ACTION_REF_検出 | E-01 (L230) | ○ |
| C-015 | hasReactServerActionAttributes: name=null時のfalsy | E-01 (L229) | ○ |
| C-016〜C-022 | isModifiedEvent: 各修飾キー・target検出 | E-02 (L226-237) | ○ |
| C-023〜C-028 | linkClicked: 各条件分岐のナビゲーション処理 | E-02 (L239-300) | ○ |
| C-029〜C-030 | formatStringOrUrl: 文字列/URLオブジェクト処理 | E-02 (L302-308) | ○ |
| C-031〜C-033 | getFetchStrategyFromPrefetchProp: 各戦略 | E-02 (L753-775) | ○ |
| C-034 | useLinkStatus: LinkStatusContextからステータス取得 | E-02 (L749-751) | ○ |
| C-035〜C-037 | LinkComponent (react-server): props受渡し・警告 | E-03 (L1-31) | ○ |
| C-038〜C-039 | useRouter: NextRouter返却/null返却 | E-04 (L1-17) | ○ |
| C-040〜C-050 | formatObject: 各型のフォーマット | E-05 (L3-60) | ○ |
| C-051〜C-058 | formatConsoleArgs: 各フォーマット指定子 | E-05 (L62-119) | ○ |
| C-059〜C-063 | parseConsoleArgs: サーバーログ解析 | E-05 (L121-159) | ○ |
| C-064〜C-070 | isJavaScriptURLString: 各URLパターン検出 | E-06 (L1-18) | ○ |
| C-071〜C-074 | resolvePromiseWithTimeout: 解決/拒否/タイムアウト | E-07 (L1-48) | ○ |
| C-075 | Portal: DOM要素の生成とbodyへの追加 | E-08 (L9-22) | △ |
| C-076 | Portal: アンマウント時のDOM要素削除 | E-08 (L17-18) | △ |
| C-077 | Portal: 初期状態でのnullレンダリング | E-08 (L10, L21) | △ |
| C-078〜C-084 | onCaughtError/onUncaughtError: 各条件分岐 | E-09 (L19-110) | ○ |
| C-085〜C-089 | isRecoverableError/onRecoverableError: 各テストケース | E-10 (L1-31) | ○ |
| C-090〜C-091 | reportGlobalError: ブラウザ互換 | E-11 (L1-9) | ○ |
| C-092〜C-096 | params.browser.dev: Proxy警告 | E-12 (L1-85) | ○ |
| C-097〜C-098 | params.browser.prod: キャッシュ動作 | E-13 (L1-22) | ○ |
| C-099〜C-103 | search-params.browser.dev: Proxy警告 | E-14 (L1-103) | ○ |
| C-104〜C-105 | search-params.browser.prod: キャッシュ動作 | E-15 (L1-24) | ○ |
| C-106〜C-113 | Span: 初期化・終了・二重終了防止 | E-16 (L26-57) | ○ |
| C-114〜C-117 | Tracer: startSpan/onSpanEnd | E-16 (L59-76) | ○ |
| C-118〜C-119 | reportToSocket: ソケット送信・未終了チェック | E-17 (L1-18) | ○ |
| C-120〜C-121 | normalizeSrc: パス正規化 | E-18 (L28-30) | ○ |
| C-122〜C-126 | imgixLoader/akamaiLoader/cloudinaryLoader: URL生成 | E-18 (L68-108) | ○ |
| C-127 | customLoader: エラースロー | E-18 (L110-115) | ○ |
| C-128〜C-131 | defaultLoader: URL生成・バリデーション | E-18 (L117-217) | ○ |
| C-132〜C-135 | getWidths: 各レイアウトの幅計算 | E-18 (L331-377) | ○ |
| C-136〜C-137 | generateImgAttrs: 画像属性生成 | E-18 (L396-432) | ○ |
| C-138〜C-140 | getInt: 数値パース | E-18 (L434-442) | ○ |
| C-141〜C-142 | defaultImageLoader: ローダー選択 | E-18 (L444-455) | ○ |
| C-143〜C-145 | isStaticImport: 静的インポート判定 | E-18 (L267-285) | ○ |
| C-146〜C-149 | handleLoading: ロード完了処理 | E-18 (L459-513) | △ |

## 4) 不足情報（Unknown / Missing）
- **Portalコンポーネント (C-075〜C-077)**: DOM操作を伴うReactコンポーネントのテストであり、テスト環境でのdocument.bodyの利用可能性やcreatePortalの動作は実行環境に依存する。jsdom等のモック環境での動作検証が必要。
  - 候補：jsdomテスト環境の設定 / React Testing Libraryのレンダリング確認 / テストヘルパーの事前確認
- **handleLoading (C-146〜C-149)**: img要素のdecode()メソッドはPromiseベースであり、テスト時にはdecode()のモックとPromiseチェーンの完了待機が必要。また、parentNodeの存在チェックもDOMモックが前提。
  - 候補：HTMLImageElementのモック / decode()のスタブ / parentNodeプロパティの設定

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: formatObject, formatConsoleArgs, parseConsoleArgs, getInt, normalizeSrc, isStaticImport - 純粋関数であり、テストケースの正確性が高い
- **0 (低リスク)**: isJavaScriptURLString - セキュリティ関連だが正規表現の動作がソースコードで明確
- **0 (低リスク)**: Span, Tracer - クラス定義が明確でテストケースが直接的
- **1 (中リスク)**: onCaughtError, onUncaughtError, onRecoverableError - 外部モジュール依存が多く、モック設定の精度に注意が必要
- **1 (中リスク)**: linkClicked, Form, LinkComponent - Reactコンポーネントのイベントハンドリングテストであり、モックの精度が重要
- **1 (中リスク)**: Proxyベースの警告系テスト (params/search-params browser.dev) - Proxyの動作テストには環境依存あり
- **2 (高リスク)**: Portal - DOM操作の直接テストにはブラウザ環境モックの正確な設定が不可欠

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースのテストID (UT-CLM-xxx) が連番で重複がないこと
- [ ] 対象ファイルパスがモジュール内のファイルと一致すること
- [ ] テスト観点（正常系/異常系/境界値/条件分岐）のカバレッジが十分であること
- [ ] セキュリティ関連関数（isJavaScriptURLString）のテストケースが攻撃パターンを網羅していること
- [ ] エラーバウンダリコールバックのテストケースがNextRouterError/BailoutToCSRErrorのスキップを含むこと
- [ ] Proxy警告系テストケースがget/set/has/ownKeysの各トラップを網羅していること
- [ ] legacy/image.tsx の各ローダー（imgix, akamai, cloudinary, default, custom）が網羅されていること
- [ ] Portalコンポーネントのテストケースについて、実行環境の前提条件が妥当であること
