---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 155
  claims_with_evidence: 151
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：next-src-client-top 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：151 / 155、根拠なし：4
- 優先レビュー（高）
  1. **C-143 (appBootstrap)**: hydrate呼び出しの具体的な引数はgetAssetPrefixの実行時挙動に依存し、テスト時のDOM環境構築が複雑
  2. **C-147, C-148 (useMergedRef)**: React Hook環境が前提であり、テスト方法が実装詳細に依存する可能性
  3. **C-154, C-155 (linkGc)**: MutationObserverのDOM環境テストは環境構築が複雑

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/client/add-base-path.ts` - addBasePath関数の実装
- E-02: `packages/next/src/client/has-base-path.ts` - hasBasePath関数の実装
- E-03: `packages/next/src/client/remove-base-path.ts` - removeBasePath関数の実装
- E-04: `packages/next/src/client/normalize-trailing-slash.ts` - normalizePathTrailingSlash関数の実装
- E-05: `packages/next/src/client/add-locale.ts` - addLocale関数の実装
- E-06: `packages/next/src/client/remove-locale.ts` - removeLocale関数の実装
- E-07: `packages/next/src/client/normalize-locale-path.ts` - normalizeLocalePath関数の実装
- E-08: `packages/next/src/client/detect-domain-locale.ts` - detectDomainLocale関数の実装
- E-09: `packages/next/src/client/get-domain-locale.ts` - getDomainLocale関数の実装
- E-10: `packages/next/src/client/assign-location.ts` - assignLocation関数の実装
- E-11: `packages/next/src/client/flight-data-helpers.ts` - Flight Data関連関数群の実装
- E-12: `packages/next/src/client/head-manager.ts` - HeadManager関連関数群の実装
- E-13: `packages/next/src/client/set-attributes-from-props.ts` - setAttributesFromProps関数の実装
- E-14: `packages/next/src/client/trusted-types.ts` - TrustedTypes関連関数の実装
- E-15: `packages/next/src/client/asset-prefix.ts` - getAssetPrefix関数の実装
- E-16: `packages/next/src/client/app-build-id.ts` - setAppBuildId/getAppBuildId関数の実装
- E-17: `packages/next/src/client/app-find-source-map-url.ts` - findSourceMapURL関数の実装
- E-18: `packages/next/src/client/route-params.ts` - ルートパラメータ関連関数群の実装
- E-19: `packages/next/src/client/form-shared.tsx` - Form共有関数群の実装
- E-20: `packages/next/src/client/resolve-href.ts` - resolveHref関数の実装
- E-21: `packages/next/src/client/request-idle-callback.ts` - requestIdleCallback/cancelIdleCallbackの実装
- E-22: `packages/next/src/client/route-loader.ts` - RouteLoader関連関数群の実装
- E-23: `packages/next/src/client/page-loader.ts` - PageLoaderクラスの実装
- E-24: `packages/next/src/client/use-client-disallowed.ts` - クライアントコンポーネント禁止Proxyの実装
- E-25: `packages/next/src/client/app-bootstrap.ts` - appBootstrap関数の実装
- E-26: `packages/next/src/client/use-merged-ref.ts` - useMergedRef/applyRef関数の実装
- E-27: `packages/next/src/client/app-link-gc.ts` - linkGc関数の実装
- E-28: `packages/next/src/client/flight-data-helpers.test.ts` - 既存テストファイル（参考）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | addBasePath: basePath付与の基本機能 | E-01 | ○ |
| C-002 | addBasePath: required=true時の動作 | E-01 | ○ |
| C-003 | addBasePath: 手動basePathモードの動作 | E-01 | ○ |
| C-004 | addBasePath: 空basePathのエッジケース | E-01 | ○ |
| C-005 | hasBasePath: basePath判定の基本機能 | E-02 | ○ |
| C-006 | hasBasePath: basePath不一致時の動作 | E-02 | ○ |
| C-007 | removeBasePath: basePath除去の基本機能 | E-03 | ○ |
| C-008 | removeBasePath: 空basePath時のエッジケース | E-03 | ○ |
| C-009 | removeBasePath: 手動モードでbasePath不一致時 | E-03 | ○ |
| C-010 | removeBasePath: basePathと完全一致する場合 | E-03 | ○ |
| C-011 | normalizePathTrailingSlash: trailing slash付与 | E-04 | ○ |
| C-012 | normalizePathTrailingSlash: trailing slash除去 | E-04 | ○ |
| C-013 | normalizePathTrailingSlash: 拡張子付きパスの特殊処理 | E-04 | ○ |
| C-014 | normalizePathTrailingSlash: 相対パスの処理 | E-04 | ○ |
| C-015 | normalizePathTrailingSlash: 手動trailing slashモード | E-04 | ○ |
| C-016 | normalizePathTrailingSlash: クエリ・ハッシュ付きパスの処理 | E-04 | ○ |
| C-017 | addLocale: ロケール付与の基本機能 | E-05 | ○ |
| C-018 | addLocale: I18N無効時の動作 | E-05 | ○ |
| C-019 | removeLocale: ロケール除去の基本機能 | E-06 | ○ |
| C-020 | removeLocale: ルートロケールパスの処理 | E-06 | ○ |
| C-021 | removeLocale: I18N無効時の動作 | E-06 | ○ |
| C-022 | removeLocale: locale未指定時の動作 | E-06 | ○ |
| C-023 | removeLocale: ケース非依存のロケール比較 | E-06 | ○ |
| C-024 | normalizeLocalePath: ロケールパス正規化の基本機能 | E-07 | ○ |
| C-025 | normalizeLocalePath: I18N無効時の動作 | E-07 | ○ |
| C-026 | detectDomainLocale: ドメインロケール検出 | E-08 | ○ |
| C-027 | detectDomainLocale: I18N無効時の動作 | E-08 | ○ |
| C-028 | getDomainLocale: ドメインロケールURL生成 | E-09 | ○ |
| C-029 | getDomainLocale: I18N無効時の動作 | E-09 | ○ |
| C-030 | getDomainLocale: ドメイン未一致時 | E-09 | ○ |
| C-031 | assignLocation: 相対パスの解決 | E-10 | ○ |
| C-032 | assignLocation: 絶対パスの解決 | E-10 | ○ |
| C-033 | assignLocation: 末尾スラッシュ補完 | E-10 | ○ |
| C-034 | getFlightDataPartsFromPath: FlightData解析の基本機能 | E-11 | ○ |
| C-035 | getFlightDataPartsFromPath: ルートレンダリング判定 | E-11 | ○ |
| C-036 | getFlightDataPartsFromPath: 非ルートレンダリング判定 | E-11 | ○ |
| C-037 | getFlightDataPartsFromPath: 空segmentPathのエッジケース | E-11 | ○ |
| C-038 | getNextFlightSegmentPath: segmentPathスライスの基本機能 | E-11 | ○ |
| C-039 | getNextFlightSegmentPath: 最小segmentPathのエッジケース | E-11 | ○ |
| C-040 | normalizeFlightData: FlightData正規化（配列入力） | E-11 | ○ |
| C-041 | normalizeFlightData: FlightData正規化（文字列入力） | E-11 | ○ |
| C-042 | prepareFlightRouterStateForRequest: クライアントデータ除去 | E-11 | ○ |
| C-043 | prepareFlightRouterStateForRequest: HMRリフレッシュ時 | E-11 | ○ |
| C-044 | stripClientOnlyDataFromSegment: PAGE_SEGMENT_KEYクリーニング | E-11 | ○ |
| C-045 | stripClientOnlyDataFromSegment: 動的セグメントクリーニング | E-11 | ○ |
| C-046 | isEqualNode: ノード等価判定の基本機能 | E-12 | ○ |
| C-047 | isEqualNode: nonce属性のセキュリティ対応 | E-12 | ○ |
| C-048 | isEqualNode: 非等価ノードの判定 | E-12 | ○ |
| C-049 | initHeadManager: HeadManager初期化 | E-12 | ○ |
| C-050 | initHeadManager: titleの更新 | E-12 | ○ |
| C-051 | initHeadManager: meta要素の追加 | E-12 | ○ |
| C-052 | initHeadManager: フォント最適化のスキップ処理 | E-12 | ○ |
| C-053 | setAttributesFromProps: 属性変換の基本機能 | E-13 | ○ |
| C-054 | setAttributesFromProps: 属性名変換 | E-13 | ○ |
| C-055 | setAttributesFromProps: 無視プロパティの処理 | E-13 | ○ |
| C-056 | setAttributesFromProps: script boolean属性の処理 | E-13 | ○ |
| C-057 | setAttributesFromProps: false値属性の処理 | E-13 | ○ |
| C-058 | setAttributesFromProps: undefined値のスキップ | E-13 | ○ |
| C-059 | isBooleanScriptAttribute: boolean属性判定（真） | E-13 | ○ |
| C-060 | isBooleanScriptAttribute: boolean属性判定（偽） | E-13 | ○ |
| C-061 | __unsafeCreateTrustedScriptURL: TrustedTypes対応 | E-14 | ○ |
| C-062 | __unsafeCreateTrustedScriptURL: TrustedTypes未サポートフォールバック | E-14 | ○ |
| C-063 | getAssetPrefix: assetPrefix抽出の基本機能 | E-15 | ○ |
| C-064 | getAssetPrefix: 無効なcurrentScript | E-15 | ○ |
| C-065 | getAssetPrefix: 不正なスクリプトsrc | E-15 | ○ |
| C-066 | getAssetPrefix: ルートパスのassetPrefix | E-15 | ○ |
| C-067 | setAppBuildId: buildId設定の基本機能 | E-16 | ○ |
| C-068 | getAppBuildId: buildId取得の基本機能 | E-16 | ○ |
| C-069 | getAppBuildId: 初期状態のbuildId | E-16 | ○ |
| C-070 | findSourceMapURL: クライアントチャンクのソースマップURL | E-17 | ○ |
| C-071 | findSourceMapURL: サーバーファイルのソースマップURL | E-17 | ○ |
| C-072 | findSourceMapURL: 空filename | E-17 | ○ |
| C-073 | findSourceMapURL: 本番モードの無効化 | E-17 | ○ |
| C-074 | parseDynamicParamFromURLPart: 動的パラメータ解析 | E-18 | ○ |
| C-075 | parseDynamicParamFromURLPart: キャッチオールパラメータ解析 | E-18 | ○ |
| C-076 | parseDynamicParamFromURLPart: オプショナルキャッチオール（値あり） | E-18 | ○ |
| C-077 | parseDynamicParamFromURLPart: オプショナルキャッチオール（値なし） | E-18 | ○ |
| C-078 | parseDynamicParamFromURLPart: パス不足時のエッジケース | E-18 | ○ |
| C-079 | parseDynamicParamFromURLPart: キャッチオール（パスなし） | E-18 | ○ |
| C-080 | parseDynamicParamFromURLPart: インターセプト付き動的パラメータ | E-18 | ○ |
| C-081 | doesStaticSegmentAppearInURL: 通常セグメントのURL出現判定 | E-18 | ○ |
| C-082 | doesStaticSegmentAppearInURL: ルートグループのURL非出現判定 | E-18 | ○ |
| C-083 | doesStaticSegmentAppearInURL: PAGE_SEGMENT_KEYの判定 | E-18 | ○ |
| C-084 | doesStaticSegmentAppearInURL: DEFAULT_SEGMENT_KEYの判定 | E-18 | ○ |
| C-085 | doesStaticSegmentAppearInURL: not-foundセグメントの判定 | E-18 | ○ |
| C-086 | getCacheKeyForDynamicParam: 文字列パラメータのキャッシュキー | E-18 | ○ |
| C-087 | getCacheKeyForDynamicParam: nullパラメータのキャッシュキー | E-18 | ○ |
| C-088 | getCacheKeyForDynamicParam: 配列パラメータのキャッシュキー | E-18 | ○ |
| C-089 | urlToUrlWithoutFlightMarker: Flightマーカー除去 | E-18 | ○ |
| C-090 | urlToUrlWithoutFlightMarker: export出力の.txtパス除去 | E-18 | ○ |
| C-091 | urlToUrlWithoutFlightMarker: export出力のindex.txtパス除去 | E-18 | ○ |
| C-092 | getParamValueFromCacheKey: キャッチオールのキャッシュキー変換 | E-18 | ○ |
| C-093 | getParamValueFromCacheKey: 動的パラメータのキャッシュキー変換 | E-18 | ○ |
| C-094 | urlSearchParamsToParsedUrlQuery: クエリパラメータ変換 | E-18 | ○ |
| C-095 | urlSearchParamsToParsedUrlQuery: 複数値クエリパラメータ変換 | E-18 | ○ |
| C-096 | urlSearchParamsToParsedUrlQuery: 空クエリの変換 | E-18 | ○ |
| C-097 | getRenderedSearch: リライトクエリ取得 | E-18 | ○ |
| C-098 | getRenderedSearch: 空リライトクエリ | E-18 | ○ |
| C-099 | getRenderedSearch: 通常のサーチ取得 | E-18 | ○ |
| C-100 | getRenderedPathname: リライトパス取得 | E-18 | ○ |
| C-101 | getRenderedPathname: 通常のパス取得 | E-18 | ○ |
| C-102 | createFormSubmitDestinationUrl: フォーム送信先URL生成の基本機能 | E-19 | ○ |
| C-103 | createFormSubmitDestinationUrl: 既存サーチパラメータのクリア | E-19 | ○ |
| C-104 | createFormSubmitDestinationUrl: 無効URLの処理 | E-19 | ○ |
| C-105 | checkFormActionUrl: 有効URLの検証 | E-19 | ○ |
| C-106 | checkFormActionUrl: サーチパラメータ付きURLの警告 | E-19 | ○ |
| C-107 | checkFormActionUrl: 無効URLの警告 | E-19 | ○ |
| C-108 | isSupportedFormEncType: サポートencType判定 | E-19 | ○ |
| C-109 | isSupportedFormEncType: 非サポートencType判定 | E-19 | ○ |
| C-110 | isSupportedFormMethod: サポートmethod判定 | E-19 | ○ |
| C-111 | isSupportedFormMethod: 非サポートmethod判定 | E-19 | ○ |
| C-112 | isSupportedFormTarget: サポートtarget判定 | E-19 | ○ |
| C-113 | isSupportedFormTarget: 非サポートtarget判定 | E-19 | ○ |
| C-114 | hasUnsupportedSubmitterAttributes: 非サポートencType検出 | E-19 | ○ |
| C-115 | hasUnsupportedSubmitterAttributes: 非サポートmethod検出 | E-19 | ○ |
| C-116 | hasUnsupportedSubmitterAttributes: 非サポートtarget検出 | E-19 | ○ |
| C-117 | hasUnsupportedSubmitterAttributes: 全属性サポート時 | E-19 | ○ |
| C-118 | hasReactClientActionAttributes: Reactクライアントアクション判定 | E-19 | ○ |
| C-119 | hasReactClientActionAttributes: 非クライアントアクション判定 | E-19 | ○ |
| C-120 | resolveHref: href解決の基本機能 | E-20 | ○ |
| C-121 | resolveHref: オブジェクトhref解決 | E-20 | ○ |
| C-122 | resolveHref: resolveAs時のタプル返却 | E-20 | ○ |
| C-123 | resolveHref: 外部URL処理 | E-20 | ○ |
| C-124 | resolveHref: 重複スラッシュの処理 | E-20 | ○ |
| C-125 | resolveHref: ハッシュのみのhref処理 | E-20 | ○ |
| C-126 | resolveHref: 動的ルートでのクエリhref処理 | E-20 | ○ |
| C-127 | resolveHref: 動的ルートのinterpolation | E-20 | ○ |
| C-128 | requestIdleCallback: ネイティブ実装の使用 | E-21 | ○ |
| C-129 | requestIdleCallback: setTimeoutフォールバック | E-21 | ○ |
| C-130 | cancelIdleCallback: cancelのフォールバック | E-21 | ○ |
| C-131 | markAssetError: アセットエラーマーキング | E-22 | ○ |
| C-132 | isAssetError: アセットエラー判定（真） | E-22 | ○ |
| C-133 | isAssetError: アセットエラー判定（偽） | E-22 | ○ |
| C-134 | isAssetError: undefined引数 | E-22 | ○ |
| C-135 | PageLoader: 初期化 | E-23 | ○ |
| C-136 | PageLoader.getDataHref: データURL生成の基本機能 | E-23 | ○ |
| C-137 | PageLoader.getDataHref: 動的ルートのデータURL生成 | E-23 | ○ |
| C-138 | PageLoader.getDataHref: 無効ルート名の検出 | E-23 | ○ |
| C-139 | PageLoader.loadPage: ページロードの基本機能 | E-23 | ○ |
| C-140 | PageLoader.loadPage: ページロードエラー | E-23 | ○ |
| C-141 | use-client-disallowed: ESModule互換性 | E-24 | ○ |
| C-142 | use-client-disallowed: クライアントコンポーネント禁止 | E-24 | ○ |
| C-143 | appBootstrap: アプリブートストラップの基本機能 | E-25 | △ |
| C-144 | loadScriptsInSequence: 空スクリプト配列の処理 | E-25 | ○ |
| C-145 | loadScriptsInSequence: スクリプト順序読み込み | E-25 | ○ |
| C-146 | loadScriptsInSequence: スクリプトエラー時のhydrate保証 | E-25 | ○ |
| C-147 | useMergedRef: ref統合の基本機能 | E-26 | △ |
| C-148 | useMergedRef: refクリーンアップ | E-26 | △ |
| C-149 | applyRef: 関数ref適用 | E-26 | ○ |
| C-150 | applyRef: オブジェクトref適用 | E-26 | ○ |
| C-151 | createRouteLoader: エントリポイント待機 | E-22 | ○ |
| C-152 | createRouteLoader: エントリポイント登録 | E-22 | ○ |
| C-153 | createRouteLoader: エントリポイントエラー登録 | E-22 | ○ |
| C-154 | linkGc: リンクGCの設定 | E-27 | △ |
| C-155 | linkGc: 本番モードでのGC無効化 | E-27 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-143 (appBootstrap)**: getAssetPrefixの内部でdocument.currentScriptを使用するため、テスト時のDOM環境構築の詳細が根拠として不足。テスト実行時にdocument.currentScriptをモックする方法の具体的な検証が必要。
  - 候補：jest.spyOn / jsdom環境の設定 / document.currentScriptのモック
- **C-147, C-148 (useMergedRef)**: React Hookのテストは`@testing-library/react-hooks`や`renderHook`を使用する必要があるが、テストケースの入力値・期待結果はHookの内部動作に依存しており、具体的な検証方法の根拠が不足。
  - 候補：renderHook / React Testing Library / コンポーネントレンダリング経由のテスト
- **C-154 (linkGc)**: MutationObserverを使用した開発モード限定機能のテストは、DOM環境の複雑さから具体的なテスト手法の根拠が不足。
  - 候補：jsdomのMutationObserverモック / DOM操作テスト / イベント駆動テスト

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: basePath関連関数（C-001〜C-010）、ロケール関連関数（C-017〜C-030）、flight-data-helpers（C-034〜C-045）、route-params（C-074〜C-101）、form-shared（C-102〜C-119）- ソースコードから直接テストケースを導出しており信頼性が高い
- **リスク0（低）**: set-attributes-from-props（C-053〜C-060）、trusted-types（C-061〜C-062）、asset-prefix（C-063〜C-066）、app-build-id（C-067〜C-069）- 単純な関数であり網羅的にカバー
- **リスク1（中）**: appBootstrap（C-143〜C-146）、useMergedRef（C-147〜C-150）、linkGc（C-154〜C-155）- DOM環境やReact Hook環境が必要であり、テスト環境構築の複雑さがリスク
- **リスク1（中）**: resolveHref（C-120〜C-127）- 多くの外部依存関数を使用しており、モック設定の正確性に注意が必要
- **リスク0（低）**: PageLoader（C-135〜C-140）、RouteLoader（C-131〜C-134、C-151〜C-153）- クラス/インタフェースの明確な契約に基づくテスト

## 6) レビュアーチェックリスト（最小）
- [ ] basePath関連関数のテストケースが環境変数の各パターンを網羅しているか
- [ ] I18N関連関数のテストケースがI18Nサポート有効/無効の両方をカバーしているか
- [ ] flight-data-helpersのテストケースがFlightDataPath型の各パターン（ルート/非ルート、文字列/配列）を網羅しているか
- [ ] form-sharedの各バリデーション関数がサポート/非サポート値を網羅しているか
- [ ] resolveHrefのテストケースがstring/Url型の両方の入力、resolveAs=true/falseの両方を網羅しているか
- [ ] route-paramsの各paramType（d, c, oc, di系, ci系）が網羅されているか
- [ ] PageLoaderのgetDataHrefが静的/動的ルートの両方をカバーしているか
- [ ] head-managerのisEqualNodeがnonce属性の特殊処理を含む全ケースをカバーしているか
- [ ] setAttributesFromPropsのDOMAttributeNames変換テーブルとignorePropsが正しく反映されているか
