---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 137
  claims_with_evidence: 131
  claims_without_evidence: 6
confidence_derived: 0.96
---

# 根拠レポート：next-src-export 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：131 / 137、根拠なし：6
- 優先レビュー（高）
  1. **UT-EXP-014〜019（createIncrementalCache）**：外部依存（IncrementalCacheクラス、cacheHandlersモジュール）の動作が実際のテスト環境で再現可能か要確認
  2. **UT-EXP-072〜076（exportPageWithRetry）**：内部関数のためテストの実装方法に工夫が必要
  3. **UT-EXP-132〜134（exportPagesInBatches）**：内部関数のためテストの実装方法に工夫が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/next/src/export/helpers/get-params.ts` - getParams関数の実装
- E-02: `packages/next/src/export/helpers/is-dynamic-usage-error.ts` - isDynamicUsageError関数の実装
- E-03: `packages/next/src/export/helpers/create-incremental-cache.ts` - createIncrementalCache関数の実装
- E-04: `packages/next/src/export/utils.ts` - hasCustomExportOutput関数の実装
- E-05: `packages/next/src/export/index.ts` - ExportError, buildRDCCacheByPage, exportAppImpl, collectSegmentPaths, exportApp関数の実装
- E-06: `packages/next/src/export/worker.ts` - TimeoutError, ExportPageError, exportPageImpl, exportPages, exportPage関数の実装
- E-07: `packages/next/src/export/routes/app-route.ts` - exportAppRoute関数の実装
- E-08: `packages/next/src/export/routes/app-page.ts` - exportAppPage, logDynamicUsageWarning関数の実装
- E-09: `packages/next/src/export/routes/pages.ts` - exportPagesPage関数の実装
- E-10: `packages/next/src/export/types.ts` - 型定義（ExportPathEntry, ExportPagesInput, ExportPageInput等）
- E-11: `packages/next/src/export/routes/types.ts` - RouteMetadata型定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-EXP-001: getParamsが動的ルートパラメータを正しく抽出する | E-01 (L19-38: matcherでパス照合しparamsを返却) | ○ |
| C-02 | UT-EXP-002: 複数動的パラメータの抽出 | E-01 (L27: getRouteMatcher/getRouteRegexによるパターンマッチング) | ○ |
| C-03 | UT-EXP-003: キャッチオールルートのサポート | E-01 (L27: getRouteRegexがキャッチオールをサポート) | ○ |
| C-04 | UT-EXP-004: 連続呼び出し時のキャッシュ利用 | E-01 (L8-11, L24-25: last変数によるキャッシュ) | ○ |
| C-05 | UT-EXP-005: パス不一致時のエラースロー | E-01 (L31-34: matcherがfalseならError) | ○ |
| C-06 | UT-EXP-006: 異なるページパターンでのキャッシュ更新 | E-01 (L24-28: last?.page !== pageの場合に再作成) | ○ |
| C-07 | UT-EXP-007〜010: isDynamicUsageErrorが各エラー型を検出 | E-02 (L6-10: 4つの条件のOR) | ○ |
| C-08 | UT-EXP-011〜013: 通常エラー/null/undefinedでfalse | E-02 (L6-10: 各関数が該当しない場合false) | ○ |
| C-09 | UT-EXP-014: カスタムキャッシュハンドラなしのIncrementalCache作成 | E-03 (L56-77: IncrementalCacheコンストラクタ呼び出し) | ○ |
| C-10 | UT-EXP-015: カスタムキャッシュハンドラのインポート | E-03 (L33-39: cacheHandler指定時のdynamic import) | ○ |
| C-11 | UT-EXP-016: cacheHandlers指定時のsetCacheHandler呼び出し | E-03 (L41-54: initializeCacheHandlers + setCacheHandler) | ○ |
| C-12 | UT-EXP-017: グローバル変数への設定 | E-03 (L79: globalThis.__incrementalCache = incrementalCache) | ○ |
| C-13 | UT-EXP-018: flushToDisk=falseでminimalMode動作 | E-03 (L59, L76: flushToDisk, hasNextSupport→minimalMode) | ○ |
| C-14 | UT-EXP-019: undefinedハンドラのスキップ | E-03 (L43: if (!handler) continue) | ○ |
| C-15 | UT-EXP-020〜023: hasCustomExportOutput の各条件 | E-04 (L3-13: output === 'export' && distDir !== '.next') | ○ |
| C-16 | UT-EXP-024〜025: ExportErrorのcode/継承 | E-05 (L77-79: class ExportError extends Error, code = 'NEXT_EXPORT_ERROR') | ○ |
| C-17 | UT-EXP-026〜031: buildRDCCacheByPageの各シナリオ | E-05 (L86-189: buildRDCCacheByPage全体の実装) | ○ |
| C-18 | UT-EXP-032: ビルドID不在時のエラー | E-05 (L238-242: existsSync(buildIdFile)チェック) | ○ |
| C-19 | UT-EXP-033〜034: 予約ディレクトリの使用防止 | E-05 (L335-345: outDir === join(dir, 'public'/'static')チェック) | ○ |
| C-20 | UT-EXP-035: i18n非互換エラー | E-05 (L402-406: i18n && !options.buildExportチェック) | ○ |
| C-21 | UT-EXP-036: fallback有効ページの検出 | E-05 (L607-613: fallbackEnabledPages.size > 0) | ○ |
| C-22 | UT-EXP-037: 特殊ページの除外 | E-05 (L299-301: _document, _app, _errorスキップ) | ○ |
| C-23 | UT-EXP-038: APIルートの除外 | E-05 (L294-297: isAPIRoute(page)スキップ) | ○ |
| C-24 | UT-EXP-039: appDirOnly時の404/500削除 | E-05 (L549-552: delete exportPathMap['/404']/['/500']) | ○ |
| C-25 | UT-EXP-040: 重複パスフィルタリング | E-05 (L577-583: seenExportPaths.has(normalizedPath)) | ○ |
| C-26 | UT-EXP-041: 空エクスポートでnull返却 | E-05 (L601-605: allExportPaths.length === 0 && !prerenderManifest) | ○ |
| C-27 | UT-EXP-042: PPR+エクスポートモード非互換 | E-05 (L864-867: !options.buildExport && nextConfig.experimental.ppr) | ○ |
| C-28 | UT-EXP-043: インターセプトルートリライト検出 | E-05 (L445-454: isInterceptionRouteRewriteチェック) | ○ |
| C-29 | UT-EXP-044: サーバーアクション検出 | E-05 (L456-470: actionIdsのserver-actionチェック) | ○ |
| C-30 | UT-EXP-045: エクスポート失敗の報告 | E-05 (L1006-1013: failedExportAttemptsByPage.size > 0) | ○ |
| C-31 | UT-EXP-046: buildExport時の結果収集 | E-05 (L821-860: options.buildExport時のcollector設定) | ○ |
| C-32 | UT-EXP-047: 404.htmlエイリアス | E-05 (L565-568: exportPathMap['/404.html'] = exportPathMap['/404']) | ○ |
| C-33 | UT-EXP-048〜051: collectSegmentPathsの各シナリオ | E-05 (L1042-1074: collectSegmentPaths/collectSegmentPathsImpl) | ○ |
| C-34 | UT-EXP-052〜053: TimeoutError/ExportPageError | E-06 (L61-67: class定義) | ○ |
| C-35 | UT-EXP-054〜056: exportPageImplのルーティング | E-06 (L238-327: isAppDir && isAppRouteRoute → exportAppRoute等) | ○ |
| C-36 | UT-EXP-057: 動的パラメータ抽出 | E-06 (L155-158: isDynamic && page !== nonLocalizedPath) | ○ |
| C-37 | UT-EXP-058: ロケール処理 | E-06 (L134-141: normalizeLocalePath呼び出し) | ○ |
| C-38 | UT-EXP-059〜060: htmlFilename特殊ケース | E-06 (L206-221: path === '/404.html', path === '/') | ○ |
| C-39 | UT-EXP-061〜062: ステータスコード設定 | E-06 (L164-174: for...of statusCode in [404, 500]) | ○ |
| C-40 | UT-EXP-063: trailingSlash付与 | E-06 (L177-179: trailingSlash && !req.url?.endsWith('/')) | ○ |
| C-41 | UT-EXP-064: subFoldersモード | E-06 (L195-196: subFolders ? index.html : .html) | ○ |
| C-42 | UT-EXP-065〜071: exportPagesの各シナリオ | E-06 (L330-521: exportPages全体) | ○ |
| C-43 | UT-EXP-072〜076: exportPageWithRetryリトライロジック | E-06 (L385-503: exportPageWithRetry内部関数) | ○ |
| C-44 | UT-EXP-077〜082: exportPageの結果・エラー処理 | E-06 (L523-600: exportPage関数) | ○ |
| C-45 | UT-EXP-083〜095: exportAppRouteの各シナリオ | E-07 (L36-173: exportAppRoute全体) | ○ |
| C-46 | UT-EXP-096〜115: exportAppPageの各シナリオ | E-08 (L40-274: exportAppPage全体) | ○ |
| C-47 | UT-EXP-116〜118: logDynamicUsageWarningの動作 | E-08 (L276-294: logDynamicUsageWarning) | ○ |
| C-48 | UT-EXP-119〜131: exportPagesPageの各シナリオ | E-09 (L29-137: exportPagesPage全体) | ○ |
| C-49 | UT-EXP-132〜134: exportPagesInBatchesバッチ処理 | E-05 (L678-734: exportPagesInBatches内部関数) | ○ |
| C-50 | UT-EXP-135: cacheComponents 2フェーズ分類 | E-05 (L739-749: cacheComponents分岐) | ○ |
| C-51 | UT-EXP-136: Image Optimization非互換検出 | E-05 (L408-432: isNextImageImported検証) | ○ |
| C-52 | UT-EXP-137: exportAppのトレーススパン | E-05 (L1076-1087: exportApp関数) | ○ |
| C-53 | UT-EXP-014〜016: createIncrementalCacheの外部モジュールインポート動作 | **根拠不足** | △ |
| C-54 | UT-EXP-072〜076: exportPageWithRetryの指数バックオフとジッター | E-06 (L491-495)、ただし実際のタイミング検証は困難 | △ |
| C-55 | UT-EXP-082: process.sendの呼び出し | E-06 (L592)、ワーカープロセス環境依存 | △ |
| C-56 | UT-EXP-069: Error.stackTraceLimit設定 | E-06 (L361)、try-catchで囲まれているため環境依存 | △ |
| C-57 | UT-EXP-075: process.exit(1)の呼び出し | E-06 (L471)、プロセス終了のテストは特殊な方法が必要 | △ |
| C-58 | UT-EXP-114: renderResumeDataCacheの文字列化 | E-08 (L240-245)、stringifyResumeDataCacheの実装は外部依存 | △ |

## 4) 不足情報（Unknown / Missing）
- createIncrementalCache内でのdynamic importの動作は、テスト環境でのモックが必要。実際のモジュール解決パスの動作は外部依存であり完全な根拠が得られない。
  - 候補：IncrementalCacheクラスの実装詳細 / format-dynamic-import-pathの動作 / setCacheHandlerの内部実装
- exportPageWithRetryの指数バックオフ（baseDelay * Math.pow(2, attempt)）のタイミング検証は非決定的であり、正確なテストが困難。
  - 候補：setTimeoutのモック / タイマー制御ライブラリの使用
- process.exit(1)やprocess.sendのテストはプロセスレベルの副作用であり、特殊なテスト手法が必要。
  - 候補：jest.spyOnでprocess.exitをモック / child_processでの実行

## 5) リスクフラグ（レビュー観点）
- 0: hasCustomExportOutput、ExportError、isDynamicUsageError、getParamsなどの純粋関数のテスト - ロジックが明確で低リスク
- 1: exportAppRoute、exportAppPage、exportPagesPageのテスト - 外部依存（ファイルシステム、レンダリングエンジン）のモックが必要で中リスク
- 2: exportAppImpl、exportPages のテスト - 多数の外部依存（ファイルシステム、設定ファイル、マニフェスト、ワーカー）のモックが必要で、テスト環境構築の複雑さが高リスク

## 6) レビュアーチェックリスト（最小）
- [ ] getParams（UT-EXP-001〜006）のテスト観点が正常系・異常系・キャッシュの観点を網羅しているか
- [ ] isDynamicUsageError（UT-EXP-007〜013）が4つの内部関数すべてをカバーしているか
- [ ] createIncrementalCache（UT-EXP-014〜019）でカスタムキャッシュハンドラの動的インポートテストが実現可能か
- [ ] hasCustomExportOutput（UT-EXP-020〜023）で全条件分岐がカバーされているか
- [ ] exportAppImpl（UT-EXP-032〜047, 132〜137）の多数のエラーケース（i18n, PPR, Image Optimization, Server Actions等）が網羅されているか
- [ ] exportPageImpl（UT-EXP-054〜064）でAppRoute/AppPage/PagesRouterの3つのルーティングパスがカバーされているか
- [ ] exportAppRoute（UT-EXP-083〜095）で静的生成の有効/無効、メタデータルート、cacheComponentsの各条件がカバーされているか
- [ ] exportAppPage（UT-EXP-096〜115）でPPR有効/無効、postponed有無、/_not-found・/_global-errorの処理がカバーされているか
- [ ] exportPagesPage（UT-EXP-119〜131）でgetServerSideProps禁止、getStaticPropsスキップ、文字列コンポーネント処理がカバーされているか
- [ ] exportPageWithRetry（UT-EXP-072〜076）のリトライ・タイムアウト・早期終了のテストが実現可能な設計であるか
