---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 195
  claims_with_evidence: 189
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：next-src-lib-metadata 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：189 / 195、根拠なし：6
- 優先レビュー（高）
  1. **UT-MET-033（getSocialImageMetadataBaseFallback開発環境テスト）**：環境変数依存のため実行環境による挙動差異の確認が必要
  2. **UT-MET-191/192（IconMarkサーバー/クライアント判定）**：window判定のモックが必要で実装方法に依存
  3. **UT-MET-193/194/195（createSegmentProps useCacheテスト）**：isUseCacheFunction内部実装への依存があり、モック設計に注意が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/lib/metadata/constants.ts` - ViewportMetaKeys, IconKeys定数定義
- E-02: `packages/next/src/lib/metadata/default-metadata.tsx` - createDefaultViewport, createDefaultMetadata関数定義
- E-03: `packages/next/src/lib/metadata/get-metadata-route.ts` - fillMetadataSegment, normalizeMetadataRoute, normalizeMetadataPageToRoute関数定義
- E-04: `packages/next/src/lib/metadata/is-metadata-route.ts` - getExtensionRegexString, isStaticMetadataFile, isMetadataRouteFile, isStaticMetadataRoute, isMetadataPage, isMetadataRoute関数定義, STATIC_METADATA_IMAGES定数
- E-05: `packages/next/src/lib/metadata/metadata-context.tsx` - createMetadataContext関数定義
- E-06: `packages/next/src/lib/metadata/metadata.tsx` - createMetadataComponents, createMetadataElements, createViewportElements関数定義
- E-07: `packages/next/src/lib/metadata/resolve-metadata.ts` - isFavicon, convertUrlsToStrings, normalizeMetadataBase, mergeMetadata, mergeViewport, accumulateMetadata, accumulateViewport, resolveMetadata, resolveViewport, isPromiseLike, postProcessMetadata, inheritFromMetadata, createSegmentProps関数定義
- E-08: `packages/next/src/lib/metadata/resolvers/resolve-basics.ts` - resolveThemeColor, resolveAlternates, resolveRobots, resolveVerification, resolveAppleWebApp, resolveAppLinks, resolveItunes, resolveFacebook, resolvePagination関数定義
- E-09: `packages/next/src/lib/metadata/resolvers/resolve-icons.ts` - resolveIcon, resolveIcons関数定義
- E-10: `packages/next/src/lib/metadata/resolvers/resolve-opengraph.ts` - resolveImages, resolveOpenGraph, resolveTwitter関数定義
- E-11: `packages/next/src/lib/metadata/resolvers/resolve-title.ts` - resolveTitle関数定義
- E-12: `packages/next/src/lib/metadata/resolvers/resolve-url.ts` - isStringOrURL, resolveUrl, resolveRelativeUrl, resolveAbsoluteUrlWithPathname, getSocialImageMetadataBaseFallback関数定義
- E-13: `packages/next/src/lib/metadata/generate/utils.ts` - resolveArray, resolveAsArrayOrUndefined, getOrigin関数定義
- E-14: `packages/next/src/lib/metadata/generate/meta.tsx` - Meta, MetaFilter, MultiMeta関数定義
- E-15: `packages/next/src/lib/metadata/generate/alternate.tsx` - AlternatesMetadata関数定義
- E-16: `packages/next/src/lib/metadata/generate/basic.tsx` - ViewportMeta, BasicMeta, ItunesMeta, FacebookMeta, PinterestMeta, FormatDetectionMeta, AppleWebAppMeta, VerificationMeta関数定義
- E-17: `packages/next/src/lib/metadata/generate/icons.tsx` - IconsMetadata関数定義
- E-18: `packages/next/src/lib/metadata/generate/opengraph.tsx` - OpenGraphMetadata, TwitterMetadata, AppLinksMeta関数定義
- E-19: `packages/next/src/lib/metadata/generate/icon-mark.tsx` - IconMark関数定義
- E-20: `packages/next/src/lib/metadata/is-metadata-route.test.ts` - 既存テストファイル（テスト観点の参考）
- E-21: `packages/next/src/lib/metadata/resolve-metadata.test.ts` - 既存テストファイル（テスト観点の参考）
- E-22: `packages/next/src/lib/metadata/resolvers/resolve-opengraph.test.ts` - 既存テストファイル（テスト観点の参考）
- E-23: `packages/next/src/lib/metadata/resolvers/resolve-title.test.ts` - 既存テストファイル（テスト観点の参考）
- E-24: `packages/next/src/lib/metadata/resolvers/resolve-url.test.ts` - 既存テストファイル（テスト観点の参考）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-MET-001: createDefaultViewportのデフォルト値 | E-02 (L6-15) | ○ |
| C-02 | UT-MET-002: createDefaultMetadataのデフォルト値 | E-02 (L17-65) | ○ |
| C-03 | UT-MET-003: alternatesフィールドの初期化構造 | E-02 (L37-42) | ○ |
| C-04 | UT-MET-004: paginationフィールドの初期化構造 | E-02 (L59-62) | ○ |
| C-05 | UT-MET-005~006: resolveArrayの配列/単一値処理 | E-13 (L1-6) | ○ |
| C-06 | UT-MET-007~010: resolveAsArrayOrUndefinedの各種入力処理 | E-13 (L8-15) | ○ |
| C-07 | UT-MET-011~012: getOriginのURL解析 | E-13 (L17-26) | ○ |
| C-08 | UT-MET-013~019: resolveTitleの各パターン処理 | E-11 (L1-40) | ○ |
| C-09 | UT-MET-020~022: isStringOrURLの型判定 | E-12 (L6-8) | ○ |
| C-10 | UT-MET-023~028: resolveUrlの各入力パターン処理 | E-12 (L57-85) | ○ |
| C-11 | UT-MET-029~032: resolveAbsoluteUrlWithPathnameのパス解決とtrailingSlash | E-12 (L103-155) | ○ |
| C-12 | UT-MET-033: getSocialImageMetadataBaseFallbackの環境別フォールバック | E-12 (L35-55) | △ |
| C-13 | UT-MET-034~035: resolveRelativeUrlの相対/絶対パス処理 | E-12 (L88-93) | ○ |
| C-14 | UT-MET-036~042: resolveIcon/resolveIconsの各入力処理 | E-09 (L1-34) | ○ |
| C-15 | UT-MET-043~046: resolveImagesの各入力処理 | E-10 (L110-143) | ○ |
| C-16 | UT-MET-047~049: resolveOpenGraphの各入力処理 | E-10 (L161-207) | ○ |
| C-17 | UT-MET-050~053: resolveTwitterの各入力処理とカードタイプ自動判定 | E-10 (L217-259) | ○ |
| C-18 | UT-MET-054~056: resolveThemeColorの各入力処理 | E-08 (L42-59) | ○ |
| C-19 | UT-MET-057~061: resolveRobotsの各入力処理 | E-08 (L187-218) | ○ |
| C-20 | UT-MET-062~064: resolveVerificationの各入力処理 | E-08 (L220-242) | ○ |
| C-21 | UT-MET-065~068: resolveAppleWebAppの各入力処理 | E-08 (L244-264) | ○ |
| C-22 | UT-MET-069~070: resolveAppLinksの各入力処理 | E-08 (L266-273) | ○ |
| C-23 | UT-MET-071~073: resolveFacebookの各入力処理 | E-08 (L293-299) | ○ |
| C-24 | UT-MET-074~076: resolveAlternatesの各入力処理 | E-08 (L135-172) | ○ |
| C-25 | UT-MET-077~078: resolveItunesの各入力処理 | E-08 (L275-291) | ○ |
| C-26 | UT-MET-079~080: resolvePaginationの各入力処理 | E-08 (L301-323) | ○ |
| C-27 | UT-MET-081~083: getExtensionRegexStringの正規表現生成 | E-04 (L36-48) | ○ |
| C-28 | UT-MET-084~097: isStaticMetadataFile/isMetadataRouteFileの各ファイルパターン判定 | E-04 (L55-200) | ○ |
| C-29 | UT-MET-098~100: isStaticMetadataRouteの判定ロジック | E-04 (L206-220) | ○ |
| C-30 | UT-MET-101~103: isMetadataPageの判定ロジック | E-04 (L233-237) | ○ |
| C-31 | UT-MET-104~108: isMetadataRouteの判定ロジック | E-04 (L250-263) | ○ |
| C-32 | UT-MET-109~110: fillMetadataSegmentの静的/動的セグメント処理 | E-03 (L63-94) | ○ |
| C-33 | UT-MET-111~116: normalizeMetadataRouteの各種メタデータルート正規化 | E-03 (L105-130) | ○ |
| C-34 | UT-MET-117~119: normalizeMetadataPageToRouteの静的/動的ルート正規化 | E-03 (L137-148) | ○ |
| C-35 | UT-MET-120~121: createMetadataContextの生成 | E-05 (L1-11) | ○ |
| C-36 | UT-MET-122~125: isFaviconの判定ロジック | E-07 (L118-129) | ○ |
| C-37 | UT-MET-126~129: convertUrlsToStringsの再帰的変換 | E-07 (L131-146) | ○ |
| C-38 | UT-MET-130~133: normalizeMetadataBaseの変換とエラー処理 | E-07 (L148-157) | ○ |
| C-39 | UT-MET-134~138: isPromiseLikeの各種入力判定 | E-07 (L1299-1307) | ○ |
| C-40 | UT-MET-139~145: Metaコンポーネントの各入力パターン処理 | E-14 (L4-25) | ○ |
| C-41 | UT-MET-146~148: MetaFilterのフィルタリングとフラット化 | E-14 (L27-39) | ○ |
| C-42 | UT-MET-149~151: MultiMetaの各入力パターン処理 | E-14 (L98-133) | ○ |
| C-43 | UT-MET-152~153: ViewportMetaのmetaタグ生成 | E-16 (L37-52) | ○ |
| C-44 | UT-MET-154~155: BasicMetaのmetaタグ生成 | E-16 (L54-131) | ○ |
| C-45 | UT-MET-156~158: ItunesMetaの各入力処理 | E-16 (L133-141) | ○ |
| C-46 | UT-MET-159~160: FacebookMetaの各入力処理 | E-16 (L143-158) | ○ |
| C-47 | UT-MET-161~163: PinterestMetaの各入力処理 | E-16 (L160-170) | ○ |
| C-48 | UT-MET-164~165: FormatDetectionMetaの各入力処理 | E-16 (L179-193) | ○ |
| C-49 | UT-MET-166~167: AppleWebAppMetaの各入力処理 | E-16 (L195-223) | ○ |
| C-50 | UT-MET-168~169: VerificationMetaの各入力処理 | E-16 (L225-249) | ○ |
| C-51 | UT-MET-170~172: AlternatesMetadataの各入力処理 | E-15 (L23-58) | ○ |
| C-52 | UT-MET-173~175: IconsMetadataの各入力処理 | E-17 (L23-50) | ○ |
| C-53 | UT-MET-176~178: OpenGraphMetadataの各入力処理 | E-18 (L6-221) | ○ |
| C-54 | UT-MET-179~180: TwitterMetadataの各入力処理 | E-18 (L240-279) | ○ |
| C-55 | UT-MET-181~182: AppLinksMetaの各入力処理 | E-18 (L281-303) | ○ |
| C-56 | UT-MET-183~184: 定数値の確認 | E-01 (L1-15) | ○ |
| C-57 | UT-MET-185~187: mergeViewportの各入力パターン処理 | E-07 (L451-493) | ○ |
| C-58 | UT-MET-188~190: inheritFromMetadataの継承ロジック | E-07 (L914-926) | ○ |
| C-59 | UT-MET-191~192: IconMarkのサーバー/クライアント判定 | E-19 (L1-14) | △ |
| C-60 | UT-MET-193~195: createSegmentPropsのuseCache対応 | E-07 (L554-563) | △ |

## 4) 不足情報（Unknown / Missing）
- **getSocialImageMetadataBaseFallback（UT-MET-033）**: 環境変数 `NODE_ENV`, `VERCEL`, `VERCEL_ENV`, `VERCEL_BRANCH_URL`, `VERCEL_URL`, `VERCEL_PROJECT_PRODUCTION_URL` に依存する処理。テスト時の環境変数モック設計が必要であり、全ての環境パターンを網羅するには追加のテストケースが望ましい。
  - 候補：本番環境（preview）テスト / Vercel環境変数未設定時テスト / productionデプロイメントURL使用テスト
- **IconMark（UT-MET-191~192）**: `typeof window`判定のモック方法がテスト環境に依存。Jest/Vitestなどのテストフレームワークでのwindowオブジェクト制御が必要。
  - 候補：jsdom環境テスト / node環境テスト
- **createSegmentProps（UT-MET-193~195）**: `isUseCacheFunction`の内部実装に依存。この関数は`../client-and-server-references`からインポートされており、モック設計が必要。
  - 候補：client-and-server-references モジュールのモック戦略の確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テストケースの大部分（UT-MET-001~190）はソースコードから直接抽出した関数シグネチャ・条件分岐に基づいており、根拠が明確である。
- **1（中リスク）**: 環境変数依存のテスト（UT-MET-033）は実行環境によって結果が変わる可能性がある。テスト実装時に適切なモック設計が必要。
- **1（中リスク）**: Reactコンポーネントのテスト（generate/配下）はJSX出力の検証方法に依存する。Reactテスティングユーティリティの利用が前提となる。
- **1（中リスク）**: mergeMetadata, accumulateMetadata, postProcessMetadataなどの複合関数は内部で多くの依存関数を呼び出すため、単体テストでは適切なモック/スタブが必要。本一覧では個別のresolve関数レベルでのテストを優先している。

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの「期待結果」がソースコードの実装と整合しているか
- [ ] 正常系・異常系・境界値のバランスが適切か（特に高優先度の関数について）
- [ ] 環境変数依存テスト（UT-MET-033等）のモック戦略が実現可能か
- [ ] Reactコンポーネントテスト（generate/配下）の検証方法が妥当か
- [ ] resolve-metadata.tsの内部関数（mergeMetadata等）のテスト粒度が適切か
- [ ] 既存テストファイル（is-metadata-route.test.ts, resolve-metadata.test.ts, resolve-opengraph.test.ts, resolve-title.test.ts, resolve-url.test.ts）との重複・補完関係が整理されているか
