---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 142
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：next-src-lib-misc 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：142 / 150、根拠なし：8
- 優先レビュー（高）
  1. **C-071〜072 (GCコールバック)**: PerformanceObserverのコールバック動作は内部実装のため直接テストが困難な可能性
  2. **C-086〜088 (traceMemoryUsage環境依存)**: EXPERIMENTAL_DEBUG_MEMORY_USAGEやヒープスナップショット生成はプロセス状態に依存
  3. **C-093〜096 (diagnosticFormatter内部関数)**: getFormattedLinkDiagnosticMessageText, getFormattedLayoutAndPageDiagnosticMessageTextは非exportの内部関数

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/lib/framework/boundary-constants.tsx` - 4つの定数定義
- E-02: `packages/next/src/lib/framework/boundary-components.tsx` - 4つのバウンダリコンポーネント定義
- E-03: `packages/next/src/lib/fs/rename.ts` - renameSync関数（Windows対応リトライロジック含む）
- E-04: `packages/next/src/lib/fs/write-atomic.ts` - writeFileAtomic関数
- E-05: `packages/next/src/lib/helpers/get-cache-directory.ts` - getCacheDirectory関数（プラットフォーム別キャッシュ）
- E-06: `packages/next/src/lib/helpers/get-npx-command.ts` - getNpxCommand関数
- E-07: `packages/next/src/lib/helpers/get-online.ts` - getProxy（内部）, getOnline関数
- E-08: `packages/next/src/lib/helpers/get-pkg-manager.ts` - getPkgManager関数（ロックファイル/user-agent/コマンド検出）
- E-09: `packages/next/src/lib/helpers/get-registry.ts` - getRegistry関数
- E-10: `packages/next/src/lib/helpers/get-reserved-port.ts` - KNOWN_RESERVED_PORTS, isPortIsReserved, getReservedPortExplanation
- E-11: `packages/next/src/lib/helpers/install.ts` - install関数（npm/yarn/pnpm対応）
- E-12: `packages/next/src/lib/memory/gc-observer.ts` - startObservingGc, stopObservingGc, getGcEvents, PerformanceObserverコールバック
- E-13: `packages/next/src/lib/memory/shutdown.ts` - disableMemoryDebuggingMode関数
- E-14: `packages/next/src/lib/memory/startup.ts` - enableMemoryDebuggingMode関数
- E-15: `packages/next/src/lib/memory/trace.ts` - startPeriodicMemoryUsageTracing, stopPeriodicMemoryUsageTracing, getAllMemoryUsageSpans, traceMemoryUsage
- E-16: `packages/next/src/lib/typescript/diagnosticFormatter.ts` - getFormattedDiagnostic（export）, getFormattedLinkDiagnosticMessageText（内部）, getFormattedLayoutAndPageDiagnosticMessageText（内部）
- E-17: `packages/next/src/lib/typescript/getTypeScriptConfiguration.ts` - getTypeScriptConfiguration関数
- E-18: `packages/next/src/lib/typescript/getTypeScriptIntent.ts` - getTypeScriptIntent関数
- E-19: `packages/next/src/lib/typescript/missingDependencyError.ts` - missingDepsError関数
- E-20: `packages/next/src/lib/typescript/type-paths.ts` - getTypeDefinitionGlobPatterns, getDevTypesPath関数
- E-21: `packages/next/src/lib/typescript/writeAppTypeDeclarations.ts` - writeAppTypeDeclarations関数
- E-22: `packages/next/src/lib/typescript/writeConfigurationDefaults.ts` - writeConfigurationDefaults, getRequiredConfiguration（export）, getDesiredCompilerOptions（内部）
- E-23: `packages/next/src/lib/typescript/runTypeCheck.ts` - runTypeCheck, fileMatchesDebugPaths（内部）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001〜004 | boundary-constantsの4定数が正しい値を持つ | E-01 | ○ |
| C-005〜008 | バウンダリコンポーネントがchildrenを返す | E-02 | ○ |
| C-009〜010 | バウンダリコンポーネントの関数名が保持される | E-02 | ○ |
| C-011 | renameSyncでsource===targetの場合にno-op | E-03 (L40-42) | ○ |
| C-012 | 非Windowsでfs.renameSyncが呼ばれる | E-03 (L44-52) | ○ |
| C-013 | WindowsでwindowsRetryTimeout=falseの場合 | E-03 (L44) | ○ |
| C-014 | EACCES/EPERM/EBUSY以外で即throw | E-03 (L65-71) | ○ |
| C-015 | リトライタイムアウト後throw | E-03 (L73-79) | ○ |
| C-016 | 100回リトライ後throw | E-03 (L81-86) | ○ |
| C-017 | ターゲットが非ファイル時中断 | E-03 (L88-101) | ○ |
| C-018 | writeFileAtomicの基本動作 | E-04 (L4-16) | ○ |
| C-019〜020 | writeFileAtomicのエラー時クリーンアップ | E-04 (L9-16) | ○ |
| C-021 | getCacheDirectoryでenvPath指定 | E-05 (L10-11) | ○ |
| C-022〜025 | getCacheDirectoryのプラットフォーム別分岐 | E-05 (L14-22) | ○ |
| C-026 | 相対パスの絶対パス変換 | E-05 (L44-51) | ○ |
| C-027 | WindowsでLOCALAPPDATA未設定時 | E-05 (L21) | ○ |
| C-028〜031 | getNpxCommandの各パッケージマネージャ分岐 | E-06 (L4-17) | ○ |
| C-032〜034 | getProxyの各条件 | E-07 (L4-17) | ○ |
| C-035〜038 | getOnlineのDNS/プロキシ判定 | E-07 (L19-37) | ○ |
| C-039〜046 | getPkgManagerの各検出ロジック | E-08 (L7-36) | ○ |
| C-047〜051 | getRegistryのURL取得・フォーマット | E-09 (L10-43) | ○ |
| C-052〜058 | isPortIsReserved, getReservedPortExplanation | E-10 (L87-96) | ○ |
| C-059〜066 | installの各パッケージマネージャ引数生成 | E-11 (L25-85) | ○ |
| C-067〜070 | GC Observer関数群 | E-12 (L21-36) | ○ |
| C-071〜072 | PerformanceObserverコールバックの閾値判定 | E-12 (L8-15) | △ |
| C-073〜074 | disableMemoryDebuggingModeのレポート出力 | E-13 (L6-28) | ○ |
| C-075〜077 | enableMemoryDebuggingModeの各機能 | E-14 (L7-51) | ○ |
| C-078〜082 | メモリトレースのタイマー・スナップショット | E-15 (L27-45) | ○ |
| C-083〜085 | traceMemoryUsageの記録・トレース | E-15 (L51-76) | ○ |
| C-086〜088 | traceMemoryUsageの環境変数依存・スナップショット | E-15 (L77-124) | △ |
| C-089〜092 | getFormattedDiagnosticのカテゴリ別フォーマット | E-16 (L303-391) | ○ |
| C-093〜096 | getFormattedLinkDiagnosticMessageTextの内部ロジック | E-16 (L4-51) | △ |
| C-097〜101 | getTypeScriptConfigurationの読み込み・パース | E-17 (L8-76) | ○ |
| C-102〜107 | getTypeScriptIntentのtsconfig検出ロジック | E-18 (L7-42) | ○ |
| C-108〜111 | missingDepsErrorのエラーメッセージ生成 | E-19 (L8-47) | ○ |
| C-112〜118 | type-pathsのグロブパターン・devTypesパス | E-20 (L1-48) | ○ |
| C-119〜124 | writeAppTypeDeclarationsの型宣言生成 | E-21 (L5-89) | ○ |
| C-125〜127 | getRequiredConfigurationのenum変換 | E-22 (L129-180) | ○ |
| C-128〜137 | writeConfigurationDefaultsの設定書き込み | E-22 (L185-449) | ○ |
| C-138〜139 | fileMatchesDebugPathsのパスマッチ | E-23 (L32-37) | ○ |
| C-140〜148 | runTypeCheckの実行・フィルタリング | E-23 (L39-230) | ○ |
| C-149〜150 | getDesiredCompilerOptionsのバージョン分岐 | E-22 (L21-127) | △ |

## 4) 不足情報（Unknown / Missing）
- **PerformanceObserverコールバック (C-071〜072)**: コールバックはモジュールスコープで定義されており、直接テストするにはモジュール内部状態のモックが必要。テスト実装時にPerformanceObserverのモック戦略を検討する必要がある。
  - 候補：jest.mock('perf_hooks') / テスト用ラッパー / 統合テストとして実装
- **traceMemoryUsageの環境依存動作 (C-086〜088)**: v8.getHeapStatistics()の返値やv8.writeHeapSnapshot()の動作はNode.jsプロセスの状態に依存。alreadyGeneratedHeapSnapshotのモジュールスコープ変数のリセットも課題。
  - 候補：jest.mock('v8') / 環境変数のセットアップ・ティアダウン
- **diagnosticFormatter内部関数 (C-093〜096)**: getFormattedLinkDiagnosticMessageTextは非export関数。getFormattedDiagnostic経由でテストするか、テスト用にexportを検討する必要がある。
  - 候補：getFormattedDiagnostic経由の間接テスト / テスト専用export
- **getDesiredCompilerOptionsのバージョン分岐 (C-149〜150)**: 非export内部関数。writeConfigurationDefaults経由でテストする必要がある。
  - 候補：writeConfigurationDefaults経由の間接テスト

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: framework/boundary-*, helpers/get-reserved-port (定数・純粋関数で副作用なし)
- **1 (中リスク)**: fs/rename, fs/write-atomic, helpers/install (ファイルシステム・子プロセスの副作用あり、モック必須)
- **1 (中リスク)**: memory/* (v8, perf_hooks, process等のNode.js API依存、モック戦略が重要)
- **1 (中リスク)**: typescript/* (TypeScript APIへの依存が大きく、モック作成が複雑)
- **0 (低リスク)**: helpers/get-pkg-manager, helpers/get-cache-directory, helpers/get-npx-command (ファイル存在チェック・コマンド実行のモックで対応可能)

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースのテストIDが一意であり、UT-LMI-001〜150の連番になっているか
- [ ] 全てのexport関数が網羅されているか（特にrenameSync, writeFileAtomic, getCacheDirectory, getPkgManager, getRegistry, isPortIsReserved, getOnline, install, GC/メモリ関連, TypeScript関連）
- [ ] 正常系・異常系・境界値の3観点が各関数に適切に割り当てられているか
- [ ] 内部関数（非export）のテストケースが間接テスト可能な形で記述されているか
- [ ] Windows固有のリトライロジック（rename.ts）のテストケースが十分か
- [ ] TypeScript API依存部分のモック戦略が実現可能か
- [ ] 優先度の設定が妥当か（金額計算なし、データ整合性・セキュリティ関連は高優先度）
