---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 201
  claims_with_evidence: 195
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：next-src-lib-top 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：195 / 201、根拠なし：6
- 優先レビュー（高）
  1. **C-065〜C-066 (generateInterceptionRoutesRewrites)**: インターセプションルートの実際のパスパターン例はコード内の正規表現から推測しており、具体的なテストフィクスチャの確認が望ましい
  2. **C-143 (stripNextRscUnionQuery)**: NEXT_RSC_UNION_QUERYの実際のキー名はインポート先のapp-router-headersに依存しており、値の確認が必要
  3. **C-191〜C-192 (getNetworkHost)**: 環境依存のためテスト結果が実行環境により異なる可能性がある

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/lib/batcher.ts` - Batcherクラスの実装（create, batch メソッド）
- E-02: `packages/next/src/lib/build-custom-route.ts` - buildCustomRoute関数の実装
- E-03: `packages/next/src/lib/coalesced-function.ts` - withCoalescedInvoke関数の実装
- E-04: `packages/next/src/lib/constants.ts` - 定数定義（SERVER_RUNTIME, WEBPACK_LAYERS等）
- E-05: `packages/next/src/lib/create-client-router-filter.ts` - createClientRouterFilter関数の実装
- E-06: `packages/next/src/lib/detached-promise.ts` - DetachedPromiseクラスの実装
- E-07: `packages/next/src/lib/detect-typo.ts` - detectTypo関数とminDistance関数の実装
- E-08: `packages/next/src/lib/fallback.ts` - FallbackMode enum, parseFallbackField, fallbackModeToFallbackField, parseStaticPathsResult
- E-09: `packages/next/src/lib/file-exists.ts` - fileExists関数, FileType enum
- E-10: `packages/next/src/lib/find-config.ts` - findConfigPath, findConfig関数
- E-11: `packages/next/src/lib/find-pages-dir.ts` - findDir, findPagesDir関数
- E-12: `packages/next/src/lib/find-root.ts` - findRootDirAndLockFiles, warnDuplicatedLockFiles関数
- E-13: `packages/next/src/lib/format-server-error.ts` - formatServerError, getStackWithoutErrorMessage関数
- E-14: `packages/next/src/lib/generate-interception-routes-rewrites.ts` - generateInterceptionRoutesRewrites, isInterceptionRouteRewrite関数
- E-15: `packages/next/src/lib/is-error.ts` - isError, getProperError関数, NextError interface
- E-16: `packages/next/src/lib/is-serializable-props.ts` - isSerializableProps, SerializableError
- E-17: `packages/next/src/lib/is-edge-runtime.ts` - isEdgeRuntime関数
- E-18: `packages/next/src/lib/is-api-route.ts` - isAPIRoute関数
- E-19: `packages/next/src/lib/is-app-page-route.ts` - isAppPageRoute関数
- E-20: `packages/next/src/lib/is-app-route-route.ts` - isAppRouteRoute関数
- E-21: `packages/next/src/lib/is-internal-component.ts` - isInternalComponent, isNonRoutePagesPage関数
- E-22: `packages/next/src/lib/interop-default.ts` - interopDefault関数
- E-23: `packages/next/src/lib/try-to-parse-path.ts` - tryToParsePath関数, ParseResult interface
- E-24: `packages/next/src/lib/redirect-status.ts` - getRedirectStatus, modifyRouteRegex, allowedStatusCodes
- E-25: `packages/next/src/lib/oxford-comma-list.ts` - getOxfordCommaList関数
- E-26: `packages/next/src/lib/non-nullable.ts` - nonNullable関数
- E-27: `packages/next/src/lib/pretty-bytes.ts` - prettyBytes関数
- E-28: `packages/next/src/lib/pick.ts` - pick関数
- E-29: `packages/next/src/lib/wait.ts` - wait関数
- E-30: `packages/next/src/lib/scheduler.ts` - scheduleOnNextTick, scheduleImmediate, atLeastOneTask, waitAtLeastOneReactRenderTask
- E-31: `packages/next/src/lib/url.ts` - isFullStringUrl, parseUrl, parseReqUrl, stripNextRscUnionQuery
- E-32: `packages/next/src/lib/client-and-server-references.ts` - isServerReference, isUseCacheFunction, getUseCacheFunctionInfo, isClientReference
- E-33: `packages/next/src/lib/error-telemetry-utils.ts` - createDigestWithErrorCode, extractNextErrorCode
- E-34: `packages/next/src/lib/route-pattern-normalizer.ts` - hasAdjacentParameterIssues, normalizeAdjacentParameters, normalizeTokensForRegexp, stripNormalizedSeparators, stripParameterSeparators
- E-35: `packages/next/src/lib/resolve-from.ts` - resolveFrom関数
- E-36: `packages/next/src/lib/with-promise-cache.ts` - withPromiseCache関数
- E-37: `packages/next/src/lib/static-env.ts` - getNextPublicEnvironmentVariables, getNextConfigEnv, getStaticEnv, populateStaticEnv, errorIfEnvConflicted
- E-38: `packages/next/src/lib/multi-file-writer.ts` - MultiFileWriterクラス
- E-39: `packages/next/src/lib/needs-experimental-react.ts` - needsExperimentalReact関数
- E-40: `packages/next/src/lib/compile-error.ts` - CompileErrorクラス
- E-41: `packages/next/src/lib/fatal-error.ts` - FatalErrorクラス
- E-42: `packages/next/src/lib/semver-noop.ts` - satisfies関数
- E-43: `packages/next/src/lib/normalize-path.ts` - normalizePath関数
- E-44: `packages/next/src/lib/format-dynamic-import-path.ts` - formatDynamicImportPath関数
- E-45: `packages/next/src/lib/get-network-host.ts` - getNetworkHost関数
- E-46: `packages/next/src/lib/picocolors.ts` - bold, red等のフォーマッタ関数
- E-47: `packages/next/src/lib/get-package-version.ts` - getDependencies, getPackageVersion関数
- E-48: `packages/next/src/lib/has-necessary-dependencies.ts` - hasNecessaryDependencies関数
- E-49: `packages/next/src/lib/mime-type.ts` - imageExtMimeTypeMap定数
- E-50: `packages/next/src/lib/page-types.ts` - PAGE_TYPES enum
- E-51: `packages/next/src/lib/format-cli-help-output.ts` - formatCliHelpOutput関数
- E-52: `packages/next/src/lib/inline-static-env.ts` - inlineStaticEnv関数
- E-53: `packages/next/src/lib/get-project-dir.ts` - getProjectDir関数
- E-54: `packages/next/src/lib/get-files-in-dir.ts` - getFilesInDir関数
- E-55: `packages/next/src/lib/realpath.ts` - realpathSync
- E-56: `packages/next/src/lib/batcher.test.ts` - 既存テスト
- E-57: `packages/next/src/lib/find-config.test.ts` - 既存テスト
- E-58: `packages/next/src/lib/format-server-error.test.ts` - 既存テスト
- E-59: `packages/next/src/lib/worker.test.ts` - 既存テスト
- E-60: `packages/next/src/lib/load-custom-routes.test.ts` - 既存テスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001〜C-007 | Batcherクラスのcreate/batchメソッドのテストケース | E-01, E-56 | ○ |
| C-008〜C-011 | buildCustomRoute関数のテストケース | E-02, E-24 | ○ |
| C-012〜C-015 | withCoalescedInvoke関数のテストケース | E-03 | ○ |
| C-016〜C-019 | createClientRouterFilter関数のテストケース | E-05 | ○ |
| C-020〜C-022 | DetachedPromiseクラスのテストケース | E-06 | ○ |
| C-023〜C-027 | detectTypo関数のテストケース | E-07 | ○ |
| C-028〜C-039 | fallback.ts内関数群のテストケース | E-08 | ○ |
| C-040〜C-045 | fileExists関数のテストケース | E-09 | ○ |
| C-046〜C-049 | findConfig関連関数のテストケース | E-10, E-57 | ○ |
| C-050〜C-055 | findPagesDir関連関数のテストケース | E-11 | ○ |
| C-056〜C-057 | findRootDirAndLockFiles関数のテストケース | E-12 | ○ |
| C-058〜C-064 | formatServerError関連関数のテストケース | E-13, E-58 | ○ |
| C-065〜C-066 | generateInterceptionRoutesRewrites関数のテストケース | E-14 | △ |
| C-067〜C-068 | isInterceptionRouteRewrite関数のテストケース | E-14 | △ |
| C-069〜C-076 | isError/getProperError関数のテストケース | E-15 | ○ |
| C-077〜C-083 | isSerializableProps関数のテストケース | E-16 | ○ |
| C-084〜C-087 | isEdgeRuntime関数のテストケース | E-17, E-04 | ○ |
| C-088〜C-091 | isAPIRoute関数のテストケース | E-18 | ○ |
| C-092〜C-095 | isAppPageRoute/isAppRouteRoute関数のテストケース | E-19, E-20 | ○ |
| C-096〜C-101 | isInternalComponent/isNonRoutePagesPage関数のテストケース | E-21 | ○ |
| C-102〜C-103 | interopDefault関数のテストケース | E-22 | ○ |
| C-104〜C-106 | tryToParsePath関数のテストケース | E-23 | ○ |
| C-107〜C-111 | redirect-status関連関数のテストケース | E-24 | ○ |
| C-112〜C-115 | getOxfordCommaList関数のテストケース | E-25 | ○ |
| C-116〜C-120 | nonNullable関数のテストケース | E-26 | ○ |
| C-121〜C-127 | prettyBytes関数のテストケース | E-27 | ○ |
| C-128〜C-129 | pick関数のテストケース | E-28 | ○ |
| C-130〜C-131 | wait関数のテストケース | E-29 | ○ |
| C-132〜C-135 | scheduler関連関数のテストケース | E-30 | ○ |
| C-136〜C-143 | url.ts関連関数のテストケース | E-31 | ○ |
| C-144〜C-147 | client-and-server-references関連関数のテストケース | E-32 | ○ |
| C-148〜C-153 | error-telemetry-utils関連関数のテストケース | E-33 | ○ |
| C-154〜C-163 | route-pattern-normalizer関連関数のテストケース | E-34 | ○ |
| C-164〜C-167 | resolveFrom関数のテストケース | E-35 | ○ |
| C-168〜C-170 | withPromiseCache関数のテストケース | E-36 | ○ |
| C-171〜C-175 | static-env関連関数のテストケース | E-37 | ○ |
| C-176〜C-178 | MultiFileWriterクラスのテストケース | E-38 | ○ |
| C-179〜C-181 | needsExperimentalReact関数のテストケース | E-39 | ○ |
| C-182〜C-185 | CompileError/FatalErrorクラスのテストケース | E-40, E-41 | ○ |
| C-186 | satisfies関数のテストケース | E-42 | ○ |
| C-187〜C-188 | normalizePath関数のテストケース | E-43 | ○ |
| C-189〜C-190 | formatDynamicImportPath関数のテストケース | E-44 | ○ |
| C-191〜C-192 | getNetworkHost関数のテストケース | E-45 | △ |
| C-193〜C-195 | picocolors関連関数のテストケース | E-46 | ○ |
| C-196〜C-199 | getPackageVersion関連関数のテストケース | E-47 | ○ |
| C-200〜C-201 | hasNecessaryDependencies関数のテストケース | E-48 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-065〜C-068**: `generateInterceptionRoutesRewrites`と`isInterceptionRouteRewrite`の具体的なインターセプションルートパターンは`shared/lib/router/utils/interception-routes.ts`に依存しており、実際のルートパターン例の正確性は外部モジュールの実装に依存する
  - 候補：`packages/next/src/shared/lib/router/utils/interception-routes.ts` / 既存の`generate-interception-routes-rewrites.test.ts`
- **C-143**: `NEXT_RSC_UNION_QUERY`の実際のキー名は`app-router-headers.ts`から取得されるため、テスト入力値の正確性は外部定義に依存
  - 候補：`packages/next/src/client/components/app-router-headers.ts`
- **C-191〜C-192**: ネットワークインターフェースの取得結果は実行環境に依存するため、テスト結果が環境により異なる可能性がある
  - 候補：os.networkInterfaces()のモック化

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースは直接ソースコードから導出されており、ロジックの分岐や戻り値が明確
- 1: 中リスク - インターセプションルート関連（C-065〜C-068）は外部モジュールへの依存が高く、パターン例の正確性を検証する必要がある
- 0: 低リスク - 環境変数やファイルシステムに依存するテスト（C-040〜C-045, C-171〜C-175）はモック化前提のため実装時に注意

## 6) レビュアーチェックリスト（最小）
- [ ] インターセプションルート関連テストケース（C-065〜C-068）の入力パターンが実際のNext.jsルーティング仕様と整合しているか
- [ ] `NEXT_RSC_UNION_QUERY`のキー名がapp-router-headers.tsの定義と一致しているか
- [ ] `errorIfEnvConflicted`の正規表現パターン `/^(?:NODE_.+)|^(?:__.+)$/i` が`NODE_ENV`等の予約キーを正しく検出するテストケースになっているか
- [ ] ファイルシステム依存テスト（fileExists, findDir等）のモック戦略が実装時に適切か
- [ ] `RedirectStatusCode.PermanentRedirect`と`RedirectStatusCode.TemporaryRedirect`の実際の値（308/307）が正しいか確認
- [ ] 既存テストファイル（batcher.test.ts, find-config.test.ts, format-server-error.test.ts等）との重複・整合性を確認
