---
generated_at: 2026-02-03 00:00:00
metrics:
  claims_total: 33
  claims_with_evidence: 30
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：next-src-misc 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：30 / 33、根拠なし：3
- 優先レビュー（高）
  1. **UT-MSC-004（空文字列のinspectアドレス）**：getParsedDebugAddressの内部実装に依存し、空文字列時の挙動が不明
  2. **UT-MSC-015（devコマンドのinspect許可）**：preActionフックの条件分岐からの推測であり、inspectオプション値の実際の挙動要確認
  3. **UT-MSC-016（startコマンドのinspect許可）**：同上、startコマンドでのinspectオプション値の実際の挙動要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/next/src/bin/next.ts` - parseValidInspectAddress関数（L107-121）
- E-02: `packages/next/src/bin/next.ts` - NextRootCommand.createCommand メソッド（L65-105）
- E-03: `packages/next/src/bin/next.ts` - preActionフック内のNODE_ENV検証ロジック（L69-89）
- E-04: `packages/next/src/bin/next.ts` - inspectフラグの非推奨チェック（L91-100）
- E-05: `packages/next/src/diagnostics/build-diagnostics.ts` - recordFrameworkVersion関数（L32-39）
- E-06: `packages/next/src/diagnostics/build-diagnostics.ts` - updateBuildDiagnostics関数（L48-67）
- E-07: `packages/next/src/diagnostics/build-diagnostics.ts` - recordFetchMetrics関数（L72-86）
- E-08: `packages/next/src/diagnostics/build-diagnostics.ts` - updateIncrementalBuildMetrics関数（L101-116）
- E-09: `packages/next/src/diagnostics/build-diagnostics.ts` - getDiagnosticsDir内部関数（L22-27）
- E-10: `packages/next/src/diagnostics/build-diagnostics.ts` - BuildDiagnosticsインターフェース（L13-20）
- E-11: `packages/next/src/diagnostics/build-diagnostics.ts` - IncrementalBuildDiagnosticsインターフェース（L88-96）
- E-12: `packages/next/src/diagnostics/build-diagnostics.test.ts` - 既存のテストケース（L16-67）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | parseValidInspectAddressが有効なhost:port形式をパースする | E-01 | ○ |
| C-02 | parseValidInspectAddressがポート番号のみをパースする | E-01 | ○ |
| C-03 | parseValidInspectAddressが不正アドレスでInvalidArgumentErrorをスローする | E-01 | ○ |
| C-04 | parseValidInspectAddressが空文字列でInvalidArgumentErrorをスローする | E-01 | △ |
| C-05 | devコマンドでNODE_ENVがdevelopmentに設定される | E-02, E-03 | ○ |
| C-06 | buildコマンドでNODE_ENVがproductionに設定される | E-02, E-03 | ○ |
| C-07 | startコマンドでNODE_ENVがproductionに設定される | E-02, E-03 | ○ |
| C-08 | 既存のNODE_ENVが維持される | E-03 | ○ |
| C-09 | NEXT_RUNTIMEがnodejsに設定される | E-02 | ○ |
| C-10 | NODE_ENV=developmentでstart/build時に警告が出る | E-03 | ○ |
| C-11 | NODE_ENV=developmentでbuild時に警告が出る | E-03 | ○ |
| C-12 | NODE_ENV=productionでdev時に警告が出る | E-03 | ○ |
| C-13 | 非標準NODE_ENVで警告が出る | E-03 | ○ |
| C-14 | dev/start以外で--inspectフラグ使用時にエラー終了する | E-04 | ○ |
| C-15 | devコマンドで--inspectが許可される | E-04 | △ |
| C-16 | startコマンドで--inspectが許可される | E-04 | △ |
| C-17 | recordFrameworkVersionがバージョンをJSON形式で記録する | E-05, E-12 | ○ |
| C-18 | diagnosticsディレクトリが自動作成される | E-09 | ○ |
| C-19 | updateBuildDiagnosticsが初回保存する | E-06, E-12 | ○ |
| C-20 | updateBuildDiagnosticsがbuildStageを上書きマージする | E-06, E-12 | ○ |
| C-21 | buildOptionsが既存オプションとマージされる | E-06, E-12 | ○ |
| C-22 | 空diagnosticsで既存データが保持される | E-06 | ○ |
| C-23 | 既存ファイル未存在でもupdateBuildDiagnosticsが動作する | E-06 | ○ |
| C-24 | recordFetchMetricsがfetchMetrics付きパスを記録する | E-07 | ○ |
| C-25 | fetchMetrics未設定のパスがスキップされる | E-07 | ○ |
| C-26 | 空Mapで空オブジェクトが記録される | E-07 | ○ |
| C-27 | 複数パスのfetchMetricsが全て記録される | E-07 | ○ |
| C-28 | updateIncrementalBuildMetricsが初回保存する | E-08 | ○ |
| C-29 | updateIncrementalBuildMetricsが既存データとマージする | E-08 | ○ |
| C-30 | 同一キーが上書きされる | E-08 | ○ |
| C-31 | 空diagnosticsで既存データが保持される（incremental） | E-08 | ○ |
| C-32 | 既存ファイル未存在でもupdateIncrementalBuildMetricsが動作する | E-08 | ○ |
| C-33 | changedDependenciesが記録される | E-08, E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-04: `getParsedDebugAddress`（`../server/lib/utils`からインポート）の内部実装が未確認のため、空文字列入力時にportがNaNになるかどうかの確証がない
  - 候補：`packages/next/src/server/lib/utils.ts` のgetParsedDebugAddress実装を確認
- C-15, C-16: preActionフックの条件分岐（`commandName !== 'dev' && commandName !== 'start'`）からの論理的推論だが、inspectオプション値がgetOptionValueで取得される際の実際の値（`true`かどうか）が文脈依存
  - 候補：Commanderライブラリのオプション値取得の挙動を確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - diagnostics系関数のテストケースは既存テストコード（E-12）と整合しており信頼性が高い
- 1: 中リスク - bin/next.tsのpreActionフック関連テストケースはCommanderライブラリの挙動に依存するため、モック設計の検討が必要
- 0: 低リスク - parseValidInspectAddressのテストケースはコード構造から直接導出されており信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] getParsedDebugAddress関数の内部実装を確認し、空文字列入力時のportの値を検証する
- [ ] CommanderライブラリのgetOptionValue('inspect')がオプション未指定時にfalseを返すことを確認する
- [ ] recordFetchMetricsのexportResult.byPathがMap型であることの前提条件が適切かを確認する
- [ ] 既存テスト（build-diagnostics.test.ts）でカバーされているケースとの重複・差分を確認する
- [ ] bin/next.tsのトップレベルコード（semverチェック、依存モジュール確認）のテスト対象外判断が妥当か確認する
