---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 122
  claims_with_evidence: 118
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：next-src-next-devtools-dev-overlay 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：118 / 122、根拠なし：4
- 優先レビュー（高）
  1. **saveDevToolsConfig バリデーションエラーケース (UT-DOV-024)**：devToolsConfigSchema の実際のバリデーションルールがインポート先にあるため、具体的な不正値が要確認
  2. **body-locker スクロールバーギャップ補正 (UT-DOV-116)**：window.innerWidth と clientWidth の差分計算はブラウザ環境依存であり、JSDOM等での再現性要確認
  3. **useMinimumLoadingTimeMultiple の動作 (hooks)**：React Hook テストはrenderHookでの検証が必要であり、タイミングテストの安定性要確認
  4. **ShadowRoot内アクティブ要素取得 (UT-DOV-104)**：ShadowDOMの検証環境が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/next-devtools/dev-overlay/utils/css.ts` - css関数のソースコード
- E-02: `packages/next/src/next-devtools/dev-overlay/utils/cx.ts` - cx関数のソースコード
- E-03: `packages/next/src/next-devtools/dev-overlay/utils/parse-url-from-text.ts` - parseUrlFromText関数のソースコード
- E-04: `packages/next/src/next-devtools/dev-overlay/utils/get-error-by-type.ts` - getErrorByType, useFrames, createMemoizedPromiseのソースコード
- E-05: `packages/next/src/next-devtools/dev-overlay/utils/indicator-metrics.ts` - getIndicatorOffset関数のソースコード
- E-06: `packages/next/src/next-devtools/dev-overlay/utils/save-devtools-config.ts` - saveDevToolsConfig, flushPatchのソースコード
- E-07: `packages/next/src/next-devtools/dev-overlay/segment-explorer-trie.ts` - createTrie, createSegmentTreeStoreのソースコード
- E-08: `packages/next/src/next-devtools/dev-overlay/components/code-frame/parse-code-frame.ts` - formatCodeFrame, groupCodeFrameLines, parseLineNumberFromCodeFrameLineのソースコード
- E-09: `packages/next/src/next-devtools/dev-overlay/shared.ts` - useErrorOverlayReducer, getInitialState, INITIAL_OVERLAY_STATE, pushErrorFilterDuplicates, getStackIgnoringStrictModeのソースコード
- E-10: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` - getErrorTypeLabel, matchLinkType, getBlockingRouteErrorDetails, useErrorDetailsのソースコード
- E-11: `packages/next/src/next-devtools/dev-overlay/components/errors/dev-tools-indicator/draggable.tsx` - calculateVelocity, project関数のソースコード
- E-12: `packages/next/src/next-devtools/dev-overlay/components/errors/dev-tools-indicator/utils.ts` - useFocusTrap, getActiveElement, getFocusableNodesのソースコード
- E-13: `packages/next/src/next-devtools/dev-overlay/hooks/use-shortcuts.ts` - useShortcuts, isFocusedOnElementのソースコード
- E-14: `packages/next/src/next-devtools/dev-overlay/components/overlay/body-locker.ts` - lock, unlock関数のソースコード
- E-15: `packages/next/src/next-devtools/dev-overlay/hooks/use-delayed-render.ts` - useDelayedRender hookのソースコード
- E-16: `packages/next/src/next-devtools/dev-overlay/hooks/use-on-click-outside.ts` - useOnClickOutside hookのソースコード
- E-17: `packages/next/src/next-devtools/dev-overlay/hooks/use-active-runtime-error.ts` - useActiveRuntimeError hookのソースコード
- E-18: `packages/next/src/next-devtools/dev-overlay/utils/css.test.ts` - 既存のcssテストファイル
- E-19: `packages/next/src/next-devtools/dev-overlay/utils/cx.test.ts` - 既存のcxテストファイル
- E-20: `packages/next/src/next-devtools/dev-overlay/utils/parse-url-from-text.test.ts` - 既存のparseUrlFromTextテストファイル
- E-21: `packages/next/src/next-devtools/dev-overlay/components/code-frame/parse-code-frame.test.ts` - 既存のparse-code-frameテストファイル
- E-22: `packages/next/src/next-devtools/dev-overlay/segment-explorer-trie.test.tsx` - 既存のtrie テストファイル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | css関数がテンプレートリテラルからCSSをミニファイする (UT-DOV-001~006) | E-01, E-18 | ○ |
| C-02 | cx関数が複数クラス名を結合しfalsyを除外する (UT-DOV-007~011) | E-02, E-19 | ○ |
| C-03 | parseUrlFromTextがテキストからURLを抽出する (UT-DOV-012~017) | E-03, E-20 | ○ |
| C-04 | createMemoizedPromiseがPromiseをキャッシュする (UT-DOV-018) | E-04 | ○ |
| C-05 | getErrorByTypeがSupportedErrorEventをReadyRuntimeErrorに変換する (UT-DOV-019) | E-04 | ○ |
| C-06 | useFramesがnull入力で空配列を返す (UT-DOV-020) | E-04 | ○ |
| C-07 | getIndicatorOffsetがscale基準でオフセットを計算する (UT-DOV-021~022) | E-05 | ○ |
| C-08 | saveDevToolsConfigが有効パッチを保存する (UT-DOV-023) | E-06 | ○ |
| C-09 | saveDevToolsConfigが無効パッチを拒否する (UT-DOV-024) | E-06 | △ |
| C-10 | saveDevToolsConfigがdeepMergeで統合しデバウンスする (UT-DOV-025~026) | E-06 | ○ |
| C-11 | createTrieのinsert/remove/getRoot基本動作 (UT-DOV-027~038) | E-07, E-22 | ○ |
| C-12 | formatCodeFrame/groupCodeFrameLines/parseLineNumberFromCodeFrameLine (UT-DOV-039~046) | E-08, E-21 | ○ |
| C-13 | useErrorOverlayReducerの全アクション処理 (UT-DOV-047~075) | E-09 | ○ |
| C-14 | getInitialStateのrouter種別別初期値 (UT-DOV-076~077) | E-09 | ○ |
| C-15 | getStackIgnoringStrictModeのスタック処理 (UT-DOV-078~079) | E-09 | ○ |
| C-16 | pushErrorFilterDuplicatesの重複フィルタ (UT-DOV-080~083) | E-09 | ○ |
| C-17 | getErrorTypeLabelのエラータイプ別ラベル生成 (UT-DOV-084~088) | E-10 | ○ |
| C-18 | matchLinkTypeのリンク種別判定 (UT-DOV-089~092) | E-10 | ○ |
| C-19 | getBlockingRouteErrorDetailsのエラー分類 (UT-DOV-093~097) | E-10 | ○ |
| C-20 | calculateVelocity/project関数の物理計算 (UT-DOV-098~103) | E-11 | ○ |
| C-21 | getActiveElementのShadowRoot対応 (UT-DOV-104~106) | E-12 | △ |
| C-22 | getFocusableNodesのフォーカス可能要素取得 (UT-DOV-107~108) | E-12 | ○ |
| C-23 | isFocusedOnElementの要素種別判定 (UT-DOV-109~114) | E-13 | ○ |
| C-24 | body-lockerのlock/unlock動作 (UT-DOV-115~120) | E-14 | △ |
| C-25 | INITIAL_OVERLAY_STATE/NEXT_DEV_TOOLS_SCALEの定数値 (UT-DOV-121~122) | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- **devToolsConfigSchema の詳細バリデーションルール (C-09)**: `devToolsConfigSchema` は `../../shared/devtools-config-schema` からインポートされており、本モジュール外のため具体的なバリデーションルールを直接確認していない。
  - 候補：`packages/next/src/next-devtools/shared/devtools-config-schema.ts` を確認し、具体的な不正入力値を特定する
- **ShadowDOM環境でのgetActiveElement動作 (C-21)**: ShadowRoot APIを使用しており、テスト環境（JSDOM等）での再現性が未確認
  - 候補：ShadowDOMのpolyfillまたはブラウザテストでの検証
- **body-lockerのブラウザ依存動作 (C-24)**: window.innerWidth, document.documentElement.clientWidth等のブラウザAPI依存。JSDOMでのスクロールバー幅シミュレーションは制限がある
  - 候補：E2Eテストでの検証、またはwindowオブジェクトのモック
- **React Hooksのテスト環境**: useDelayedRender, useMinimumLoadingTimeMultiple等のHookはrenderHookを使用した間接テストが必要。本CSV内ではHook自体のテストケースを一部省略している（UIコンポーネントテストとして実施すべき項目）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - css, cx, parseUrlFromText等の純粋関数テスト。入力・出力が明確でソースコードから完全に検証可能
- 0: 低リスク - createTrie, formatCodeFrame等の関数テスト。既存テストファイル（E-18~E-22）が存在し、テスト観点の妥当性を確認可能
- 0: 低リスク - useErrorOverlayReducerのアクション処理テスト。reducerは純粋関数であり、全アクションタイプをソースコードから網羅的に列挙
- 1: 中リスク - saveDevToolsConfigのバリデーション。外部スキーマ依存のため具体的な不正値の特定が不完全
- 1: 中リスク - body-locker, ShadowDOM関連テスト。ブラウザAPI依存のためテスト環境での再現性に注意
- 0: 低リスク - calculateVelocity, project等の数値計算テスト。数学的に検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] saveDevToolsConfig (UT-DOV-024) のバリデーションエラーケースで使用する不正入力値が実際のスキーマと整合しているか確認
- [ ] body-locker (UT-DOV-115~120) のテストが選択したテスト環境（JSDOM等）で実行可能か確認
- [ ] ShadowRoot関連テスト (UT-DOV-104~106) のモック方法が適切か確認
- [ ] useErrorOverlayReducer (UT-DOV-047~075) のテストケースが全てのアクションタイプを網羅しているか確認
- [ ] getBlockingRouteErrorDetails (UT-DOV-093~097) のエラーメッセージパターンが最新のNext.jsエラーメッセージと一致しているか確認
- [ ] React Hookテスト（useFrames等）のテスト方法がプロジェクトのテスト方針と一致しているか確認
