---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 173
  claims_with_evidence: 168
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：next-src-next-devtools-misc 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：168 / 173、根拠なし：5
- 優先レビュー（高）
  1. **C-066 (ignoreListAnonymousStackFramesIfSandwiched)**: 関数本体は外部モジュールへの委譲のみでありテスト観点の詳細が外部依存
  2. **C-108 (getAttachNodejsDebuggerMiddleware)**: Node.js inspector APIのモック方法が環境依存
  3. **C-168 (patchConsoleError)**: ブラウザ環境依存のwindow.console.errorパッチでテスト環境構築に注意が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/next-devtools/shared/deepmerge.ts` - deepMerge関数の実装
- E-02: `packages/next/src/next-devtools/shared/version-staleness.ts` - getStaleness関数の実装
- E-03: `packages/next/src/next-devtools/shared/webpack-module-path.ts` - isWebpackInternalResource/formatStackFrameFile関数の実装
- E-04: `packages/next/src/next-devtools/shared/console-error.ts` - createConsoleError/isConsoleError関数の実装
- E-05: `packages/next/src/next-devtools/shared/react-19-hydration-error.ts` - React 19ハイドレーションエラー関連関数の実装
- E-06: `packages/next/src/next-devtools/shared/react-18-hydration-error.ts` - React 18ハイドレーションエラー関連関数の実装
- E-07: `packages/next/src/next-devtools/shared/forward-logs-shared.ts` - patchConsoleMethod関数の実装
- E-08: `packages/next/src/next-devtools/server/middleware-response.ts` - middlewareResponseオブジェクトの実装
- E-09: `packages/next/src/next-devtools/server/shared.ts` - ignoreListAnonymousStackFramesIfSandwiched/getOriginalCodeFrame関数の実装
- E-10: `packages/next/src/next-devtools/server/launch-editor.ts` - launchEditor/openFileInEditor/escapeApplescriptStringFragment関数の実装
- E-11: `packages/next/src/next-devtools/server/get-next-error-feedback-middleware.ts` - getNextErrorFeedbackMiddleware関数の実装
- E-12: `packages/next/src/next-devtools/server/dev-indicator-middleware.ts` - getDisableDevIndicatorMiddleware関数の実装
- E-13: `packages/next/src/next-devtools/server/restart-dev-server-middleware.ts` - getRestartDevServerMiddleware関数の実装
- E-14: `packages/next/src/next-devtools/server/devtools-config-middleware.ts` - devToolsConfigMiddleware/getDevToolsConfig関数の実装
- E-15: `packages/next/src/next-devtools/server/font/get-dev-overlay-font-middleware.ts` - getDevOverlayFontMiddleware関数の実装
- E-16: `packages/next/src/next-devtools/server/attach-nodejs-debugger-middleware.ts` - getAttachNodejsDebuggerMiddleware関数の実装
- E-17: `packages/next/src/next-devtools/shared/devtools-config-schema.ts` - devToolsConfigSchemaの定義
- E-18: `packages/next/src/next-devtools/shared/stack-frame.ts` - getStackFrameFile/getOriginalStackFrames関数の実装
- E-19: `packages/next/src/next-devtools/dev-overlay.shim.ts` - shim関数の実装
- E-20: `packages/next/src/next-devtools/dev-overlay.browser.tsx` - getSerializedOverlayState/getSegmentTrieData/dispatcher関数の実装
- E-21: `packages/next/src/next-devtools/userspace/app/forward-logs-utils.ts` - preLogSerializationClone/logStringify関数の実装
- E-22: `packages/next/src/next-devtools/userspace/app/terminal-logging-config.ts` - getTerminalLoggingConfig/getIsTerminalLoggingEnabled関数の実装
- E-23: `packages/next/src/next-devtools/userspace/app/errors/stitched-error.ts` - coerceError/getOwnerStack/setOwnerStack/decorateDevError関数の実装
- E-24: `packages/next/src/next-devtools/userspace/pages/hydration-error-state.ts` - getSquashedHydrationErrorDetails/attachHydrationErrorState/storeHydrationErrorStateFromConsoleArgs関数の実装
- E-25: `packages/next/src/next-devtools/userspace/app/errors/use-error-handler.ts` - handleConsoleError/handleClientError/handleGlobalErrors関数の実装
- E-26: `packages/next/src/next-devtools/userspace/app/errors/intercept-console-error.ts` - patchConsoleError関数の実装
- E-27: `packages/next/src/next-devtools/userspace/app/forward-logs.ts` - logUnhandledRejection/forwardUnhandledError/forwardErrorLog/initializeDebugLogForwarding関数の実装
- E-28: `packages/next/src/next-devtools/shared/hydration-error.ts` - HydrationErrorState型定義
- E-29: `packages/next/src/next-devtools/shared/types.ts` - DebugInfo型定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001〜C-008 | deepMerge関数の正常系・異常系・境界値テスト | E-01 | ○ |
| C-009〜C-015 | getStaleness関数の各stalenessステータステスト | E-02 | ○ |
| C-016〜C-023 | isWebpackInternalResource/formatStackFrameFile関数のテスト | E-03 | ○ |
| C-024〜C-031 | createConsoleError/isConsoleError関数のテスト | E-04 | ○ |
| C-032〜C-041 | React 19ハイドレーションエラー関連テスト | E-05 | ○ |
| C-042〜C-052 | React 18ハイドレーションエラー関連テスト | E-06 | ○ |
| C-053〜C-056 | patchConsoleMethod関数のテスト | E-07 | ○ |
| C-057〜C-065 | middlewareResponseオブジェクトの各メソッドテスト | E-08 | ○ |
| C-066〜C-067 | ignoreListAnonymousStackFramesIfSandwiched関数のテスト | E-09 | △ |
| C-068〜C-070 | getOriginalCodeFrame関数のテスト | E-09 | ○ |
| C-071〜C-083 | launchEditor/openFileInEditor/escapeApplescriptStringFragment関数のテスト | E-10 | ○ |
| C-084〜C-088 | getNextErrorFeedbackMiddleware関数のテスト | E-11 | ○ |
| C-089〜C-091 | getDisableDevIndicatorMiddleware関数のテスト | E-12 | ○ |
| C-092〜C-096 | getRestartDevServerMiddleware関数のテスト | E-13 | ○ |
| C-097〜C-103 | devToolsConfigMiddleware/getDevToolsConfig関数のテスト | E-14 | ○ |
| C-104〜C-107 | getDevOverlayFontMiddleware関数のテスト | E-15 | ○ |
| C-108〜C-110 | getAttachNodejsDebuggerMiddleware関数のテスト | E-16 | △ |
| C-111〜C-115 | devToolsConfigSchema Zodスキーマのテスト | E-17 | ○ |
| C-116〜C-126 | getStackFrameFile/getOriginalStackFrames関数のテスト | E-18 | ○ |
| C-127〜C-129 | shim関数のテスト | E-19 | ○ |
| C-130〜C-131 | getSerializedOverlayState/getSegmentTrieData関数のテスト | E-20 | ○ |
| C-132〜C-141 | preLogSerializationClone/logStringify関数のテスト | E-21 | ○ |
| C-142〜C-147 | getTerminalLoggingConfig/getIsTerminalLoggingEnabled関数のテスト | E-22 | ○ |
| C-148〜C-157 | coerceError/getOwnerStack/setOwnerStack/decorateDevError関数のテスト | E-23 | ○ |
| C-158〜C-164 | hydration-error-state関連関数のテスト | E-24 | ○ |
| C-165〜C-167 | handleConsoleError/handleClientError関数のテスト | E-25 | ○ |
| C-168 | patchConsoleError関数のテスト | E-26 | △ |
| C-169〜C-173 | logUnhandledRejection/forwardUnhandledError/forwardErrorLog関数のテスト | E-27 | △ |

## 4) 不足情報（Unknown / Missing）
- **ignoreListAnonymousStackFramesIfSandwiched (C-066〜C-067)**: この関数は外部の `ignoreListAnonymousStackFramesIfSandwichedGeneric` に委譲しており、具体的な内部動作は `../../server/lib/source-maps` に依存する。テスト詳細の正確性は委譲先の動作仕様に依る。
  - 候補: `packages/next/src/server/lib/source-maps.ts` のテスト / ドキュメント
- **getAttachNodejsDebuggerMiddleware (C-108〜C-110)**: Node.js `inspector` モジュールのモック方法が環境依存であり、CI環境での再現性に注意が必要。
  - 候補: Node.js inspectorモジュールのモック例 / JestのモジュールモックAPIドキュメント
- **patchConsoleError (C-168)**: ブラウザ環境の `window.console.error` を直接操作するため、テスト環境（jsdom等）のセットアップが必要。
  - 候補: jsdom環境設定 / テスト環境構成ドキュメント
- **forward-logs系 (C-169〜C-173)**: WebSocket接続やタイマー系処理を含むため、モック戦略の設計が必要。
  - 候補: WebSocketモック / jest.useFakeTimersによるタイマーモック

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: deepMerge、getStaleness、webpack-module-path、console-error、devtools-config-schema、version-staleness等の純粋関数テスト - ソースコードから直接テストケースを導出可能
- **0 (低リスク)**: middleware-response - シンプルなHTTP応答ユーティリティで動作が明確
- **1 (中リスク)**: launch-editor - OS固有の動作（macOS/Linux/Windows分岐）があるためプラットフォーム依存テストが必要
- **1 (中リスク)**: hydration-error関連 - React 18/19の両方のエラーフォーマットに依存しており、Reactバージョンアップ時に変更の可能性あり
- **1 (中リスク)**: forward-logs系 - WebSocket通信やタイマー処理を含むため非同期テスト設計が必要
- **1 (中リスク)**: attach-nodejs-debugger-middleware - Node.js inspectorのモックが必要

## 6) レビュアーチェックリスト（最小）
- [ ] deepMerge関数のテストケースが全分岐（オブジェクト/配列/null/undefined）をカバーしているか
- [ ] ハイドレーションエラー関連テストがReact 18/19両方のパターンを網羅しているか
- [ ] middlewareResponse各メソッドのHTTPステータスコードが正しいか
- [ ] launchEditor関数のセキュリティチェック（Windows RCE対策）がテストに含まれているか
- [ ] devToolsConfigMiddlewareのZodスキーマバリデーションが全フィールドをカバーしているか
- [ ] forward-logs系テストで非同期処理（WebSocket/タイマー）のモック戦略が適切か
- [ ] getOriginalStackFrames関数のfetch成功/失敗両方のパスがテストされているか
- [ ] React Reactサーバーリプレイログのスキップ判定ロジックが正しくテストされているか
