---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 106
  claims_with_evidence: 103
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：next-src-pages 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：103 / 106、根拠なし：3
- 優先レビュー（高）
  1. **C-078（クライアントサイドhostname取得）**：window環境のモックが必要であり、実行環境依存の挙動
  2. **C-079（サーバーサイドhostname取得）**：getRequestMetaの内部実装に依存しており、外部モジュールのモックが必要
  3. **C-096（Partytownスクリプト生成）**：`@builder.io/partytown`外部モジュールの存在が前提であり、テスト環境でのモック設定が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/pages/_app.tsx` - Appコンポーネントの定義（47行）
- E-02: `packages/next/src/pages/_document.tsx` - Documentコンポーネントの定義（1001行）
- E-03: `packages/next/src/pages/_error.tsx` - Errorコンポーネントの定義（157行）
- E-04: `packages/next/src/shared/lib/utils.ts` - loadGetInitialProps関数（型定義の参照元）
- E-05: `packages/next/src/server/get-page-files.ts` - getPageFiles関数（getDocumentFilesの依存先）
- E-06: `packages/next/src/server/htmlescape.ts` - htmlEscapeJsonString関数（getInlineScriptSourceの依存先）
- E-07: `packages/next/src/shared/lib/html-context.shared-runtime.ts` - HtmlContext定義
- E-08: `packages/next/src/shared/lib/encode-uri-path.ts` - encodeURIPath関数
- E-09: `packages/next/src/lib/is-error.ts` - isError関数
- E-10: `packages/next/src/server/request-meta.ts` - getRequestMeta関数（_error.tsxの依存先）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | appGetInitialPropsがloadGetInitialPropsを呼びpagePropsを返す | E-01 (L26-32), E-04 | ○ |
| C-002 | getInitialProps未定義時に空オブジェクトが返る | E-01 (L30), E-04 | ○ |
| C-003 | loadGetInitialPropsの例外が伝播する | E-01 (L30) | ○ |
| C-004 | App.renderがComponentをpagePropsで描画する | E-01 (L41-45) | ○ |
| C-005 | 空pagePropsでComponentが描画される | E-01 (L41-45) | ○ |
| C-006 | origGetInitialPropsの静的プロパティ | E-01 (L38) | ○ |
| C-007 | getInitialPropsの静的プロパティ | E-01 (L39) | ○ |
| C-008 | getDocumentFilesがsharedFiles/pageFiles/allFilesを返す | E-02 (L54-66) | ○ |
| C-009 | allFilesで重複が除去される | E-02 (L64) | ○ |
| C-010 | 空ページファイルのケース | E-02 (L58-66) | ○ |
| C-011 | polyfillScriptsの.jsフィルタリング | E-02 (L79-81) | ○ |
| C-012 | .module.jsの除外 | E-02 (L81) | ○ |
| C-013 | 空polyfillFiles | E-02 (L79) | ○ |
| C-014 | disableOptimizedLoadingとdefer属性 | E-02 (L86) | ○ |
| C-015 | hasComponentPropsのtrue判定 | E-02 (L97-98) | ○ |
| C-016 | hasComponentPropsのnull判定 | E-02 (L98) | ○ |
| C-017 | hasComponentPropsのundefined判定 | E-02 (L98) | ○ |
| C-018 | hasComponentPropsのpropsなし判定 | E-02 (L98) | ○ |
| C-019 | getDynamicChunksの.jsフィルタリング | E-02 (L116) | ○ |
| C-020 | getDynamicChunksの重複排除 | E-02 (L116) | ○ |
| C-021 | 空dynamicImports | E-02 (L115) | ○ |
| C-022 | getScriptsのスクリプト結合 | E-02 (L145-150) | ○ |
| C-023 | getScriptsの非JSフィルタ | E-02 (L145) | ○ |
| C-024 | getHeadHTMLPropsのcrossOrigin/nonce除去 | E-02 (L300-309) | ○ |
| C-025 | getHeadHTMLPropsの透過 | E-02 (L300-309) | ○ |
| C-026 | getNextFontLinkTagsのpreload生成 | E-02 (L311-364) | ○ |
| C-027 | フォント結合と重複除去 | E-02 (L326-328) | ○ |
| C-028 | nextFontManifest undefined時のフォールバック | E-02 (L316-320) | ○ |
| C-029 | preconnect生成条件 | E-02 (L331-334) | ○ |
| C-030 | pagesUsingSizeAdjustフラグ | E-02 (L340-341) | ○ |
| C-031 | assetPrefixの反映 | E-02 (L314, L354) | ○ |
| C-032 | Head.getCssLinksのCSS link生成 | E-02 (L377-445) | ○ |
| C-033 | optimizeCss falseでpreload生成 | E-02 (L410-423) | ○ |
| C-034 | optimizeCss trueでpreload省略 | E-02 (L410) | ○ |
| C-035 | CSSファイルなし時null返却 | E-02 (L444) | ○ |
| C-036 | 動的CSSの追加 | E-02 (L392-402) | ○ |
| C-037 | getPreloadDynamicChunksの.jsフィルタ | E-02 (L447-474) | ○ |
| C-038 | getPreloadDynamicChunksの非JS除外 | E-02 (L454) | ○ |
| C-039 | getPreloadMainLinksの生成 | E-02 (L476-507) | ○ |
| C-040 | getBeforeInteractiveInlineScriptsのdangerouslySetInnerHTML | E-02 (L509-555) | ○ |
| C-041 | children文字列のインラインスクリプト | E-02 (L532-534) | ○ |
| C-042 | children配列の結合 | E-02 (L535-537) | ○ |
| C-043 | srcありスクリプトの除外 | E-02 (L514-516) | ○ |
| C-044 | Head.renderの基本レンダリング | E-02 (L573-732) | ○ |
| C-045 | unstable_runtimeJS false時のスクリプト除外 | E-02 (L587, L697-716) | ○ |
| C-046 | isDevelopment時のFOUC防止 | E-02 (L669-685) | ○ |
| C-047 | CSS preloadの優先配置 | E-02 (L596-614) | ○ |
| C-048 | data-next-head属性の付与 | E-02 (L608) | ○ |
| C-049 | handleDocumentScriptLoaderItemsのbeforeInteractive登録 | E-02 (L766-774) | ○ |
| C-050 | afterInteractiveスクリプトの__NEXT_DATA__登録 | E-02 (L775-780) | ○ |
| C-051 | strategy未定義時のデフォルト | E-02 (L782-784) | ○ |
| C-052 | lazyOnloadスクリプト登録 | E-02 (L776) | ○ |
| C-053 | workerスクリプト登録 | E-02 (L776) | ○ |
| C-054 | children未定義の早期リターン | E-02 (L740) | ○ |
| C-055 | HeadとBody両方のスクリプト処理 | E-02 (L748-759) | ○ |
| C-056 | getInlineScriptSourceのHTMLエスケープ | E-02 (L813-848), E-06 | ○ |
| C-057 | 循環参照エラーハンドリング | E-02 (L849-855) | ○ |
| C-058 | 大量データ警告 | E-02 (L830-844) | ○ |
| C-059 | 重複警告の抑制 | E-02 (L818-819, L833) | ○ |
| C-060 | NextScript.renderの__NEXT_DATA__スクリプト | E-02 (L859-922) | ○ |
| C-061 | disableRuntimeJS true時のスクリプト除外 | E-02 (L869, L899) | ○ |
| C-062 | disableOptimizedLoading時のスクリプト出力 | E-02 (L910-919) | ○ |
| C-063 | devFilesの出力 | E-02 (L887-898) | ○ |
| C-064 | Html localeのlang設定 | E-02 (L925-949) | ○ |
| C-065 | props.langの優先 | E-02 (L945) | ○ |
| C-066 | deploymentIdのdata-dpl-id | E-02 (L946) | ○ |
| C-067 | lang未設定時undefined | E-02 (L945) | ○ |
| C-068 | Html.docComponentsRendered.Html設定 | E-02 (L939) | ○ |
| C-069 | Mainのレンダリング | E-02 (L951-956) | ○ |
| C-070 | Main.docComponentsRendered.Main設定 | E-02 (L953) | ○ |
| C-071 | Document.getInitialProps | E-02 (L969-971) | ○ |
| C-072 | Document.renderの構造 | E-02 (L973-983) | ○ |
| C-073 | nonce属性の伝播 | E-02 (L976, L979) | ○ |
| C-074 | res.statusCode取得 | E-03 (L24-25) | ○ |
| C-075 | err.statusCode取得 | E-03 (L25) | ○ |
| C-076 | デフォルト404 | E-03 (L25) | ○ |
| C-077 | res.statusCodeの優先 | E-03 (L24-25) | ○ |
| C-078 | クライアントサイドhostname | E-03 (L29-30) | △ |
| C-079 | サーバーサイドhostname | E-03 (L31-39), E-10 | △ |
| C-080 | falsy statusCode | E-03 (L24-25) | ○ |
| C-081 | statusCode表示 | E-03 (L131-135) | ○ |
| C-082 | 404メッセージ | E-03 (L5-9, L91) | ○ |
| C-083 | 500メッセージ | E-03 (L5-9, L91) | ○ |
| C-084 | 400メッセージ | E-03 (L5-9, L91) | ○ |
| C-085 | 405メッセージ | E-03 (L5-9, L91) | ○ |
| C-086 | カスタムタイトル | E-03 (L89-90) | ○ |
| C-087 | 未知statusCodeのフォールバック | E-03 (L91-92) | ○ |
| C-088 | クライアントサイドエラー表示 | E-03 (L98-100, L141-148) | ○ |
| C-089 | hostname表示 | E-03 (L143-145) | ○ |
| C-090 | ダークモードCSS | E-03 (L88, L123-127) | ○ |
| C-091 | ダークモード無効 | E-03 (L88, L124-126) | ○ |
| C-092 | title要素の内容 | E-03 (L97-101) | ○ |
| C-093 | クライアントエラーのtitle | E-03 (L99-100) | ○ |
| C-094 | displayName | E-03 (L82) | ○ |
| C-095 | origGetInitialProps | E-03 (L85) | ○ |
| C-096 | Partytownスクリプト生成 | E-02 (L164-269) | △ |
| C-097 | Partytown無効時 | E-02 (L168) | ○ |
| C-098 | ユーザー定義partytown設定 | E-02 (L181-186) | ○ |
| C-099 | MODULE_NOT_FOUND時のnull返却 | E-02 (L263-268) | ○ |
| C-100 | 非MODULE_NOT_FOUNDエラー処理 | E-02 (L264-266) | ○ |
| C-101 | workerスクリプトsrc | E-02 (L222-224) | ○ |
| C-102 | workerインラインスクリプト | E-02 (L225-231) | ○ |
| C-103 | workerスクリプトchildren変換 | E-02 (L232-240) | ○ |
| C-104 | 無効スクリプト検出 | E-02 (L243-246) | ○ |
| C-105 | beforeInteractiveスクリプトレンダリング | E-02 (L271-298) | ○ |
| C-106 | srcなしスクリプトの除外 | E-02 (L277) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-078: クライアントサイド（window環境）でのhostname取得テストは、`window`オブジェクトのモック設定が必要。実際のブラウザ環境での挙動はE2Eテストで補完すべき。
  - 候補：jsdom環境でのテスト / E2Eテスト / window.locationのモック
- C-079: サーバーサイドでの`getRequestMeta`呼び出しは外部モジュール（`../server/request-meta`）に依存。モジュールのモック設定と`initURL`メタデータの構造確認が必要。
  - 候補：request-metaモジュールのモック / IncomingMessageのモック / サーバー環境テスト
- C-096: Partytownスクリプト生成は`@builder.io/partytown`外部パッケージの`__non_webpack_require__`に依存。テスト環境でのモジュール読み込みの模擬が必要。
  - 候補：jest.mockによるモジュールモック / テスト用パッケージインストール

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 型エクスポートや静的プロパティのテスト（C-006, C-007, C-094, C-095）は自明であり、テスト価値は低い
- 1: 中リスク - Reactコンポーネントのレンダリングテスト（C-044, C-060, C-072）はテスト環境のセットアップ（HtmlContext Providerなど）に注意が必要
- 1: 中リスク - `getInlineScriptSource`の循環参照テスト（C-057）はJSON.stringifyのエラー挙動に依存
- 2: 高リスク - `getPreNextWorkerScripts`のPartytown関連テスト（C-096〜C-104）は外部モジュール依存が高く、モック戦略の検討が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの入力値と期待結果がソースコードのロジックと一致しているか
- [ ] 正常系・異常系・境界値の各観点が網羅されているか
- [ ] `_error.tsx`の`_getInitialProps`における条件分岐（res/err/default）が全パターンカバーされているか
- [ ] `_document.tsx`のHead.renderにおけるフラグ組み合わせ（optimizeCss, disableRuntimeJS, disableOptimizedLoading, isDevelopment）が十分にテストされているか
- [ ] HtmlContextへの依存関係を持つコンポーネントのテストセットアップが現実的か
- [ ] Partytown関連のテスト（C-096〜C-104）のモック戦略が妥当か
- [ ] `handleDocumentScriptLoaderItems`の各strategy分岐が網羅されているか
