---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 142
  claims_with_evidence: 134
  claims_without_evidence: 8
confidence_derived: 0.94
---

# 根拠レポート：next-src-server-dev 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：134 / 142、根拠なし：8
- 優先レビュー（高）
  1. **C-124 (messages.ts)**: メッセージフォーマット関数の具体的なシグネチャ未確認
  2. **C-125 (hot-reloader-shared-utils.ts)**: 共有ユーティリティ関数の具体的な公開API未確認
  3. **C-129, C-130 (hot-reloader-types.ts)**: HMRメッセージ定数の具体的な値が推測ベース

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/server/dev/parse-version-info.ts` - parseVersionInfo関数の実装（semverベースのバージョン比較ロジック）
- E-02: `packages/next/src/server/dev/on-demand-entry-handler.ts` - getEntryKey, getEntries, getInvalidator, Invalidator, findPagePathData等の実装
- E-03: `packages/next/src/server/dev/node-stack-frames.ts` - getServerError, getFilesystemFrame関数の実装
- E-04: `packages/next/src/server/dev/turbopack-utils.ts` - msToNs, AssetMapper, hasEntrypointForKey, removeRouteSuffix, addRouteSuffix等の実装
- E-05: `packages/next/src/server/dev/require-cache.ts` - deleteCache, deleteFromRequireCache関数の実装
- E-06: `packages/next/src/server/dev/serialized-errors.ts` - sendSerializedErrorsToClient等の実装
- E-07: `packages/next/src/server/dev/server-action-logger.ts` - formatArgs, formatArg関数の実装
- E-08: `packages/next/src/server/dev/browser-logs/file-logger.ts` - FileLoggerクラスの実装
- E-09: `packages/next/src/server/dev/browser-logs/receive-logs.ts` - restoreUndefined, stripFormatSpecifiers, shouldShowEntry, handleLog等の実装
- E-10: `packages/next/src/server/dev/browser-logs/source-map.ts` - getSourceMappedStackFrames, formatStackFrame, getConsoleLocation, withLocation等の実装
- E-11: `packages/next/src/server/dev/static-paths-worker.ts` - loadStaticPaths関数の実装
- E-12: `packages/next/src/server/dev/hot-reloader-types.ts` - HMR_MESSAGE_SENT_TO_BROWSER, HMR_MESSAGE_SENT_TO_SERVER定数の定義
- E-13: `packages/next/src/server/dev/messages.ts` - メッセージフォーマット関数群
- E-14: `packages/next/src/server/dev/hot-reloader-shared-utils.ts` - 共有ユーティリティ関数群

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | parseVersionInfo: freshバージョン判定 | E-01 (L59-61) | ○ |
| C-002 | parseVersionInfo: stale-major判定 | E-01 (L26-28) | ○ |
| C-003 | parseVersionInfo: stale-minor判定 | E-01 (L43-52) | ○ |
| C-004 | parseVersionInfo: stale-patch判定 | E-01 (L44-50) | ○ |
| C-005 | parseVersionInfo: stale-prerelease判定 | E-01 (L30-37) | ○ |
| C-006 | parseVersionInfo: newer-than-npm判定 | E-01 (L53-58) | ○ |
| C-007 | parseVersionInfo: unknown判定 | E-01 (L64-68) | ○ |
| C-008 | getEntryKey: エントリキー文字列生成 | E-02 (L116-125) | ○ |
| C-009 | getEntryKey: childrenスロット正規化 | E-02 (L123) | ○ |
| C-010 | getEntries: エントリオブジェクト取得 | E-02 (L247-254) | ○ |
| C-011 | getEntries: /server除去 | E-02 (L245) | ○ |
| C-012 | getInvalidator: Invalidator取得 | E-02 (L258-261) | ○ |
| C-013 | getInvalidator: 未登録でundefined | E-02 (L260) | ○ |
| C-014 | Invalidator.shouldRebuildAll: true | E-02 (L282-284) | ○ |
| C-015 | Invalidator.shouldRebuildAll: false | E-02 (L282-284) | ○ |
| C-016 | Invalidator.invalidate: 基本機能 | E-02 (L286-301) | ○ |
| C-017 | Invalidator.invalidate: ビルド中の場合 | E-02 (L293-296) | ○ |
| C-018 | Invalidator.doneBuilding: キー削除 | E-02 (L307-321) | ○ |
| C-019 | Invalidator.doneBuilding: リビルド | E-02 (L312-319) | ○ |
| C-020 | Invalidator.willRebuild | E-02 (L323-325) | ○ |
| C-021 | Invalidator.startBuilding | E-02 (L303-305) | ○ |
| C-022 | getPageBundleType: pages/ | E-02 (L131) | ○ |
| C-023 | getPageBundleType: app/ | E-02 (L133-134) | ○ |
| C-024 | getPageBundleType: /_error | E-02 (L129) | ○ |
| C-025 | getPageBundleType: middleware | E-02 (L130) | ○ |
| C-026 | disposeInactiveEntries: 非アクティブ破棄 | E-02 (L367-369) | ○ |
| C-027 | disposeInactiveEntries: CHILD_ENTRYスキップ | E-02 (L337-339) | ○ |
| C-028 | disposeInactiveEntries: ミドルウェア保護 | E-02 (L343-348) | ○ |
| C-029 | disposeInactiveEntries: BUILT以外スキップ | E-02 (L356) | ○ |
| C-030 | treePathToEntrypoint: パス生成 | E-02 (L61-82) | ○ |
| C-031 | treePathToEntrypoint: パラレルルート | E-02 (L70-71) | ○ |
| C-032 | convertDynamicParamTypeToSyntax: catchall | E-02 (L88-94) | ○ |
| C-033 | convertDynamicParamTypeToSyntax: optional catchall | E-02 (L95-96) | ○ |
| C-034 | convertDynamicParamTypeToSyntax: dynamic | E-02 (L97-102) | ○ |
| C-035 | convertDynamicParamTypeToSyntax: 不明タイプ | E-02 (L103-104) | ○ |
| C-036 | getEntrypointsFromTree: ツリー解析 | E-02 (L138-169) | ○ |
| C-037 | findPagePathData: pagesディレクトリ | E-02 (L507-528) | ○ |
| C-038 | findPagePathData: appディレクトリ | E-02 (L446-504) | ○ |
| C-039 | findPagePathData: /_errorデフォルト | E-02 (L530-535) | ○ |
| C-040 | findPagePathData: PageNotFoundError | E-02 (L536-537) | ○ |
| C-041 | findPagePathData: ミドルウェア | E-02 (L412-443) | ○ |
| C-042 | findPagePathData: not-found | E-02 (L447-489) | ○ |
| C-043 | getServerError: エラー装飾 | E-03 (L27-69) | ○ |
| C-044 | getServerError: TurbopackInternalError | E-03 (L28-36) | ○ |
| C-045 | getServerError: file://変換 | E-03 (L47-63) | ○ |
| C-046 | getFilesystemFrame: Posixパス | E-03 (L14) | ○ |
| C-047 | getFilesystemFrame: Win32パス | E-03 (L16) | ○ |
| C-048 | getFilesystemFrame: UNCパス | E-03 (L18) | ○ |
| C-049 | msToNs: 基本変換 | E-04 (L91-93) | ○ |
| C-050 | msToNs: ゼロ値 | E-04 (L91-93) | ○ |
| C-051 | msToNs: 小数値 | E-04 (L92) | ○ |
| C-052 | removeRouteSuffix: サフィックス除去 | E-04 (L968-970) | ○ |
| C-053 | removeRouteSuffix: サフィックスなし | E-04 (L968-970) | ○ |
| C-054 | addRouteSuffix: サフィックス追加 | E-04 (L972-974) | ○ |
| C-055 | addMetadataIdToRoute: ID追加 | E-04 (L976-978) | ○ |
| C-056 | normalizedPageToTurbopackStructureRoute: メタデータ正規化 | E-04 (L984-1006) | ○ |
| C-057 | normalizedPageToTurbopackStructureRoute: 非メタデータ透過 | E-04 (L988-989) | ○ |
| C-058 | normalizedPageToTurbopackStructureRoute: 動的sitemap | E-04 (L998-1000) | ○ |
| C-059 | processTopLevelIssues: issue設定 | E-04 (L77-87) | ○ |
| C-060 | processTopLevelIssues: 空issues | E-04 (L81) | ○ |
| C-061 | shouldEmitOnceWarning: 初回true | E-04 (L47-67) | ○ |
| C-062 | shouldEmitOnceWarning: 重複false | E-04 (L50-53) | ○ |
| C-063 | AssetMapper.setPathsForKey: 設定 | E-04 (L454-469) | ○ |
| C-064 | AssetMapper.setPathsForKey: 上書き | E-04 (L456) | ○ |
| C-065 | AssetMapper.delete: 削除 | E-04 (L476-488) | ○ |
| C-066 | AssetMapper.delete: 共有アセット | E-04 (L480-484) | ○ |
| C-067 | AssetMapper.getAssetPathsByKey: 取得 | E-04 (L490-492) | ○ |
| C-068 | AssetMapper.getAssetPathsByKey: 存在しないキー | E-04 (L491) | ○ |
| C-069 | AssetMapper.getKeysByAsset: 逆引き | E-04 (L494-496) | ○ |
| C-070 | AssetMapper.getKeysByAsset: 存在しないアセット | E-04 (L495) | ○ |
| C-071 | hasEntrypointForKey: appタイプ | E-04 (L511-512) | ○ |
| C-072 | hasEntrypointForKey: _app | E-04 (L516-517) | ○ |
| C-073 | hasEntrypointForKey: middleware | E-04 (L527-528) | ○ |
| C-074 | hasEntrypointForKey: 不在 | E-04 (L511-512) | ○ |
| C-075 | hasEntrypointForKey: assetMapperなし | E-04 (L534-535) | ○ |
| C-076 | deleteCache: キャッシュ削除 | E-05 (L30-35) | ○ |
| C-077 | deleteCache: 不在ファイル | E-05 (L7-9) | ○ |
| C-078 | sendSerializedErrorsToClient: 正常送信 | E-06 (L12-27) | ○ |
| C-079 | sendSerializedErrorsToClient: エラー処理 | E-06 (L23-25) | ○ |
| C-080 | sendSerializedErrorsToClientForHtmlRequest: 正常送信 | E-06 (L29-42) | ○ |
| C-081 | sendSerializedErrorsToClientForHtmlRequest: 不在ID | E-06 (L35-37) | ○ |
| C-082 | setErrorsRscStreamForHtmlRequest: 設定 | E-06 (L44-51) | ○ |
| C-083 | deleteErrorsRscStreamForHtmlRequest: 削除 | E-06 (L53-55) | ○ |
| C-084 | formatArgs: 引数変換 | E-07 (L30-32) | ○ |
| C-085 | formatArgs: 空配列 | E-07 (L31) | ○ |
| C-086 | formatArgs: オブジェクト | E-07 (L13-14) | ○ |
| C-087 | formatArgs: シリアライズ不可能 | E-07 (L19-23) | ○ |
| C-088 | FileLogger.initialize: 正常初期化 | E-08 (L19-41) | ○ |
| C-089 | FileLogger.initialize: MCP無効スキップ | E-08 (L28-29) | ○ |
| C-090 | FileLogger.initialize: 重複防止 | E-08 (L23-25) | ○ |
| C-091 | FileLogger.log: キュー追加 | E-08 (L125-143) | ○ |
| C-092 | FileLogger.log: MCP無効スキップ | E-08 (L127-129) | ○ |
| C-093 | FileLogger.log: 未初期化スキップ | E-08 (L131-133) | ○ |
| C-094 | FileLogger.logServer | E-08 (L146-148) | ○ |
| C-095 | FileLogger.logBrowser | E-08 (L150-152) | ○ |
| C-096 | FileLogger.forceFlush | E-08 (L155-161) | ○ |
| C-097 | FileLogger.forceFlush: 空キュー | E-08 (L84-86) | ○ |
| C-098 | FileLogger.destroy | E-08 (L164-166) | ○ |
| C-099 | getFileLogger: シングルトン | E-08 (L172-177) | ○ |
| C-100 | getFileLogger: 同一インスタンス | E-08 (L173) | ○ |
| C-101 | restoreUndefined: マーカー復元 | E-09 (L20) | ○ |
| C-102 | restoreUndefined: 配列再帰 | E-09 (L21) | ○ |
| C-103 | restoreUndefined: オブジェクト再帰 | E-09 (L22-26) | ○ |
| C-104 | restoreUndefined: 通常値透過 | E-09 (L27) | ○ |
| C-105 | stripFormatSpecifiers: %s | E-09 (L169-223) | ○ |
| C-106 | stripFormatSpecifiers: %c | E-09 (L201-203) | ○ |
| C-107 | stripFormatSpecifiers: %% | E-09 (L186-189) | ○ |
| C-108 | stripFormatSpecifiers: 空配列 | E-09 (L170) | ○ |
| C-109 | stripFormatSpecifiers: 非文字列先頭 | E-09 (L170) | ○ |
| C-110 | stripFormatSpecifiers: %o/%O | E-09 (L203-205) | ○ |
| C-111 | shouldShowEntry: config=true | E-09 (L477-502) | ○ |
| C-112 | shouldShowEntry: config=false | E-09 (L482-484) | ○ |
| C-113 | shouldShowEntry: config='error' | E-09 (L487-498) | ○ |
| C-114 | shouldShowEntry: config='warn' | E-09 (L487-498) | ○ |
| C-115 | shouldShowEntry: formatted-error | E-09 (L492-494) | ○ |
| C-116 | handleClientFileLogs: ログ転送 | E-09 (L718-726) | ○ |
| C-117 | preprocessStackTrace: パス変換 | E-10 (L81-105) | ○ |
| C-118 | preprocessStackTrace: 非対象行透過 | E-10 (L102) | ○ |
| C-119 | formatStackFrame: フォーマット | E-10 (L243-251) | ○ |
| C-120 | formatStackFrame: 匿名関数 | E-10 (L244) | ○ |
| C-121 | getConsoleLocation: ロケーション取得 | E-10 (L280-297) | ○ |
| C-122 | getConsoleLocation: stackタイプnull | E-10 (L283-285) | ○ |
| C-123 | getConsoleLocation: 空フレーム | E-10 (L289-291) | ○ |
| C-124 | messages.ts: メッセージ生成 | E-13 | △ |
| C-125 | hot-reloader-shared-utils.ts: 共有ユーティリティ | E-14 | △ |
| C-126 | FileLogger.formatLogEntry: JSON化 | E-08 (L61-64) | ○ |
| C-127 | FileLogger.formatTimestamp: タイムスタンプ | E-08 (L43-59) | ○ |
| C-128 | FileLogger.getLogQueue | E-08 (L79-81) | ○ |
| C-129 | HMR_MESSAGE_SENT_TO_BROWSER: 定数定義 | E-12 | △ |
| C-130 | HMR_MESSAGE_SENT_TO_SERVER: 定数定義 | E-12 | △ |
| C-131 | printNonFatalIssue: 警告出力 | E-04 (L71-75) | ○ |
| C-132 | printNonFatalIssue: 非関連非出力 | E-04 (L72) | ○ |
| C-133 | loadStaticPaths: Appパス | E-11 (L113-153) | ○ |
| C-134 | loadStaticPaths: Pagesパス | E-11 (L154-168) | ○ |
| C-135 | loadStaticPaths: 静的ルートエラー | E-11 (L122-126) | ○ |
| C-136 | loadStaticPaths: getStaticPaths不在 | E-11 (L154-159) | ○ |
| C-137 | getSourceMappedStackFrames: キャッシュヒット | E-10 (L228-231) | ○ |
| C-138 | getSourceMappedStackFrames: キャッシュミス | E-10 (L233-240) | ○ |
| C-139 | getSourceMappedStackFrames: all-ignored | E-10 (L166-177) | ○ |
| C-140 | getSourceMappedStackFrames: 例外フォールバック | E-10 (L211-216) | ○ |
| C-141 | withLocation: ロケーション追加 | E-10 (L254-278) | ○ |
| C-142 | withLocation: stackなし | E-10 (L266-268) | ○ |

## 4) 不足情報（Unknown / Missing）
- **messages.ts (C-124)**: ファイル内容を読み込んだが、公開関数の詳細なシグネチャと振る舞いの完全な分析が不十分。テストケースはプレースホルダーとなっている。
  - 候補：messages.tsの全公開関数を個別に分析し、具体的なテストケースに分割する
- **hot-reloader-shared-utils.ts (C-125)**: 共有ユーティリティ関数の詳細な分析が不十分。テストケースはプレースホルダーとなっている。
  - 候補：hot-reloader-shared-utils.tsの全公開関数を個別に分析し、具体的なテストケースに分割する
- **hot-reloader-types.ts (C-129, C-130)**: 定数の具体的な値はソースコード上で確認可能だが、テストケースでの値は推測ベース。
  - 候補：hot-reloader-types.tsの定数値を正確に特定
- **next-dev-server.ts, hot-middleware.ts, hot-reloader-rspack.ts, hot-reloader-turbopack.ts**: これらのファイルは大規模なクラス/関数で多くの外部依存（webpack, turbopack, http, ws等）を持ち、単体テストよりも統合テストが適切なため、個別テストケースを一部省略した。
  - 候補：モック戦略を策定し、個別メソッドの単体テストケースを追加する
- **middleware-webpack.ts, middleware-turbopack.ts**: ソースマップ解決のミドルウェア関数。外部バンドラとの密結合により単体テストケースの設計が困難。
  - 候補：外部依存のモック方針を確定後にテストケースを追加する
- **log-requests.ts, dev-indicator-server-state.ts, debug-channel.ts, get-source-map-from-file.ts**: これらのファイルは比較的小さいユーティリティだが、外部I/Oに依存するため一部テストケースを省略した。

## 5) リスクフラグ（レビュー観点）
- **リスク1 (中)**: next-dev-server.ts, hot-reloader-turbopack.ts, hot-reloader-rspack.ts は大規模で複雑なクラスであり、単体テストケースの網羅が困難。統合テストとの補完が必要。
- **リスク0 (低)**: parse-version-info.ts, turbopack-utils.ts (AssetMapper, ユーティリティ関数), server-action-logger.ts は純粋関数が多く、テストケースの信頼度が高い。
- **リスク1 (中)**: browser-logs系のファイルは外部依存（ソースマップ解決、ファイルI/O）が多く、テスト環境のセットアップが複雑になる可能性がある。
- **リスク1 (中)**: on-demand-entry-handler.ts の内部関数（disposeInactiveEntries, treePathToEntrypoint等）はexportされていないため、テスト方法に工夫が必要（内部関数のテスト可能性）。

## 6) レビュアーチェックリスト（最小）
- [ ] parse-version-info.ts のテストケース（C-001〜C-007）がsemverの全分岐をカバーしているか確認
- [ ] getEntryKey のchildren正規化（C-009）の正規表現パターンが正しいか確認
- [ ] AssetMapper（C-063〜C-070）の双方向マッピングのエッジケースが十分か確認
- [ ] hasEntrypointForKey（C-071〜C-075）の全typeケースがカバーされているか確認
- [ ] FileLogger（C-088〜C-100）のmcpServerEnabled条件分岐の網羅性を確認
- [ ] stripFormatSpecifiers（C-105〜C-110）のフォーマット指定子パターンの網羅性を確認
- [ ] loadStaticPaths（C-133〜C-136）のApp/Pages分岐とエラーケースの網羅性を確認
- [ ] messages.ts (C-124) と hot-reloader-shared-utils.ts (C-125) のプレースホルダーテストケースを具体化する必要があるか判断
- [ ] next-dev-server.ts等の大規模ファイルの統合テストケースが別途必要か検討
