---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 104
  claims_with_evidence: 98
  claims_without_evidence: 6
confidence_derived: 0.94
---

# 根拠レポート：next-src-server-mcp 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：98 / 104、根拠なし：6
- 優先レビュー（高）
  1. **UT-MCP-036, 037（resolveErrorFrames）**：private関数のため外部テストでのアクセス方法が要確認
  2. **UT-MCP-057〜059（convertSegmentTrieToPageMetadata）**：private関数でありSegmentTrieNodeの内部構造に依存
  3. **UT-MCP-103（srcディレクトリ検出）**：isSrcDirの判定ロジックの内部実装詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/server/mcp/mcp-telemetry-tracker.ts` - McpTelemetryTrackerクラスの実装
- E-02: `packages/next/src/server/mcp/mcp-telemetry-tracker.test.ts` - 既存の単体テスト（7テストケース）
- E-03: `packages/next/src/server/mcp/get-or-create-mcp-server.ts` - シングルトンMCPサーバー作成ロジック
- E-04: `packages/next/src/server/mcp/get-mcp-middleware.ts` - MCPミドルウェア実装
- E-05: `packages/next/src/server/mcp/tools/utils/browser-communication.ts` - ブラウザ通信ユーティリティ
- E-06: `packages/next/src/server/mcp/tools/utils/format-errors.ts` - エラーフォーマットユーティリティ
- E-07: `packages/next/src/server/mcp/tools/get-page-metadata.ts` - ページメタデータ取得ツール
- E-08: `packages/next/src/server/mcp/tools/get-server-action-by-id.ts` - サーバーアクション検索ツール
- E-09: `packages/next/src/server/mcp/tools/get-logs.ts` - ログファイルパス取得ツール
- E-10: `packages/next/src/server/mcp/tools/get-project-metadata.ts` - プロジェクトメタデータ取得ツール
- E-11: `packages/next/src/server/mcp/tools/next-instance-error-state.ts` - インスタンスエラー状態管理
- E-12: `packages/next/src/server/mcp/tools/get-errors.ts` - エラー取得ツール
- E-13: `packages/next/src/server/mcp/tools/get-routes.ts` - ルート取得ツール

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-MCP-001〜003: recordToolCallが正しくカウントを記録する | E-01 (L19-22), E-02 (L23-33, L35-46, L48-76) | ○ |
| C-02 | UT-MCP-004〜006: getUsagesが正しい形式で使用状況を返す | E-01 (L27-32), E-02 (L18-21, L54-75) | ○ |
| C-03 | UT-MCP-007〜008: resetが全記録をクリアする | E-01 (L37-39), E-02 (L96-107) | ○ |
| C-04 | UT-MCP-009〜010: hasUsageが使用有無を正しく判定する | E-01 (L44-46), E-02 (L18-19, L26) | ○ |
| C-05 | UT-MCP-011〜012: getMcpTelemetryUsage/resetMcpTelemetryがシングルトンのラッパーである | E-01 (L55-57, L62-64) | ○ |
| C-06 | UT-MCP-013〜014: recordMcpTelemetryがtelemetryインスタンスにイベントを記録する | E-01 (L69-83) | ○ |
| C-07 | UT-MCP-015〜017: getOrCreateMcpServerがシングルトンでツールを登録する | E-03 (L22-59) | ○ |
| C-08 | UT-MCP-018〜019: getMcpMiddlewareがパスに基づきルーティングする | E-04 (L9-18) | ○ |
| C-09 | UT-MCP-020〜021: ミドルウェアがエラー時に500レスポンスを返す | E-04 (L30-41) | ○ |
| C-10 | UT-MCP-022: req.url未設定時のフォールバック | E-04 (L15) | ○ |
| C-11 | UT-MCP-023〜027: createBrowserRequestがHMRメッセージを送信しPromiseを返す | E-05 (L30-75) | ○ |
| C-12 | UT-MCP-028〜031: handleBrowserPageResponseがレスポンスを蓄積し完了処理する | E-05 (L77-97) | ○ |
| C-13 | UT-MCP-032: setStackFrameResolverが依存性注入を設定する | E-06 (L23-25) | ○ |
| C-14 | UT-MCP-033〜035: formatStackFrameToObjectがフレームを変換する | E-06 (L69-78) | ○ |
| C-15 | UT-MCP-036〜038: resolveErrorFramesがフレームを解決しフォールバックする | E-06 (L80-119) | △ |
| C-16 | UT-MCP-039〜041: formatRuntimeErrorsToObjectsがランタイムエラーをフォーマットする | E-06 (L121-150) | △ |
| C-17 | UT-MCP-042〜049: formatErrorsがconfigErrorsとsessionErrorsを統合フォーマットする | E-06 (L152-206) | ○ |
| C-18 | UT-MCP-050〜056: registerGetPageMetadataToolがページメタデータを取得・フォーマットする | E-07 (L19-117, L120-130) | ○ |
| C-19 | UT-MCP-057〜059: convertSegmentTrieToPageMetadataがトライを変換する | E-07 (L132-160) | △ |
| C-20 | UT-MCP-060〜066: formatPageMetadataがセッションメタデータをフォーマットする | E-07 (L179-239) | ○ |
| C-21 | UT-MCP-067〜073: registerGetActionByIdToolがアクションを検索する | E-08 (L22-156) | ○ |
| C-22 | UT-MCP-074〜077: registerGetLogsToolがログファイルパスを返す | E-09 (L12-66) | ○ |
| C-23 | UT-MCP-078〜082: registerGetProjectMetadataToolがプロジェクト情報を返す | E-10 (L4-62) | ○ |
| C-24 | UT-MCP-083〜085: NextInstanceErrorStateがエラー蓄積・リセットできる | E-11 (L18-22) | ○ |
| C-25 | UT-MCP-086〜093: registerGetErrorsToolがエラー状態を取得・フォーマットする | E-12 (L31-140) | ○ |
| C-26 | UT-MCP-094〜104: registerGetRoutesToolがルートを取得・フィルタ・ソートする | E-13 (L34-232) | ○ |
| C-27 | UT-MCP-036: resolveErrorFramesのignored判定の具体的挙動 | E-06 (L103-108) | △ |
| C-28 | UT-MCP-057: SegmentTrieNode内部構造の具体的フィールド | E-07 (L137-151) | △ |
| C-29 | UT-MCP-103: isSrcDir判定が/src/を含むパスで正しく動作する | E-13 (L80-82) | ○ |
| C-30 | UT-MCP-104: routerTypeの不正値がundefinedにフォールバックする | E-13 (L57-60) | △ |

## 4) 不足情報（Unknown / Missing）
- resolveErrorFrames, formatRuntimeErrorsToObjectsはprivate関数であり、直接テストするにはモジュールの内部実装へのアクセスが必要。テスト実装時はformatErrors経由の間接テスト、またはモジュールの内部エクスポートの検討が必要。
  - 候補：`@internal`エクスポート / formatErrors経由の統合テスト / ts-jestのmodule mock
- convertSegmentTrieToPageMetadataもprivate関数。registerGetPageMetadataTool経由での間接テストが必要。
  - 候補：registerGetPageMetadataTool経由のテスト / テスト用エクスポートの追加
- SegmentTrieNodeの型定義は`next-devtools/dev-overlay/segment-explorer-trie`に存在するが、テストデータの構築に詳細な型情報が必要。
  - 候補：`packages/next/src/next-devtools/dev-overlay/segment-explorer-trie.ts`の参照
- routerTypeの不正値フォールバック（UT-MCP-104）は実装コードL57-60の条件分岐から推測しているが、zod schemaがoptionalでunion型のため実際にはzodのパースエラーになる可能性もある。
  - 候補：zod schemaのバリデーション動作の確認

## 5) リスクフラグ（レビュー観点）
- 0: UT-MCP-001〜014 (McpTelemetryTracker) - 既存テストが存在し低リスク
- 0: UT-MCP-083〜085 (NextInstanceErrorState) - 単純なオブジェクトで低リスク
- 1: UT-MCP-015〜017 (getOrCreateMcpServer) - シングルトンのテストはモジュールスコープのリセットが必要で中リスク
- 1: UT-MCP-018〜022 (getMcpMiddleware) - HTTPリクエスト/レスポンスのモック作成が必要で中リスク
- 1: UT-MCP-023〜031 (browser-communication) - 非同期タイムアウト処理のテストは中リスク
- 1: UT-MCP-036〜041 (format-errors private) - private関数へのアクセスが必要で中リスク
- 1: UT-MCP-094〜104 (get-routes) - ファイルシステムスキャンの外部依存があり中リスク
- 0: UT-MCP-042〜049 (formatErrors public) - public関数で直接テスト可能
- 0: UT-MCP-067〜073 (get-server-action-by-id) - ファイル読み取りモックで対応可能

## 6) レビュアーチェックリスト（最小）
- [ ] McpTelemetryTracker関連テストケース(UT-MCP-001〜014)が既存テスト(mcp-telemetry-tracker.test.ts)と重複していないか確認
- [ ] private関数（resolveErrorFrames, formatRuntimeErrorsToObjects, convertSegmentTrieToPageMetadata, formatPageMetadata）のテスト方針が適切か確認（直接テスト vs 間接テスト）
- [ ] handleBrowserPageResponseのURL空文字バリデーション(UT-MCP-030)が実装コードL82-86と一致していることを確認
- [ ] getOrCreateMcpServerのシングルトンテスト(UT-MCP-015〜016)でモジュールスコープ変数のリセット手段が検討されているか確認
- [ ] registerGetRoutesToolのrouterTypeパラメータ(UT-MCP-104)のzod schema検証動作を確認
- [ ] 全ツールのテレメトリ記録テストケースが網羅されているか確認（6ツール全てに対応するテストケースがあること）
- [ ] 全てのエラーハンドリング（try-catch）パスに対応するテストケースが存在するか確認
