---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 160
  claims_with_evidence: 152
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：next-src-server-misc 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：152 / 160、根拠なし：8
- 優先レビュー（高）
  1. **UT-SMC-039 (wrapApiHandler)**: api-resolverの内部トレーサー挙動はテストフレームワークへの依存度が高い
  2. **UT-SMC-077, UT-SMC-078 (ResponseCache.get)**: ResponseCacheの内部的なpendingResponses管理の詳細な挙動は複数の非同期フローに依存
  3. **UT-SMC-156, UT-SMC-157 (ImageResponse)**: og/image-responseはnext/ogの@vercel/ogへの委譲であり、内部実装の詳細が不透明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/next/src/server/after/awaiter.ts` - AwaiterMulti, AwaiterOnceクラス定義
- E-02: `packages/next/src/server/after/after-context.ts` - AfterContextクラス定義
- E-03: `packages/next/src/server/after/after.ts` - after関数定義
- E-04: `packages/next/src/server/after/builtin-request-context.ts` - getBuiltinRequestContext, createLocalRequestContext定義
- E-05: `packages/next/src/server/after/run-with-after.ts` - AfterRunnerクラス定義
- E-06: `packages/next/src/server/api-utils/get-cookie-parser.ts` - getCookieParser関数定義
- E-07: `packages/next/src/server/api-utils/index.ts` - sendStatusCode, redirect, checkIsOnDemandRevalidate, clearPreviewData, ApiError, sendError, setLazyProp, wrapApiHandler定義
- E-08: `packages/next/src/server/api-utils/web.ts` - byteLength関数定義
- E-09: `packages/next/src/server/api-utils/node/parse-body.ts` - parseBody関数定義
- E-10: `packages/next/src/server/async-storage/draft-mode-provider.ts` - DraftModeProviderクラス定義
- E-11: `packages/next/src/server/base-http/helpers.ts` - isWebNextRequest, isNodeNextRequest, isNodeNextResponse定義
- E-12: `packages/next/src/server/base-http/index.ts` - BaseNextRequest, BaseNextResponseクラス定義
- E-13: `packages/next/src/server/instrumentation/utils.ts` - getRevalidateReason関数定義
- E-14: `packages/next/src/server/response-cache/index.ts` - ResponseCacheクラス, parsePositiveInt, createCacheKey, extractInvocationID定義
- E-15: `packages/next/src/server/response-cache/utils.ts` - routeKindToIncrementalCacheKind, toResponseCacheEntry定義
- E-16: `packages/next/src/server/response-cache/web.ts` - WebResponseCacheクラス定義
- E-17: `packages/next/src/server/resume-data-cache/cache-store.ts` - parseUseCacheCacheStore定義
- E-18: `packages/next/src/server/resume-data-cache/resume-data-cache.ts` - createPrerenderResumeDataCache, createRenderResumeDataCache, stringifyResumeDataCache定義
- E-19: `packages/next/src/server/stream-utils/uint8array-helpers.ts` - indexOfUint8Array, isEquivalentUint8Arrays, removeFromUint8Array定義
- E-20: `packages/next/src/server/stream-utils/node-web-streams-helper.ts` - chainStreams, streamFromString, streamToString, streamToBuffer, streamToUint8Array, createBufferedTransformStream, createRootLayoutValidatorStream, createDocumentClosingStream定義
- E-21: `packages/next/src/server/use-cache/use-cache-errors.ts` - UseCacheTimeoutError, isUseCacheTimeoutError定義
- E-22: `packages/next/src/server/use-cache/cache-life.ts` - validateCacheLife, cacheLife定義
- E-23: `packages/next/src/server/use-cache/cache-tag.ts` - cacheTag定義
- E-24: `packages/next/src/server/use-cache/handlers.ts` - initializeCacheHandlers, getCacheHandler, setCacheHandler, getCacheHandlers, getCacheHandlerEntries定義
- E-25: `packages/next/src/server/use-cache/constants.ts` - DYNAMIC_EXPIRE, RUNTIME_PREFETCH_DYNAMIC_STALE定数定義
- E-26: `packages/next/src/server/use-cache/use-cache-wrapper.ts` - cache, shouldForceRevalidate, shouldDiscardCacheEntry, isRecentlyRevalidatedTag, encodeFormData, isPageSegmentFunction, isLayoutSegmentFunction定義
- E-27: `packages/next/src/server/route-matchers/route-matcher.ts` - RouteMatcherクラス定義
- E-28: `packages/next/src/server/route-matcher-managers/default-route-matcher-manager.ts` - DefaultRouteMatcherManagerクラス定義
- E-29: `packages/next/src/server/async-storage/work-store.ts` - createWorkStore関数定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-SMC-001~006: AwaiterMultiのwaitUntil/awaiting動作 | E-01 | ○ |
| C-02 | UT-SMC-007~010: AwaiterOnceのwaitUntil/awaiting動作 | E-01 | ○ |
| C-03 | UT-SMC-011~016: AfterContextのafter/reportTaskError | E-02 | ○ |
| C-04 | UT-SMC-017~018: after関数のスコープ検証 | E-03 | ○ |
| C-05 | UT-SMC-019~021: builtin-request-contextのコンテキスト取得 | E-04 | ○ |
| C-06 | UT-SMC-022~023: AfterRunnerのexecuteAfter | E-05 | ○ |
| C-07 | UT-SMC-024~026: getCookieParserのCookieパース | E-06 | ○ |
| C-08 | UT-SMC-027~039: api-utils/indexの各ユーティリティ関数 | E-07 | ○ |
| C-09 | UT-SMC-039: wrapApiHandlerのトレーサーラップ | E-07 | △ |
| C-10 | UT-SMC-040~042: byteLength関数 | E-08 | ○ |
| C-11 | UT-SMC-043~048: parseBody関数 | E-09 | ○ |
| C-12 | UT-SMC-049~054: DraftModeProviderクラス | E-10 | ○ |
| C-13 | UT-SMC-055~058: base-http/helpers判定関数 | E-11 | ○ |
| C-14 | UT-SMC-059~062: BaseNextRequest/Response | E-12 | ○ |
| C-15 | UT-SMC-063~066: getRevalidateReason関数 | E-13 | ○ |
| C-16 | UT-SMC-067~078: ResponseCacheとユーティリティ | E-14 | ○ |
| C-17 | UT-SMC-077~078: ResponseCache.get内部動作 | E-14 | △ |
| C-18 | UT-SMC-079~085: response-cache/utils変換関数 | E-15, E-16 | ○ |
| C-19 | UT-SMC-086: WebResponseCacheリクエスト重複排除 | E-16 | ○ |
| C-20 | UT-SMC-087~093: resume-data-cacheのパース・生成・シリアライズ | E-17, E-18 | ○ |
| C-21 | UT-SMC-094~104: uint8array-helpersの3関数 | E-19 | ○ |
| C-22 | UT-SMC-105~116: node-web-streams-helperの各関数 | E-20 | ○ |
| C-23 | UT-SMC-117~121: UseCacheTimeoutError/isUseCacheTimeoutError | E-21 | ○ |
| C-24 | UT-SMC-122~125: validateCacheLife/cacheLife | E-22 | ○ |
| C-25 | UT-SMC-126: cacheTag設定チェック | E-23 | ○ |
| C-26 | UT-SMC-127~135: cache handlers管理関数群 | E-24 | ○ |
| C-27 | UT-SMC-136~143: RouteMatcherクラス | E-27 | ○ |
| C-28 | UT-SMC-144~151: DefaultRouteMatcherManagerクラス | E-28 | ○ |
| C-29 | UT-SMC-152~154: createWorkStore関数 | E-29 | ○ |
| C-30 | UT-SMC-155: use-cache-errorsの再エクスポート確認 | E-21, E-26 | △ |
| C-31 | UT-SMC-156~158: ImageResponse | **根拠不足** | △ |
| C-32 | UT-SMC-159~160: use-cache/constants定数値 | E-25 | ○ |

## 4) 不足情報（Unknown / Missing）
- **ImageResponseの内部実装詳細（UT-SMC-156~158）**: `og/image-response.ts`は`@vercel/og`パッケージのImageResponseを再エクスポートしている。実際のレスポンス生成ロジックは外部パッケージに委譲されており、ヘッダー設定の具体的な挙動は外部パッケージの実装に依存する。
  - 候補: @vercel/ogパッケージのソースコード / テスト / ドキュメント
- **wrapApiHandlerのトレーサー挙動（UT-SMC-039）**: トレーサー（`tracer.trace`）の実際の動作はOpenTelemetryの実装に依存し、テスト時にはモック化が必要。
  - 候補: packages/next/src/server/lib/trace/ / OpenTelemetryドキュメント
- **ResponseCache.getの詳細な非同期フロー（UT-SMC-077~078）**: pendingResponsesの管理やresolvePendingResponseの詳細な挙動は、incrementalCacheやrevalidation処理と密接に連携しているため、単体テストでの検証範囲が限定的。
  - 候補: packages/next/src/server/response-cache/ の他ファイル / 統合テスト
- **use-cache-wrapperの再エクスポート確認（UT-SMC-155）**: use-cache-wrapper.tsからのisUseCacheTimeoutError参照は、単純なimport再利用であり単体テストの意義が薄い可能性がある。
  - 候補: テスト方針の検討

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: UT-SMC-094~104（uint8array-helpers）- 純粋関数であり、テストケースの正確性が高い
- **0 (低リスク)**: UT-SMC-063~066（getRevalidateReason）- 単純な条件分岐で検証が容易
- **0 (低リスク)**: UT-SMC-117~121（UseCacheTimeoutError）- 明確な型判定ロジック
- **1 (中リスク)**: UT-SMC-049~054（DraftModeProvider）- Cookieの暗号化・復号処理に依存するため、モック設計が重要
- **1 (中リスク)**: UT-SMC-043~048（parseBody）- ストリームの読み取りとサイズ制限の組み合わせテストが必要
- **1 (中リスク)**: UT-SMC-144~151（DefaultRouteMatcherManager）- 非同期のリロード処理と動的ルートソートの検証が複雑
- **2 (高リスク)**: UT-SMC-077~078（ResponseCache.get）- incrementalCacheとの統合的な挙動を伴うため、単体テストでの完全な検証が困難
- **2 (高リスク)**: UT-SMC-156~158（ImageResponse）- 外部パッケージへの委譲のため、実装詳細が不透明

## 6) レビュアーチェックリスト（最小）
- [ ] uint8array-helpers（UT-SMC-094~104）のテストケースが全てのエッジケースを網羅しているか確認
- [ ] parseBody（UT-SMC-043~048）のサイズ制限テストで実際のlimit値が正しいか確認
- [ ] DraftModeProvider（UT-SMC-049~054）のCookie暗号化テストのモック設計が適切か確認
- [ ] DefaultRouteMatcherManager（UT-SMC-144~151）の動的ルートソートのテストケースが十分か確認
- [ ] ImageResponse（UT-SMC-156~158）のテストケースが外部パッケージの実際の挙動と整合しているか確認
- [ ] ResponseCache（UT-SMC-077~078）のテストケースで非同期フローのエッジケースが考慮されているか確認
- [ ] wrapApiHandler（UT-SMC-039）のトレーサーモック設計が適切か確認
- [ ] cacheLife/cacheTag（UT-SMC-122~126）のAsyncLocalStorage依存テストのモック設計が適切か確認
