---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 134
  claims_with_evidence: 130
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：next-src-server-node-environment-extensions 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：130 / 134、根拠なし：4
- 優先レビュー（高）
  1. **UT-NEE-015（applyOwnerStack error.stackがundefinedの場合）**：stack未設定時の具体的挙動はコードの分岐ロジックから推測だが明示的テストなし
  2. **UT-NEE-055（web-crypto getRandomValuesパッチ失敗）**：パッチ失敗を再現する環境条件が不明
  3. **UT-NEE-063（Math.randomパッチ失敗）**：パッチ失敗を再現する環境条件が不明
  4. **UT-NEE-134（error-inspect.tsx patchErrorInspectNodeJS）**：外部関数の呼び出しのみで内部動作は別モジュール依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/server/node-environment-extensions/utils.tsx` - io関数およびapplyOwnerStack関数の実装
- E-02: `packages/next/src/server/node-environment-extensions/console-dim.external.tsx` - コンソールdim処理の実装
- E-03: `packages/next/src/server/node-environment-extensions/console-file.tsx` - コンソールファイルロギングの実装
- E-04: `packages/next/src/server/node-environment-extensions/console-exit.tsx` - workUnitストア退出パッチの実装
- E-05: `packages/next/src/server/node-environment-extensions/node-crypto.tsx` - node:crypto API拡張の実装
- E-06: `packages/next/src/server/node-environment-extensions/web-crypto.tsx` - Web Crypto API拡張の実装
- E-07: `packages/next/src/server/node-environment-extensions/date.tsx` - Date API拡張の実装
- E-08: `packages/next/src/server/node-environment-extensions/random.tsx` - Math.random拡張の実装
- E-09: `packages/next/src/server/node-environment-extensions/global-behaviors.tsx` - グローバル動作設定の実装
- E-10: `packages/next/src/server/node-environment-extensions/fast-set-immediate.external.ts` - fast setImmediateパッチの実装
- E-11: `packages/next/src/server/node-environment-extensions/unhandled-rejection.tsx` - unhandledRejectionフィルターの実装
- E-12: `packages/next/src/server/node-environment-extensions/process-error-handlers.ts` - processエラーハンドラーの実装
- E-13: `packages/next/src/server/node-environment-extensions/error-inspect.tsx` - エラーinspectパッチの実装
- E-14: `packages/next/src/server/node-environment-extensions/fast-set-immediate.external.test.ts` - 既存テストファイル（参考）
- E-15: `packages/next/src/server/node-environment-extensions/console-dim.external.test.ts` - 既存テストファイル（参考）
- E-16: `packages/next/src/server/node-environment-extensions/unhandled-rejection.test.ts` - 既存テストファイル（参考）
- E-17: `packages/next/src/server/node-environment-extensions/console-exit.test.ts` - 既存テストファイル（参考）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | io関数はworkUnitStore/workStoreが存在しない場合に早期リターンする | E-01 (L12-17) | ○ |
| C-02 | io関数はprerenderタイプでシグナル未中断時にabortOnSynchronousPlatformIOAccessを呼ぶ | E-01 (L20-51) | ○ |
| C-03 | io関数はtype='random'で正しいメッセージを生成する | E-01 (L32-33) | ○ |
| C-04 | io関数はtype='crypto'で正しいメッセージを生成する | E-01 (L35-37) | ○ |
| C-05 | io関数はシグナルがaborted=trueの場合にスキップする | E-01 (L24) | ○ |
| C-06 | io関数はprerender-runtimeタイプを処理する | E-01 (L21) | ○ |
| C-07 | io関数はprerender-clientタイプで専用メッセージを生成する | E-01 (L53-84) | ○ |
| C-08 | io関数はrequestタイプでstagedRenderingを処理する | E-01 (L85-144) | ○ |
| C-09 | io関数はrequestタイプのRuntime stageで専用メッセージを使用する | E-01 (L106-138) | ○ |
| C-10 | io関数はcache等のタイプで何もしない | E-01 (L145-150) | ○ |
| C-11 | io関数は不明なtypeでInvariantErrorをスローする | E-01 (L38-42) | ○ |
| C-12 | applyOwnerStackはownerStack存在時にstackを更新する | E-01 (L156-188) | ○ |
| C-13 | applyOwnerStackはownerStack不在時にエラーをそのまま返す | E-01 (L166-184) | ○ |
| C-14 | applyOwnerStackはproductionモードで処理しない | E-01 (L161) | ○ |
| C-15 | applyOwnerStackはerror.stackがundefinedの場合を処理する | E-01 (L169) | △ |
| C-16 | applyOwnerStackはreact_stack_bottom_frameでフレームを切り捨てる | E-01 (L172-176) | ○ |
| C-17 | setAbortedLogsStyleは'hidden'に設定可能 | E-02 (L16-18) | ○ |
| C-18 | setAbortedLogsStyleは'dimmed'に設定可能 | E-02 (L16-18) | ○ |
| C-19 | dimmedConsoleArgsはカラー非対応時に入力をそのまま返す | E-02 (L42-44) | ○ |
| C-20 | dimmedConsoleArgsは文字列テンプレートにdimスタイルを適用する | E-02 (L46-138) | ○ |
| C-21 | dimmedConsoleArgsは数値型に適切なフォーマットを使用する | E-02 (L115-120) | ○ |
| C-22 | dimmedConsoleArgsはオブジェクト型に%Oを使用する | E-02 (L122-123) | ○ |
| C-23 | dimmedConsoleArgsはreactBadgeFormatを処理する | E-02 (L56-68) | ○ |
| C-24 | dimmedConsoleArgsは空引数を処理する | E-02 (L42-138) | ○ |
| C-25 | convertToDimmedArgsはdir等のメソッドで引数をそのまま返す | E-02 (L144-155) | ○ |
| C-26 | convertToDimmedArgsはassertで第2引数以降をdim処理する | E-02 (L156-158) | ○ |
| C-27 | convertToDimmedArgsはlog等のメソッドでdim処理する | E-02 (L159-168) | ○ |
| C-28 | patchConsoleMethodはconsoleメソッドをパッチする | E-02 (L172-275) | ○ |
| C-29 | wrapperMethodはcacheSignal.aborted=true+HIDDENでreturnする | E-02 (L194-197) | ○ |
| C-30 | wrapperMethodはcacheSignal.aborted=true+DIMMEDでdim表示する | E-02 (L198-204) | ○ |
| C-31 | wrapperMethodはcacheSignal未中断+dim=trueでdim表示する | E-02 (L205-211) | ○ |
| C-32 | wrapperMethodはcacheSignal未中断+dim=falseで通常呼び出し | E-02 (L212-215) | ○ |
| C-33 | wrapperMethodはcacheSignal=null時にworkUnitStoreにフォールバック | E-02 (L223-266) | ○ |
| C-34 | wrapperMethodはprerender+renderSignal.aborted+HIDDENでreturn | E-02 (L233-235) | ○ |
| C-35 | applyWithDimmingはdim=trueで変換引数を直接適用する | E-02 (L277-292) | ○ |
| C-36 | applyWithDimmingはdim=false時にDIMMED_STOREでrunする | E-02 (L287-291) | ○ |
| C-37 | patchConsoleMethodDEVは開発モードでファイルロギングする | E-03 (L21-57) | ○ |
| C-38 | patchConsoleMethodDEVはdim=trueでファイルロギングをスキップ | E-03 (L33-37) | ○ |
| C-39 | patchConsoleMethodDEVはANSIコードを除去する | E-03 (L43-46) | ○ |
| C-40 | patchConsoleMethodDEVはメソッド名を保持する | E-03 (L49-52) | ○ |
| C-41 | console-exit patchConsoleMethodはworkUnitAsyncStorage.exitで実行する | E-04 (L26-29) | ○ |
| C-42 | console-exit patchConsoleMethodはメソッド名を保持する | E-04 (L31-33) | ○ |
| C-43 | console-exit patchConsoleMethodは設定不可メソッドをスキップする | E-04 (L19-22) | ○ |
| C-44 | node-crypto randomUUIDがio関数を呼ぶ | E-05 (L25-28) | ○ |
| C-45 | node-crypto randomBytes同期呼び出しでio関数を呼ぶ | E-05 (L39-43) | ○ |
| C-46 | node-crypto randomBytes非同期呼び出しではio関数を呼ばない | E-05 (L40-41) | ○ |
| C-47 | node-crypto randomFillSyncがio関数を呼ぶ | E-05 (L57-59) | ○ |
| C-48 | node-crypto randomInt同期呼び出しでio関数を呼ぶ | E-05 (L71-75) | ○ |
| C-49 | node-crypto randomInt非同期呼び出しではio関数を呼ばない | E-05 (L72-73) | ○ |
| C-50 | node-crypto generatePrimeSyncがio関数を呼ぶ | E-05 (L89-91) | ○ |
| C-51 | node-crypto generateKeyPairSyncがio関数を呼ぶ | E-05 (L104-106) | ○ |
| C-52 | node-crypto generateKeySyncがio関数を呼ぶ | E-05 (L118-120) | ○ |
| C-53 | web-crypto getRandomValuesがio関数を呼ぶ | E-06 (L28-30) | ○ |
| C-54 | web-crypto randomUUIDがio関数を呼ぶ | E-06 (L41-43) | ○ |
| C-55 | web-crypto パッチ失敗時にconsole.errorが出力される | E-06 (L32-36) | △ |
| C-56 | Date.nowのパッチがio関数を呼ぶ | E-07 (L16-18) | ○ |
| C-57 | new Date()（引数なし）がio関数を呼ぶ | E-07 (L37-38) | ○ |
| C-58 | new Date(timestamp)はio関数を呼ばない | E-07 (L37-40) | ○ |
| C-59 | Date()（new無し）がio関数を呼ぶ | E-07 (L33-35) | ○ |
| C-60 | パッチされたDateのprototype互換性 | E-07 (L44-46) | ○ |
| C-61 | Math.randomがio関数を呼ぶ | E-08 (L14-16) | ○ |
| C-62 | Math.random.nameが'random'である | E-08 (L21) | ○ |
| C-63 | Math.randomパッチ失敗時にconsole.errorが出力される | E-08 (L22-25) | △ |
| C-64 | installGlobalBehaviorsはhideLogsAfterAbort=trueでhiddenに設定 | E-09 (L19-20) | ○ |
| C-65 | installGlobalBehaviorsはhideLogsAfterAbort=falseでdimmedに設定 | E-09 (L21-23) | ○ |
| C-66 | installGlobalBehaviorsはedgeランタイムでエラーをスローする | E-09 (L13-17) | ○ |
| C-67 | installGlobalBehaviorsはexperimental未定義でdimmedを使用 | E-09 (L19-23) | ○ |
| C-68 | DANGEROUSLY_runPendingImmediatesAfterCurrentTaskはキャプチャを開始する | E-10 (L121-148) | ○ |
| C-69 | DANGEROUSLY_runPendingImmediatesAfterCurrentTaskはedgeでエラー | E-10 (L122-125) | ○ |
| C-70 | DANGEROUSLY_runPendingImmediatesAfterCurrentTaskは重複キャプチャでbail | E-10 (L385-392) | ○ |
| C-71 | expectNoPendingImmediatesはnull時に何もしない | E-10 (L157-172) | ○ |
| C-72 | expectNoPendingImmediatesは非null時にbailする | E-10 (L163-170) | ○ |
| C-73 | expectNoPendingImmediatesはedgeでエラー | E-10 (L158-161) | ○ |
| C-74 | patchedSetImmediateはキャプチャ中にキューに追加する | E-10 (L578-624) | ○ |
| C-75 | patchedSetImmediateはキャプチャ外でネイティブに委譲する | E-10 (L579-585) | ○ |
| C-76 | patchedSetImmediateは引数付きでargsを保存する | E-10 (L604-605) | ○ |
| C-77 | patchedClearImmediateはパッチ済みimmediateをクリアする | E-10 (L665-683) | ○ |
| C-78 | patchedClearImmediateは非パッチimmediateをネイティブに委譲する | E-10 (L680-682) | ○ |
| C-79 | patchedNextTickはpendingNextTicksをインクリメントする | E-10 (L538) | ○ |
| C-80 | patchedNextTickはキャプチャ外でネイティブに委譲する | E-10 (L504-510) | ○ |
| C-81 | patchedSetImmediatePromiseはキャプチャ中にPromise解決する | E-10 (L626-661) | ○ |
| C-82 | patchedSetImmediatePromiseはキャプチャ外でネイティブに委譲する | E-10 (L630-632) | ○ |
| C-83 | patchedSetImmediatePromiseはaborted signalでrejectする | E-10 (L637-639) | ○ |
| C-84 | patchedSetImmediatePromiseはref=falseでunrefする | E-10 (L646-648) | ○ |
| C-85 | NextImmediate.hasRefはデフォルトでtrueを返す | E-10 (L718, L723) | ○ |
| C-86 | NextImmediate.hasRefはクリア済みでfalseを返す | E-10 (L728-729) | ○ |
| C-87 | NextImmediate.refはhasRefをtrueに設定する | E-10 (L732-739) | ○ |
| C-88 | NextImmediate.unrefはhasRefをfalseに設定する | E-10 (L741-749) | ○ |
| C-89 | NextImmediate[Symbol.dispose]はキューアイテムをクリアする | E-10 (L758-769) | ○ |
| C-90 | NextImmediate[Symbol.dispose]はネイティブdisposeに委譲する | E-10 (L766-768) | ○ |
| C-91 | performWorkはアクティブimmediateのコールバックを実行する | E-10 (L257-341) | ○ |
| C-92 | performWorkはキュー空でキャプチャを停止する | E-10 (L273-277) | ○ |
| C-93 | performWorkはエラー時にmicrotaskで再スローする | E-10 (L315-334) | ○ |
| C-94 | takeNextActiveQueueItemはアクティブアイテムを返す | E-10 (L343-382) | ○ |
| C-95 | takeNextActiveQueueItemはクリア済みをスキップする | E-10 (L351-357) | ○ |
| C-96 | takeNextActiveQueueItemは空キューでnullを返す | E-10 (L360-369) | ○ |
| C-97 | takeNextActiveQueueItemは全クリア済みでnull+キュー空にする | E-10 (L363-366) | ○ |
| C-98 | bailはimmediatesをネイティブにスケジュールする | E-10 (L425-453) | ○ |
| C-99 | bailはstateをAbandonedに設定する | E-10 (L434) | ○ |
| C-100 | installUnhandledRejectionFilterは既存リスナーをキャプチャする | E-11 (L196-529) | ○ |
| C-101 | installUnhandledRejectionFilterは重複インストールで警告する | E-11 (L197-202) | ○ |
| C-102 | uninstallUnhandledRejectionFilterはメソッドを復元する | E-11 (L536-576) | ○ |
| C-103 | uninstallUnhandledRejectionFilterは未インストール時に警告する | E-11 (L537-541) | ○ |
| C-104 | filteringHandlerはabortedプリレンダーのrejectionを抑制する | E-11 (L581-599) | ○ |
| C-105 | filteringHandlerは通常rejectionをリスナーに委譲する | E-11 (L614-636) | ○ |
| C-106 | filteringHandlerはリスナー空でconsole.errorする | E-11 (L615-622) | ○ |
| C-107 | filteringHandlerはonceリスナーを呼び出し後に削除する | E-11 (L626-633) | ○ |
| C-108 | filteringHandlerはリスナーエラー時にsetImmediateで再スローする | E-11 (L637-643) | ○ |
| C-109 | filteringHandlerはprerender-clientでaborted時に抑制する | E-11 (L592) | ○ |
| C-110 | filteringHandlerはprerender-runtimeでaborted時に抑制する | E-11 (L593) | ○ |
| C-111 | filteringHandlerはrequestタイプで委譲する | E-11 (L604) | ○ |
| C-112 | パッチ済みaddListenerはunhandledRejectionをunderlyingListenersに追加 | E-11 (L231-257) | ○ |
| C-113 | パッチ済みaddListenerは他イベントを元のメソッドに委譲する | E-11 (L255) | ○ |
| C-114 | パッチ済みremoveListenerはunderlyingListenersから削除する | E-11 (L260-299) | ○ |
| C-115 | パッチ済みremoveListenerはfilteringHandler削除でアンインストール | E-11 (L264-275) | ○ |
| C-116 | パッチ済みprependListenerは先頭に追加する | E-11 (L373-406) | ○ |
| C-117 | パッチ済みonceはonce=trueで追加する | E-11 (L409-433) | ○ |
| C-118 | パッチ済みremoveAllListenersはunderlyingListenersをクリアする | E-11 (L475-514) | ○ |
| C-119 | パッチ済みremoveAllListeners(引数なし)でアンインストールする | E-11 (L503-512) | ○ |
| C-120 | パッチ済みlistenersはfilteringHandler+underlyingListenersを返す | E-11 (L517-526) | ○ |
| C-121 | patchWithoutReentrancyはbypassPatch=trueでoriginalを呼ぶ | E-11 (L163-166) | ○ |
| C-122 | patchWithoutReentrancyは実行中にbypassPatchをtrue設定する | E-11 (L168-175) | ○ |
| C-123 | MODE='disabled'でフィルター無効化 | E-11 (L46-49) | ○ |
| C-124 | MODE='debug'でdebugレベル設定 | E-11 (L43-44) | ○ |
| C-125 | MODE='silent'でsilentレベル設定 | E-11 (L40-41) | ○ |
| C-126 | 不正なMODE値でconsole.errorが出力される | E-11 (L57-63) | ○ |
| C-127 | installProcessErrorHandlersは初回でハンドラーをインストールする | E-12 (L7-89) | ○ |
| C-128 | installProcessErrorHandlersはshouldRemove=trueで既存リスナー削除 | E-12 (L52-55) | ○ |
| C-129 | installProcessErrorHandlersは2回目で早期リターンする | E-12 (L10) | ○ |
| C-130 | installProcessErrorHandlersはpostponeのrejectionを抑制する | E-12 (L59-63) | ○ |
| C-131 | installProcessErrorHandlersは通常rejectionをconsole.errorする | E-12 (L71) | ○ |
| C-132 | installProcessErrorHandlersはpostponeのexceptionを抑制する | E-12 (L84-86) | ○ |
| C-133 | installProcessErrorHandlersは通常exceptionをconsole.errorする | E-12 (L87) | ○ |
| C-134 | error-inspect.tsxはpatchErrorInspectNodeJSを呼び出す | E-13 (L3) | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: `applyOwnerStack`で`error.stack`が`undefined`の場合、`ownerStack`のみが設定されるという推測。コードの分岐条件`if (error.stack)`から推測可能だが、`error.stack`がfalsy/undefinedのケースの明示的な動作保証はソースに記載なし
  - 候補：既存テストの確認 / 実行時デバッグ
- C-55, C-63: パッチ失敗（try/catchのcatch分岐）を再現する環境条件が特定できていない。Object.freezeやreadonly環境等が考えられるが、実際のエッジケースは不明
  - 候補：Object.freeze(crypto) / Object.defineProperty(Math, 'random', {writable: false})
- C-134: `error-inspect.tsx`は外部関数`patchErrorInspectNodeJS`を呼び出すのみで、その内部動作は別モジュール(`../patch-error-inspect`)に依存。テストケースはモジュール境界の呼び出し確認にとどまる
  - 候補：patch-error-inspectモジュールのテストケースとの連携確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードの分岐ロジックに直接対応しており、根拠が明確
- 1: 中リスク - `fast-set-immediate.external.ts`のテストケースは非同期スケジューリングの複雑な相互作用を含むため、テスト実装時にタイミング依存の問題が発生する可能性がある
- 1: 中リスク - `unhandled-rejection.tsx`のprocessメソッドパッチは多数の分岐を含み、テスト実装時にグローバル状態の管理が困難になる可能性がある
- 0: 低リスク - crypto/Date/Math.randomのパッチはシンプルなラッパーパターンで根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] `io`関数の各workUnitStoreタイプ（prerender, prerender-runtime, prerender-client, request）に対するテストケースが網羅的か確認
- [ ] `fast-set-immediate.external.ts`の非同期スケジューリングテストが実際のNode.jsイベントループの動作と整合するか確認
- [ ] `unhandled-rejection.tsx`のprocessメソッドパッチテストがグローバル状態の適切なセットアップ/ティアダウンを含むか確認
- [ ] crypto/Date/Math.randomのパッチテストで、元の関数の戻り値が変更されていないことの検証が含まれているか確認
- [ ] `console-dim.external.tsx`のreactBadgeFormat処理テストが実際のReactログ形式と一致するか確認
- [ ] 各パッチ失敗時のcatch分岐テスト（UT-NEE-055, UT-NEE-063）の実現可能性を確認
