---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 101
  claims_with_evidence: 97
  claims_without_evidence: 4
confidence_derived: 0.96
---

# 根拠レポート：next-src-server-normalizers 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：97 / 101、根拠なし：4
- 優先レビュー（高）
  1. **C-089〜C-091（インターフェース定義確認）**：インターフェースは実行時テストが困難であり、TypeScript型チェックの範疇
  2. **C-096（PrefixingNormalizer空パス）**：path.posix.joinの空文字列挙動は実行時確認が必要
  3. **C-055（NextDataPathnameNormalizerのindex正規化）**：denormalizePagePathの具体的な挙動に依存
  4. **C-097（BasePathPathnameNormalizerのundefined）**：TypeScriptの型制約によりランタイムでの発生可能性が低い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/server/normalizers/normalizer.ts` - Normalizerインターフェース定義
- E-02: `packages/next/src/server/normalizers/normalizers.ts` - Normalizersクラス（チェーンnormalizer）
- E-03: `packages/next/src/server/normalizers/absolute-filename-normalizer.ts` - AbsoluteFilenameNormalizerクラス
- E-04: `packages/next/src/server/normalizers/wrap-normalizer-fn.ts` - wrapNormalizerFn関数
- E-05: `packages/next/src/server/normalizers/underscore-normalizer.ts` - UnderscoreNormalizerクラス
- E-06: `packages/next/src/server/normalizers/locale-route-normalizer.ts` - LocaleRouteNormalizerクラス
- E-07: `packages/next/src/server/normalizers/prefixing-normalizer.ts` - PrefixingNormalizerクラス
- E-08: `packages/next/src/server/normalizers/request/pathname-normalizer.ts` - PathnameNormalizerインターフェース
- E-09: `packages/next/src/server/normalizers/request/prefix.ts` - PrefixPathnameNormalizerクラス
- E-10: `packages/next/src/server/normalizers/request/suffix.ts` - SuffixPathnameNormalizerクラス
- E-11: `packages/next/src/server/normalizers/request/base-path.ts` - BasePathPathnameNormalizerクラス
- E-12: `packages/next/src/server/normalizers/request/rsc.ts` - RSCPathnameNormalizerクラス
- E-13: `packages/next/src/server/normalizers/request/next-data.ts` - NextDataPathnameNormalizerクラス
- E-14: `packages/next/src/server/normalizers/request/segment-prefix-rsc.ts` - SegmentPrefixRSCPathnameNormalizerクラス
- E-15: `packages/next/src/server/normalizers/built/app/app-filename-normalizer.ts` - AppFilenameNormalizerクラス
- E-16: `packages/next/src/server/normalizers/built/app/app-bundle-path-normalizer.ts` - AppBundlePathNormalizer, DevAppBundlePathNormalizerクラス
- E-17: `packages/next/src/server/normalizers/built/app/app-page-normalizer.ts` - DevAppPageNormalizerクラス
- E-18: `packages/next/src/server/normalizers/built/app/app-pathname-normalizer.ts` - AppPathnameNormalizer, DevAppPathnameNormalizerクラス
- E-19: `packages/next/src/server/normalizers/built/app/index.ts` - AppNormalizers, DevAppNormalizersファクトリ
- E-20: `packages/next/src/server/normalizers/built/pages/pages-filename-normalizer.ts` - PagesFilenameNormalizerクラス
- E-21: `packages/next/src/server/normalizers/built/pages/pages-bundle-path-normalizer.ts` - PagesBundlePathNormalizer, DevPagesBundlePathNormalizerクラス
- E-22: `packages/next/src/server/normalizers/built/pages/pages-page-normalizer.ts` - DevPagesPageNormalizerクラス
- E-23: `packages/next/src/server/normalizers/built/pages/pages-pathname-normalizer.ts` - DevPagesPathnameNormalizerクラス
- E-24: `packages/next/src/server/normalizers/built/pages/index.ts` - PagesNormalizers, DevPagesNormalizersファクトリ
- E-25: `packages/next/src/lib/constants.ts` - RSC_SUFFIX, RSC_SEGMENT_SUFFIX, RSC_SEGMENTS_DIR_SUFFIX定数
- E-26: `packages/next/src/shared/lib/constants.ts` - SERVER_DIRECTORY定数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Normalizers.normalizeが単一normalizerで正規化する | E-02 (L14-18: reduce処理) | ○ |
| C-002 | Normalizers.normalizeが複数normalizerを順次適用する | E-02 (L14-18: reduce処理) | ○ |
| C-003 | Normalizers.normalizeが空配列で入力をそのまま返す | E-02 (L14-18: reduceの初期値がpathname) | ○ |
| C-004 | Normalizers.pushでnormalizerが追加される | E-02 (L10-12: push処理) | ○ |
| C-005 | Normalizers.constructorで配列が設定される | E-02 (L8: constructorパラメータ) | ○ |
| C-006 | Normalizers.constructorがデフォルト引数で空配列を生成 | E-02 (L8: デフォルト値=[]) | ○ |
| C-007 | AbsoluteFilenameNormalizer.normalizeがabsolutePathToPageを呼ぶ | E-03 (L22-29: absolutePathToPage呼び出し) | ○ |
| C-008 | AbsoluteFilenameNormalizer.normalizeが拡張子を除去する | E-03 (L23-28: extensionsパラメータ) | ○ |
| C-009 | AbsoluteFilenameNormalizer.normalizeが/indexを除去する | E-03 (L26: keepIndex: false) | ○ |
| C-010 | AbsoluteFilenameNormalizer.constructorが正しく設定される | E-03 (L16-20: constructorパラメータ) | ○ |
| C-011 | wrapNormalizerFnが関数をNormalizerにラップする | E-04 (L3-5: {normalize: fn}を返す) | ○ |
| C-012 | ラップされたnormalizerが元の関数を呼ぶ | E-04 (L4: normalize: fn) | ○ |
| C-013 | UnderscoreNormalizer.normalizeが%5Fを_に置換する | E-05 (L8: replace(/%5F/g, '_')) | ○ |
| C-014 | 複数の%5Fがすべて置換される | E-05 (L8: グローバルフラグ/g) | ○ |
| C-015 | %5Fを含まないパスがそのまま返る | E-05 (L8: replaceはマッチしなければ変更なし) | ○ |
| C-016 | 空文字列が空文字列のまま返る | E-05 (L8: 空文字列へのreplaceは空文字列) | ○ |
| C-017 | 小文字%5fは置換されない | E-05 (L8: 正規表現は大文字%5Fのみ) | ○ |
| C-018 | LocaleRouteNormalizer.normalizeがロケールプレフィックスを除去する | E-06 (L17-18: provider.analyze(pathname).pathname) | ○ |
| C-019 | ロケールがないパスがそのまま返る | E-06 (L17-18: analyzeの結果に依存) | ○ |
| C-020 | LocaleRouteNormalizer.constructorがproviderを設定する | E-06 (L8: constructorパラメータ) | ○ |
| C-021 | PrefixingNormalizer.normalizeがプレフィックスを付与する | E-07 (L11-13: path.posix.join) | ○ |
| C-022 | 複数プレフィックスが結合される | E-07 (L7-8: path.posix.join(...prefixes)) | ○ |
| C-023 | constructorで複数引数がjoinされる | E-07 (L7-8: path.posix.join(...prefixes)) | ○ |
| C-024 | ルートパス'/'にプレフィックスが付与される | E-07 (L11-13: path.posix.joinの挙動) | ○ |
| C-025 | PrefixPathnameNormalizer.matchがプレフィックス開始でtrueを返す | E-09 (L12-18: startsWith(prefix + '/')) | ○ |
| C-026 | PrefixPathnameNormalizer.matchがプレフィックス完全一致でtrueを返す | E-09 (L14: pathname !== this.prefix条件) | ○ |
| C-027 | PrefixPathnameNormalizer.matchがプレフィックス不一致でfalseを返す | E-09 (L14-16: 条件分岐) | ○ |
| C-028 | 部分一致(スラッシュ区切りでない)でfalseを返す | E-09 (L14: prefix + '/'でチェック) | ○ |
| C-029 | PrefixPathnameNormalizer.normalizeがプレフィックスを除去する | E-09 (L29: substring(prefix.length)) | ○ |
| C-030 | プレフィックス完全一致で'/'が返る | E-09 (L25-27: lengthが等しい場合'/'を返す) | ○ |
| C-031 | マッチしない場合にパスがそのまま返る | E-09 (L23: !matched && !match条件) | ○ |
| C-032 | matched=trueでmatchスキップ | E-09 (L23: !matched条件) | ○ |
| C-033 | プレフィックスがスラッシュ終わりでエラー | E-09 (L5-9: endsWith('/')チェック) | ○ |
| C-034 | SuffixPathnameNormalizer.matchがサフィックス終了でtrueを返す | E-10 (L7-8: endsWith(suffix)) | ○ |
| C-035 | SuffixPathnameNormalizer.matchがサフィックス不一致でfalseを返す | E-10 (L8: !endsWith条件) | ○ |
| C-036 | SuffixPathnameNormalizer.normalizeがサフィックスを除去する | E-10 (L17: substring(0, length - suffix.length)) | ○ |
| C-037 | マッチしない場合にパスがそのまま返る | E-10 (L15: !matched && !match条件) | ○ |
| C-038 | matched=trueでmatchスキップ | E-10 (L15: !matched条件) | ○ |
| C-039 | サフィックスのみの場合に空文字列が返る | E-10 (L17: substring(0, 0)は空文字列) | ○ |
| C-040 | BasePathPathnameNormalizer有効なbasePathで生成される | E-11 (L9-15: constructorの正常パス) | ○ |
| C-041 | basePath空文字でエラー | E-11 (L10-12: !basePath条件) | ○ |
| C-042 | basePath='/'でエラー | E-11 (L10-12: basePath === '/'条件) | ○ |
| C-043 | BasePathPathnameNormalizer.matchがPrefixPathnameNormalizerを継承 | E-11 (L5-7: extends PrefixPathnameNormalizer) | ○ |
| C-044 | BasePathPathnameNormalizer.normalizeがPrefixPathnameNormalizerを継承 | E-11 (L5-7: extends PrefixPathnameNormalizer) | ○ |
| C-045 | RSCPathnameNormalizer.matchが.rsc終了でtrueを返す | E-12 (L10-13: extends SuffixPathnameNormalizer(RSC_SUFFIX)), E-25 (RSC_SUFFIX='.rsc') | ○ |
| C-046 | RSCPathnameNormalizer.matchが.rsc不一致でfalseを返す | E-12, E-10 (SuffixPathnameNormalizerの挙動) | ○ |
| C-047 | RSCPathnameNormalizer.normalizeが.rscを除去する | E-12, E-10 (SuffixPathnameNormalizerの挙動) | ○ |
| C-048 | .rsc不一致でパスがそのまま返る | E-12, E-10 (SuffixPathnameNormalizerの挙動) | ○ |
| C-049 | NextDataPathnameNormalizer有効なbuildIDで生成される | E-13 (L10-16: constructorでprefixを設定) | ○ |
| C-050 | buildID空文字でエラー | E-13 (L11-13: !buildID条件) | ○ |
| C-051 | NextDataPathnameNormalizer.matchがプレフィックスとサフィックス両方マッチ | E-13 (L18-19: prefix.match && suffix.match) | ○ |
| C-052 | プレフィックスのみ一致でfalse | E-13 (L19: && 条件) | ○ |
| C-053 | サフィックスのみ一致でfalse | E-13 (L19: && 条件) | ○ |
| C-054 | NextDataPathnameNormalizer.normalizeがプレフィックスとサフィックスを除去する | E-13 (L26-29: prefix.normalize + suffix.normalize + denormalizePagePath) | ○ |
| C-055 | indexパスがdenormalizePagePathで正規化される | E-13 (L29: denormalizePagePath呼び出し) | ○ |
| C-056 | マッチしない場合にパスがそのまま返る | E-13 (L24: !matched && !match条件) | ○ |
| C-057 | matched=trueでmatchスキップ | E-13 (L24: !matched条件) | ○ |
| C-058 | SegmentPrefixRSCPathnameNormalizer.matchがパターン一致でtrueを返す | E-14 (L13-15: PATTERN.test) | ○ |
| C-059 | パターン不一致でfalseを返す | E-14 (L14: PATTERN.test) | ○ |
| C-060 | extractがoriginalPathnameとsegmentPathを抽出する | E-14 (L17-21: match[1], match[2]) | ○ |
| C-061 | extract不一致でnullを返す | E-14 (L19: !matchでnull) | ○ |
| C-062 | normalizeがoriginalPathnameを返す | E-14 (L24-28: extract結果のoriginalPathname) | ○ |
| C-063 | normalize不一致でパスがそのまま返る | E-14 (L26: !matchでpathname返却) | ○ |
| C-064 | AppFilenameNormalizer.normalizeがdistDir/serverプレフィックスを付与する | E-15 (L4-12: extends PrefixingNormalizer(distDir, SERVER_DIRECTORY)) | ○ |
| C-065 | AppFilenameNormalizer.constructorがdistDirとSERVER_DIRECTORYで初期化 | E-15 (L5-7: super(distDir, SERVER_DIRECTORY)) | ○ |
| C-066 | AppBundlePathNormalizer.normalizeがapp/プレフィックスを付与する | E-16 (L8-14: super('app'), normalizePagePath) | ○ |
| C-067 | normalizePagePathが適用される | E-16 (L13: normalizePagePath(page)) | ○ |
| C-068 | DevAppBundlePathNormalizer.normalizeがチェーンで適用される | E-16 (L17-36: Normalizers継承) | ○ |
| C-069 | isTurbopack=trueでUnderscoreNormalizerが先頭に追加 | E-16 (L27-29: isTurbopack条件でunshift) | ○ |
| C-070 | isTurbopack=falseでUnderscoreNormalizerが含まれない | E-16 (L27: if条件) | ○ |
| C-071 | DevAppPageNormalizer.normalizeがAPPタイプで正規化する | E-17 (L9-13: PAGE_TYPES.APP) | ○ |
| C-072 | DevAppPageNormalizer.constructorがAPPタイプで初期化 | E-17 (L11: super(appDir, extensions, PAGE_TYPES.APP)) | ○ |
| C-073 | AppPathnameNormalizer.normalizeがnormalizeAppPathと%5F置換を適用 | E-18 (L7-21: normalizeAppPath + UnderscoreNormalizer) | ○ |
| C-074 | %5Fが_に置換される | E-18 (L14: UnderscoreNormalizer) | ○ |
| C-075 | DevAppPathnameNormalizer.normalizeがチェーンで適用される | E-18 (L23-36: Normalizers継承) | ○ |
| C-076 | AppNormalizers.constructorが3つのnormalizerを初期化 | E-19 (L12-22: filename, pathname, bundlePath) | ○ |
| C-077 | DevAppNormalizers.constructorが3つのnormalizerを初期化 | E-19 (L24-38: page, pathname, bundlePath) | ○ |
| C-078 | PagesFilenameNormalizer.normalizeがdistDir/serverプレフィックスを付与 | E-20 (L4-12: extends PrefixingNormalizer) | ○ |
| C-079 | PagesFilenameNormalizer.constructorがdistDirとSERVER_DIRECTORYで初期化 | E-20 (L5-7: super(distDir, SERVER_DIRECTORY)) | ○ |
| C-080 | PagesBundlePathNormalizer.normalizeがpages/プレフィックスを付与 | E-21 (L7-21: normalizePagePath + PrefixingNormalizer('pages')) | ○ |
| C-081 | normalizePagePathが適用される | E-21 (L12: normalizePagePath) | ○ |
| C-082 | DevPagesBundlePathNormalizer.normalizeがチェーンで適用される | E-21 (L23-36: Normalizers継承) | ○ |
| C-083 | DevPagesPageNormalizer.normalizeがPAGESタイプで正規化する | E-22 (L4-8: extends AbsoluteFilenameNormalizer, PAGE_TYPES.PAGES) | ○ |
| C-084 | DevPagesPageNormalizer.constructorがPAGESタイプで初期化 | E-22 (L5-7: super(pagesDir, extensions, PAGE_TYPES.PAGES)) | ○ |
| C-085 | DevPagesPathnameNormalizer.normalizeがPAGESタイプで正規化する | E-23 (L4-8: extends AbsoluteFilenameNormalizer, PAGE_TYPES.PAGES) | ○ |
| C-086 | DevPagesPathnameNormalizer.constructorがPAGESタイプで初期化 | E-23 (L5-7: super(pagesDir, extensions, PAGE_TYPES.PAGES)) | ○ |
| C-087 | PagesNormalizers.constructorが2つのnormalizerを初期化 | E-24 (L9-21: filename, bundlePath) | ○ |
| C-088 | DevPagesNormalizers.constructorが3つのnormalizerを初期化 | E-24 (L23-33: page, pathname, bundlePath) | ○ |
| C-089 | PathnameNormalizerインターフェースにmatchが定義 | E-08 (L4: match定義) | ○ |
| C-090 | PathnameNormalizerインターフェースにnormalize(matched?)が定義 | E-08 (L5: normalize定義) | ○ |
| C-091 | Normalizerインターフェースにnormalizeが定義 | E-01 (L2: normalize定義) | ○ |
| C-092 | 長いプレフィックスが正しく処理される | E-09 (L29: substring処理は長さに依存しない) | ○ |
| C-093 | ネストされたパスのセグメントが抽出される | E-14 (L8-9: 正規表現パターンの(.*)部分) | ○ |
| C-094 | ネストされたページパスが正規化される | E-13 (L26-29: prefix/suffix/denormalize処理) | ○ |
| C-095 | パス先頭の%5Fが置換される | E-05 (L8: グローバル置換) | ○ |
| C-096 | 空パスにプレフィックスが付与される | E-07 (L11-13: path.posix.join) | △ |
| C-097 | basePathがundefinedでエラー | E-11 (L10: !basePath条件) | △ |
| C-098 | isTurbopack=trueでUnderscoreNormalizerがunshiftされる | E-16 (L27-29: normalizers.unshift) | ○ |
| C-099 | isTurbopack=falseでUnderscoreNormalizerが含まれない | E-16 (L27: if(isTurbopack)条件) | ○ |
| C-100 | SuffixPathnameNormalizer.matchが空文字列でfalseを返す | E-10 (L8: ''.endsWith(suffix)はfalse) | △ |
| C-101 | PrefixPathnameNormalizer.matchが空文字列でfalseを返す | E-09 (L14: '' !== prefix && !''.startsWith(prefix + '/')) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-096**: `path.posix.join('app', '')`の戻り値はNode.jsのpath.posix.joinの仕様に依存する。'app'を返すか'app/'を返すかは実行時確認が必要。
  - 候補：Node.js path.posixドキュメント / 実行時テスト
- **C-097**: TypeScriptの型定義により`basePath`パラメータはstring型であり、undefinedが渡されるケースはコンパイル時に防がれる。ランタイムJavaScriptとして呼ばれた場合のみ該当。
  - 候補：TypeScript型定義の確認 / ランタイムテスト
- **C-100, C-101**: 空文字列がString.prototype.endsWith/startsWithでどう振る舞うかはJavaScript仕様に依存。理論上正しいが、実行時確認推奨。
  - 候補：ECMAScript仕様 / ランタイムテスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケースはソースコードの実装から直接導出されており、信頼性が高い
- **1（中リスク）**: `denormalizePagePath`や`absolutePathToPage`などの外部関数への委譲部分は、その関数の挙動を前提としている。それらの関数の仕様変更が影響する可能性がある
- **0（低リスク）**: インターフェース定義のテストケース（C-089〜C-091）は実質的にTypeScript型チェックの範疇であり、ランタイムテストとしての必要性は低い

## 6) レビュアーチェックリスト（最小）
- [ ] 各normalizer クラスのnormalizeメソッドに対して正常系・異常系・境界値の観点が網羅されているか
- [ ] PrefixPathnameNormalizerのmatch処理でスラッシュ区切りの部分一致防止ロジックが正しくテストされているか
- [ ] BasePathPathnameNormalizerとNextDataPathnameNormalizerのコンストラクタバリデーションが適切にテストされているか
- [ ] DevAppBundlePathNormalizerのisTurbopackフラグによるUnderscoreNormalizer追加/非追加の分岐がテストされているか
- [ ] 外部関数（absolutePathToPage, normalizeAppPath, normalizePagePath, denormalizePagePath）への委譲部分でモック化が必要かどうか検討されているか
- [ ] PathnameNormalizerのmatchedパラメータによるmatchスキップロジックが全該当クラスでテストされているか
