---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 131
  claims_with_evidence: 127
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：next-src-server-request 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：127 / 131、根拠なし：4
- 優先レビュー（高）
  1. **C-020 (UT-REQ-020)**: `areCookiesMutableInCurrentPhase`のランタイム動作が外部モジュール依存のため、戻り値条件の根拠が間接的
  2. **C-032 (UT-REQ-032)**: `getDraftModeProviderForCacheScope`の詳細な条件判定が外部モジュール依存
  3. **C-074 (UT-REQ-074)**: `getMetadataVaryParamsAccumulator`の戻り値に依存するメタデータパラメータ生成ロジック
  4. **C-111 (UT-REQ-111)**: 同上、SearchParams版

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/server/request/connection.ts` - connection()関数の実装
- E-02: `packages/next/src/server/request/cookies.ts` - cookies()関数およびヘルパー関数群の実装
- E-03: `packages/next/src/server/request/draft-mode.ts` - draftMode()関数、DraftModeクラス、trackDynamicDraftMode関数の実装
- E-04: `packages/next/src/server/request/fallback-params.ts` - createOpaqueFallbackRouteParams, getFallbackRouteParams関数の実装
- E-05: `packages/next/src/server/request/headers.ts` - headers()関数およびヘルパー関数群の実装
- E-06: `packages/next/src/server/request/params.ts` - createParamsFromClient, createServerParamsForRoute等のパラメータ生成関数群の実装
- E-07: `packages/next/src/server/request/pathname.ts` - createServerPathnameForMetadata, createPrerenderPathname等の実装
- E-08: `packages/next/src/server/request/root-params.ts` - getRootParam, createPrerenderRootParamPromise等の実装
- E-09: `packages/next/src/server/request/search-params.ts` - createSearchParamsFromClient, createServerSearchParamsForServerPage等の実装
- E-10: `packages/next/src/server/request/utils.ts` - throwWithStaticGenerationBailoutErrorWithDynamicError, throwForSearchParamsAccessInUseCache, isRequestAPICallableInsideAfter関数の実装
- E-11: `packages/next/src/server/request/fallback-params.test.ts` - 既存テストファイル（createOpaqueFallbackRouteParams, getFallbackRouteParamsのテスト）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | connection()はforceStatic=trueでPromise.resolve(undefined)を返す | E-01 L40-44 | ○ |
| C-002 | connection()はdynamicShouldError=trueでStaticGenBailoutErrorをスロー | E-01 L46-50 | ○ |
| C-003 | connection()はafter()内（非action）でエラーをスロー | E-01 L30-38 | ○ |
| C-004 | connection()はcacheコンテキストでエラーをスロー | E-01 L54-61 | ○ |
| C-005 | connection()はprivate-cacheコンテキストでエラーをスロー | E-01 L62-72 | ○ |
| C-006 | connection()はunstable-cacheコンテキストでエラーをスロー | E-01 L73-76 | ○ |
| C-007 | connection()はprerenderタイプでハンギングPromiseを返す | E-01 L77-86 | ○ |
| C-008 | connection()はprerender-pprでpostponeWithTrackingを呼ぶ | E-01 L87-94 | ○ |
| C-009 | connection()はprerender-legacyでthrowToInterruptStaticGenerationを呼ぶ | E-01 L95-102 | ○ |
| C-010 | connection()はrequestタイプ（本番）でPromise.resolve(undefined)を返す | E-01 L103-119 | ○ |
| C-011 | connection()はworkStoreなしでthrowForMissingRequestStoreを呼ぶ | E-01 L127 | ○ |
| C-012 | cookies()はforceStatic=trueで空Cookiesを返す | E-02 L50-55 | ○ |
| C-013 | cookies()はdynamicShouldError=trueでStaticGenBailoutErrorをスロー | E-02 L57-61 | ○ |
| C-014 | cookies()はafter()内（非action）でエラーをスロー | E-02 L39-48 | ○ |
| C-015 | cookies()はcacheコンテキストでエラーをスロー | E-02 L65-71 | ○ |
| C-016 | cookies()はunstable-cacheコンテキストでエラーをスロー | E-02 L72-75 | ○ |
| C-017 | cookies()はprerenderタイプでハンギングPromiseを返す | E-02 L76-77 | ○ |
| C-018 | cookies()はprerender-clientタイプでInvariantErrorをスロー | E-02 L78-82 | ○ |
| C-019 | cookies()はprerender-pprでpostponeWithTrackingを呼ぶ | E-02 L83-90 | ○ |
| C-020 | cookies()はrequestタイプでミュータブルCookiesの場合にuserspaceMutableCookiesを返す | E-02 L108-133 | △ |
| C-021 | cookies()はrequestタイプで非ミュータブルの場合に読み取り専用cookiesを返す | E-02 L108-133 | ○ |
| C-022 | cookies()はworkStoreなしでthrowForMissingRequestStoreを呼ぶ | E-02 L141 | ○ |
| C-023 | createEmptyCookies()は空のRequestCookiesオブジェクトを返す | E-02 L144-146 | ○ |
| C-024 | makeHangingCookies()はキャッシュ済みの場合に同一Promiseを返す | E-02 L154-171 | ○ |
| C-025 | makeUntrackedCookies()はPromise.resolveを返す | E-02 L173-185 | ○ |
| C-026 | makeUntrackedCookies()はキャッシュ済みの場合に同一Promiseを返す | E-02 L173-185 | ○ |
| C-027 | createCookiesAccessError()はroute指定時にルート名を含むエラーを生成 | E-02 L293-303 | ○ |
| C-028 | createCookiesAccessError()はroute未指定時に'This route'を含むエラーを生成 | E-02 L293-303 | ○ |
| C-029 | draftMode()はrequestタイプでDraftModeインスタンスを返す | E-03 L41-42 | ○ |
| C-030 | draftMode()はprerenderタイプでnullプロバイダのDraftModeを返す | E-03 L61-66 | ○ |
| C-031 | draftMode()はworkStore/workUnitStoreなしでthrowForMissingRequestStoreを呼ぶ | E-03 L30-32 | ○ |
| C-032 | draftMode()はcacheコンテキストでdraftModeProviderあり時にDraftModeを返す | E-03 L44-57 | △ |
| C-033 | draftMode()はcacheコンテキストでdraftModeProviderなし時にnullプロバイダのDraftModeを返す | E-03 L44-66 | ○ |
| C-034 | DraftMode.isEnabled はprovider存在時にprovider.isEnabledを返す | E-03 L135-139 | ○ |
| C-035 | DraftMode.isEnabled はprovider=null時にfalseを返す | E-03 L135-139 | ○ |
| C-036 | DraftMode.enable()はprovider.enable()を呼ぶ | E-03 L141-148 | ○ |
| C-037 | DraftMode.enable()はprovider=null時にエラーなし | E-03 L141-148 | ○ |
| C-038 | DraftMode.disable()はprovider.disable()を呼ぶ | E-03 L149-154 | ○ |
| C-039 | DraftMode.disable()はprovider=null時にエラーなし | E-03 L149-154 | ○ |
| C-040 | trackDynamicDraftMode()はafter()フェーズでエラーをスロー | E-03 L172-183 | ○ |
| C-041 | trackDynamicDraftMode()はdynamicShouldError=trueでStaticGenBailoutErrorをスロー | E-03 L185-189 | ○ |
| C-042 | trackDynamicDraftMode()はcacheコンテキストでエラーをスロー | E-03 L192-201 | ○ |
| C-043 | trackDynamicDraftMode()はunstable-cacheコンテキストでエラーをスロー | E-03 L202-205 | ○ |
| C-044 | createDraftModeAccessError()はroute指定時にルート名を含むエラーを生成 | E-03 L160-170 | ○ |
| C-045 | createOpaqueFallbackRouteParams()は空配列でnullを返す | E-04 L56, E-11 | ○ |
| C-046 | createOpaqueFallbackRouteParams()はFallbackRouteParamをMapに変換 | E-04 L52-75, E-11 | ○ |
| C-047 | createOpaqueFallbackRouteParams()は複数パラメータを正しく変換 | E-04 L52-75, E-11 | ○ |
| C-048 | createOpaqueFallbackRouteParams()は一意のID形式のsearchValueを生成 | E-04 L61, E-11 L56-57 | ○ |
| C-049 | createOpaqueFallbackRouteParams()のhas/get/entriesが正しく動作 | E-04 L52-75, E-11 L44-72 | ○ |
| C-050 | getFallbackRouteParams()は単一動的セグメントを抽出 | E-04 L86-124, E-11 L77-86 | ○ |
| C-051 | getFallbackRouteParams()はネストされた複数動的セグメントを抽出 | E-04, E-11 L88-104 | ○ |
| C-052 | getFallbackRouteParams()は動的セグメントなしでnullを返す | E-04, E-11 L161-173 | ○ |
| C-053 | getFallbackRouteParams()はcatchallセグメントを抽出 | E-04, E-11 L106-116 | ○ |
| C-054 | getFallbackRouteParams()はoptional catchallセグメントを抽出 | E-04, E-11 L118-132 | ○ |
| C-055 | getFallbackRouteParams()は部分的に静的なルートで動的のみ抽出 | E-04, E-11 L175-192 | ○ |
| C-056 | headers()はforceStatic=trueで空Headersを返す | E-05 L56-61 | ○ |
| C-057 | headers()はafter()内（非action）でエラーをスロー | E-05 L46-54 | ○ |
| C-058 | headers()はcacheコンテキストでエラーをスロー | E-05 L65-72 | ○ |
| C-059 | headers()はunstable-cacheコンテキストでエラーをスロー | E-05 L73-76 | ○ |
| C-060 | headers()はdynamicShouldError=trueでStaticGenBailoutErrorをスロー | E-05 L90-94 | ○ |
| C-061 | headers()はprerenderタイプでハンギングPromiseを返す | E-05 L98-99 | ○ |
| C-062 | headers()はprerender-clientタイプでInvariantErrorをスロー | E-05 L100-104 | ○ |
| C-063 | headers()はprerender-pprでpostponeWithTrackingを呼ぶ | E-05 L105-114 | ○ |
| C-064 | headers()はrequestタイプ（本番）でheadersを含むPromiseを返す | E-05 L134-148 | ○ |
| C-065 | headers()はworkStoreなしでthrowForMissingRequestStoreを呼ぶ | E-05 L157 | ○ |
| C-066 | makeHangingHeaders()はキャッシュ済みの場合に同一Promiseを返す | E-05 L163-180 | ○ |
| C-067 | makeUntrackedHeaders()はPromise.resolveを返す | E-05 L182-194 | ○ |
| C-068 | createHeadersAccessError()はroute指定時にルート名を含むエラーを生成 | E-05 L295-305 | ○ |
| C-069 | createHeadersAccessError()はroute未指定時に'This route'を含むエラーを生成 | E-05 L295-305 | ○ |
| C-070 | createParamsFromClient()はrequestタイプ（本番）でPromise.resolveを返す | E-06 L76-90 | ○ |
| C-071 | createParamsFromClient()はcacheコンテキストでInvariantErrorをスロー | E-06 L66-71 | ○ |
| C-072 | createParamsFromClient()はprerender-runtimeでInvariantErrorをスロー | E-06 L72-75 | ○ |
| C-073 | createParamsFromClient()はworkUnitStoreなしでthrowInvariantForMissingStoreを呼ぶ | E-06 L95 | ○ |
| C-074 | createServerParamsForMetadata()はgetMetadataVaryParamsAccumulatorを取得して委譲 | E-06 L99-110 | △ |
| C-075 | createServerParamsForRoute()はrequestタイプでPromise.resolveを返す | E-06 L143-157 | ○ |
| C-076 | createServerParamsForRoute()はcacheコンテキストでInvariantErrorをスロー | E-06 L131-135 | ○ |
| C-077 | createServerParamsForRoute()はprerender-runtimeでdelayUntilRuntimeStageを呼ぶ | E-06 L137-142 | ○ |
| C-078 | createServerParamsForServerSegment()はprerenderタイプでcreateStaticPrerenderParamsを呼ぶ | E-06 L165-181 | ○ |
| C-079 | createServerParamsForServerSegment()はrequestタイプでPromiseを返す | E-06 L195-209 | ○ |
| C-080 | createPrerenderParamsForClientSegment()はfallbackParamsマッチ時にハンギングPromiseを返す | E-06 L217-247 | ○ |
| C-081 | createPrerenderParamsForClientSegment()はfallbackParams非マッチ時にPromise.resolveを返す | E-06 L217-268 | ○ |
| C-082 | createPrerenderParamsForClientSegment()はworkStoreなしでInvariantErrorをスロー | E-06 L220-225 | ○ |
| C-083 | makeUntrackedParams()はPromise.resolveを返す | E-06 L484-494 | ○ |
| C-084 | makeUntrackedParams()はキャッシュ済みの場合に同一Promiseを返す | E-06 L484-494 | ○ |
| C-085 | createParamsAccessError()はroute指定時にルート名を含むエラーを生成 | E-06 L595-605 | ○ |
| C-086 | createParamsAccessError()はroute未指定時に'This route'を含むエラーを生成 | E-06 L595-605 | ○ |
| C-087 | createServerPathnameForMetadata()はrequestタイプでPromise.resolveを返す | E-07 L46-47 | ○ |
| C-088 | createServerPathnameForMetadata()はprerenderタイプでcreatePrerenderPathnameを呼ぶ | E-07 L24-33 | ○ |
| C-089 | createServerPathnameForMetadata()はcacheコンテキストでInvariantErrorをスロー | E-07 L35-39 | ○ |
| C-090 | createServerPathnameForMetadata()はworkUnitStoreなしでthrowInvariantForMissingStoreを呼ぶ | E-07 L52 | ○ |
| C-091 | createPrerenderPathname()はprerenderタイプでfallbackParamsあり時にハンギングPromiseを返す | E-07 L65-73 | ○ |
| C-092 | createPrerenderPathname()はprerenderタイプでfallbackParamsなし時にPromise.resolveを返す | E-07 L55-91 | ○ |
| C-093 | createPrerenderPathname()はprerender-pprでfallbackParamsあり時にmakeErroringPathnameを呼ぶ | E-07 L76-81 | ○ |
| C-094 | createPrerenderPathname()はprerender-clientタイプでInvariantErrorをスロー | E-07 L61-64 | ○ |
| C-095 | createRenderPathname()はPromise.resolveを返す | E-07 L128-130 | ○ |
| C-096 | getRootParam()はrequestタイプでrootParamsから値を返す | E-08 L78-89 | ○ |
| C-097 | getRootParam()はworkStoreなしでInvariantErrorをスロー | E-08 L29-31 | ○ |
| C-098 | getRootParam()はworkUnitStoreなしでErrorをスロー | E-08 L34-38 | ○ |
| C-099 | getRootParam()はRoute Handler内でErrorをスロー | E-08 L43-47 | ○ |
| C-100 | getRootParam()はServer Action内（actionフェーズ）でErrorをスロー | E-08 L49-57 | ○ |
| C-101 | getRootParam()はcache/unstable-cacheコンテキストでErrorをスロー | E-08 L61-65 | ○ |
| C-102 | getRootParam()はprerenderでfallbackParamsマッチ時にハンギングPromiseを返す | E-08 L113-126 | ○ |
| C-103 | getRootParam()はprerenderでfallbackParams非マッチ時に静的値を返す | E-08 L110-155 | ○ |
| C-104 | createPrerenderRootParamPromise()はprerender-clientでInvariantErrorをスロー | E-08 L99-103 | ○ |
| C-105 | makeErroringRootParamPromise()はprerender-pprでpostponeWithTrackingを呼ぶ | E-08 L170-177 | ○ |
| C-106 | makeErroringRootParamPromise()はprerender-legacyでthrowToInterruptStaticGenerationを呼ぶ | E-08 L178-183 | ○ |
| C-107 | createSearchParamsFromClient()はrequestタイプでSearchParamsを含むPromiseを返す | E-09 L67-72 | ○ |
| C-108 | createSearchParamsFromClient()はprerenderタイプでcreateStaticPrerenderSearchParamsを呼ぶ | E-09 L51-56 | ○ |
| C-109 | createSearchParamsFromClient()はcacheコンテキストでInvariantErrorをスロー | E-09 L61-65 | ○ |
| C-110 | createSearchParamsFromClient()はworkUnitStoreなしでthrowInvariantForMissingStoreを呼ぶ | E-09 L77 | ○ |
| C-111 | createServerSearchParamsForMetadata()はgetMetadataVaryParamsAccumulatorを取得して委譲 | E-09 L81-91 | △ |
| C-112 | createServerSearchParamsForServerPage()はrequestタイプでSearchParamsを含むPromiseを返す | E-09 L118-123 | ○ |
| C-113 | createServerSearchParamsForServerPage()はprerenderタイプでcreateStaticPrerenderSearchParamsを呼ぶ | E-09 L101-105 | ○ |
| C-114 | createServerSearchParamsForServerPage()はcacheコンテキストでInvariantErrorをスロー | E-09 L106-111 | ○ |
| C-115 | createPrerenderSearchParamsForClientPage()はforceStatic=trueで空オブジェクトを返す | E-09 L134-138 | ○ |
| C-116 | createPrerenderSearchParamsForClientPage()はprerenderタイプでハンギングPromiseを返す | E-09 L143-151 | ○ |
| C-117 | createPrerenderSearchParamsForClientPage()はprerender-ppr/legacyで空オブジェクトを返す | E-09 L162-165 | ○ |
| C-118 | makeErroringSearchParamsForUseCache()はProxyで包まれたPromiseを返す | E-09 L356-389 | ○ |
| C-119 | makeErroringSearchParamsForUseCache()はthenアクセスでthrowForSearchParamsAccessInUseCacheを呼ぶ | E-09 L376-381 | ○ |
| C-120 | makeErroringSearchParamsForUseCache()はキャッシュ済みの場合に同一Promiseを返す | E-09 L359-362 | ○ |
| C-121 | makeUntrackedSearchParams()はPromise.resolveを返す | E-09 L391-403 | ○ |
| C-122 | createSearchAccessError()はroute指定時にルート名を含むエラーを生成 | E-09 L617-627 | ○ |
| C-123 | createSearchAccessError()はroute未指定時に'This route'を含むエラーを生成 | E-09 L617-627 | ○ |
| C-124 | throwWithStaticGenerationBailoutErrorWithDynamicError()はStaticGenBailoutErrorをスロー | E-10 L5-12 | ○ |
| C-125 | throwWithStaticGenerationBailoutErrorWithDynamicError()のエラーメッセージにルート名と式が含まれる | E-10 L9-11 | ○ |
| C-126 | throwForSearchParamsAccessInUseCache()はErrorをスロー | E-10 L14-26 | ○ |
| C-127 | throwForSearchParamsAccessInUseCache()はworkStore.invalidDynamicUsageErrorにエラーを設定 | E-10 L23 | ○ |
| C-128 | throwForSearchParamsAccessInUseCache()は既存errorがあれば上書きしない（??=演算子） | E-10 L23 | ○ |
| C-129 | isRequestAPICallableInsideAfter()はrootTaskSpawnPhase='action'時にtrueを返す | E-10 L28-31 | ○ |
| C-130 | isRequestAPICallableInsideAfter()はrootTaskSpawnPhase!='action'時にfalsy値を返す | E-10 L28-31 | ○ |
| C-131 | isRequestAPICallableInsideAfter()はafterTaskStoreなし時にundefinedを返す | E-10 L28-31 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-020**: `areCookiesMutableInCurrentPhase`関数の正確な判定条件は`packages/next/src/server/web/spec-extension/adapters/request-cookies.ts`に定義されており、本モジュール内のコードからは間接的にのみ確認可能
  - 候補: request-cookies.ts / work-unit-async-storage.external.ts
- **C-032**: `getDraftModeProviderForCacheScope`関数の正確な条件分岐は`work-unit-async-storage.external.ts`に定義されており、本モジュール内のコードからは間接的にのみ確認可能
  - 候補: work-unit-async-storage.external.ts
- **C-074, C-111**: `getMetadataVaryParamsAccumulator`の戻り値が`createServerParamsForServerSegment`/`createServerSearchParamsForServerPage`に与える影響は`vary-params.ts`に依存
  - 候補: packages/next/src/server/app-render/vary-params.ts

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: エラーメッセージ生成関数（createCookiesAccessError, createHeadersAccessError, createParamsAccessError, createSearchAccessError, createDraftModeAccessError）- 文字列処理のみで副作用なし
- **0（低リスク）**: WeakMapキャッシュ動作（makeUntrackedCookies, makeUntrackedHeaders, makeUntrackedParams, makeUntrackedSearchParams）- キャッシュ有無の確認のみ
- **1（中リスク）**: connection(), cookies(), headers()のworkUnitStore.typeによる分岐網羅 - 多数のcase分岐があり、テストケースの漏れがないか確認が必要
- **1（中リスク）**: params.tsの複数のcreate系関数がほぼ同一パターンの分岐を持つ - 差分の見落としに注意
- **1（中リスク）**: draft-mode.tsのtrackDynamicDraftMode関数のprerender/prerender-runtime分岐でabortAndThrowOnSynchronousRequestDataAccessが使用される - 外部依存
- **2（高リスク）**: cookies()のミュータブル/リードオンリー判定 - areCookiesMutableInCurrentPhaseの外部依存によりテストケースの期待結果が実装と乖離する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] connection.tsの全workUnitStoreタイプ分岐（10タイプ）が網羅されていること
- [ ] cookies.tsのミュータブル/リードオンリー判定テスト（UT-REQ-020, 021）の期待結果が正確であること
- [ ] draft-mode.tsのDraftModeクラスのenable/disableがtrackDynamicDraftModeを正しく呼び出すことがテストされていること
- [ ] fallback-params.tsのテストケースが既存テストファイル(fallback-params.test.ts)と整合していること
- [ ] params.tsの5つのcreate系関数それぞれについてcache/prerender/requestの分岐が網羅されていること
- [ ] root-params.tsのactionStore判定（Route Handler, Server Action）のテストケースが正確であること
- [ ] search-params.tsのmakeErroringSearchParamsForUseCacheのProxyハンドラ動作が正しくテストされていること
- [ ] utils.tsのisRequestAPICallableInsideAfterのfalsy値（undefined含む）の判定が正確であること
